/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.FilteringIterator;
import common.iterable.IterableDouble;
import common.iterable.IterableInt;
import common.iterable.IterableLong;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;

public abstract class FilteringIterable<T>
implements Iterable<T> {
    protected final Iterable<T> iterable;

    public FilteringIterable(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    public static IterableInt dedupe(final IterableInt iterableInt) {
        return new IterableInt(){

            @Override
            public PrimitiveIterator.OfInt iterator() {
                return FilteringIterator.dedupe(iterableInt.iterator());
            }
        };
    }

    public static IterableLong dedupe(final IterableLong iterableLong) {
        return new IterableLong(){

            @Override
            public PrimitiveIterator.OfLong iterator() {
                return FilteringIterator.dedupe(iterableLong.iterator());
            }
        };
    }

    public static IterableDouble dedupe(final IterableDouble iterableDouble) {
        return new IterableDouble(){

            @Override
            public PrimitiveIterator.OfDouble iterator() {
                return FilteringIterator.dedupe(iterableDouble.iterator());
            }
        };
    }

    public static <T> Iterable<T> dedupe(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return FilteringIterator.dedupe(iterable.iterator());
            }
        };
    }

    public static class OfDouble
    extends FilteringIterable<Double>
    implements IterableDouble {
        private DoublePredicate predicate;

        public OfDouble(IterableDouble iterableDouble, DoublePredicate doublePredicate) {
            super(iterableDouble);
            this.predicate = doublePredicate;
        }

        @Override
        public PrimitiveIterator.OfDouble iterator() {
            return new FilteringIterator.OfDouble((IterableDouble)this.iterable, this.predicate);
        }
    }

    public static class OfLong
    extends FilteringIterable<Long>
    implements IterableLong {
        private LongPredicate predicate;

        public OfLong(IterableLong iterableLong, LongPredicate longPredicate) {
            super(iterableLong);
            this.predicate = longPredicate;
        }

        @Override
        public PrimitiveIterator.OfLong iterator() {
            return new FilteringIterator.OfLong((IterableLong)this.iterable, this.predicate);
        }
    }

    public static class OfInt
    extends FilteringIterable<Integer>
    implements IterableInt {
        private IntPredicate predicate;

        public OfInt(IterableInt iterableInt, IntPredicate intPredicate) {
            super(iterableInt);
            this.predicate = intPredicate;
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            return new FilteringIterator.OfInt((IterableInt)this.iterable, this.predicate);
        }
    }

    public static class Of<T>
    extends FilteringIterable<T> {
        private Predicate<? super T> predicate;

        public Of(Iterable<T> iterable, Predicate<? super T> predicate) {
            super(iterable);
            this.predicate = predicate;
        }

        @Override
        public Iterator<T> iterator() {
            return new FilteringIterator.Of<T>(this.iterable, this.predicate);
        }
    }
}

