/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.iterable.IterableInt;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class IterableBitSet
implements IterableInt {
    private BitSet set;
    private boolean clearBits = false;
    private boolean reversed = false;
    private Integer maxIndex = null;

    public IterableBitSet(BitSet bitSet) {
        this.set = bitSet;
        this.clearBits = false;
        this.reversed = false;
    }

    public IterableBitSet(BitSet bitSet, Integer n, boolean bl) {
        this(bitSet, n, bl, false);
    }

    public IterableBitSet(BitSet bitSet, Integer n, boolean bl, boolean bl2) {
        this.set = bitSet;
        this.maxIndex = n;
        this.clearBits = bl;
        this.reversed = bl2;
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        if (!this.clearBits) {
            if (this.reversed) {
                return new SetBitsReversedIterator();
            }
            return new SetBitsIterator();
        }
        if (this.reversed) {
            return new ClearBitsReversedIterator();
        }
        return new ClearBitsIterator();
    }

    public static IterableBitSet getSetBits(BitSet bitSet) {
        return new IterableBitSet(bitSet);
    }

    public static IterableBitSet getSetBitsReversed(BitSet bitSet) {
        return new IterableBitSet(bitSet, null, false, true);
    }

    public static IterableBitSet getClearBits(BitSet bitSet, int n) {
        return new IterableBitSet(bitSet, n, true);
    }

    public static IterableBitSet getClearBitsReversed(BitSet bitSet, int n) {
        return new IterableBitSet(bitSet, n, true, true);
    }

    public static void main(String[] stringArray) {
        BitSet bitSet = new BitSet();
        bitSet.set(1);
        bitSet.set(2);
        bitSet.set(3);
        bitSet.set(5);
        bitSet.set(8);
        bitSet.set(13);
        bitSet.set(21);
        System.out.println("\n" + bitSet + " - set bits:");
        for (Integer n : IterableBitSet.getSetBits(bitSet)) {
            System.out.println(n);
        }
        bitSet.clear();
        PrimitiveIterator.OfInt ofInt = IterableBitSet.getSetBits(bitSet).iterator();
        if (ofInt.hasNext()) {
            Integer n;
            n = (Integer)ofInt.next();
            throw new RuntimeException("BitSet should be empty!");
        }
    }

    private class ClearBitsReversedIterator
    implements PrimitiveIterator.OfInt {
        private int current = -1;
        private int next;

        public ClearBitsReversedIterator() {
            this.next = IterableBitSet.this.set.nextSetBit(0);
            this.current = -1;
            this.next = IterableBitSet.this.set.previousClearBit(IterableBitSet.this.maxIndex);
        }

        @Override
        public boolean hasNext() {
            return this.next >= 0;
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                this.current = this.next;
                this.next = IterableBitSet.this.set.previousClearBit(this.current - 1);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            IterableBitSet.this.set.clear(this.current);
        }
    }

    private class ClearBitsIterator
    implements PrimitiveIterator.OfInt {
        private int current = -1;
        private int next;

        private ClearBitsIterator() {
            this.next = IterableBitSet.this.set.nextClearBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.next <= IterableBitSet.this.maxIndex;
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                this.current = this.next;
                this.next = IterableBitSet.this.set.nextClearBit(this.current + 1);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            IterableBitSet.this.set.set(this.current);
        }
    }

    private class SetBitsReversedIterator
    implements PrimitiveIterator.OfInt {
        private int current = -1;
        private int next;

        public SetBitsReversedIterator() {
            this.next = IterableBitSet.this.set.nextSetBit(0);
            this.current = -1;
            this.next = IterableBitSet.this.maxIndex != null ? IterableBitSet.this.set.previousSetBit(IterableBitSet.this.maxIndex) : IterableBitSet.this.set.length() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.next >= 0;
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                this.current = this.next;
                this.next = IterableBitSet.this.set.previousSetBit(this.current - 1);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            IterableBitSet.this.set.clear(this.current);
        }
    }

    private class SetBitsIterator
    implements PrimitiveIterator.OfInt {
        private int current = -1;
        private int next;

        private SetBitsIterator() {
            this.next = IterableBitSet.this.set.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            if (IterableBitSet.this.maxIndex != null && this.next > IterableBitSet.this.maxIndex) {
                return false;
            }
            return this.next >= 0;
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                this.current = this.next;
                this.next = IterableBitSet.this.set.nextSetBit(this.current + 1);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            IterableBitSet.this.set.clear(this.current);
        }
    }
}

