/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceGenRabinDD;
import acceptance.AcceptanceGeneric;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceType;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import jdd.JDDVars;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class AcceptanceGenRabin
extends ArrayList<GenRabinPair>
implements AcceptanceOmega {
    @Override
    public AcceptanceGenRabin clone() {
        AcceptanceGenRabin acceptanceGenRabin = new AcceptanceGenRabin();
        for (GenRabinPair genRabinPair : this) {
            acceptanceGenRabin.add(genRabinPair.clone());
        }
        return acceptanceGenRabin;
    }

    @Override
    public boolean isBSCCAccepting(BitSet bitSet) {
        for (GenRabinPair genRabinPair : this) {
            if (!genRabinPair.isBSCCAccepting(bitSet)) continue;
            return true;
        }
        return false;
    }

    public AcceptanceGeneric complementToGeneric() {
        AcceptanceGeneric acceptanceGeneric = this.toAcceptanceGeneric();
        return acceptanceGeneric.complementToGeneric();
    }

    @Override
    public AcceptanceOmega complement(int n, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.GENERIC)) {
            return this.complementToGeneric();
        }
        throw new PrismNotSupportedException("Can not complement " + this.getType() + " acceptance to a supported acceptance type");
    }

    @Override
    public void lift(AcceptanceOmega.LiftBitSet liftBitSet) {
        for (GenRabinPair genRabinPair : this) {
            genRabinPair.L = liftBitSet.lift(genRabinPair.L);
            int n = genRabinPair.K_list.size();
            for (int i = 0; i < n; ++i) {
                genRabinPair.K_list.set(i, liftBitSet.lift(genRabinPair.K_list.get(i)));
            }
        }
    }

    public AcceptanceGenRabin or(AcceptanceGenRabin acceptanceGenRabin) {
        AcceptanceGenRabin acceptanceGenRabin2 = new AcceptanceGenRabin();
        for (GenRabinPair genRabinPair : this) {
            acceptanceGenRabin2.add(genRabinPair.clone());
        }
        for (GenRabinPair genRabinPair : acceptanceGenRabin) {
            acceptanceGenRabin2.add(genRabinPair.clone());
        }
        return acceptanceGenRabin2;
    }

    @Override
    public AcceptanceGenRabinDD toAcceptanceDD(JDDVars jDDVars) {
        return new AcceptanceGenRabinDD(this, jDDVars);
    }

    @Override
    public AcceptanceGeneric toAcceptanceGeneric() {
        if (this.size() == 0) {
            return new AcceptanceGeneric(false);
        }
        AcceptanceGeneric acceptanceGeneric = null;
        for (GenRabinPair genRabinPair : this) {
            AcceptanceGeneric acceptanceGeneric2 = genRabinPair.toAcceptanceGeneric();
            if (acceptanceGeneric == null) {
                acceptanceGeneric = acceptanceGeneric2;
                continue;
            }
            acceptanceGeneric = new AcceptanceGeneric(AcceptanceGeneric.ElementType.OR, acceptanceGeneric, acceptanceGeneric2);
        }
        return acceptanceGeneric;
    }

    @Override
    public String getSignatureForState(int n) {
        Object object = "";
        for (int i = 0; i < this.size(); ++i) {
            GenRabinPair genRabinPair = (GenRabinPair)this.get(i);
            object = (String)object + genRabinPair.getSignatureForState(n, i);
        }
        return object;
    }

    @Override
    public String getSignatureForStateHOA(int n) {
        Object object = "";
        int n2 = 0;
        for (GenRabinPair genRabinPair : this) {
            if (genRabinPair.getL().get(n)) {
                object = (String)object + (((String)object).isEmpty() ? "" : " ") + n2;
            }
            ++n2;
            for (int i = 0; i < genRabinPair.getNumK(); ++i) {
                if (genRabinPair.getK(i).get(n)) {
                    object = (String)object + (((String)object).isEmpty() ? "" : " ") + n2;
                }
                ++n2;
            }
        }
        if (!((String)object).isEmpty()) {
            object = "{" + (String)object + "}";
        }
        return object;
    }

    @Override
    public String toString() {
        Object object = "";
        for (GenRabinPair genRabinPair : this) {
            object = (String)object + genRabinPair.toString();
        }
        return object;
    }

    @Override
    public String getSizeStatistics() {
        return this.size() + " Generalized Rabin pairs";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.GENERALIZED_RABIN;
    }

    @Override
    @Deprecated
    public String getTypeAbbreviated() {
        return this.getType().getNameAbbreviated();
    }

    @Override
    @Deprecated
    public String getTypeName() {
        return this.getType().getName();
    }

    @Override
    public void outputHOAHeader(PrintStream printStream) {
        int n = 0;
        printStream.print("acc-name: generalized-Rabin " + this.size());
        for (Object object : this) {
            ++n;
            printStream.print(" " + ((GenRabinPair)object).getNumK());
            n += ((GenRabinPair)object).getNumK();
        }
        printStream.println();
        printStream.print("Acceptance: " + n);
        if (n == 0) {
            printStream.println("f");
            return;
        }
        int n2 = 0;
        for (GenRabinPair genRabinPair : this) {
            if (n2 > 0) {
                printStream.print(" | ");
            }
            printStream.print("( Fin(" + n2 + ")");
            ++n2;
            for (int i = 0; i < genRabinPair.getNumK(); ++i) {
                printStream.print(" & Inf(" + n2 + ")");
                ++n2;
            }
            printStream.print(")");
        }
        printStream.println();
    }

    public static class GenRabinPair {
        private BitSet L;
        private ArrayList<BitSet> K_list;

        public GenRabinPair(BitSet bitSet, ArrayList<BitSet> arrayList) {
            this.L = bitSet;
            this.K_list = arrayList;
        }

        public BitSet getL() {
            return this.L;
        }

        public int getNumK() {
            return this.K_list.size();
        }

        public BitSet getK(int n) {
            return this.K_list.get(n);
        }

        public boolean isBSCCAccepting(BitSet bitSet) {
            if (this.L.intersects(bitSet)) {
                return false;
            }
            for (BitSet bitSet2 : this.K_list) {
                if (bitSet2.intersects(bitSet)) continue;
                return false;
            }
            return true;
        }

        public String getSignatureForState(int n, int n2) {
            return "?";
        }

        public GenRabinPair clone() {
            ArrayList<BitSet> arrayList = new ArrayList<BitSet>();
            for (BitSet bitSet : this.K_list) {
                arrayList.add((BitSet)bitSet.clone());
            }
            return new GenRabinPair((BitSet)this.L.clone(), arrayList);
        }

        public AcceptanceGeneric toAcceptanceGeneric() {
            AcceptanceGeneric acceptanceGeneric = new AcceptanceGeneric(AcceptanceGeneric.ElementType.FIN, (BitSet)this.L.clone());
            if (this.getNumK() == 0) {
                return acceptanceGeneric;
            }
            AcceptanceGeneric acceptanceGeneric2 = null;
            for (BitSet bitSet : this.K_list) {
                AcceptanceGeneric acceptanceGeneric3 = new AcceptanceGeneric(AcceptanceGeneric.ElementType.INF, (BitSet)bitSet.clone());
                if (acceptanceGeneric2 == null) {
                    acceptanceGeneric2 = acceptanceGeneric3;
                    continue;
                }
                acceptanceGeneric2 = new AcceptanceGeneric(AcceptanceGeneric.ElementType.AND, acceptanceGeneric2, acceptanceGeneric3);
            }
            return new AcceptanceGeneric(AcceptanceGeneric.ElementType.AND, acceptanceGeneric, acceptanceGeneric2);
        }

        public String toString() {
            String string = "(" + this.L;
            for (BitSet bitSet : this.K_list) {
                string = string + "," + bitSet;
            }
            string = string + ")";
            return string;
        }
    }
}

