/*
 * Decompiled with CFR 0.152.
 */
package userinterface.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JTable;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import userinterface.util.GUIGroupedTable;
import userinterface.util.GUIGroupedTableColumnModel;
import userinterface.util.GUIGroupedTableModel;

public class GUIGroupedTableHeader
extends JTableHeader
implements TableColumnModelListener,
MouseListener {
    private JTableHeader bottomHeader;
    private JTableHeader topHeader;
    private GUIGroupedTableModel tableModel;

    public GUIGroupedTableHeader(GUIGroupedTableColumnModel gUIGroupedTableColumnModel, GUIGroupedTableModel gUIGroupedTableModel, GUIGroupedTable gUIGroupedTable) {
        this.removeAll();
        this.tableModel = gUIGroupedTableModel;
        this.topHeader = new JTableHeader(gUIGroupedTableColumnModel.getGroupTableColumnModel());
        this.topHeader.setResizingAllowed(false);
        this.topHeader.setReorderingAllowed(false);
        final TableCellRenderer tableCellRenderer = this.topHeader.getDefaultRenderer();
        this.topHeader.setDefaultRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setFont(GUIGroupedTableHeader.this.topHeader.getFont().deriveFont(1));
                return component;
            }
        });
        this.bottomHeader = new JTableHeader(gUIGroupedTableColumnModel);
        this.bottomHeader.setReorderingAllowed(false);
        this.topHeader.setTable(gUIGroupedTable);
        this.bottomHeader.setTable(gUIGroupedTable);
        this.setLayout(new GridLayout(2, 1));
        this.add(this.topHeader);
        this.add(this.bottomHeader);
        gUIGroupedTableColumnModel.updateGroups();
        this.setPreferredSize(new Dimension(this.bottomHeader.getPreferredSize().width, this.bottomHeader.getPreferredSize().height * 2));
        this.setMinimumSize(new Dimension(this.bottomHeader.getMinimumSize().width, this.bottomHeader.getMinimumSize().height * 2));
        this.setMaximumSize(new Dimension(this.bottomHeader.getMaximumSize().width, this.bottomHeader.getMaximumSize().height * 2));
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].addMouseListener(this);
        }
        this.topHeader.addMouseMotionListener(new MouseMotionAdapter(){
            private TableColumn lastColumn;

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                TableColumn tableColumn;
                GUIGroupedTableHeader.this.bottomHeader.setToolTipText(null);
                int n = GUIGroupedTableHeader.this.topHeader.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                if (n >= 0 && (tableColumn = GUIGroupedTableHeader.this.topHeader.getColumnModel().getColumn(n)) != this.lastColumn) {
                    GUIGroupedTableHeader.this.topHeader.setToolTipText(GUIGroupedTableHeader.this.tableModel.getGroupToolTip(n));
                    this.lastColumn = tableColumn;
                }
            }
        });
        this.bottomHeader.addMouseMotionListener(new MouseMotionAdapter(){
            private TableColumn lastColumn;

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                TableColumn tableColumn;
                GUIGroupedTableHeader.this.topHeader.setToolTipText(null);
                int n = GUIGroupedTableHeader.this.bottomHeader.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                if (n >= 0 && (tableColumn = GUIGroupedTableHeader.this.bottomHeader.getColumnModel().getColumn(n)) != this.lastColumn) {
                    GUIGroupedTableHeader.this.bottomHeader.setToolTipText(GUIGroupedTableHeader.this.tableModel.getColumnToolTip(n));
                    this.lastColumn = tableColumn;
                }
            }
        });
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (this.getComponents().length < 2) {
            super.addImpl(component, object, n);
        }
    }

    @Override
    public void setReorderingAllowed(boolean bl) {
        super.setReorderingAllowed(false);
    }

    @Override
    public TableColumn getResizingColumn() {
        return this.bottomHeader.getResizingColumn();
    }

    @Override
    public void resizeAndRepaint() {
        if (this.topHeader != null && this.bottomHeader != null) {
            this.setPreferredSize(new Dimension(this.bottomHeader.getPreferredSize().width, this.bottomHeader.getPreferredSize().height * 2));
            this.setMinimumSize(new Dimension(this.bottomHeader.getMinimumSize().width, this.bottomHeader.getMinimumSize().height * 2));
            this.setMaximumSize(new Dimension(this.bottomHeader.getMaximumSize().width, this.bottomHeader.getMaximumSize().height * 2));
            this.doLayout();
        }
        super.resizeAndRepaint();
    }

    public void setColumnModel(GUIGroupedTableColumnModel gUIGroupedTableColumnModel) {
        this.topHeader.setColumnModel(gUIGroupedTableColumnModel.getGroupTableColumnModel());
        this.bottomHeader.setColumnModel(gUIGroupedTableColumnModel);
        this.resizeAndRepaint();
        gUIGroupedTableColumnModel.updateGroups();
        super.setColumnModel(gUIGroupedTableColumnModel);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.dispatchEvent(new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY() + ((Component)mouseEvent.getSource()).getBounds().y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.dispatchEvent(new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY() + ((Component)mouseEvent.getSource()).getBounds().y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.dispatchEvent(new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY() + ((Component)mouseEvent.getSource()).getBounds().y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.dispatchEvent(new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY() + ((Component)mouseEvent.getSource()).getBounds().y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dispatchEvent(new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY() + ((Component)mouseEvent.getSource()).getBounds().y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
    }
}

