/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import userinterface.GUIPrism;
import userinterface.properties.GUIExperiment;
import userinterface.properties.GUIMultiProperties;

public class GUIResultsTable
extends JDialog {
    private static int noOpen = 0;
    private GUIMultiProperties guiProps;
    private GUIExperiment exp;
    private JPanel topPanel;
    private JButton closeButton;
    private JScrollPane scroller;
    private JTable table;
    private ResultsTableModel tableModel;

    public GUIResultsTable(GUIPrism gUIPrism, GUIMultiProperties gUIMultiProperties, GUIExperiment gUIExperiment) {
        super(gUIPrism, "Experiment Results", false);
        this.guiProps = gUIMultiProperties;
        this.exp = gUIExperiment;
        this.tableModel = new ResultsTableModel(gUIExperiment);
        this.table = new JTable();
        this.table.setModel(this.tableModel);
        this.table.setCellSelectionEnabled(true);
        this.table.setRowHeight(this.getFontMetrics(this.table.getFont()).getHeight() + 4);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.closeButton);
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUIResultsTable.this.closeDialog();
            }
        });
        JLabel jLabel = new JLabel("Results of '" + this.exp.getPropertyString() + "' for '" + this.exp.getDefinedConstantsString() + "'");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jLabel, "North");
        this.topPanel = new JPanel();
        this.topPanel.setBorder(new TitledBorder("Results"));
        this.topPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.table);
        jPanel2.add((Component)jScrollPane, "Center");
        this.topPanel.add(jPanel2);
        this.topPanel.setPreferredSize(new Dimension(500, 200));
        jPanel.add((Component)this.topPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIResultsTable.this.closeDialog();
            }
        });
        jPanel3.add((Component)this.closeButton, "East");
        jPanel.add((Component)jPanel3, "South");
        this.getContentPane().add(jPanel);
    }

    @Override
    public void show() {
        this.setLocation(this.getX() + ++noOpen * 50, this.getY() + noOpen * 50);
        super.show();
    }

    @Override
    public void dispose() {
        --noOpen;
        super.dispose();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    class ResultsTableModel
    extends AbstractTableModel {
        String[] headings;
        ArrayList cells;
        int numRows;
        int numCols;

        public ResultsTableModel(GUIExperiment gUIExperiment) {
            this.headings = gUIExperiment.getResults().getHeadingsArray();
            this.cells = gUIExperiment.getResults().toArrayList();
            this.numRows = this.cells.size();
            this.numCols = this.headings.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.headings[n];
        }

        @Override
        public int getColumnCount() {
            return this.numCols;
        }

        @Override
        public int getRowCount() {
            return this.numRows;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String[] stringArray = (String[])this.cells.get(n);
            if (n2 < stringArray.length) {
                return stringArray[n2];
            }
            return "?";
        }
    }
}

