/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.computation;

import java.io.File;
import javax.swing.SwingUtilities;
import userinterface.GUIComputationThread;
import userinterface.model.GUIMultiModelHandler;
import userinterface.util.GUIComputationEvent;

public class ComputeTransientThread
extends GUIComputationThread {
    private GUIMultiModelHandler handler;
    private double transientTime;
    private int exportType;
    private File exportFile;

    public ComputeTransientThread(GUIMultiModelHandler gUIMultiModelHandler, double d) {
        this(gUIMultiModelHandler, d, 1, null);
    }

    public ComputeTransientThread(GUIMultiModelHandler gUIMultiModelHandler, double d, int n, File file) {
        super(gUIMultiModelHandler.getGUIPlugin());
        this.handler = gUIMultiModelHandler;
        this.transientTime = d;
        this.exportType = n;
        this.exportFile = file;
    }

    @Override
    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComputeTransientThread.this.plug.startProgress();
                ComputeTransientThread.this.plug.notifyEventListeners(new GUIComputationEvent(0, ComputeTransientThread.this.plug));
                ComputeTransientThread.this.plug.setTaskBarText("Computing transient probabilities...");
            }
        });
        try {
            this.prism.doTransient(this.transientTime, this.exportType, this.exportFile, null);
        }
        catch (Throwable throwable) {
            this.error(throwable);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComputeTransientThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, ComputeTransientThread.this.plug));
                    ComputeTransientThread.this.plug.setTaskBarText("Computing transient probabilities... error.");
                    ComputeTransientThread.this.plug.stopProgress();
                }
            });
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComputeTransientThread.this.plug.setTaskBarText("Computing transient probabilities... done.");
                ComputeTransientThread.this.plug.notifyEventListeners(new GUIComputationEvent(1, ComputeTransientThread.this.plug));
                ComputeTransientThread.this.plug.stopProgress();
            }
        });
    }
}

