/*
 * Decompiled with CFR 0.152.
 */
package userinterface;

import java.awt.Dimension;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import prism.Prism;
import prism.PrismSettingsListener;
import userinterface.GUIPrism;
import userinterface.OptionsPanel;
import userinterface.util.GUIEvent;
import userinterface.util.GUIEventHandler;
import userinterface.util.GUIEventListener;
import userinterface.util.GUILogEvent;
import userinterface.util.GUIUndoManager;

public abstract class GUIPlugin
extends JPanel
implements GUIEventListener,
PrismSettingsListener {
    private static final long serialVersionUID = 1L;
    private GUIPrism gui;
    private Prism prism;
    protected GUIEventHandler selectionChangeHandler;

    public GUIPlugin(GUIPrism gUIPrism, boolean bl) {
        this.gui = gUIPrism;
        this.prism = gUIPrism.getPrism();
        this.selectionChangeHandler = new GUIEventHandler(gUIPrism);
        if (bl) {
            gUIPrism.getEventHandler().addListener(this);
        }
        this.setPreferredSize(new Dimension(800, 600));
    }

    public GUIEventHandler getSelectionChangeHandler() {
        return this.selectionChangeHandler;
    }

    public GUIPlugin(GUIPrism gUIPrism) {
        this(gUIPrism, true);
    }

    public abstract String getTabText();

    public abstract JMenu getMenu();

    public abstract JToolBar getToolBar();

    public abstract OptionsPanel getOptions();

    @Deprecated
    public abstract Object getXMLSaveTree();

    @Deprecated
    public abstract String getXMLIDTag();

    public abstract boolean displaysTab();

    public Prism getPrism() {
        return this.prism;
    }

    public GUIPrism getGUI() {
        return this.gui;
    }

    public GUIUndoManager getUndoManager() {
        return null;
    }

    public boolean canDoClipBoardAction(Action action) {
        return false;
    }

    public GUIPlugin getFocussedComponent() {
        return this.gui.getFocussedPlugin();
    }

    public File getChooserFile() {
        return this.gui.getChooser().getSelectedFile();
    }

    public abstract void takeCLArgs(String[] var1);

    @Override
    public abstract boolean processGUIEvent(GUIEvent var1);

    public void onInitComponentsCompleted() {
    }

    @Deprecated
    public abstract void loadXML(Object var1);

    public void error(String string, String string2) {
        this.gui.errorDialog(string, "Error: " + string2 + ".");
    }

    public void error(String string) {
        this.gui.errorDialog("Error: " + string + ".");
    }

    public void message(String string, Object object) {
        JOptionPane.showMessageDialog(this.gui, object, string, 1);
    }

    public void message(Object object) {
        this.message("Information", object);
    }

    public void warning(String string, Object object) {
        JOptionPane.showMessageDialog(this.gui, "Warning: " + object + ".", string, 2);
    }

    public void warning(Object object) {
        this.warning("Warning", object);
    }

    public int question(String string, Object object, Object[] objectArray, int n) {
        int n2;
        if (n < 0 || n > objectArray.length) {
            n = 0;
        }
        if ((n2 = JOptionPane.showOptionDialog(this.gui, object, string, -1, 3, null, objectArray, objectArray[n])) == -1) {
            return -1;
        }
        return n2;
    }

    public int question(String string, Object object, Object[] objectArray) {
        return this.question(string, object, objectArray, 0);
    }

    public int question(Object object, Object[] objectArray) {
        return this.question("Question", object, objectArray, 0);
    }

    public int question(Object object, Object[] objectArray, int n) {
        return this.question("Question", object, objectArray, n);
    }

    public int questionYesNo(String string, Object object, int n) {
        Object[] objectArray = new String[]{"Yes", "No"};
        return this.question(string, object, objectArray, n);
    }

    public int questionYesNo(String string, Object object) {
        return this.questionYesNo(string, object, 0);
    }

    public int questionYesNo(Object object) {
        return this.questionYesNo("Question", object, 0);
    }

    public int questionYesNo(Object object, int n) {
        return this.questionYesNo("Question", object, n);
    }

    public int optionPane(String string, String string2, int n, int n2, String[] stringArray, String string3) {
        return JOptionPane.showOptionDialog(this.gui, string, string2, n, n2, null, stringArray, string3);
    }

    public int showOpenFileDialog(FileFilter fileFilter) {
        return this.showOpenFileDialog(Collections.singletonList(fileFilter), fileFilter);
    }

    public int showOpenFileDialog(Collection<FileFilter> collection, FileFilter fileFilter) {
        JFileChooser jFileChooser = this.gui.getChooser();
        jFileChooser.resetChoosableFileFilters();
        for (FileFilter fileFilter2 : collection) {
            jFileChooser.addChoosableFileFilter(fileFilter2);
        }
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.setSelectedFile(new File(""));
        return jFileChooser.showOpenDialog(this.gui);
    }

    public int showSaveFileDialog(FileFilter fileFilter) {
        return this.showSaveFileDialog(Collections.singletonList(fileFilter), fileFilter);
    }

    public int showSaveFileDialog(Collection<FileFilter> collection, FileFilter fileFilter) {
        JFileChooser jFileChooser = this.gui.getChooser();
        jFileChooser.resetChoosableFileFilters();
        for (FileFilter object2 : collection) {
            jFileChooser.addChoosableFileFilter(object2);
        }
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.setSelectedFile(new File(""));
        int n = jFileChooser.showSaveDialog(this.gui);
        if (n != 0) {
            return n;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            this.error("No file selected");
            return 1;
        }
        if (file.exists()) {
            int n2 = 2;
            n2 = this.optionPane("File \"" + file.getPath() + "\" exists. Overwrite?", "Confirm Overwrite", 2, 3, null, null);
            if (n2 != 0) {
                return 1;
            }
        }
        return 0;
    }

    public void setTaskBarText(String string) {
        this.gui.setTaskBarText(string);
    }

    public void notifyEventListeners(GUIEvent gUIEvent) {
        this.gui.notifyEventListeners(gUIEvent);
    }

    public void startProgress() {
        this.gui.startProgress();
    }

    public void stopProgress() {
        this.gui.stopProgress();
    }

    public void logln() {
        this.notifyEventListeners(new GUILogEvent(""));
    }

    public void logln(Object object) {
        this.notifyEventListeners(new GUILogEvent(object));
    }

    public void logln(int n) {
        this.notifyEventListeners(new GUILogEvent(n));
    }

    public void logln(double d) {
        this.notifyEventListeners(new GUILogEvent(d));
    }

    public void logln(float f) {
        this.notifyEventListeners(new GUILogEvent(f));
    }

    public void logln(long l) {
        this.notifyEventListeners(new GUILogEvent(l));
    }

    public void logln(short s) {
        this.notifyEventListeners(new GUILogEvent(s));
    }

    public void logln(byte by) {
        this.notifyEventListeners(new GUILogEvent(by));
    }

    public void logln(boolean bl) {
        this.notifyEventListeners(new GUILogEvent(bl));
    }

    public void log(Object object) {
        this.notifyEventListeners(new GUILogEvent(1, object));
    }

    public void log(int n) {
        this.notifyEventListeners(new GUILogEvent(1, n));
    }

    public void log(double d) {
        this.notifyEventListeners(new GUILogEvent(1, d));
    }

    public void log(float f) {
        this.notifyEventListeners(new GUILogEvent(1, f));
    }

    public void log(short s) {
        this.notifyEventListeners(new GUILogEvent(1, s));
    }

    public void log(byte by) {
        this.notifyEventListeners(new GUILogEvent(1, by));
    }

    public void log(boolean bl) {
        this.notifyEventListeners(new GUILogEvent(1, bl));
    }

    public void setTabEnabled(boolean bl) {
        this.gui.enableTab(this, bl);
    }

    public void logSeparator() {
        this.notifyEventListeners(new GUILogEvent(2, ""));
    }

    public void logWarning(String string) {
        this.notifyEventListeners(new GUILogEvent(3, string));
    }

    public void tabToFront() {
        this.gui.showTab(this);
    }

    public void logToFront() {
        this.gui.showLogTab();
    }
}

