/*
 * Decompiled with CFR 0.152.
 */
package userinterface;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import userinterface.GUIPrism;
import userinterface.OptionsPanel;
import userinterface.util.GUIException;
import userinterface.util.PresentationMetalTheme;

public class GUIGeneralOptions
extends OptionsPanel {
    private GUIPrism gui;
    private int last;
    private int adjust;
    JSlider adjustSlider;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;

    public GUIGeneralOptions(GUIPrism gUIPrism) {
        super("General");
        this.initComponents();
        this.gui = gUIPrism;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.adjustSlider = new JSlider();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jLabel1.setLabelFor(this.adjustSlider);
        this.jLabel1.setText("User interface size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.adjustSlider.setMajorTickSpacing(5);
        this.adjustSlider.setMaximum(5);
        this.adjustSlider.setMinimum(-5);
        this.adjustSlider.setMinorTickSpacing(1);
        this.adjustSlider.setPaintLabels(true);
        this.adjustSlider.setPaintTicks(true);
        this.adjustSlider.setSnapToTicks(true);
        this.adjustSlider.setValue(0);
        this.add((Component)this.adjustSlider, new GridBagConstraints());
    }

    @Override
    public void apply() {
        int n = 0;
        n = this.adjustSlider.getValue();
        if (n != this.last) {
            try {
                PresentationMetalTheme presentationMetalTheme = new PresentationMetalTheme(n);
                MetalLookAndFeel.setCurrentTheme(presentationMetalTheme);
                UIManager.setLookAndFeel(UIManager.getLookAndFeel());
            }
            catch (Exception exception) {
                return;
            }
            SwingUtilities.updateComponentTreeUI(this.gui);
            SwingUtilities.updateComponentTreeUI(this.gui.getOptions());
            this.gui.pack();
            this.gui.getOptions().pack();
            this.gui.addNotify();
            this.last = n;
        }
    }

    @Override
    public void synchronizeGUI() {
        this.last = this.adjust = this.adjustSlider.getValue();
    }

    public void defaultGUI() {
        this.adjustSlider.setValue(0);
    }

    public boolean valid() throws GUIException {
        return true;
    }

    public Element saveXMLElement(Document document) throws DOMException {
        return document.createElement("dummy");
    }

    public void loadXMLElement(Element element) {
    }

    public void loadProperties(Properties properties) {
    }

    public void loadXMLElement(Document document, Element element) {
    }

    public void saveProperties(Properties properties) {
    }
}

