/*
 * Decompiled with CFR 0.152.
 */
package strat;

import dv.IntegerVector;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import prism.Model;
import prism.PrismException;
import prism.PrismLog;
import strat.MDStrategy;
import strat.Strategy;

public class MDStrategyIV
extends MDStrategy {
    private Model model;
    private int numStates;
    private List<String> actions;
    private IntegerVector iv;

    public MDStrategyIV(Model model, IntegerVector integerVector) {
        this.model = model;
        this.numStates = (int)model.getNumStates();
        this.actions = model.getSynchs();
        this.iv = integerVector;
    }

    @Override
    public int getNumStates() {
        return this.numStates;
    }

    @Override
    public boolean isChoiceDefined(int n) {
        return this.iv.getElement(n) >= 0;
    }

    @Override
    public Strategy.Choice getChoice(int n) {
        int n2 = this.iv.getElement(n);
        switch (n2) {
            case -1: {
                return Strategy.Choice.UNKNOWN;
            }
            case -2: {
                return Strategy.Choice.ARBITRARY;
            }
            case -3: {
                return Strategy.Choice.UNREACHABLE;
            }
        }
        return Strategy.Choice.INDEX;
    }

    @Override
    public int getChoiceIndex(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getChoiceAction(int n) {
        int n2 = this.iv.getElement(n);
        return n2 >= 0 ? this.actions.get(n2) : (n2 == -1 ? "?" : (n2 == -2 ? "*" : "-"));
    }

    @Override
    public void exportInducedModel(PrismLog prismLog) {
    }

    @Override
    public void exportDotFile(PrismLog prismLog) {
        try {
            this.model.exportToFile(3, true, new File("a.dot"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (PrismException prismException) {
            prismException.printStackTrace();
        }
    }

    @Override
    public void clear() {
        this.iv.clear();
        this.iv = null;
    }
}

