/*
 * Decompiled with CFR 0.152.
 */
package strat;

import explicit.Model;
import explicit.NondetModel;
import prism.PrismLog;
import strat.MDStrategy;
import strat.Strategy;

public class MDStrategyArray
extends MDStrategy {
    private NondetModel model;
    private int[] choices;

    public MDStrategyArray(NondetModel nondetModel, int[] nArray) {
        this.model = nondetModel;
        this.choices = nArray;
    }

    @Override
    public int getNumStates() {
        return this.model.getNumStates();
    }

    @Override
    public boolean isChoiceDefined(int n) {
        return this.choices[n] >= 0;
    }

    @Override
    public Strategy.Choice getChoice(int n) {
        switch (this.choices[n]) {
            case -1: {
                return Strategy.Choice.UNKNOWN;
            }
            case -2: {
                return Strategy.Choice.ARBITRARY;
            }
            case -3: {
                return Strategy.Choice.UNREACHABLE;
            }
        }
        return Strategy.Choice.INDEX;
    }

    @Override
    public int getChoiceIndex(int n) {
        return this.choices[n];
    }

    @Override
    public Object getChoiceAction(int n) {
        int n2 = this.choices[n];
        return n2 >= 0 ? this.model.getAction(n, n2) : (n2 == -1 ? "?" : (n2 == -2 ? "*" : "-"));
    }

    @Override
    public void exportInducedModel(PrismLog prismLog) {
        Model model = this.model.constructInducedModel(this);
        model.exportToPrismExplicitTra(prismLog);
    }

    @Override
    public void exportDotFile(PrismLog prismLog) {
        this.model.exportToDotFileWithStrat(prismLog, null, this.choices);
    }

    @Override
    public void clear() {
        this.choices = null;
    }
}

