/*
 * Decompiled with CFR 0.152.
 */
package simulator.method;

import parser.ast.Expression;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.RelOp;
import prism.PrismException;
import simulator.method.SimulationMethod;
import simulator.sampler.Sampler;
import simulator.sampler.SamplerDouble;

public final class SPRTMethod
extends SimulationMethod {
    private double alpha;
    private double beta;
    private double delta;
    private double p0;
    private double p1;
    private boolean h0true;
    private int computedIterations;
    private boolean missingParameterComputed;

    public SPRTMethod(double d, double d2, double d3) {
        this.alpha = d;
        this.beta = d2;
        this.delta = d3;
        this.p0 = 0.0;
        this.p1 = 0.0;
        this.h0true = false;
        this.computedIterations = 0;
        this.missingParameterComputed = false;
    }

    @Override
    public String getName() {
        return "SPRT";
    }

    @Override
    public String getFullName() {
        return "Sequential Probability Ratio Test";
    }

    @Override
    public void reset() {
        this.h0true = false;
        this.missingParameterComputed = false;
    }

    @Override
    public void computeMissingParameterBeforeSim() throws PrismException {
    }

    @Override
    public void setExpression(Expression expression) throws PrismException {
        RelOp relOp;
        Expression expression2;
        if (expression instanceof ExpressionProb) {
            expression2 = ((ExpressionProb)expression).getProb();
            relOp = ((ExpressionProb)expression).getRelOp();
        } else if (expression instanceof ExpressionReward) {
            expression2 = ((ExpressionReward)expression).getReward();
            relOp = ((ExpressionReward)expression).getRelOp();
        } else {
            throw new PrismException("Cannot approximate " + expression + " using simulation");
        }
        if (expression2 == null) {
            throw new PrismException("Cannot use SPRT on a quantitative (=?) property");
        }
        double d = expression2.evaluateDouble();
        if (d - this.delta <= 0.0) {
            String string = "Indifference for SPRT method (" + this.delta + ") is too wide";
            string = string + " (bound " + d + " is too close to 0)";
            throw new PrismException(string);
        }
        if (d + this.delta > 1.0 && expression instanceof ExpressionProb) {
            String string = "Indifference for SPRT method (" + this.delta + ") is too wide";
            string = string + " (bound " + d + " is too close to 1)";
            throw new PrismException(string);
        }
        if (relOp.isLowerBound()) {
            this.p0 = d + this.delta;
            this.p1 = d - this.delta;
        } else {
            this.p0 = d - this.delta;
            this.p1 = d + this.delta;
        }
    }

    @Override
    public void computeMissingParameterAfterSim() {
    }

    @Override
    public Object getMissingParameter() throws PrismException {
        if (!this.missingParameterComputed) {
            throw new PrismException("Missing parameter not computed yet");
        }
        return this.computedIterations;
    }

    @Override
    public String getParametersString() {
        if (!this.missingParameterComputed) {
            return "type I error=" + this.alpha + ", type II error=" + this.beta + ", delta=" + this.delta + ", iterations=unknown";
        }
        return "type I error=" + this.alpha + ", type II error=" + this.beta + ", delta=" + this.delta + ", iterations=" + this.computedIterations;
    }

    @Override
    public boolean shouldStopNow(int n, Sampler sampler) {
        double d;
        if (n < 2) {
            return false;
        }
        try {
            d = sampler.getLikelihoodRatio(this.p1, this.p0);
        }
        catch (PrismException prismException) {
            return false;
        }
        if (sampler instanceof SamplerDouble && (d <= 0.0 || Double.isInfinite(d))) {
            return false;
        }
        if (d <= this.beta / (1.0 - this.alpha)) {
            this.h0true = true;
            this.missingParameterComputed = true;
            this.computedIterations = n;
            return true;
        }
        if (d >= (1.0 - this.beta) / this.alpha) {
            this.h0true = false;
            this.missingParameterComputed = true;
            this.computedIterations = n;
            return true;
        }
        return false;
    }

    @Override
    public int getProgress(int n, Sampler sampler) {
        return 0;
    }

    @Override
    public Object getResult(Sampler sampler) throws PrismException {
        return new Boolean(this.h0true);
    }

    @Override
    public String getResultExplanation(Sampler sampler) {
        return this.computedIterations + " samples needed to decide property " + this.h0true;
    }

    @Override
    public SimulationMethod clone() {
        SPRTMethod sPRTMethod = new SPRTMethod(this.alpha, this.beta, this.delta);
        sPRTMethod.p0 = this.p0;
        sPRTMethod.p1 = this.p1;
        sPRTMethod.h0true = this.h0true;
        sPRTMethod.computedIterations = this.computedIterations;
        sPRTMethod.missingParameterComputed = this.missingParameterComputed;
        return sPRTMethod;
    }
}

