/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import parser.State;
import parser.VarList;
import parser.ast.Command;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.ast.RewardStruct;
import parser.ast.Update;
import parser.ast.Updates;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import simulator.Choice;
import simulator.ChoiceListFlexi;
import simulator.TransitionList;

public class Updater
extends PrismComponent {
    protected boolean doProbChecks = true;
    protected double sumRoundOff = 1.0E-5;
    protected ModulesFile modulesFile;
    protected ModelType modelType;
    protected int numModules;
    protected VarList varList;
    protected Vector<String> synchs;
    protected int numSynchs;
    protected int[] synchModuleCounts;
    protected int numRewardStructs;
    protected List<List<List<Updates>>> updateLists;
    protected BitSet enabledSynchs;
    protected BitSet[] enabledModules;

    public Updater(ModulesFile modulesFile, VarList varList) {
        this(modulesFile, varList, null);
    }

    public Updater(ModulesFile modulesFile, VarList varList, PrismComponent prismComponent) {
        int n;
        this.doProbChecks = prismComponent.getSettings().getBoolean("prism.doProbChecks");
        this.sumRoundOff = prismComponent.getSettings().getDouble("prism.sumRoundOff");
        this.modulesFile = modulesFile;
        this.modelType = modulesFile.getModelType();
        this.numModules = modulesFile.getNumModules();
        this.synchs = modulesFile.getSynchs();
        this.numSynchs = this.synchs.size();
        this.numRewardStructs = modulesFile.getNumRewardStructs();
        this.varList = varList;
        ArrayList<HashSet<String>> arrayList = new ArrayList<HashSet<String>>(this.numModules);
        for (n = 0; n < this.numModules; ++n) {
            arrayList.add(new HashSet<String>(modulesFile.getModule(n).getAllSynchs()));
        }
        this.synchModuleCounts = new int[this.numSynchs];
        for (n = 0; n < this.numSynchs; ++n) {
            this.synchModuleCounts[n] = 0;
            String string = this.synchs.get(n);
            for (int i = 0; i < this.numModules; ++i) {
                if (!((HashSet)arrayList.get(i)).contains(string)) continue;
                int n2 = n;
                this.synchModuleCounts[n2] = this.synchModuleCounts[n2] + 1;
            }
        }
        this.updateLists = new ArrayList<List<List<Updates>>>(this.numModules);
        for (n = 0; n < this.numModules; ++n) {
            this.updateLists.add(new ArrayList(this.numSynchs + 1));
            for (int i = 0; i < this.numSynchs + 1; ++i) {
                this.updateLists.get(n).add(new ArrayList());
            }
        }
        this.enabledSynchs = new BitSet(this.numSynchs + 1);
        this.enabledModules = new BitSet[this.numSynchs + 1];
        for (n = 0; n < this.numSynchs + 1; ++n) {
            this.enabledModules[n] = new BitSet(this.numModules);
        }
    }

    public void setSumRoundOff(double d) {
        this.sumRoundOff = d;
    }

    public double getSumRoundOff() {
        return this.sumRoundOff;
    }

    public void calculateTransitions(State state, TransitionList transitionList) throws PrismException {
        int n;
        int n2;
        transitionList.clear();
        for (n2 = 0; n2 < this.numModules; ++n2) {
            for (n = 0; n < this.numSynchs + 1; ++n) {
                this.updateLists.get(n2).get(n).clear();
            }
        }
        this.enabledSynchs.clear();
        for (n2 = 0; n2 < this.numSynchs + 1; ++n2) {
            this.enabledModules[n2].clear();
        }
        for (n2 = 0; n2 < this.numModules; ++n2) {
            this.calculateUpdatesForModule(n2, state);
        }
        n2 = this.enabledModules[0].nextSetBit(0);
        while (n2 >= 0) {
            for (Updates object2 : this.updateLists.get(n2).get(0)) {
                ChoiceListFlexi choiceListFlexi = this.processUpdatesAndCreateNewChoice(-(n2 + 1), object2, state);
                if (choiceListFlexi.size() <= 0) continue;
                transitionList.add(choiceListFlexi);
            }
            n2 = this.enabledModules[0].nextSetBit(n2 + 1);
        }
        ArrayList<ChoiceListFlexi> arrayList = new ArrayList<ChoiceListFlexi>();
        n2 = this.enabledSynchs.nextSetBit(1);
        while (n2 >= 0) {
            arrayList.clear();
            if (this.enabledModules[n2].cardinality() >= this.synchModuleCounts[n2 - 1]) {
                n = this.enabledModules[n2].nextSetBit(0);
                while (n >= 0) {
                    Object object;
                    int n3 = this.updateLists.get(n).get(n2).size();
                    if (n3 == 1) {
                        object = this.updateLists.get(n).get(n2).get(0);
                        if (arrayList.size() == 0) {
                            ChoiceListFlexi choiceListFlexi = this.processUpdatesAndCreateNewChoice(n2, (Updates)object, state);
                            if (choiceListFlexi.size() > 0) {
                                arrayList.add(choiceListFlexi);
                            }
                        } else {
                            for (ChoiceListFlexi choiceListFlexi : arrayList) {
                                this.processUpdatesAndAddToProduct((Updates)object, state, choiceListFlexi);
                            }
                        }
                    } else if (arrayList.size() == 0) {
                        for (Updates updates : this.updateLists.get(n).get(n2)) {
                            ChoiceListFlexi choiceListFlexi = this.processUpdatesAndCreateNewChoice(n2, updates, state);
                            if (choiceListFlexi.size() <= 0) continue;
                            arrayList.add(choiceListFlexi);
                        }
                    } else {
                        int n4;
                        int n5;
                        int n6 = arrayList.size();
                        for (n5 = 0; n5 < n3 - 1; ++n5) {
                            for (n4 = 0; n4 < n6; ++n4) {
                                arrayList.add(new ChoiceListFlexi((ChoiceListFlexi)arrayList.get(n4)));
                            }
                        }
                        for (n5 = 0; n5 < n3; ++n5) {
                            object = this.updateLists.get(n).get(n2).get(n5);
                            for (n4 = 0; n4 < n6; ++n4) {
                                this.processUpdatesAndAddToProduct((Updates)object, state, (ChoiceListFlexi)arrayList.get(n5 * n6 + n4));
                            }
                        }
                    }
                    n = this.enabledModules[n2].nextSetBit(n + 1);
                }
                for (ChoiceListFlexi choiceListFlexi : arrayList) {
                    transitionList.add(choiceListFlexi);
                }
            }
            n2 = this.enabledSynchs.nextSetBit(n2 + 1);
        }
        if (this.modelType == ModelType.DTMC) {
            double d = transitionList.getProbabilitySum();
            transitionList.scaleProbabilitiesBy(1.0 / d);
        }
    }

    public void calculateStateRewards(State state, double[] dArray) throws PrismLangException {
        for (int i = 0; i < this.numRewardStructs; ++i) {
            RewardStruct rewardStruct = this.modulesFile.getRewardStruct(i);
            int n = rewardStruct.getNumItems();
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                if (rewardStruct.getRewardStructItem(j).isTransitionReward() || !rewardStruct.getStates(j).evaluateBoolean(state)) continue;
                d += rewardStruct.getReward(j).evaluateDouble(state);
            }
            dArray[i] = d;
        }
    }

    public void calculateTransitionRewards(State state, Choice choice, double[] dArray) throws PrismLangException {
        for (int i = 0; i < this.numRewardStructs; ++i) {
            RewardStruct rewardStruct = this.modulesFile.getRewardStruct(i);
            int n = rewardStruct.getNumItems();
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                if (!rewardStruct.getRewardStructItem(j).isTransitionReward() || rewardStruct.getRewardStructItem(j).getSynchIndex() != Math.max(0, choice.getModuleOrActionIndex()) || !rewardStruct.getStates(j).evaluateBoolean(state)) continue;
                d += rewardStruct.getReward(j).evaluateDouble(state);
            }
            dArray[i] = d;
        }
    }

    protected void calculateUpdatesForModule(int n, State state) throws PrismLangException {
        Module module = this.modulesFile.getModule(n);
        int n2 = module.getNumCommands();
        for (int i = 0; i < n2; ++i) {
            Command command = module.getCommand(i);
            if (!command.getGuard().evaluateBoolean(state)) continue;
            int n3 = command.getSynchIndex();
            this.updateLists.get(n).get(n3).add(command.getUpdates());
            this.enabledSynchs.set(n3);
            this.enabledModules[n3].set(n);
        }
    }

    private ChoiceListFlexi processUpdatesAndCreateNewChoice(int n, Updates updates, State state) throws PrismLangException {
        ChoiceListFlexi choiceListFlexi = new ChoiceListFlexi();
        choiceListFlexi.setModuleOrActionIndex(n);
        int n2 = updates.getNumUpdates();
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d2 = updates.getProbabilityInState(i, state);
            if (Double.isNaN(d2) || d2 < 0.0) {
                Object object = this.modelType.choicesSumToOne() ? "Probability" : "Rate";
                object = (String)object + " is invalid (" + d2 + ") in state " + state.toString(this.modulesFile);
                throw new PrismLangException((String)object, updates);
            }
            if (d2 == 0.0) continue;
            d += d2;
            ArrayList<Update> arrayList = new ArrayList<Update>();
            arrayList.add(updates.getUpdate(i));
            choiceListFlexi.add(d2, arrayList);
        }
        if (choiceListFlexi.size() == 0) {
            Object object = this.modelType.probabilityOrRate();
            object = (String)object + (updates.getNumUpdates() > 1 ? " values sum to " : " is ");
            object = (String)object + "zero for updates in state " + state.toString(this.modulesFile);
            throw new PrismLangException((String)object, updates);
        }
        if (this.doProbChecks && choiceListFlexi.size() > 0 && this.modelType.choicesSumToOne() && Math.abs(d - 1.0) > this.sumRoundOff) {
            throw new PrismLangException("Probabilities sum to " + d + " in state " + state.toString(this.modulesFile), updates);
        }
        return choiceListFlexi;
    }

    private void processUpdatesAndAddToProduct(Updates updates, State state, ChoiceListFlexi choiceListFlexi) throws PrismLangException {
        ChoiceListFlexi choiceListFlexi2 = this.processUpdatesAndCreateNewChoice(0, updates, state);
        choiceListFlexi.productWith(choiceListFlexi2);
    }
}

