/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import settings.Setting;
import settings.SettingEditor;

public class ColorEditor
implements SettingEditor,
ActionListener,
FocusListener {
    private JLabel renderer;
    private JPanel panel;
    private Font font = new Font("monospaced", 2, 12);
    private JPanel colourPanel;
    private JPanel blank1;
    private JPanel blank2;
    private JButton button;
    private JTable lastTable = null;
    private int tableRow = -1;
    private int tableCol = -1;
    private boolean dialogFocus = false;
    private boolean modified = false;

    public ColorEditor() {
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.renderer = new JLabel();
        this.colourPanel = new JPanel();
        this.renderer = new JLabel();
        this.blank2 = new JPanel();
        this.blank1 = new JPanel();
        this.button = new JButton("...");
        this.button.setFont(new Font("serif", 0, 7));
        this.panel.add((Component)this.renderer, "Center");
        this.blank2.setLayout(new FlowLayout(1, 0, 0));
        this.blank2.setPreferredSize(new Dimension(20, 2));
        this.colourPanel.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
        this.colourPanel.setPreferredSize(new Dimension(12, 12));
        this.blank2.add(this.colourPanel);
        this.panel.add((Component)this.blank2, "West");
        this.blank1.setLayout(new FlowLayout(1, 0, 0));
        this.blank1.setPreferredSize(new Dimension(18, 2));
        this.button.setPreferredSize(new Dimension(16, 12));
        this.blank1.add(this.button);
        this.panel.add((Component)this.blank1, "East");
        this.button.addActionListener(this);
        this.button.addFocusListener(this);
    }

    @Override
    public Object getEditorValue() {
        if (this.modified) {
            this.modified = false;
            return this.colourPanel.getBackground();
        }
        return "$%^&*NOTCHANGED*&^%$";
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Setting setting, Object object, boolean bl, int n, int n2) {
        ArrayList arrayList;
        if (bl) {
            this.renderer.setForeground(jTable.getSelectionForeground());
            this.panel.setBackground(jTable.getSelectionBackground());
            this.blank1.setBackground(jTable.getSelectionBackground());
            this.blank2.setBackground(jTable.getSelectionBackground());
            this.button.setBackground(jTable.getSelectionBackground());
        } else {
            this.renderer.setForeground(jTable.getForeground());
            this.panel.setBackground(jTable.getBackground());
            this.blank1.setBackground(jTable.getBackground());
            this.blank2.setBackground(jTable.getBackground());
            this.button.setBackground(jTable.getBackground());
        }
        this.panel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        if (object instanceof Color) {
            Color color = (Color)object;
            this.renderer.setText("[" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "]");
            this.renderer.setFont(this.font);
            this.colourPanel.setBackground(color);
        } else if (object instanceof ArrayList && (arrayList = (ArrayList)object).size() > 0) {
            Color color = null;
            boolean bl2 = true;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!(arrayList.get(i) instanceof Color)) continue;
                Color color2 = (Color)arrayList.get(i);
                if (color != null) {
                    if (!color2.equals(color)) {
                        bl2 = false;
                        break;
                    }
                    color = color2;
                    continue;
                }
                color = color2;
            }
            if (bl2) {
                this.renderer.setText("[" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "]");
                this.renderer.setFont(this.font);
                this.colourPanel.setBackground(color);
            } else {
                this.renderer.setText("(Different values)");
                this.renderer.setFont(this.font);
                this.colourPanel.setBackground(Color.lightGray);
            }
        }
        this.lastTable = jTable;
        this.tableRow = n;
        this.tableCol = n2;
        return this.panel;
    }

    @Override
    public void stopEditing() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.dialogFocus = true;
        Color color = JColorChooser.showDialog(this.lastTable, "Choose Colour", this.colourPanel.getBackground());
        if (color != null) {
            this.colourPanel.setBackground(color);
            this.renderer.setText("[" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "]");
            if (this.lastTable != null) {
                this.panel.setBackground(this.lastTable.getBackground());
                this.blank1.setBackground(this.lastTable.getBackground());
                this.blank2.setBackground(this.lastTable.getBackground());
            }
            if (this.dialogFocus) {
                this.dialogFocus = false;
                if (this.lastTable != null) {
                    this.lastTable.editingStopped(new ChangeEvent(this));
                }
            } else if (this.lastTable != null) {
                this.lastTable.setValueAt(this.getEditorValue(), this.tableRow, this.tableCol);
            }
            this.modified = true;
        }
        if (this.lastTable != null) {
            this.lastTable.editingStopped(new ChangeEvent(this));
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.dialogFocus = false;
    }
}

