/*
 * Decompiled with CFR 0.152.
 */
package pta;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import prism.PrismException;
import pta.Constraint;
import pta.Edge;
import pta.PTA;

public class Transition {
    private PTA parent;
    private int src;
    private String action;
    private Set<Constraint> guard;
    private int numEdges;
    private ArrayList<Edge> edges;

    public Transition(PTA pTA, int n, String string) {
        this.parent = pTA;
        this.src = n;
        this.action = string;
        this.guard = new LinkedHashSet<Constraint>();
        this.numEdges = 0;
        this.edges = new ArrayList();
    }

    public Transition(Transition transition) {
        this(transition.parent, transition.src, transition.action);
        for (Constraint object : transition.guard) {
            this.addGuardConstraint(new Constraint(object));
        }
        for (Edge edge : transition.edges) {
            this.addEdge(new Edge(edge));
        }
    }

    public void addGuardConstraint(Constraint constraint) {
        this.guard.add(constraint);
        this.parent.recomputeMaxClockConstraint(constraint);
    }

    public Edge addEdge(double d, int n) {
        Edge edge = new Edge(this, d, n);
        this.edges.add(edge);
        ++this.numEdges;
        return edge;
    }

    public void addEdge(Edge edge) {
        edge.setParent(this);
        this.edges.add(edge);
        ++this.numEdges;
    }

    public void setParent(PTA pTA) {
        this.parent = pTA;
    }

    public PTA getParent() {
        return this.parent;
    }

    public String getAction() {
        return this.action;
    }

    public int getSource() {
        return this.src;
    }

    public Iterable<Constraint> getGuardConstraints() {
        return this.guard;
    }

    public int getNumEdges() {
        return this.edges.size();
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public void check() throws PrismException {
        double d = 0.0;
        double d2 = 1.0E-10;
        for (Edge edge : this.edges) {
            edge.check();
            d += edge.getProbability();
        }
        if (d < 1.0 - d2 || d > 1.0 + d2) {
            throw new PrismException("Non-1 probability (" + d + ") for PTA transition \"" + this + "\"");
        }
    }

    public String toString() {
        Object object = "";
        object = (String)object + this.parent.getLocationName(this.src) + " -";
        if (this.action != null) {
            object = (String)object + this.action + ":";
        }
        object = (String)object + Constraint.toStringList(this.parent, this.guard);
        object = (String)object + "-> ";
        boolean bl = true;
        for (Edge edge : this.edges) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + " + ";
            }
            object = (String)object + edge;
        }
        return object;
    }

    public void writeToDesFile(Writer writer) throws PrismException, IOException {
        writer.write("\t[\n");
        for (Edge edge : this.edges) {
            edge.writeToDesFile(writer, (String)(this.action == null || "".equals(this.action) ? "" : this.action + "||"), this.guard);
        }
        writer.write("\t]\n");
    }
}

