/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.Vector;
import parser.ast.ModulesFile;
import parser.ast.SystemDefn;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class SystemReference
extends SystemDefn {
    private String name;

    public SystemReference(String string) {
        this.name = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void getModules(Vector<String> vector) {
        vector.addElement(this.name);
    }

    @Override
    public void getModules(Vector<String> vector, ModulesFile modulesFile) {
        SystemDefn systemDefn = modulesFile.getSystemDefnByName(this.name);
        if (systemDefn != null) {
            systemDefn.getModules(vector, modulesFile);
        }
    }

    @Override
    public void getSynchs(Vector<String> vector) {
    }

    @Override
    public void getSynchs(Vector<String> vector, ModulesFile modulesFile) {
        SystemDefn systemDefn = modulesFile.getSystemDefnByName(this.name);
        if (systemDefn != null) {
            systemDefn.getSynchs(vector, modulesFile);
        }
    }

    @Override
    public void getReferences(Vector<String> vector) {
        if (!vector.contains(this.name)) {
            vector.add(this.name);
        }
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        return "\"" + this.name + "\"";
    }

    @Override
    public SystemDefn deepCopy() {
        SystemReference systemReference = new SystemReference(this.name);
        systemReference.setPosition(this);
        return systemReference;
    }
}

