/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class Filter
extends ASTElement {
    private Expression expr = null;
    private boolean minReq = false;
    private boolean maxReq = false;

    public Filter(Expression expression) {
        this.expr = expression;
    }

    public void setExpression(Expression expression) {
        this.expr = expression;
    }

    public void setMinRequested(boolean bl) {
        this.minReq = bl;
    }

    public void setMaxRequested(boolean bl) {
        this.maxReq = bl;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public boolean minRequested() {
        return this.minReq;
    }

    public boolean maxRequested() {
        return this.maxReq;
    }

    public String getFilterOpString() {
        if (this.minReq) {
            return this.maxReq ? "range" : "min";
        }
        return this.maxReq ? "max" : "state";
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        object = (String)object + "{" + this.expr + "}";
        if (this.minReq) {
            object = (String)object + "{min}";
        }
        if (this.maxReq) {
            object = (String)object + "{max}";
        }
        return object;
    }

    @Override
    public ASTElement deepCopy() {
        Filter filter = new Filter(this.expr.deepCopy());
        filter.setMinRequested(this.minReq);
        filter.setMaxRequested(this.maxReq);
        filter.setPosition(this);
        return filter;
    }
}

