/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import param.Function;
import param.MutablePMC;

final class StateEliminator {
    private MutablePMC pmc;
    private EliminationOrder eliminationOrder;

    StateEliminator(MutablePMC mutablePMC, EliminationOrder eliminationOrder) {
        this.pmc = mutablePMC;
        this.eliminationOrder = eliminationOrder;
    }

    private int[] collectStatesForward() {
        int[] nArray = new int[this.pmc.getNumStates()];
        BitSet bitSet = new BitSet(this.pmc.getNumStates());
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = 0;
        for (int i = 0; i < this.pmc.getNumStates(); ++i) {
            if (!this.pmc.isInitState(i)) continue;
            nArray[n] = i;
            bitSet.set(i, true);
            hashSet.add(i);
            ++n;
        }
        while (!hashSet.isEmpty()) {
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                Iterator iterator2 = this.pmc.transitionTargets.get(n2).iterator();
                while (iterator2.hasNext()) {
                    int n3 = (Integer)iterator2.next();
                    if (bitSet.get(n3)) continue;
                    bitSet.set(n3, true);
                    hashSet2.add(n3);
                    nArray[n] = n3;
                    ++n;
                }
            }
            hashSet = hashSet2;
        }
        return nArray;
    }

    private int[] collectStatesBackward() {
        return this.collectStatesBackward(false);
    }

    private int[] collectStatesBackward(boolean bl) {
        int n;
        int n2;
        int[] nArray = new int[this.pmc.getNumStates()];
        BitSet bitSet = new BitSet(this.pmc.getNumStates());
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n3 = 0;
        for (int i = 0; i < this.pmc.getNumStates(); ++i) {
            if (!this.pmc.isTargetState(i)) continue;
            hashSet.add(i);
            nArray[n3] = i;
            bitSet.set(i, true);
            ++n3;
        }
        while (!hashSet.isEmpty()) {
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                n2 = (Integer)iterator.next();
                Iterator iterator2 = this.pmc.incoming.get(n2).iterator();
                while (iterator2.hasNext()) {
                    int n4 = (Integer)iterator2.next();
                    if (bitSet.get(n4)) continue;
                    bitSet.set(n4, true);
                    hashSet2.add(n4);
                    nArray[n3] = n4;
                    ++n3;
                }
            }
            hashSet = hashSet2;
        }
        if (bl) {
            return nArray;
        }
        HashSet<Integer> hashSet3 = new HashSet<Integer>();
        for (n = 0; n < nArray.length; ++n) {
            n2 = nArray[n];
            hashSet3.add(n2);
        }
        for (n = 0; n < this.pmc.getNumStates(); ++n) {
            if (hashSet3.contains(n)) continue;
            nArray[n3] = n;
            ++n3;
        }
        return nArray;
    }

    private boolean precompute() {
        if (!this.pmc.isUseTime() && !this.pmc.hasTargetStates()) {
            for (int i = 0; i < this.pmc.getNumStates(); ++i) {
                this.pmc.makeAbsorbing(i);
                if (!this.pmc.isUseRewards()) continue;
                this.pmc.setReward(i, this.pmc.getFunctionFactory().getInf());
            }
            return false;
        }
        if (this.pmc.isUseRewards()) {
            int n;
            int[] nArray = this.collectStatesBackward(true);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (n = 0; n < nArray.length; ++n) {
                hashSet.add(nArray[n]);
            }
            for (n = 0; n < this.pmc.getNumStates(); ++n) {
                if (this.pmc.isUseTime() || hashSet.contains(n)) continue;
                this.pmc.setReward(n, this.pmc.getFunctionFactory().getInf());
            }
        }
        return true;
    }

    void eliminate() {
        int n;
        if (!this.precompute()) {
            return;
        }
        int[] nArray = new int[this.pmc.getNumStates()];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        switch (this.eliminationOrder) {
            case ARBITRARY: {
                for (n = 0; n < this.pmc.getNumStates(); ++n) {
                    nArray[n] = n;
                }
                break;
            }
            case FORWARD: {
                nArray = this.collectStatesForward();
                break;
            }
            case FORWARD_REVERSED: {
                nArray = this.collectStatesForward();
                for (n = 0; n < this.pmc.getNumStates(); ++n) {
                    arrayList.add(nArray[n]);
                }
                Collections.reverse(arrayList);
                for (n = 0; n < this.pmc.getNumStates(); ++n) {
                    nArray[n] = (Integer)arrayList.get(n);
                }
                break;
            }
            case BACKWARD: {
                nArray = this.collectStatesBackward();
                break;
            }
            case BACKWARD_REVERSED: {
                nArray = this.collectStatesBackward();
                for (n = 0; n < this.pmc.getNumStates(); ++n) {
                    arrayList.add(nArray[n]);
                }
                Collections.reverse(arrayList);
                for (n = 0; n < this.pmc.getNumStates(); ++n) {
                    nArray[n] = (Integer)arrayList.get(n);
                }
                break;
            }
            case RANDOM: {
                for (n = 0; n < this.pmc.getNumStates(); ++n) {
                    arrayList.add(n);
                }
                Collections.shuffle(arrayList);
                for (n = 0; n < this.pmc.getNumStates(); ++n) {
                    nArray[n] = (Integer)arrayList.get(n);
                }
                break;
            }
            default: {
                throw new RuntimeException("unknown state elimination order");
            }
        }
        for (n = 0; n < this.pmc.getNumStates(); ++n) {
            this.eliminate(nArray[n]);
        }
    }

    private void eliminate(int n) {
        Object object;
        Object object2;
        int n2;
        int n3;
        Iterator<NewTransition> iterator;
        Function function = this.pmc.getSelfLoopProb(n);
        if (function.equals(this.pmc.getFunctionFactory().getOne())) {
            return;
        }
        Function function2 = function.star();
        if (this.pmc.isUseRewards()) {
            this.pmc.setReward(n, this.pmc.getReward(n).multiply(function2));
            iterator = this.pmc.incoming.get(n).iterator();
            while (iterator.hasNext()) {
                n3 = (Integer)iterator.next();
                if (n3 == n) continue;
                this.pmc.setReward(n3, this.pmc.getReward(n3).add(this.pmc.getTransProb(n3, n).multiply(this.pmc.getReward(n))));
            }
        }
        if (this.pmc.isUseTime()) {
            this.pmc.setTime(n, this.pmc.getTime(n).multiply(function2));
            iterator = this.pmc.incoming.get(n).iterator();
            while (iterator.hasNext()) {
                n3 = (Integer)iterator.next();
                if (n3 == n) continue;
                this.pmc.setTime(n3, this.pmc.getTime(n3).add(this.pmc.getTransProb(n3, n).multiply(this.pmc.getTime(n))));
            }
        }
        iterator = new ArrayList();
        Iterator iterator2 = this.pmc.incoming.get(n).iterator();
        while (iterator2.hasNext()) {
            n2 = (Integer)iterator2.next();
            if (n2 == n) continue;
            object2 = this.pmc.getTransProb(n2, n);
            object = this.pmc.transitionTargets.get(n).listIterator();
            ListIterator listIterator = this.pmc.transitionProbs.get(n).listIterator();
            while (object.hasNext()) {
                int n4 = (Integer)object.next();
                Function function3 = (Function)listIterator.next();
                if (n4 == n) continue;
                Function function4 = ((Function)object2).multiply(function2.multiply(function3));
                ((ArrayList)((Object)iterator)).add(new NewTransition(n2, n4, function4));
            }
        }
        iterator2 = this.pmc.incoming.get(n).iterator();
        block4: while (iterator2.hasNext()) {
            n2 = (Integer)iterator2.next();
            object2 = this.pmc.transitionTargets.get(n2).listIterator();
            object = this.pmc.transitionProbs.get(n2).listIterator();
            while (object2.hasNext()) {
                int n5 = (Integer)object2.next();
                object.next();
                if (n5 != n) continue;
                object2.remove();
                object.remove();
                continue block4;
            }
        }
        iterator2 = ((ArrayList)((Object)iterator)).iterator();
        while (iterator2.hasNext()) {
            NewTransition newTransition = (NewTransition)iterator2.next();
            this.pmc.addTransition(newTransition.fromState, newTransition.toState, newTransition.prob);
        }
        iterator2 = this.pmc.transitionTargets.get(n).listIterator();
        ListIterator<Function> listIterator = this.pmc.transitionProbs.get(n).listIterator();
        while (iterator2.hasNext()) {
            int n6 = (Integer)iterator2.next();
            object = (Function)listIterator.next();
            if (n == n6) continue;
            listIterator.set(function2.multiply((Function)object));
        }
        iterator2 = this.pmc.transitionTargets.get(n).listIterator();
        listIterator = this.pmc.transitionProbs.get(n).listIterator();
        while (iterator2.hasNext()) {
            int n7 = (Integer)iterator2.next();
            listIterator.next();
            if (n != n7) continue;
            iterator2.remove();
            listIterator.remove();
            break;
        }
        this.pmc.incoming.get(n).clear();
    }

    Function getResult(int n) {
        if (this.pmc.isUseRewards() && !this.pmc.isUseTime()) {
            return this.pmc.getReward(n);
        }
        if (this.pmc.isUseRewards() && this.pmc.isUseTime()) {
            ListIterator listIterator = this.pmc.transitionTargets.get(n).listIterator();
            ListIterator listIterator2 = this.pmc.transitionProbs.get(n).listIterator();
            Function function = this.pmc.getFunctionFactory().getZero();
            while (listIterator.hasNext()) {
                int n2 = (Integer)listIterator.next();
                Function function2 = (Function)listIterator2.next();
                function = function.add(function2.multiply(this.pmc.getReward(n2)).divide(this.pmc.getTime(n2)));
            }
            return function;
        }
        ListIterator listIterator = this.pmc.transitionTargets.get(n).listIterator();
        ListIterator listIterator3 = this.pmc.transitionProbs.get(n).listIterator();
        Function function = this.pmc.getFunctionFactory().getZero();
        while (listIterator.hasNext()) {
            int n3 = (Integer)listIterator.next();
            Function function3 = (Function)listIterator3.next();
            if (!this.pmc.isTargetState(n3)) continue;
            function = function.add(function3);
        }
        return function;
    }

    class NewTransition {
        final int fromState;
        final int toState;
        final Function prob;

        public NewTransition(int n, int n2, Function function) {
            this.fromState = n;
            this.toState = n2;
            this.prob = function;
        }
    }

    static enum EliminationOrder {
        ARBITRARY,
        FORWARD,
        FORWARD_REVERSED,
        BACKWARD,
        BACKWARD_REVERSED,
        RANDOM;

    }
}

