/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import param.BigRational;
import param.BoxRegion;
import param.BoxRegionFactory;
import param.Function;
import param.Point;
import param.Region;
import param.RegionValues;
import param.StateValues;

final class ResultExporter {
    private RegionValues values;
    private BoxRegionFactory regionFactory;
    private OutputStream output;
    private int pointsPerDim;

    ResultExporter() {
    }

    void setRegionValues(RegionValues regionValues) {
        this.values = regionValues;
        this.regionFactory = (BoxRegionFactory)regionValues.getRegionFactory();
    }

    void setOutputStream(OutputStream outputStream) {
        this.output = outputStream;
    }

    void setPointsPerDimension(int n) {
        this.pointsPerDim = n;
    }

    void print() {
        PrintStream printStream = new PrintStream(this.output);
        int n = this.regionFactory.numVariables();
        boolean bl = this.values.booleanValues();
        if (n == 2 && bl) {
            this.printBooleanTwoVars(printStream);
        } else if (n == 2 && !bl) {
            this.printFunctionTwoVars(printStream);
        } else {
            throw new RuntimeException("not implemented");
        }
        printStream.flush();
    }

    private void printBooleanTwoVars(PrintStream printStream) {
        printStream.println("\\begin{tikzpicture}[scale=5]");
        printStream.print("\\draw[rectangle,fill=gray] ");
        printStream.print("(" + this.regionFactory.getLowerBound(0).doubleValue());
        printStream.print("," + this.regionFactory.getLowerBound(1).doubleValue() + ")");
        printStream.print(" rectangle ");
        printStream.print("(" + this.regionFactory.getUpperBound(0).doubleValue());
        printStream.print("," + this.regionFactory.getUpperBound(1).doubleValue() + ");\n");
        for (Map.Entry<Region, StateValues> entry : this.values) {
            boolean bl = entry.getValue().getInitStateValueAsBoolean();
            BoxRegion boxRegion = (BoxRegion)entry.getKey();
            String string = bl ? "white" : "black";
            String string2 = bl ? "black" : "white";
            printStream.print("\\draw[rectangle,");
            printStream.print("fill=" + string + ",");
            printStream.print("draw=" + string2 + "] ");
            printStream.print("(" + boxRegion.getDimensionLower(0).doubleValue());
            printStream.print("," + boxRegion.getDimensionLower(1).doubleValue() + ")");
            printStream.print(" rectangle ");
            printStream.print("(" + boxRegion.getDimensionUpper(0).doubleValue());
            printStream.print("," + boxRegion.getDimensionUpper(1).doubleValue() + ");\n");
        }
        printStream.print("\\draw[rectangle,draw=black] ");
        printStream.print("(" + this.regionFactory.getLowerBound(0).doubleValue());
        printStream.print("," + this.regionFactory.getLowerBound(1).doubleValue() + ")");
        printStream.print(" rectangle ");
        printStream.print("(" + this.regionFactory.getUpperBound(0).doubleValue());
        printStream.print("," + this.regionFactory.getUpperBound(1).doubleValue() + ");\n");
        printStream.println("\\end{tikzpicture}");
    }

    private ArrayList<Point> samplePoints() {
        Object object;
        Object object2;
        int n = this.regionFactory.numVariables();
        BigRational[] bigRationalArray = new BigRational[n];
        for (int i = 0; i < n; ++i) {
            bigRationalArray[i] = this.regionFactory.sideWidth(i).divide(this.pointsPerDim - 1);
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        int n2 = (int)Math.pow(this.pointsPerDim, n);
        for (int i = 0; i < n2; ++i) {
            int n3 = i;
            BigRational[] object32 = new BigRational[n];
            for (int pointComparator = 0; pointComparator < n; ++pointComparator) {
                int n4 = n3 % this.pointsPerDim;
                n3 /= this.pointsPerDim;
                object32[pointComparator] = object2 = this.regionFactory.getLowerBound(pointComparator).add(bigRationalArray[pointComparator].multiply(n4));
            }
            arrayList.add(new Point(object32));
        }
        HashMap<Point, BigRational> hashMap = new HashMap<Point, BigRational>();
        block3: for (Point point : arrayList) {
            for (Map.Entry<Region, StateValues> entry : this.values) {
                object2 = entry.getKey();
                object = entry.getValue().getInitStateValueAsFunction();
                if (!((Region)object2).contains(point)) continue;
                hashMap.put(point, ((Function)object).evaluate(point));
                continue block3;
            }
        }
        HashSet hashSet = new HashSet();
        for (Map.Entry<Region, StateValues> entry : this.values) {
            hashSet.add(entry.getValue().getInitStateValueAsFunction());
        }
        for (Point point : arrayList) {
            BigRational bigRational;
            BigRational bigRational2;
            if (hashMap.containsKey(point)) continue;
            boolean bl = false;
            object2 = BigRational.ZERO;
            for (int i = 0; i < this.pointsPerDim && !bl; ++i) {
                bigRational2 = BigRational.ZERO;
                int n5 = 0;
                for (int j = 0; j < n; ++j) {
                    for (int k = -1; k <= 1; k += 2) {
                        bigRational = bigRationalArray[j].multiply(j).multiply(k);
                        BigRational[] bigRationalArray2 = point.toArray();
                        bigRationalArray2[j] = bigRationalArray2[j].add(bigRational);
                        Point point2 = new Point(bigRationalArray2);
                        BigRational bigRational3 = (BigRational)hashMap.get(point2);
                        if (bigRational3 == null) continue;
                        bl = true;
                        bigRational2 = bigRational2.add(bigRational3);
                        ++n5;
                    }
                }
                if (!bl) continue;
                object2 = bigRational2.divide(n5);
            }
            object = new BigRational(1000L);
            bigRational2 = new BigRational(1000L);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Function function = (Function)iterator.next();
                BigRational bigRational4 = function.evaluate(point);
                bigRational = ((BigRational)object2).subtract(bigRational4).abs();
                if (bigRational.compareTo((BigRational)object) != -1) continue;
                bigRational2 = bigRational4;
                object = bigRational;
            }
            hashMap.put(point, bigRational2);
        }
        ArrayList<Point> arrayList2 = new ArrayList<Point>();
        for (Point point : arrayList) {
            object2 = new BigRational[n + 1];
            for (int i = 0; i < n; ++i) {
                object2[i] = point.getDimension(i);
            }
            object2[n] = (BigRational)hashMap.get(point);
            arrayList2.add(new Point((BigRational[])object2));
        }
        PointComparator pointComparator = new PointComparator();
        Collections.sort(arrayList2, pointComparator);
        return arrayList2;
    }

    private void printFunctionTwoVars(PrintStream printStream) {
        printStream.println("\\begin{tikzpicture}");
        printStream.println("\\begin{axis}[");
        printStream.println("  view={30}{30}");
        printStream.println("  ]");
        printStream.println("  \\addplot3[mesh,color=black] coordinates {");
        ArrayList<Point> arrayList = this.samplePoints();
        BigRational bigRational = arrayList.get(0).getDimension(1);
        for (Point point : arrayList) {
            if (!bigRational.equals(point.getDimension(1))) {
                printStream.print("\n\n");
                bigRational = point.getDimension(1);
            }
            printStream.print(" (");
            for (int i = 0; i < point.size(); ++i) {
                printStream.print(point.getDimension(i).doubleValue());
                if (i >= point.size() - 1) continue;
                printStream.print(",");
            }
            printStream.print(")");
        }
        printStream.println();
        printStream.println("  };");
        printStream.println("\\end{axis}");
        printStream.println("\\end{tikzpicture}");
    }

    class PointComparator
    implements Comparator<Point> {
        PointComparator() {
        }

        @Override
        public int compare(Point point, Point point2) {
            int n = point.size();
            for (int i = n - 2; i > 0; --i) {
                int n2 = point.getDimension(i).compareTo(point2.getDimension(i));
                if (n2 == 0) continue;
                return n2;
            }
            return 0;
        }
    }
}

