/*
 * Decompiled with CFR 0.152.
 */
package param;

import param.BigRational;
import param.ConstraintChecker;
import param.FunctionFactory;
import param.RegionValues;
import param.StateBoolean;
import param.StateValue;
import param.StateValues;

abstract class RegionFactory {
    protected FunctionFactory functionFactory;
    protected ConstraintChecker constraintChecker;
    protected BigRational precision;
    protected int initialState;
    protected int numStates;
    protected boolean subsumeRegions;

    RegionFactory() {
    }

    abstract RegionValues completeCover(StateValues var1);

    RegionValues completeCover(StateValue stateValue) {
        StateValues stateValues = new StateValues(this.numStates, this.initialState, stateValue);
        return this.completeCover(stateValues);
    }

    RegionValues completeCover(boolean bl) {
        return this.completeCover(new StateBoolean(bl));
    }

    BigRational getLowerBound(int n) {
        return this.functionFactory.getLowerBound(n);
    }

    BigRational getUpperBound(int n) {
        return this.functionFactory.getUpperBound(n);
    }

    BigRational sideWidth(int n) {
        return this.functionFactory.getUpperBound(n).subtract(this.functionFactory.getLowerBound(n));
    }

    FunctionFactory getFunctionFactory() {
        return this.functionFactory;
    }

    ConstraintChecker getConstraintChecker() {
        return this.constraintChecker;
    }

    BigRational getPrecision() {
        return this.precision;
    }

    int numVariables() {
        return this.functionFactory.getNumVariables();
    }

    int getNumStates() {
        return this.numStates;
    }

    int getInitialState() {
        return this.initialState;
    }

    boolean isSubsumeRegions() {
        return this.subsumeRegions;
    }
}

