/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.ArrayList;
import java.util.HashMap;
import param.BigRational;
import param.Function;
import param.Point;
import param.Region;

class ConstraintChecker {
    private boolean usedUnsoundCheck = false;
    private int numRandomPoints;
    protected HashMap<DecisionEntryKey, ArrayList<DecisionEntryValue>> decisions;

    ConstraintChecker(int n) {
        this.numRandomPoints = n;
        this.decisions = new HashMap();
    }

    boolean mainCheck(Region region, Function function, boolean bl) {
        this.usedUnsoundCheck = true;
        return true;
    }

    boolean preCheck(Region region, Function function, boolean bl) {
        ArrayList<Point> arrayList = region.specialPoints();
        for (Point point : arrayList) {
            if (function.check(point, bl)) continue;
            return false;
        }
        for (int i = 0; i < this.numRandomPoints; ++i) {
            if (function.check(region.randomPoint(), bl)) continue;
            return false;
        }
        return true;
    }

    boolean check(Region region, Function function, boolean bl) {
        boolean bl2;
        DecisionEntryValue decisionEntryValue2;
        if (function.isConstant()) {
            BigRational bigRational = function.asBigRational();
            if (bigRational.isNaN()) {
                return false;
            }
            if (bl) {
                return bigRational.signum() == 1;
            }
            return bigRational.signum() >= 0;
        }
        Function function2 = function.toConstraint();
        DecisionEntryKey decisionEntryKey = new DecisionEntryKey();
        decisionEntryKey.constraint = function2;
        decisionEntryKey.strict = bl;
        ArrayList<DecisionEntryValue> arrayList = this.decisions.get(decisionEntryKey);
        if (arrayList != null) {
            for (DecisionEntryValue decisionEntryValue2 : arrayList) {
                if (!decisionEntryValue2.region.contains(region)) continue;
                if (decisionEntryValue2.result) {
                    return true;
                }
                if (!decisionEntryValue2.region.equals(region)) continue;
                return false;
            }
        }
        if (bl2 = this.preCheck(region, function2, bl)) {
            bl2 = this.mainCheck(region, function2, bl);
        }
        if ((arrayList = this.decisions.get(decisionEntryKey)) == null) {
            arrayList = new ArrayList();
            this.decisions.put(decisionEntryKey, arrayList);
        }
        decisionEntryValue2 = new DecisionEntryValue();
        decisionEntryValue2.region = region;
        decisionEntryValue2.result = bl2;
        arrayList.add(decisionEntryValue2);
        return bl2;
    }

    public boolean unsoundCheckWasUsed() {
        return this.usedUnsoundCheck;
    }

    class DecisionEntryValue {
        Region region;
        boolean result;

        DecisionEntryValue() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof DecisionEntryValue)) {
                return false;
            }
            DecisionEntryValue decisionEntryValue = (DecisionEntryValue)object;
            return this.region.equals(decisionEntryValue.region) && this.result == decisionEntryValue.result;
        }

        public int hashCode() {
            int n = 0;
            n = this.region.hashCode() + (n << 6) + (n << 16) - n;
            n = (this.result ? 13 : 17) + (n << 6) + (n << 16) - n;
            return n;
        }
    }

    class DecisionEntryKey {
        Function constraint;
        boolean strict;

        DecisionEntryKey() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof DecisionEntryKey)) {
                return false;
            }
            DecisionEntryKey decisionEntryKey = (DecisionEntryKey)object;
            return this.constraint.equals(decisionEntryKey.constraint) && this.strict == decisionEntryKey.strict;
        }

        public int hashCode() {
            int n = 0;
            n = this.constraint.hashCode() + (n << 6) + (n << 16) - n;
            n = (this.strict ? 13 : 17) + (n << 6) + (n << 16) - n;
            return n;
        }
    }
}

