/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Random;
import param.BigRational;
import param.BoxRegionFactory;
import param.ConstraintChecker;
import param.Function;
import param.Point;
import param.Region;
import param.RegionValues;
import param.RegionsTODO;
import param.StateBoolean;
import param.StateValue;
import param.StateValues;

final class BoxRegion
extends Region {
    static Random random = new Random();
    static final int SPLIT_LONGEST = 1;
    static final int SPLIT_ALL = 2;
    private BigRational[] lower;
    private BigRational[] upper;

    private BoxRegion(BoxRegionFactory boxRegionFactory) {
        this.factory = boxRegionFactory;
        this.lower = new BigRational[boxRegionFactory.numVariables()];
        this.upper = new BigRational[boxRegionFactory.numVariables()];
    }

    BoxRegion(BoxRegionFactory boxRegionFactory, BigRational[] bigRationalArray, BigRational[] bigRationalArray2) {
        this.factory = boxRegionFactory;
        this.lower = new BigRational[bigRationalArray.length];
        this.upper = new BigRational[bigRationalArray2.length];
        System.arraycopy(bigRationalArray, 0, this.lower, 0, bigRationalArray.length);
        System.arraycopy(bigRationalArray2, 0, this.upper, 0, bigRationalArray2.length);
    }

    private BoxRegion(BoxRegion boxRegion) {
        this.factory = boxRegion.factory;
        this.lower = new BigRational[boxRegion.lower.length];
        this.upper = new BigRational[boxRegion.upper.length];
        System.arraycopy(boxRegion.lower, 0, this.lower, 0, boxRegion.lower.length);
        System.arraycopy(boxRegion.upper, 0, this.upper, 0, boxRegion.upper.length);
    }

    private void setDimension(int n, BigRational bigRational, BigRational bigRational2) {
        this.lower[n] = bigRational;
        this.upper[n] = bigRational2;
    }

    @Override
    int getDimensions() {
        return this.lower.length;
    }

    BigRational getDimensionLower(int n) {
        return this.lower[n];
    }

    BigRational getDimensionUpper(int n) {
        return this.upper[n];
    }

    public boolean equals(Object object) {
        if (!(object instanceof BoxRegion)) {
            return false;
        }
        BoxRegion boxRegion = (BoxRegion)object;
        if (this.getDimensions() != boxRegion.getDimensions()) {
            return false;
        }
        for (int i = 0; i < this.getDimensions(); ++i) {
            if (!this.lower[i].equals(boxRegion.lower[i])) {
                return false;
            }
            if (this.upper[i].equals(boxRegion.upper[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.getDimensions(); ++i) {
            n = this.lower[i].hashCode() + (n << 6) + (n << 16) - n;
            n = this.upper[i].hashCode() + (n << 6) + (n << 16) - n;
        }
        return n;
    }

    Point getMidPoint() {
        BigRational[] bigRationalArray = new BigRational[this.lower.length];
        for (int i = 0; i < this.lower.length; ++i) {
            BigRational bigRational;
            bigRationalArray[i] = bigRational = this.lower[i].add(this.upper[i]).divide(2L);
        }
        return new Point(bigRationalArray);
    }

    @Override
    BigRational volume() {
        BigRational bigRational = BigRational.ONE;
        for (int i = 0; i < this.lower.length; ++i) {
            bigRational = bigRational.multiply(this.upper[i].subtract(this.lower[i]));
            bigRational = bigRational.divide(this.factory.sideWidth(i));
        }
        return bigRational;
    }

    @Override
    boolean contains(Point point) {
        for (int i = 0; i < this.getDimensions(); ++i) {
            if (point.getDimension(i).compareTo(this.lower[i]) < 0) {
                return false;
            }
            if (point.getDimension(i).compareTo(this.upper[i]) <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean contains(Region region) {
        BoxRegion boxRegion = (BoxRegion)region;
        for (int i = 0; i < this.getDimensions(); ++i) {
            if (boxRegion.lower[i].compareTo(this.lower[i]) == -1) {
                return false;
            }
            if (boxRegion.upper[i].compareTo(this.upper[i]) != 1) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < this.getDimensions(); ++i) {
            stringBuilder.append("[");
            stringBuilder.append(this.lower[i].doubleValue());
            stringBuilder.append(",");
            stringBuilder.append(this.upper[i].doubleValue());
            stringBuilder.append("]");
            if (i >= this.getDimensions() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    RegionValues binaryOp(int n, StateValues stateValues, StateValues stateValues2) {
        RegionValues regionValues;
        if (n == 5 || n == 6 || n == 7 || n == 8 || n == 9 || n == 10) {
            regionValues = this.cmpOp(n, stateValues, stateValues2);
        } else {
            regionValues = new RegionValues(this.factory);
            int n2 = stateValues.getNumStates();
            StateValues stateValues3 = new StateValues(n2, this.factory.getInitialState());
            for (int i = 0; i < n2; ++i) {
                if (n == 1 || n == 2 || n == 3 || n == 4) {
                    boolean bl = this.booleanOp(n, stateValues.getStateValueAsBoolean(i), stateValues2.getStateValueAsBoolean(i));
                    stateValues3.setStateValue(i, bl);
                    continue;
                }
                if (n == 11 || n == 12 || n == 13 || n == 14) {
                    Function function = this.arithOp(n, stateValues.getStateValueAsFunction(i), stateValues2.getStateValueAsFunction(i));
                    stateValues3.setStateValue(i, function);
                    continue;
                }
                throw new UnsupportedOperationException("operator not yet implemented for parametric analyses");
            }
            regionValues.add(this, stateValues3);
        }
        return regionValues;
    }

    private RegionValues cmpOp(int n, StateValues stateValues, StateValues stateValues2) {
        ConstraintChecker constraintChecker = this.factory.getConstraintChecker();
        RegionsTODO regionsTODO = new RegionsTODO();
        regionsTODO.add(this);
        BigRational bigRational = this.volume().multiply(BigRational.ONE.subtract(this.factory.getPrecision()));
        BigRational bigRational2 = BigRational.ZERO;
        RegionValues regionValues = new RegionValues(this.factory);
        Function function = null;
        while (bigRational2.compareTo(bigRational) == -1) {
            BoxRegion boxRegion = (BoxRegion)regionsTODO.poll();
            StateValues stateValues3 = new StateValues(stateValues.getNumStates(), this.factory.getInitialState());
            boolean bl = true;
            for (int i = 0; i < stateValues.getNumStates(); ++i) {
                Function function2;
                Function function3;
                StateValue stateValue = stateValues.getStateValue(i);
                StateValue stateValue2 = stateValues2.getStateValue(i);
                Function function4 = stateValue instanceof Function ? (Function)stateValue : null;
                Function function5 = function3 = stateValue2 instanceof Function ? (Function)stateValue2 : null;
                if (n == 5) {
                    if (stateValue instanceof StateBoolean) {
                        stateValues3.setStateValue(i, stateValue.equals(stateValue2));
                        continue;
                    }
                    if (stateValue.equals(stateValue2)) {
                        stateValues3.setStateValue(i, true);
                        continue;
                    }
                    if (constraintChecker.check(boxRegion, function4.subtract(function3), true)) {
                        stateValues3.setStateValue(i, false);
                        continue;
                    }
                    if (constraintChecker.check(boxRegion, function3.subtract(function4), true)) {
                        stateValues3.setStateValue(i, false);
                        continue;
                    }
                    bl = false;
                    break;
                }
                if (n == 6) {
                    if (stateValue instanceof StateBoolean) {
                        stateValues3.setStateValue(i, !stateValue.equals(stateValue2));
                        continue;
                    }
                    if (stateValue.equals(stateValue2)) {
                        stateValues3.setStateValue(i, false);
                        continue;
                    }
                    if (constraintChecker.check(boxRegion, function4.subtract(function3), true)) {
                        stateValues3.setStateValue(i, true);
                        continue;
                    }
                    if (constraintChecker.check(boxRegion, function3.subtract(function4), true)) {
                        stateValues3.setStateValue(i, true);
                        continue;
                    }
                    bl = false;
                    break;
                }
                boolean bl2 = n == 7 || n == 9;
                Function function6 = function2 = n == 9 || n == 10 ? function3.subtract(function4) : function4.subtract(function3);
                if (constraintChecker.check(boxRegion, function2, bl2)) {
                    stateValues3.setStateValue(i, true);
                    continue;
                }
                Function function7 = n == 9 || n == 10 ? function4.subtract(function3) : function3.subtract(function4);
                if (constraintChecker.check(boxRegion, function7, !bl2)) {
                    stateValues3.setStateValue(i, false);
                    continue;
                }
                bl = false;
                function = function3.subtract(function4);
                break;
            }
            if (bl) {
                regionValues.add(boxRegion, stateValues3);
                bigRational2 = bigRational2.add(boxRegion.volume());
                continue;
            }
            regionsTODO.addAll(boxRegion.split(function));
        }
        return regionValues;
    }

    private Function arithOp(int n, Function function, Function function2) {
        Function function3 = null;
        switch (n) {
            case 11: {
                function3 = function.add(function2);
                break;
            }
            case 12: {
                function3 = function.subtract(function2);
                break;
            }
            case 13: {
                function3 = function.multiply(function2);
                break;
            }
            case 14: {
                function3 = function.divide(function2);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported arithmetic operator number " + n);
            }
        }
        return function3;
    }

    private boolean booleanOp(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        switch (n) {
            case 1: {
                bl3 = !bl || bl2;
                break;
            }
            case 2: {
                bl3 = bl == bl2;
                break;
            }
            case 3: {
                bl3 = bl || bl2;
                break;
            }
            case 4: {
                bl3 = bl && bl2;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported boolean operator number " + n);
            }
        }
        return bl3;
    }

    @Override
    RegionValues ITE(StateValues stateValues, StateValues stateValues2, StateValues stateValues3) {
        RegionValues regionValues = new RegionValues(this.factory);
        int n = stateValues.getNumStates();
        StateValues stateValues4 = new StateValues(n, this.factory.getInitialState());
        for (int i = 0; i < n; ++i) {
            if (stateValues.getStateValueAsBoolean(i)) {
                stateValues4.setStateValue(i, stateValues2.getStateValue(i));
                continue;
            }
            stateValues4.setStateValue(i, stateValues3.getStateValue(i));
        }
        regionValues.add(this, stateValues4);
        return regionValues;
    }

    private ArrayList<Region> splitLongest() {
        BigRational bigRational;
        Object object;
        int n = -1;
        Object object2 = BigRational.ZERO;
        for (int i = 0; i < this.lower.length; ++i) {
            object = this.upper[i].subtract(this.lower[i]);
            if (((BigRational)object).compareTo((BigRational)object2) != 1) continue;
            n = i;
            object2 = object;
        }
        ArrayList<Region> arrayList = new ArrayList<Region>();
        object = new BoxRegion(this);
        BoxRegion boxRegion = new BoxRegion(this);
        ((BoxRegion)object).upper[n] = bigRational = this.lower[n].add(this.upper[n]).divide(2L);
        boxRegion.lower[n] = bigRational;
        arrayList.add((Region)object);
        arrayList.add(boxRegion);
        return arrayList;
    }

    private ArrayList<Region> splitAll() {
        ArrayList<Region> arrayList = new ArrayList<Region>();
        int n = (int)Math.pow(2.0, this.lower.length);
        BigRational[] bigRationalArray = new BigRational[this.lower.length];
        BigRational[] bigRationalArray2 = new BigRational[this.upper.length];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            for (int j = 0; j < this.lower.length; ++j) {
                int n3 = n2 % 2;
                n2 /= 2;
                BigRational bigRational = this.upper[j].subtract(this.lower[j]).divide(2L);
                bigRationalArray[j] = this.lower[j].add(bigRational.multiply(n3));
                bigRationalArray2[j] = this.lower[j].add(bigRational.multiply(n3 + 1));
            }
            arrayList.add(new BoxRegion((BoxRegionFactory)this.factory, bigRationalArray, bigRationalArray2));
        }
        return arrayList;
    }

    @Override
    ArrayList<Region> split(Function function) {
        return this.split();
    }

    @Override
    ArrayList<Region> split() {
        if (((BoxRegionFactory)this.factory).getSplitMethod() == 1) {
            return this.splitLongest();
        }
        if (((BoxRegionFactory)this.factory).getSplitMethod() == 2) {
            return this.splitAll();
        }
        throw new RuntimeException();
    }

    @Override
    ArrayList<Point> specialPoints() {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        int n = (int)Math.pow(2.0, this.lower.length);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            BigRational[] bigRationalArray = new BigRational[this.lower.length];
            for (int j = 0; j < this.lower.length; ++j) {
                boolean bl = 0 == n2 % 2;
                n2 /= 2;
                bigRationalArray[j] = bl ? this.lower[j] : this.upper[j];
            }
            arrayList.add(new Point(bigRationalArray));
        }
        return arrayList;
    }

    @Override
    Point randomPoint() {
        BigRational[] bigRationalArray = new BigRational[this.lower.length];
        BigInteger bigInteger = new BigInteger(Long.toString((long)Math.pow(2.0, 60.0)));
        for (int i = 0; i < this.lower.length; ++i) {
            BigInteger bigInteger2 = new BigInteger(60, random);
            BigRational bigRational = new BigRational(bigInteger2, bigInteger);
            bigRationalArray[i] = bigRational = this.lower[i].add(this.upper[i].subtract(this.lower[i]).multiply(bigRational));
        }
        return new Point(bigRationalArray);
    }

    @Override
    BoxRegion conjunct(Region region) {
        BoxRegion boxRegion = (BoxRegion)region;
        BoxRegion boxRegion2 = new BoxRegion((BoxRegionFactory)this.factory);
        for (int i = 0; i < this.lower.length; ++i) {
            BigRational bigRational;
            if (this.upper[i].compareTo(boxRegion.lower[i]) <= 0) {
                return null;
            }
            if (this.lower[i].compareTo(boxRegion.upper[i]) >= 0) {
                return null;
            }
            BigRational bigRational2 = this.lower[i].max(boxRegion.lower[i]);
            if (bigRational2.equals(bigRational = this.upper[i].min(boxRegion.upper[i]))) {
                return null;
            }
            boxRegion2.setDimension(i, bigRational2, bigRational);
        }
        return boxRegion2;
    }

    private boolean adjacent(Region region, int n) {
        BoxRegion boxRegion = (BoxRegion)region;
        for (int i = 0; i < this.getDimensions(); ++i) {
            if (i == n) continue;
            if (!this.getDimensionLower(i).equals(boxRegion.getDimensionLower(i))) {
                return false;
            }
            if (this.getDimensionUpper(i).equals(boxRegion.getDimensionUpper(i))) continue;
            return false;
        }
        return this.getDimensionUpper(n).equals(boxRegion.getDimensionLower(n));
    }

    @Override
    boolean adjacent(Region region) {
        BoxRegion boxRegion = (BoxRegion)region;
        for (int i = 0; i < this.getDimensions(); ++i) {
            if (!this.adjacent(boxRegion, i)) continue;
            return true;
        }
        return false;
    }

    @Override
    Region glue(Region region) {
        BoxRegion boxRegion = (BoxRegion)region;
        BoxRegion boxRegion2 = new BoxRegion((BoxRegionFactory)this.getFactory());
        for (int i = 0; i < boxRegion2.getDimensions(); ++i) {
            boxRegion2.setDimension(i, this.getDimensionLower(i), boxRegion.getDimensionUpper(i));
        }
        return boxRegion2;
    }
}

