/*
 * Decompiled with CFR 0.152.
 */
package org.spg.PrismAPI.examples;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.spg.PrismAPI.PrismParamAPI;
import org.spg.utils.PrismAPIUtilities;

public class FxFPMC {
    public static void main(String[] args) {
        System.out.println("Testing Prism API");
        PrismParamAPI api = new PrismParamAPI();
        String propsFile = "src/test/resources/models/SimosAPITestModel/P3_rewardCost.pctl";
        String modelFile = "src/test/resources/models/SimosAPITestModel/prismPROBModel-2_P3.pm";
        String model = PrismAPIUtilities.readModelFile(modelFile);
        api.loadParamModel(model);
        api.setPropertiesFile(propsFile);
        String paramMatrix = api.getParametricTransitionMatrix();
        System.out.println("\nParametric Transition Matrix\n------------------------");
        System.out.println(paramMatrix);
        String matrixFile = "matrixFX.tra";
        api.saveParametricTransitionMatrix(matrixFile);
        String s = api.getModelStatesInfo();
        System.out.println("\nModel States Information\n------------------------");
        System.out.println(s);
        api.saveModelStatesInfo("FX.sta");
        ArrayList<String> searchedVars = new ArrayList<String>();
        searchedVars.add("s62");
        searchedVars.add("s61");
        ArrayList<Number> searchedVarsValues = new ArrayList<Number>();
        searchedVarsValues.add(3);
        searchedVarsValues.add(3);
        List<String> ss = api.findStatesWithVarValues(searchedVars, searchedVarsValues);
        System.out.println("\nModel States Matching Var Values\n------------------------");
        System.out.println(Arrays.toString(ss.toArray()));
        List<Integer> initialStates = api.getInitialStates();
        System.out.println(Arrays.toString(initialStates.toArray()));
        ArrayList<String> varsToSearch = new ArrayList<String>();
        varsToSearch.add("state");
        List<String> sss = api.findStatesSatisfyingExpression("state=10 | state=9", varsToSearch);
        System.out.println("\nModel States Matching Expression\n------------------------");
        System.out.println(Arrays.toString(sss.toArray()));
        api.closeDown();
        System.exit(-1);
    }
}

