/*
 * Decompiled with CFR 0.152.
 */
package org.spg.PrismAPI;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.spg.utils.PrismAPIUtilities;
import param.Function;
import param.ParamResult;
import param.StateValues;
import parser.Values;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import prism.Prism;
import prism.PrismDevNullLog;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLangException;
import prism.PrismLog;
import prism.Result;
import prism.ResultsCollection;
import prism.UndefinedConstants;

public class PrismParamAPI {
    private String PROPERTIESFILENAME;
    private PrismLog mainLog;
    private Prism prism;
    private ModulesFile modulesFile;
    private PropertiesFile propertiesFile;
    private String modelString;
    private File props;
    private List<Property> propertiesToCheck;
    private UndefinedConstants[] undefinedConstants;
    private UndefinedConstants undefinedMFConstants;
    private Values definedMFConstants;
    private Values definedPFConstants;
    private ResultsCollection[] results = null;
    List<String> formulaeList;
    List<String> paramNames;
    List<String> paramLowerBounds;
    List<String> paramUpperBounds;
    private boolean exact = true;

    public PrismParamAPI() {
        this(null);
    }

    public PrismParamAPI(String outputFilename) {
        try {
            this.mainLog = outputFilename == null ? new PrismDevNullLog() : (outputFilename == "stdout" ? new PrismFileLog("stdout") : new PrismFileLog(outputFilename, false));
            this.prism = new Prism(this.mainLog);
            this.prism.initialise();
            this.prism.setLinEqMethod(1);
            this.prism.setMaxIters(100000);
            this.formulaeList = new ArrayList<String>();
            this.paramNames = new ArrayList<String>();
            this.paramLowerBounds = new ArrayList<String>();
            this.paramUpperBounds = new ArrayList<String>();
            this.prism.getSettings().set("prism.doProbChecks", false);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public void setPropertiesFile(String propertiesFilename, String[] paramNames) {
        this.PROPERTIESFILENAME = propertiesFilename;
        this.props = new File(this.PROPERTIESFILENAME);
        try {
            int i;
            this.propertiesFile = this.prism.parsePropertiesFile(this.props);
            this.propertiesToCheck = new ArrayList<Property>();
            int numProperties = this.propertiesFile.getNumProperties();
            for (int i2 = 0; i2 < numProperties; ++i2) {
                this.propertiesToCheck.add(this.propertiesFile.getPropertyObject(i2));
            }
            this.undefinedMFConstants = new UndefinedConstants(this.modulesFile, null);
            this.undefinedMFConstants.setExactMode(true);
            int numPropertiesToCheck = this.propertiesFile.getNumProperties();
            this.undefinedConstants = new UndefinedConstants[numPropertiesToCheck];
            for (i = 0; i < numPropertiesToCheck; ++i) {
                this.undefinedConstants[i] = new UndefinedConstants(this.modulesFile, this.propertiesFile, this.propertiesToCheck.get(i));
                this.undefinedConstants[i].setExactMode(true);
            }
            this.undefinedMFConstants.removeConstants(paramNames);
            for (i = 0; i < numPropertiesToCheck; ++i) {
                this.undefinedConstants[i].removeConstants(paramNames);
            }
        }
        catch (FileNotFoundException | PrismLangException e) {
            e.printStackTrace();
        }
    }

    public void setPropertiesFile(String propertiesFilename) {
        this.setPropertiesFile(propertiesFilename, (String[])this.paramNames.toArray(String[]::new));
    }

    public void loadParamModel(String modelString) {
        try {
            this.modelString = modelString;
            this.findParamFeatures(modelString);
            this.modulesFile = this.prism.parseModelString(this.modelString);
            this.prism.loadPRISMModel(this.modulesFile);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public List<String> getPrismParamExpression(String[] paramNames, String[] paramLowerBounds, String[] paramUpperBounds) {
        int numPropertiesToCheck = this.propertiesFile.getNumProperties();
        this.formulaeList.clear();
        try {
            this.defineConstants();
            this.exact = !this.exact;
            this.results = new ResultsCollection[numPropertiesToCheck];
            for (int i = 0; i < numPropertiesToCheck; ++i) {
                this.definedPFConstants = this.undefinedConstants[i].getPFConstantValues();
                this.propertiesFile.setSomeUndefinedConstants(this.definedPFConstants, true);
                this.results[i] = new ResultsCollection(this.undefinedConstants[i], this.propertiesToCheck.get(i).getExpression().getResultName());
                Result res = this.prism.modelCheckParametric(this.propertiesFile, this.propertiesToCheck.get(i), paramNames, paramLowerBounds, paramUpperBounds);
                this.results[i].setResult(this.definedMFConstants, this.definedPFConstants, res.getResult());
                StateValues v = ((ParamResult)res.getResult()).getRegionValues().getResult(0);
                Function f = v.getInitStateValueAsFunction();
                this.formulaeList.add(f.toString());
            }
        }
        catch (PrismException e) {
            e.printStackTrace();
        }
        return this.formulaeList;
    }

    public List<String> getPrismParamExpression() {
        return this.getPrismParamExpression((String[])this.paramNames.toArray(String[]::new), (String[])this.paramLowerBounds.toArray(String[]::new), (String[])this.paramUpperBounds.toArray(String[]::new));
    }

    public String getParametricTransitionMatrix(String[] paramNames, String[] paramLowerBounds, String[] paramUpperBounds) {
        int numPropertiesToCheck = this.propertiesFile.getNumProperties();
        try {
            this.defineConstants();
            int i = 0;
            if (i < numPropertiesToCheck) {
                this.definedPFConstants = this.undefinedConstants[i].getPFConstantValues();
                this.propertiesFile.setSomeUndefinedConstants(this.definedPFConstants, true);
                String transitionMatrix = this.prism.getParametricTransitionMatrix(this.propertiesFile, this.propertiesToCheck.get(i), paramNames, paramLowerBounds, paramUpperBounds);
                return transitionMatrix;
            }
        }
        catch (PrismException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getParametricTransitionMatrix() {
        return this.getParametricTransitionMatrix((String[])this.paramNames.toArray(String[]::new), (String[])this.paramLowerBounds.toArray(String[]::new), (String[])this.paramUpperBounds.toArray(String[]::new));
    }

    public void saveParametricTransitionMatrix(String fileName, String[] paramNames, String[] paramLowerBounds, String[] paramUpperBounds) {
        String transitionMatrix = this.getParametricTransitionMatrix(paramNames, paramLowerBounds, paramUpperBounds);
        PrismAPIUtilities.saveToFile(fileName, transitionMatrix);
    }

    public void saveParametricTransitionMatrix(String fileName) {
        this.saveParametricTransitionMatrix(fileName, (String[])this.paramNames.toArray(String[]::new), (String[])this.paramLowerBounds.toArray(String[]::new), (String[])this.paramUpperBounds.toArray(String[]::new));
    }

    public void closeDown() {
        if (this.mainLog != null) {
            this.mainLog.close();
        }
        this.modulesFile = null;
        this.propertiesFile = null;
        this.props = null;
        this.prism = null;
    }

    private void findParamFeatures(String modelString) {
        this.paramNames.clear();
        this.paramLowerBounds.clear();
        this.paramUpperBounds.clear();
        for (String line : modelString.split("\n")) {
            int semicolumnIndex;
            String command;
            if (!(line = line.trim()).startsWith("const") || (command = line.substring(0, semicolumnIndex = line.indexOf(";"))).contains("=")) continue;
            String[] elements = command.split(" ");
            String paramName = elements[elements.length - 1];
            this.paramNames.add(paramName);
            this.paramLowerBounds.add("0.1");
            this.paramUpperBounds.add("0.11");
        }
    }

    public String getModelStatesInfo() {
        String s = null;
        try {
            this.defineConstants();
            s = this.prism.getParametricStateInfo(this.propertiesFile, this.propertiesToCheck.get(0), (String[])this.paramNames.toArray(String[]::new), (String[])this.paramLowerBounds.toArray(String[]::new), (String[])this.paramUpperBounds.toArray(String[]::new));
        }
        catch (PrismException e) {
            e.printStackTrace();
        }
        return s;
    }

    public void saveModelStatesInfo(String fileName) {
        String s = this.getModelStatesInfo();
        PrismAPIUtilities.saveToFile(fileName, s);
    }

    public List<String> findStatesWithVarValues(List<String> searchedVars, List<Number> searchedVarsValues) {
        List<String> ss = null;
        try {
            this.defineConstants();
            ss = this.prism.findStatesWithVarValues(this.propertiesFile, this.propertiesToCheck.get(0), (String[])this.paramNames.toArray(String[]::new), (String[])this.paramLowerBounds.toArray(String[]::new), (String[])this.paramUpperBounds.toArray(String[]::new), searchedVars, searchedVarsValues);
        }
        catch (PrismException e) {
            e.printStackTrace();
        }
        return ss;
    }

    public List<String> findStatesSatisfyingExpression(String expression, List<String> varsToSearch) {
        List<String> ss = null;
        try {
            this.defineConstants();
            ss = this.prism.findStatesSatisfyingExpression(this.propertiesFile, this.propertiesToCheck.get(0), (String[])this.paramNames.toArray(String[]::new), (String[])this.paramLowerBounds.toArray(String[]::new), (String[])this.paramUpperBounds.toArray(String[]::new), expression, varsToSearch);
        }
        catch (PrismException e) {
            e.printStackTrace();
        }
        return ss;
    }

    private void defineConstants() throws PrismException {
        this.definedMFConstants = this.undefinedMFConstants.getMFConstantValues();
        this.prism.setPRISMModelConstants(this.definedMFConstants, true);
    }

    public List<Integer> getInitialStates() {
        List<Integer> initialStatesList = new ArrayList<Integer>();
        try {
            this.defineConstants();
            initialStatesList = this.prism.getInitialStates(this.propertiesFile, this.propertiesToCheck.get(0), (String[])this.paramNames.toArray(String[]::new), (String[])this.paramLowerBounds.toArray(String[]::new), (String[])this.paramUpperBounds.toArray(String[]::new));
        }
        catch (PrismException e) {
            e.printStackTrace();
        }
        return initialStatesList;
    }
}

