/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.regressiontesting;

import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.RecursiveArgument;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.NumberTheory;
import org.mariuszgromada.math.mxparser.mathcollection.SpecialValueTrigonometric;
import org.mariuszgromada.math.mxparser.regressiontesting.FunExt;
import org.mariuszgromada.math.mxparser.regressiontesting.FunExtVar;
import org.mariuszgromada.math.mxparser.regressiontesting.PiMultArgExt;

public class RegTestExpression {
    private static Expression[] exp;
    private static boolean tmp;
    private static final double PI = Math.PI;

    private static boolean runTest_00000_00100(int n) {
        mXparser.consolePrint("[" + n + "] ");
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        String string = "";
        switch (n) {
            case 0: {
                string = "";
                mXparser.consolePrint("Empty expression string ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                if (Double.isNaN(d)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " --> ");
                break;
            }
            case 1: {
                string = "2+1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 3.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 2: {
                string = "1-2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 3: {
                string = "2*5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 10.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 4: {
                string = "20/4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 5.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 5: {
                string = "-2+22";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 20.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 6: {
                string = "3-(-5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 8.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 7: {
                string = "+5-(+7)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -2.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 8: {
                string = "-5+(-7)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -12.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 9: {
                string = "-2*(3-5)+7";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 11.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 10: {
                string = "5.5*(2-3 + (5.3-7.89)/2)/2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -6.31125;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 11: {
                string = "2-(32-4)/(23+(4)/(5))-(2-4)*(4+6-98.2)+4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -171.5764705882353;
                if (MathFunctions.abs(d - d2) < 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 12: {
                string = "2^3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Math.pow(2.0, 3.0);
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 13: {
                string = "2^(-3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Math.pow(2.0, -3.0);
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 14: {
                string = "2^0.7";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Math.pow(2.0, 0.7);
                if (MathFunctions.abs(d - d2) < 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 15: {
                string = "4^3^2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Math.pow(4.0, Math.pow(3.0, 2.0));
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 16: {
                string = "(4^3)^2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Math.pow(Math.pow(4.0, 3.0), 2.0);
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 17: {
                string = "0.9^0.8^0.7^0.6^0.5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.914888338607593;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 18: {
                string = "2=2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 19: {
                string = "2=3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 20: {
                string = "2<>3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 21: {
                string = "2<>2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 22: {
                string = "3>2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 23: {
                string = "2>2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 24: {
                string = "3>2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 25: {
                string = "2<3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 26: {
                string = "2<2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 27: {
                string = "3<2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 28: {
                string = "2>=2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 29: {
                string = "3>=2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 30: {
                string = "1>=2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 31: {
                string = "1<=2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 32: {
                string = "1<=1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 33: {
                string = "1<=0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 34: {
                string = "1 & 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 35: {
                string = "1 & -1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 36: {
                string = "1 & 0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 37: {
                string = "0 & 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 38: {
                string = "0 & 0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 39: {
                string = "1 | -1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 40: {
                string = "0 | -1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 41: {
                string = "1 | 0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 42: {
                string = "0 | 0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 43: {
                string = "3>2 | 2>3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 44: {
                string = "3>5 | 2>3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 45: {
                string = "not((3>4) & (2>=2))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 46: {
                string = "not(-5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 47: {
                string = "not(0)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 48: {
                string = "if(0,1,2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 49: {
                string = "if(5,1,2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 50: {
                string = "sum(n,1,10,n)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 55.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 51: {
                string = "prod(n,1,5,n)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 120.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 52: {
                Argument argument = new Argument("x", 5.0);
                string = "sin(x)-sum(n,0,10,(-1)^n*(x^(2*n+1))/(2*n+1)!)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 53: {
                Argument argument = new Argument("d", 0.01);
                string = "pi-2*sum(x,-1,1,d*sqrt(1-x^2),d)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 54: {
                Argument argument = new Argument("x", 1.0);
                string = "1 - ( sin(x)^2+cos(x)^2 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 55: {
                Argument argument = new Argument("x", 1.0);
                string = "1 - ( sec(x)^2 - tan(x)^2 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 56: {
                Argument argument = new Argument("x", 1.0);
                string = "1 - ( cosec(x)^2 - ctan(x)^2 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 57: {
                Argument argument = new Argument("x", 1.0);
                string = "1 - ( cosec(x)^2 - ctan(x)^2 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 58: {
                Argument argument = new Argument("x", 1.0);
                string = "1 - ( csc(x)^2 - ctg(x)^2 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 59: {
                Argument argument = new Argument("x", 1.0);
                string = "1 - ( sec(x)^2 - tg(x)^2 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 60: {
                Argument argument = new Argument("x", 1.0);
                string = "tan(x) - sin(x)/cos(x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 61: {
                Argument argument = new Argument("x", 2.0);
                Argument argument2 = new Argument("y", 3.0);
                string = "sin(x+y) - (sin(x)*cos(y)+cos(x)*sin(y))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument2);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 62: {
                Argument argument = new Argument("x", 2.0);
                Argument argument3 = new Argument("y", 3.0);
                string = "sin(x-y) - (sin(x)*cos(y)-cos(x)*sin(y))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument3);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 63: {
                Argument argument = new Argument("x", 2.0);
                Argument argument4 = new Argument("y", 3.0);
                string = "cos(x+y) - (cos(x)*cos(y)-sin(x)*sin(y))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument4);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 64: {
                Argument argument = new Argument("x", 2.0);
                Argument argument5 = new Argument("y", 3.0);
                string = "cos(x-y) - (cos(x)*cos(y)+sin(x)*sin(y))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument5);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 65: {
                Argument argument = new Argument("x", 2.0);
                Argument argument6 = new Argument("y", 3.0);
                string = "tg(x+y) - (tg(x)+tg(y)) / (1 - tg(x)*tg(y))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument6);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 66: {
                Argument argument = new Argument("x", 2.0);
                Argument argument7 = new Argument("y", 3.0);
                string = "tg(x-y) - (tg(x)-tg(y)) / (1 + tg(x)*tg(y))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument7);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 67: {
                Argument argument = new Argument("x", 2.0);
                Argument argument8 = new Argument("y", 3.0);
                string = "ctg(x+y) - (ctg(x)*ctg(y)-1) / (ctg(y)+ctg(x))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument8);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 68: {
                Argument argument = new Argument("x", 2.0);
                Argument argument9 = new Argument("n", 10.0);
                string = "sin(n*x) - sum(i,0,n,(-1)^i*C(n,2*i+1)*(cos(x)^(n-2*i-1))*(sin(x)^(2*i+1))) ";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument9);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 69: {
                Argument argument = new Argument("n", 45.0);
                string = "n*2^(n-1) - sum(i,1,n,i*C(n,i))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 70: {
                string = "prod(i,2,6,1+1/i)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 3.5;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 71: {
                string = "prod(i,1,6,10)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Math.pow(10.0, 6.0);
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 72: {
                string = "prod(i,1,6,i,0.5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                for (double d4 = 1.0; d4 < 6.0; d4 += 0.5) {
                    d2 *= d4;
                }
                if (d == (d2 *= 6.0)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 73: {
                string = "sum(n,1,5,prod(i,1,n,n*i))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d3 = 0.0;
                for (double d5 = 1.0; d5 <= 5.0; d5 += 1.0) {
                    d2 = 1.0;
                    for (double d6 = 1.0; d6 <= d5; d6 += 1.0) {
                        d2 *= d5 * d6;
                    }
                    d3 += d2;
                }
                d2 = d3;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 74: {
                Argument argument = new Argument("n", new PrimitiveElement[0]);
                RecursiveArgument recursiveArgument = new RecursiveArgument("fib", "fib(n-1)+fib(n-2)", argument, new PrimitiveElement[0]);
                recursiveArgument.addBaseCase(0, 0.0);
                recursiveArgument.addBaseCase(1, 1.0);
                string = "sum(n,0,5,fib(n))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, recursiveArgument);
                d = exp[n].calculate();
                d2 = 12.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 75: {
                Argument argument = new Argument("n", new PrimitiveElement[0]);
                RecursiveArgument recursiveArgument = new RecursiveArgument("fact", "n*fact(n-1)", argument, new PrimitiveElement[0]);
                recursiveArgument.addBaseCase(0, 1.0);
                string = "5!-fact(5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, recursiveArgument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 76: {
                Argument argument = new Argument("x", 2.0);
                string = "cos(x)-der(sin(x),x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-8) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 77: {
                Argument argument = new Argument("x", 2.0);
                Argument argument10 = new Argument("y", 3.0);
                string = "-sin(x+y)-der(der(sin(x+y),x),y)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument10);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 0.001) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 78: {
                Argument argument = new Argument("x", 2.0);
                Argument argument11 = new Argument("y", 3.0);
                string = "cos(x*y)-x*y*sin(x*y)-der(der(sin(x*y),x),y)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument11);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 0.001) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 79: {
                Argument argument = new Argument("n", -5.0);
                string = "C(n,2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 15.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 80: {
                Argument argument = new Argument("x", 0.0);
                string = "der+(abs(x),x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 81: {
                Argument argument = new Argument("x", 0.0);
                string = "der-(abs(x),x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = -1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 82: {
                Argument argument = new Argument("x", 4.0);
                string = "cos(x)-der(sum(n,0,10,(-1)^n*(x^(2*n+1))/(2*n+1)!),x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-4) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 83: {
                Argument argument = new Argument("n", 7.0);
                Argument argument12 = new Argument("k", 4.0);
                string = "C(n,k) - ( C(n-1,k-1)+C(n-1,k) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument12);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 84: {
                Argument argument = new Argument("n", 13.0);
                Argument argument13 = new Argument("k", 6.0);
                string = "C(n,k) - prod(i,1,k,n-i+1) / prod(i,1,k,i)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument13);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 85: {
                Argument argument = new Argument("n", 13.0);
                Argument argument14 = new Argument("k", 6.0);
                string = "C(n,k) - prod(i,1,k,(n-i+1)/i)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument14);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 86: {
                Argument argument = new Argument("n", 13.0);
                Argument argument15 = new Argument("k", 6.0);
                string = "C(n,k) - C(n,n-k)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument15);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 87: {
                Argument argument = new Argument("n", 13.0);
                Argument argument16 = new Argument("k", 6.0);
                string = "C(n,0)+C(n,n)+C(0,0)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument16);
                d = exp[n].calculate();
                d2 = 3.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 88: {
                Argument argument = new Argument("n", 13.0);
                Argument argument17 = new Argument("k", 6.0);
                string = "C(n,k+1)-C(n,k)*(n-k)/(k+1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument17);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 89: {
                Argument argument = new Argument("n", 13.0);
                string = "2^n-sum(k,0,n,C(n,k))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 90: {
                Argument argument = new Argument("n", 13.0);
                string = "C(2*n,n)-sum(k,0,n,C(n,k)^2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 91: {
                Argument argument = new Argument("n", 13.0);
                string = "sum(k,0,n,(-1)^k*C(n,k))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 92: {
                Argument argument = new Argument("n", 13.0);
                Argument argument18 = new Argument("m", 3.0);
                Argument argument19 = new Argument("s", 5.0);
                Argument argument20 = new Argument("r", 4.0);
                string = "C(r+s,m+n)-sum(k,0,n,C(r,m+k)*C(s,n-k))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument18, argument20, argument19);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 93: {
                Argument argument = new Argument("n", 13.0);
                Argument argument21 = new Argument("k", 6.0);
                string = "C(n,k)-(n/k)*C(n-1,k-1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument21);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 94: {
                Argument argument = new Argument("n", 13.0);
                Argument argument22 = new Argument("k", 6.0);
                string = "(n-k)*C(n,k)-n*C(n-1,k)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument22);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 95: {
                Argument argument = new Argument("n", 13.0);
                Argument argument23 = new Argument("k", 6.0);
                string = "C(n,k) <= n^k/k!";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument23);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 96: {
                Argument argument = new Argument("n", 13.0);
                Argument argument24 = new Argument("k", 6.0);
                string = "C(n,k) <= (n*e/k)^k";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument24);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 97: {
                Argument argument = new Argument("n", 13.0);
                Argument argument25 = new Argument("k", 6.0);
                string = "C(n,k) >= (n/k)^k";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument25);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 98: {
                Argument argument = new Argument("x", 3.0);
                string = "sin(3)-sin(2)-int(cos(x),x,2,3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 99: {
                Argument argument = new Argument("i", 5.0);
                string = "2*i+sum(i,1,10,i)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 65.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 100: {
                Argument argument = new Argument("x", 3.0);
                string = "sin(x)-sin(x-1)-int(cos(x),x,2,3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
            }
        }
        if (bl) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return bl;
    }

    private static boolean runTest_00101_00200(int n) {
        mXparser.consolePrint("[" + n + "] ");
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        String string = "";
        switch (n) {
            case 101: {
                Function function = new Function("mg", "sin(x)+cos(y)", "x", "y");
                Argument argument = new Argument("x", 3.0);
                Argument argument2 = new Argument("y", 2.0);
                string = "sin(x)+cos(y)-mg(x,y)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument2);
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 102: {
                Function function = new Function("mg", "sin(x)+cos(y)", "x", "y");
                string = "der(sin(x)+cos(y),x)-der(mg(x,y),x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new Argument("x", 3.0), new Argument("y", 2.0));
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-8) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 103: {
                Function function = new Function("f", "x^2", "x");
                Function function2 = new Function("g", "f(x)^2", "x");
                function2.addDefinitions(function);
                string = "g(x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new Argument("x", 3.0));
                exp[n].addDefinitions(function2);
                d = exp[n].calculate();
                d2 = 81.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 104: {
                Function function = new Function("f", "sin(x)", "x");
                Function function3 = new Function("g", "cos(x)", "x");
                string = "der( f(x)*g(x), x) - ( der(f(x), x)*g(x) + f(x)*der(g(x), x) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new Argument("x", 3.0));
                exp[n].addDefinitions(function, function3);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 105: {
                Function function = new Function("f", "sin(x)", "x");
                Function function4 = new Function("g", "cos(x)", "x");
                string = "der( f(x)/g(x), x) - ( der(f(x), x)*g(x) - f(x)*der(g(x), x) )/g(x)^2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new Argument("x", 3.0));
                exp[n].addDefinitions(function, function4);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 106: {
                Function function = new Function("f", "sin(x)", "x");
                string = "der( int(f(t), t, 0, x), x) - f(x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new Argument("x", 3.0));
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-4) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 107: {
                Function function = new Function("f", "sin(x)", "x");
                Function function5 = new Function("g", "cos(x)", "x");
                string = "der(f(x)+g(x), x) - ( der(f(x), x) + der(g(x),x) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new Argument("x", 3.0));
                exp[n].addDefinitions(function, function5);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 108: {
                Argument argument = new Argument("a", 2.0);
                Argument argument3 = new Argument("b", 2.0);
                Function function = new Function("f", "sin(x)", "x");
                Function function6 = new Function("g", "cos(x)", "x");
                string = "der(a*f(x)+b*g(x), x) - ( a*der(f(x), x) + b*der(g(x),x) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new Argument("x", 3.0), argument, argument3);
                exp[n].addDefinitions(function, function6);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 109: {
                Function function = new Function("f", "sin(x)", "x");
                Function function7 = new Function("g", "cos(x)", "x");
                Function function8 = new Function("h", "x^2", "x");
                string = "der(f(x)*g(x)*h(x), x) - ( der(f(x), x)*g(x)*h(x) + f(x)*der(g(x), x)*h(x) + f(x)*g(x)*der(h(x), x))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new Argument("x", 3.0));
                exp[n].addDefinitions(function, function7, function8);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 110: {
                Function function = new Function("f", "sin(x)", "x");
                string = "der(ln(f(x)), x) - der(f(x), x) / f(x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new Argument("x", 3.0));
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 111: {
                Function function = new Function("f", "sin(x)", "x");
                Argument argument = new Argument("a", Math.PI);
                string = "der( f(x)^a, x) - a*f(x)^(a-1)*der(f(x), x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new Argument("x", 3.0), argument);
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 112: {
                Function function = new Function("f", "sin(x)^2", "x");
                Function function9 = new Function("g", "cos(x)^2", "x");
                string = "der( f(x)^g(x), x) - f(x)^g(x)*( der(f(x), x)*g(x)/f(x) + der(g(x), x)*ln(f(x)) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new Argument("x", 3.0));
                exp[n].addDefinitions(function, function9);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 113: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                Function function = new Function("f", "sin(x)", "x");
                Function function10 = new Function("g", "cos(x)", "x");
                Function function11 = new Function("h", "int(f(t),t,0,x)", "x");
                function11.addDefinitions(function);
                Argument argument = new Argument("a", 2.0);
                Argument argument4 = new Argument("b", 4.0);
                Argument argument5 = new Argument("x", 3.0);
                string = "int(f(x)*g(x),x,a,b) - ( h(b)*g(b)-h(a)*g(a) - int( h(x)*der(g(x),x), x, a, b) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument5, argument, argument4);
                exp[n].addDefinitions(function, function10, function11);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 114: {
                Function function = new Function("f", "ln(x)", "x");
                Function function12 = new Function("g", "x^2+2", "x");
                Argument argument = new Argument("x", 10.0);
                Argument argument6 = new Argument("t", "g(x)", argument);
                argument6.addDefinitions(function12);
                string = "der( f(g(x)), x) - der( f(t), t)*der( g(x), x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument6);
                exp[n].addDefinitions(function, function12);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 115: {
                Argument argument = new Argument("n", new PrimitiveElement[0]);
                RecursiveArgument recursiveArgument = new RecursiveArgument("fact1", "n*fact1(n-1)", argument, new PrimitiveElement[0]);
                recursiveArgument.addBaseCase(0, 1.0);
                RecursiveArgument recursiveArgument2 = new RecursiveArgument("fact2", "if(n>0, n*fact2(n-1), 1)", argument, new PrimitiveElement[0]);
                string = "sum(i,0,10,fact1(i)-fact2(i))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, recursiveArgument, recursiveArgument2);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 116: {
                Argument argument = new Argument("n", new PrimitiveElement[0]);
                RecursiveArgument recursiveArgument = new RecursiveArgument("fib1", "fib1(n-1)+fib1(n-2)", argument, new PrimitiveElement[0]);
                recursiveArgument.addBaseCase(0, 0.0);
                recursiveArgument.addBaseCase(1, 1.0);
                RecursiveArgument recursiveArgument3 = new RecursiveArgument("fib2", "if( n>1, fib2(n-1)+fib2(n-2), if(n=1,1,0) )", argument, new PrimitiveElement[0]);
                string = "sum(i,0,10,fib1(i)-fib2(i))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, recursiveArgument, recursiveArgument3);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 117: {
                Function function = new Function("Cnk", "if( k>0, if( k<n, Cnk(n-1,k-1)+Cnk(n-1,k), 1), 1)", "n", "k");
                string = "C(10,5)-Cnk(10,5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 118: {
                Argument argument = new Argument("n", new PrimitiveElement[0]);
                RecursiveArgument recursiveArgument = new RecursiveArgument("fib1", "fib1(n-1)+fib1(n-2)", argument, new PrimitiveElement[0]);
                recursiveArgument.addBaseCase(0, 0.0);
                recursiveArgument.addBaseCase(1, 1.0);
                RecursiveArgument recursiveArgument4 = new RecursiveArgument("fib2", "if( n>1, fib2(n-1)+fib2(n-2), if(n>0,1,0) )", argument, new PrimitiveElement[0]);
                Function function = new Function("fib3", "if(n>1, fib3(n-1)+fib3(n-2), if(n>0,1,0))", "n");
                string = "sum(i,1,10,(fib1(i) = fib2(i)) & (fib2(i) = fib3(i)) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, recursiveArgument, recursiveArgument4);
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 10.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 119: {
                Argument argument = new Argument("m", new PrimitiveElement[0]);
                Argument argument7 = new Argument("n", "m-1", argument);
                Argument argument8 = new Argument("x", 3.0);
                Function function = new Function("H", "if(m>1, 2*x*H(n,x)-2*n*H(n-1,x), if(m>0, 2*x, 1) )", argument, argument8, argument7);
                function.setParametersNumber(2);
                string = "H(0,x) + H(1,x) + H(2,x) + H(3,x) - ( (1) + (2*x) + (4*x^2-2) + (8*x^3-12*x) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument8);
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 120: {
                Argument argument = new Argument("m", 4.0);
                Argument argument9 = new Argument("n", "m-1", argument);
                Argument argument10 = new Argument("x", 3.0);
                Function function = new Function("H", "if(m>1, 2*x*H(n,x)-2*n*H(n-1,x), if(m>0, 2*x, 1) )", argument, argument10, argument9);
                function.setParametersNumber(2);
                Argument argument11 = new Argument("k", 5.0);
                string = "der( H(k,x), x) - 2*k*H(k-1,x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument10, argument11);
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-4) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 121: {
                Function function = new Function("T", "if(k>1, 2*x*T(k-1,x)-T(k-2,x), if(k>0, x, 1) )", "k", "x");
                Argument argument = new Argument("k", 5.0);
                Argument argument12 = new Argument("x", 3.0);
                string = "T(k,x) - ( (x + sqrt(x^2-1))^k + (x - sqrt(x^2-1))^k)/2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument12, argument);
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 122: {
                Function function = new Function("T1", "if(k>1, 2*x*T1(k-1,x)-T1(k-2,x), if(k>0, x, 1) )", "k", "x");
                Function function13 = new Function("T2", "if(x >= 1, cosh(k*arcosh(x)), if(x <= -1, ((-1)^k)*cosh(k*arcosh(-x)), cos(k*acos(x))) )", "k", "x");
                Argument argument = new Argument("k", 5.0);
                string = "T1(k,3)-T2(k,3) + T1(k,-3)-T2(k,-3) + T1(k,-0.5)-T2(k,-0.5) + T1(k,0.5)-T2(k,0.5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                exp[n].addDefinitions(function, function13);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) <= 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 123: {
                string = "pi+e+[gam]+[phi]+[PN]+[B*]+[F'd]+[F'a]+[C2]+[M1]+[B2]+[B4]+[BN'L]+[Kat]+[K*]+[K.]+[B'L]+[RS'm]+[EB'e]+[Bern]+[GKW'l]+[HSM's]+[lm]+[Cah]+[Ll]+[AG]+[L*]+[L.]+[Dz3]+[A3n]+[Bh]+[Pt]+[L2]+[Nv]+[Ks]+[Kh]+[FR]+[La]+[P2]+[Om]+[MRB]+[li2]+[EG]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 57.81734127102257;
                if (MathFunctions.abs(d - d2) <= 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 124: {
                Argument argument = new Argument("m", 4.0);
                Argument argument13 = new Argument("n", "m-1", argument);
                Argument argument14 = new Argument("x", 3.0);
                Function function = new Function("H", "if(m>1, 2*x*H(n,x)-2*n*H(n-1,x), if(m>0, 2*x, 1) )", argument, argument14, argument13);
                function.setParametersNumber(2);
                Argument argument15 = new Argument("k", 5.0);
                string = "der( H(k,x), x) - 2*k*H(k-1,x)";
                RegTestExpression.exp[n] = new Expression(string, argument14, argument15);
                exp[n].addDefinitions(function);
                boolean bl2 = exp[n].checkSyntax();
                argument.setArgumentName("m");
                if (bl2 && !exp[n].getSyntaxStatus()) {
                    bl = true;
                }
                mXparser.consolePrint(exp[n].getErrorMessage() + " reg ... Syntax status unknown. --> ");
                break;
            }
            case 125: {
                string = "2==2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 126: {
                string = "2 != 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 127: {
                string = "2 ~= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 128: {
                string = "1 && 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 129: {
                string = "1 || -1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
            }
            case 130: {
                string = "~1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 131: {
                string = "2+~(1-1)!";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 132: {
                Argument argument = new Argument("x", 2.0);
                string = "if( int(2*x,x,0,pi) > 0 , 1, 2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 133: {
                Argument argument = new Argument("x", 2.0);
                string = "if( -int(2*x,x,0,pi) > 0 , 1, 2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 134: {
                mXparser.setEpsilon(1.0E-8);
                string = "sum(n, 0, 10, if ( if( sin(n*pi/2) > 0, 1, 2) >= 2, 4, 2) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 38.0;
                if (d == d2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 135: {
                string = "sin(0)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 136: {
                string = "cos(0) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 137: {
                string = "tan(0) - 0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 138: {
                string = "tg(0) - 0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 139: {
                string = "ctan(pi/2) - 0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 140: {
                string = "ctg(pi/2) - 0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 141: {
                string = "cot(pi/2) - 0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 142: {
                string = "sec(0) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 143: {
                string = "cosec(pi/2) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 144: {
                string = "csc(pi/2) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 145: {
                string = "asin(0.5) - pi/6";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 146: {
                string = "arsin(0) - 0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 147: {
                string = "arcsin(1) - pi/2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 148: {
                string = "acos(0) - pi/2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 149: {
                string = "arcos(0.5) - pi/3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 150: {
                string = "arccos(-1) - pi";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 151: {
                string = "atan(0) - 0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 152: {
                string = "arctan(1) - pi/4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 153: {
                string = "atg(1) - pi/4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 154: {
                string = "arctg(1) - pi/4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 155: {
                string = "actan(0) - pi/2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 156: {
                string = "arcctan(1) - pi/4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 157: {
                string = "actg(1) - pi/4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 158: {
                string = "arcctg(1) - pi/4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 159: {
                string = "acot(1) - pi/4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 160: {
                string = "arccot(1) - pi/4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 161: {
                string = "ln(e) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 162: {
                string = "ln(e^2) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 163: {
                string = "log2(8) - 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 164: {
                string = "log10(1000) - 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 165: {
                string = "rad(180) - pi";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 166: {
                string = "exp(2) - e^2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 167: {
                string = "sqrt(25) - 5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 168: {
                string = "sinh(ln([phi])) - 0.5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 169: {
                string = "cosh(ln([phi])) - 0.5*sqrt(5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 170: {
                string = "tanh(ln([phi])) - 1/sqrt(5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 171: {
                string = "tgh(ln([phi])) - 1/sqrt(5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 172: {
                string = "ctanh(ln([phi])) - sqrt(5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 173: {
                string = "coth(ln([phi])) - sqrt(5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 174: {
                string = "ctgh(ln([phi])) - sqrt(5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 175: {
                string = "sech(ln([phi])) - 1/(0.5*sqrt(5))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 176: {
                string = "csch(ln([phi])) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 177: {
                string = "cosech(ln([phi])) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 178: {
                string = "deg(pi) - 180";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 179: {
                string = "abs(-1) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 180: {
                string = "sgn(1) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 181: {
                string = "sgn(0) - 0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 182: {
                string = "floor(1.2) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 183: {
                string = "floor(1.9) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 184: {
                string = "floor(-1.9) - (-2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 185: {
                string = "ceil(1.2) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 186: {
                string = "ceil(1.9) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 187: {
                string = "ceil(-1.2) - (-1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 188: {
                string = "asinh(0.5) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 189: {
                string = "arsinh(0.5) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 190: {
                string = "acosh(0.5*sqrt(5)) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 191: {
                string = "arcosh(0.5*sqrt(5)) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 192: {
                string = "arccosh(0.5*sqrt(5)) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 193: {
                string = "atanh(1/sqrt(5)) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 194: {
                string = "arctanh(1/sqrt(5)) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 195: {
                string = "atgh(1/sqrt(5)) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 196: {
                string = "arctgh(1/sqrt(5)) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 197: {
                string = "actanh(sqrt(5)) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 198: {
                string = "arcctanh(sqrt(5)) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 199: {
                string = "acoth(sqrt(5)) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 200: {
                string = "arcoth(sqrt(5)) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
            }
        }
        if (bl) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return bl;
    }

    private static boolean runTest_00201_00300(int n) {
        mXparser.consolePrint("[" + n + "] ");
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        String string = "";
        switch (n) {
            case 201: {
                string = "arccoth(sqrt(5)) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 202: {
                string = "actgh(sqrt(5)) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 203: {
                string = "arcctgh(sqrt(5)) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 204: {
                string = "asech(1/(0.5*sqrt(5))) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 205: {
                string = "arsech(1/(0.5*sqrt(5))) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 206: {
                string = "arcsech(1/(0.5*sqrt(5))) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 207: {
                string = "acsch(2) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 208: {
                string = "arcsch(2) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 209: {
                string = "arccsch(2) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 210: {
                string = "acosech(2) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 211: {
                string = "arcosech(2) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 212: {
                string = "arccosech(2) - ln([phi])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 213: {
                string = "log(2,8) - 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 214: {
                string = "min(2,3) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 215: {
                string = "max(2,3) - 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 216: {
                string = "mod(10,6) - 4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 217: {
                string = "if(1,2,3) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 218: {
                string = "if(0,2,3) - 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 219: {
                string = "iff(1, 2) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 220: {
                string = "iff(0, 2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Double.NaN;
                if (Double.isNaN(d)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 221: {
                string = "iff(0, 2, 1, 2) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 222: {
                string = "iff(0, 2, 1, 2, 3, 4) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 223: {
                string = "iff(0, 2, 1, 2, 0, 4) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 224: {
                string = "iff(0, 2, 0, 2, 1, 4) - 4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d - d2) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 225: {
                string = "iff(0, 2, 0, 2, 0, 4)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Double.NaN;
                if (Double.isNaN(d)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 226: {
                Argument argument = new Argument("x", 2.0);
                string = "Sinc(x) - prod(n, 1, 16, cos(x / 2^n) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 227: {
                Argument argument = new Argument("x", 2.0);
                string = "sinc(x) - prod(n, 1, 100, (1 - x^2 / n^2) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 228: {
                Argument argument = new Argument("x", 2.0);
                string = "Sa(x) - prod(n, 1, 100, (1 - x^2 / n^2) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 229: {
                Argument argument = new Argument("n", 10.0);
                string = "Bell(n) - sum(k, 0, n, Stirl2(n,k) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 230: {
                Argument argument = new Argument("n", 10.0);
                Argument argument2 = new Argument("k", 5.0);
                string = "Worp(n, k) - k! * Stirl2(n+1, k+1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument2);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 231: {
                Argument argument = new Argument("n", 10.0);
                string = "Bern(n,0) - sum(k, 0, n, ( (-1)^k )* ( Worp(n, k) / ( k+1 ) ) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 232: {
                Argument argument = new Argument("n", 15.0);
                Argument argument3 = new Argument("k", 5.0);
                string = "sum(p, k, n, Stirl1(n, p) * C(p,k)) - Stirl1(n+1, k+1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument3);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 233: {
                string = "chi(1, 0, 2) + CHi(1, 0, 2) + Chi(1, 0, 2) + cHi(1, 0, 2) + chi(0, 0, 2) + CHi(0, 0, 2) + Chi(0, 0, 2) + cHi(0, 0, 2) + chi(2, 0, 2) + CHi(2, 0, 2) + Chi(2, 0, 2) + cHi(2, 0, 2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 8.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 234: {
                string = "2 + 10#7 + 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 8.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 235: {
                Argument argument = new Argument("x", 5.0);
                string = "int( chi(t, 0, x), t, 0, x) - x";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-4) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 236: {
                Argument argument = new Argument("x", 5.0);
                string = "int( CHi(t, 0, x), t, 0, x) - x";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-4) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 237: {
                Argument argument = new Argument("x", 5.0);
                string = "int( Chi(t, 0, x), t, 0, x) - x";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-4) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 238: {
                Argument argument = new Argument("x", 5.0);
                string = "int( cHi(t, 0, x), t, 0, x) - x";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-4) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 239: {
                string = "ConFrac(1,2,3,5,6,7) - ConPol(1,2,3,4,5,6,7) / ConPol(2,3,4,5,6,7)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 0.001) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 240: {
                string = "min(1,2,3,4,5,-5,343,3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -5.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-4) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 241: {
                string = "max(1,2,3,4,5,-5,343,3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 343.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 242: {
                Argument argument = new Argument("x", 0.5);
                string = "ConPol(x,x,x,x,x,x) - sum(k, 0, 6, C(6-k, k) * x^(6-2*k))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 243: {
                Argument argument = new Argument("m", 5.0);
                Argument argument4 = new Argument("n", 10.0);
                string = "Euler(n,m) -  sum(k,0,m, C(n+1,k)*((m+1-k)^n)*(-1)^k)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument4, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 244: {
                Argument argument = new Argument("x", 2.0);
                Function function = new Function("f", "sin(x)+cos(x)", "x");
                string = "diff(f(x), x) - ( f(x+1)-f(x) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 245: {
                Argument argument = new Argument("x", 2.0);
                Argument argument5 = new Argument("h", 1.0);
                Function function = new Function("f", "sin(x)+cos(x)", "x");
                string = "diff(f(x), x, h/2) - ( f(x+h/2)-f(x) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument5);
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 246: {
                Argument argument = new Argument("x", 2.0);
                Function function = new Function("f", "sin(x)+cos(x)", "x");
                string = "difb(f(x), x) - ( f(x)-f(x-1) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 247: {
                Argument argument = new Argument("x", 2.0);
                Argument argument6 = new Argument("h", 1.0);
                Function function = new Function("f", "sin(x)+cos(x)", "x");
                string = "difb(f(x), x, h/2) - ( f(x)-f(x-h/2) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument6);
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 248: {
                Function function = new Function("fib", "if(n>1, fib(n-1)+fib(n-2), if(n>0,1,0))", "n");
                string = "sum(i,0,10,Fib(i) - fib(i))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 249: {
                Function function = new Function("luc", "if(n>1, luc(n-1)+luc(n-2), if(n>0,1,2))", "n");
                string = "sum(i,0,10,Luc(i) - luc(i))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 250: {
                string = "sum(i,1,10,harm(i)) - sum(i,1,10,sum(k,1,i,1/k))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 251: {
                Constant constant = new Constant("p", 0.0);
                Constant constant2 = new Constant("q", 1.0);
                string = "p --> q";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant2);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 252: {
                Constant constant = new Constant("p", 0.0);
                Constant constant3 = new Constant("q", 1.0);
                string = "p <-- q";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant3);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 253: {
                Constant constant = new Constant("p", 0.0);
                Constant constant4 = new Constant("q", 1.0);
                string = "p <-- q";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant4);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 254: {
                Constant constant = new Constant("p", 0.0);
                Constant constant5 = new Constant("q", 1.0);
                string = "p <-> q";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant5);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 255: {
                Constant constant = new Constant("p", 0.0);
                Constant constant6 = new Constant("q", 1.0);
                string = "p (+) q";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant6);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 256: {
                Constant constant = new Constant("p", 0.0);
                Constant constant7 = new Constant("q", 1.0);
                string = "p /\\ q";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant7);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 257: {
                Constant constant = new Constant("p", 0.0);
                Constant constant8 = new Constant("q", 1.0);
                string = "p \\/ q";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant8);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 258: {
                Constant constant = new Constant("p", 0.0);
                Constant constant9 = new Constant("q", 1.0);
                string = "p ~& q";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant9);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 259: {
                Constant constant = new Constant("p", 0.0);
                Constant constant10 = new Constant("q", 1.0);
                string = "p ~&& q";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant10);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 260: {
                Constant constant = new Constant("p", 0.0);
                Constant constant11 = new Constant("q", 1.0);
                string = "p ~/\\ q";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant11);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 261: {
                Constant constant = new Constant("p", 0.0);
                Constant constant12 = new Constant("q", 1.0);
                string = "p ~| q";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant12);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 262: {
                Constant constant = new Constant("p", 0.0);
                Constant constant13 = new Constant("q", 1.0);
                string = "p ~|| q";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant13);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 263: {
                Constant constant = new Constant("p", 0.0);
                Constant constant14 = new Constant("q", 1.0);
                string = "p ~\\/ q";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant14);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 264: {
                Constant constant = new Constant("p", 0.0);
                Constant constant15 = new Constant("q", 1.0);
                Constant constant16 = new Constant("r", 1.0);
                string = "(p /\\ q) \\/ (~p) \\/ (~q)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant15, constant16);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 265: {
                Constant constant = new Constant("p", 0.0);
                Constant constant17 = new Constant("q", 1.0);
                Constant constant18 = new Constant("r", 1.0);
                string = "(p --> q) <-> (~q --> ~p)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant17, constant18);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 266: {
                Constant constant = new Constant("p", 0.0);
                Constant constant19 = new Constant("q", 1.0);
                Constant constant20 = new Constant("r", 1.0);
                string = "( (p --> q) /\\ (q --> r) ) --> (p --> r)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant19, constant20);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 267: {
                Constant constant = new Constant("p", 0.0);
                Constant constant21 = new Constant("q", 1.0);
                Constant constant22 = new Constant("r", 1.0);
                string = "( (p \\/ q) /\\ (p --> r) /\\ (q --> r) ) --> r";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant21, constant22);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 268: {
                Constant constant = new Constant("p", 0.0);
                Constant constant23 = new Constant("q", 1.0);
                string = "~(p /\\ q) <-> (~p \\/ ~q)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(constant, constant23);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 269: {
                string = "gcd(1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 270: {
                string = "gcd(12,9)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 3.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 271: {
                string = "gcd(12,6,18)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 6.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 272: {
                string = "lcm(1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 273: {
                string = "lcm(12,9)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 36.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 274: {
                string = "lcm(12,6,18)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 36.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 275: {
                string = "sum(i,1,10,harm(i)) - sum(i,1,10,Harm(1,i))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 276: {
                string = "1/4*2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.5;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 277: {
                string = "n1_geq_2(0)";
                Constant constant = new Constant("c1", 0.26);
                RecursiveArgument recursiveArgument = new RecursiveArgument("z1", "z1(n-1)^2+c1", "n");
                recursiveArgument.addDefinitions(constant);
                recursiveArgument.addBaseCase(0, 0.0);
                Function function = new Function("n1_geq_2", "if( z1(k) > 2, k, n1_geq_2(k+1) )", "k");
                function.addDefinitions(recursiveArgument);
                mXparser.consolePrint(constant.getConstantName() + " = " + constant.getConstantValue() + " ; " + recursiveArgument.getArgumentName() + " = " + recursiveArgument.getArgumentExpressionString() + " ; " + function.getFunctionName() + " = " + function.getFunctionExpressionString() + " ; " + string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(function);
                d = exp[n].calculate();
                d2 = 30.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 278: {
                string = "n2_geq_2(0)";
                Constant constant = new Constant("c2", 0.26);
                Function function = new Function("z2", "if( n>0, z2(n-1)^2+c2, 0)", "n");
                function.addDefinitions(constant);
                Function function2 = new Function("n2_geq_2", "if( z2(k) > 2, k, n2_geq_2(k+1) )", "k");
                function2.addDefinitions(function);
                mXparser.consolePrint(constant.getConstantName() + " = " + constant.getConstantValue() + " ; " + function.getFunctionName() + " = " + function.getFunctionExpressionString() + " ; " + function2.getFunctionName() + " = " + function2.getFunctionExpressionString() + " ; " + string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(function2);
                d = exp[n].calculate();
                d2 = 30.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 279: {
                string = "n1_geq_2(0) - n2_geq_2(0)";
                Constant constant = new Constant("c1", 0.26);
                RecursiveArgument recursiveArgument = new RecursiveArgument("z1", "z1(n-1)^2+c1", "n");
                recursiveArgument.addDefinitions(constant);
                recursiveArgument.addBaseCase(0, 0.0);
                Function function = new Function("n1_geq_2", "if( z1(k) > 2, k, n1_geq_2(k+1) )", "k");
                function.addDefinitions(recursiveArgument);
                Constant constant24 = new Constant("c2", 0.26);
                Function function3 = new Function("z2", "if( n>0, z2(n-1)^2+c2, 0)", "n");
                function3.addDefinitions(constant24);
                Function function4 = new Function("n2_geq_2", "if( z2(k) > 2, k, n2_geq_2(k+1) )", "k");
                function4.addDefinitions(function3);
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(function, function4);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 280: {
                string = "sum(i, 1, 20, IsPrime(i) )";
                Function function = new Function("IsFactor", "if( a>b, 0, if( n#a = 0, 1, IsFactor(n, a+1, b) ) )", "n", "a", "b");
                Function function5 = new Function("IsPrime", "if( n<2, 0, ~IsFactor(n, 2, sqrt(n)) )", "n");
                function5.addDefinitions(function);
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(function5);
                d = exp[n].calculate();
                d2 = 8.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 281: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                string = "abs( sin(0.5)-s(0.5))+abs( cos(0.7)-c(0.7) )";
                Constant constant = new Constant("a", 1.0E-5);
                Function function = new Function("s", "if( abs(x) < a, x, 2*s(x/2)*c(x/2) )", "x");
                Function function6 = new Function("c", "if( abs(x) < a, 1, c(x/2)^2 - s(x/2)^2 )", "x");
                function.addDefinitions(constant);
                function.addDefinitions(function6);
                function6.addDefinitions(constant);
                function6.addDefinitions(function);
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(function, function6);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 282: {
                string = "f1(1,2)-f2(1,2)";
                Function function = new Function("f1", "sin(x)+cos(y)", "x", "y");
                Function function7 = new Function("f2(x,y) = sin(x)+cos(y)", new PrimitiveElement[0]);
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                exp[n].addDefinitions(function, function7);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 283: {
                string = "a = 5.1, expr = 2*a";
                Constant constant = new Constant("a = 5.1", new PrimitiveElement[0]);
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression("2*a", new PrimitiveElement[0]);
                exp[n].addDefinitions(constant);
                d = exp[n].calculate();
                d2 = 10.2;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 284: {
                string = "a = sin(pi/2), expr = a";
                Constant constant = new Constant("a = sin(pi/2)", new PrimitiveElement[0]);
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression("a", new PrimitiveElement[0]);
                exp[n].addDefinitions(constant);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 285: {
                string = "fib(n)= fib(n-1)+fib(n-2), fib(10) = ";
                mXparser.consolePrint(string + " ...... ");
                RecursiveArgument recursiveArgument = new RecursiveArgument("fib(n)= fib(n-1)+fib(n-2)", new PrimitiveElement[0]);
                recursiveArgument.addBaseCase(0, 0.0);
                recursiveArgument.addBaseCase(1, 1.0);
                RegTestExpression.exp[n] = new Expression("fib(10)", recursiveArgument);
                d = exp[n].calculate();
                d2 = 55.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 286: {
                string = "fib(n) = if(n>1, fib(n-1) + fib(n-2), if(n = 1, 1, 0)), fib(10) = ";
                mXparser.consolePrint(string + " ...... ");
                Function function = new Function("fib(n) = if(n>1, fib(n-1) + fib(n-2), if(n = 1, 1, 0))", new PrimitiveElement[0]);
                RegTestExpression.exp[n] = new Expression("fib(10)", function);
                d = exp[n].calculate();
                d2 = 55.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 287: {
                string = "5^2 * 7^3 * 11^1 * 67^1 * 49201^1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                String string2 = mXparser.numberToAsciiString(exp[n].calculate());
                String string3 = "Hello";
                if (string3.equals(string2)) {
                    bl = true;
                }
                mXparser.consolePrint(string2 + " reg ... " + string3 + " --> ");
                break;
            }
            case 288: {
                string = "71^1 * 218549^1 * 6195547^1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                String string4 = mXparser.numberToAsciiString(exp[n].calculate());
                String string5 = "World!";
                if (string5.equals(string4)) {
                    bl = true;
                }
                mXparser.consolePrint(string4 + " reg ... " + string5 + " --> ");
                break;
            }
            case 289: {
                string = "min(3,4)+max(-2,-1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 290: {
                string = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 291: {
                mXparser.initPrimesCache(50);
                string = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 292: {
                mXparser.initPrimesCache(55);
                string = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 293: {
                mXparser.initPrimesCache(97);
                string = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 294: {
                mXparser.initPrimesCache(99);
                string = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 295: {
                mXparser.initPrimesCache(101);
                string = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 296: {
                mXparser.initPrimesCache(999);
                string = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 297: {
                mXparser.initPrimesCache(2000);
                string = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 298: {
                mXparser.setNoPrimesCache();
                string = "Pi(1000)";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 299: {
                mXparser.initPrimesCache(50);
                string = "Pi(1000)";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 300: {
                mXparser.initPrimesCache(55);
                string = "Pi(1000)";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
            }
        }
        if (bl) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return bl;
    }

    private static boolean runTest_00301_00400(int n) {
        mXparser.consolePrint("[" + n + "] ");
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        String string = "";
        switch (n) {
            case 301: {
                mXparser.initPrimesCache(97);
                string = "Pi(1000)";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 302: {
                mXparser.initPrimesCache(99);
                string = "Pi(1000)";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 303: {
                mXparser.initPrimesCache(101);
                string = "Pi(1000)";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 304: {
                mXparser.initPrimesCache(999);
                string = "Pi(1000)";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 305: {
                mXparser.initPrimesCache(2000);
                string = "Pi(1000)";
                mXparser.consolePrint(string + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 168.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 306: {
                string = "Ei( ln([RS'm]) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 307: {
                string = "-e*Ei(-1) - [EG]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 308: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                string = "abs( Ei(-1)  / (0.219383934395520274 * 10^0 ) ) + abs( Ei(-4)  / (0.377935240984890648 * 10^-2 ) ) + abs( Ei(-6)  / (0.360082452162658659 * 10^-3 ) ) + abs( Ei(-8)  / (0.376656228439249018 * 10^-4 ) ) + abs( Ei(-11) / (0.140030030424744178 * 10^-5 ) ) + abs( Ei(-16) / (0.664048724944104278 * 10^-8 ) ) + abs( Ei(-21) / (0.345320126714675627 * 10^-10 ) ) + abs( Ei(-26) / (0.189468588567497824 * 10^-12 ) ) + abs( Ei(-31) / (0.107676703861623826 * 10^-14 ) ) + abs( Ei(-36) / (0.627333900976224159 * 10^-17 ) ) + abs( Ei(-41) / (0.372316677645997772 * 10^-19 ) ) + abs( Ei(-46) / (0.224153175974429975 * 10^-21 ) ) + abs( Ei(-50) / (0.378326402955045902 * 10^-23 ) ) + abs( Ei(1)  / (0.189511781635593676 * 10^1 ) ) + abs( Ei(4)  / (0.196308744700562200 * 10^2 ) ) + abs( Ei(6)  / (0.859897621424392048 * 10^2 ) ) + abs( Ei(8)  / (0.440379899534838269 * 10^3 ) ) + abs( Ei(11) / (0.607140637409861151 * 10^4 ) ) + abs( Ei(16) / (0.595560998670837002 * 10^6 ) ) + abs( Ei(21) / (0.661271863554849213 * 10^8 ) ) + abs( Ei(26) / (0.784294099189818637 * 10^10 ) ) + abs( Ei(31) / (0.969455575968393966 * 10^12 ) ) + abs( Ei(36) / (0.123285207991209769 * 10^15 ) ) + abs( Ei(41) / (0.160066491432450411 * 10^17 ) ) + abs( Ei(46) / (0.211134238864782419 * 10^19 ) ) + abs( Ei(50) / (0.105856368971316910 * 10^21 ) ) - 26";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 309: {
                string = "sum(x; -11; 11; [gam] + ln(abs(x)) + sum(k, 1, 50, x^k / (k*k!)) - Ei(x), 2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 310: {
                string = "Li(0) + [li2]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 311: {
                mXparser.initPrimesCache(10000000);
                string = "Pi(10000000) / Li(10000000)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 0.001) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 312: {
                Argument argument = new Argument("x = 100000000", new PrimitiveElement[0]);
                string = "( ( x / ln(x) ) * sum(k, 0, 20, k! / ln(x)^k ) ) / li(x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 313: {
                Function function = new Function("fefe(x)=2*x", new PrimitiveElement[0]);
                string = "fefe(2) + fefe(3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 10.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 314: {
                string = "add(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 55.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 315: {
                string = "multi(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 3628800.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 316: {
                string = "mean(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 5.5;
                if (MathFunctions.abs(d2 - d) < 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 317: {
                string = "var(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 9.166666667;
                if (MathFunctions.abs(d2 - d) < 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 318: {
                string = "std(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 3.027650354;
                if (MathFunctions.abs(d2 - d) < 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 319: {
                string = "avg(i, 1, 10, i)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 5.5;
                if (MathFunctions.abs(d2 - d) < 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 320: {
                string = "vari(i, 1, 10, i)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 9.166666667;
                if (MathFunctions.abs(d2 - d) < 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 321: {
                string = "stdi(i, 1, 10, i)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 3.027650354;
                if (MathFunctions.abs(d2 - d) < 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 322: {
                string = "mini(i, -10, 10, i)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -10.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 323: {
                string = "maxi(i, -10, 10, i)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 10.0;
                if (MathFunctions.abs(d2 - d) < 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 324: {
                string = "maxi(i, 1, 100000, [Uni])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 325: {
                string = "mini(i, 1, 100000, [Uni])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 326: {
                string = "avg(i, 1, 100000, [Uni])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.5;
                if (MathFunctions.abs(d2 - d) < 1.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 327: {
                string = "vari(i, 1, 100000, [Uni])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.08333333333333333;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 328: {
                string = "stdi(i, 1, 100000, [Uni])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = MathFunctions.sqrt(0.08333333333333333);
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 329: {
                string = "maxi(i, 1, 100000, [Int1])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 10.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 330: {
                string = "mini(i, 1, 100000, [Int1])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -10.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 331: {
                string = "avg(i, 1, 100000, [Int1])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 1.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 332: {
                string = "vari(i, 1, 100000, [Int1])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = (MathFunctions.power(21.0, 2.0) - 1.0) / 12.0;
                if (MathFunctions.abs(d2 - d) < 1.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 333: {
                string = "stdi(i, 1, 100000, [Int1])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = MathFunctions.sqrt((MathFunctions.power(21.0, 2.0) - 1.0) / 12.0);
                if (MathFunctions.abs(d2 - d) < 0.1) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 334: {
                string = "maxi(i, 1, 100000, [Int2])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 100.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 335: {
                string = "mini(i, 1, 100000, [Int2])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -100.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 336: {
                string = "maxi(i, 1, 1000000, [Int3])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1000.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 337: {
                string = "mini(i, 1, 1000000, [Int3])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1000.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 338: {
                string = "maxi(i, 1, 10000000, [Int4])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 10000.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 339: {
                string = "mini(i, 1, 10000000, [Int4])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -10000.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 340: {
                string = "maxi(i, 1, 10000000, [Int5])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 100000.0;
                if (MathFunctions.abs(d2 - d) <= 10.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 341: {
                string = "mini(i, 1, 10000000, [Int5])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -100000.0;
                if (MathFunctions.abs(d2 - d) <= 10.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 342: {
                string = "maxi(i, 1, 10000000, [Int6])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1000000.0;
                if (MathFunctions.abs(d2 - d) <= 100.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 343: {
                string = "mini(i, 1, 10000000, [Int6])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1000000.0;
                if (MathFunctions.abs(d2 - d) <= 100.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 344: {
                string = "maxi(i, 1, 10000000, [Int7])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0E7;
                if (MathFunctions.abs(d2 - d) <= 1000.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 345: {
                string = "mini(i, 1, 10000000, [Int7])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1.0E7;
                if (MathFunctions.abs(d2 - d) <= 1000.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 346: {
                string = "maxi(i, 1, 10000000, [Int8])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0E8;
                if (MathFunctions.abs(d2 - d) <= 10000.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 347: {
                string = "mini(i, 1, 10000000, [Int8])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1.0E8;
                if (MathFunctions.abs(d2 - d) <= 10000.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 348: {
                string = "maxi(i, 1, 10000000, [Int9])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0E9;
                if (MathFunctions.abs(d2 - d) <= 100000.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 349: {
                string = "mini(i, 1, 10000000, [Int9])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1.0E9;
                if (MathFunctions.abs(d2 - d) <= 100000.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 350: {
                string = "maxi(i, 1, 10000000, [Int])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.147483647E9;
                if (MathFunctions.abs(d2 - d) <= 214748.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 351: {
                string = "mini(i, 1, 10000000, [Int])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -2.147483648E9;
                if (MathFunctions.abs(d2 - d) <= 214748.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 352: {
                string = "maxi(i, 1, 100000, [nat1])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 10.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 353: {
                string = "mini(i, 1, 100000, [nat1])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 354: {
                string = "maxi(i, 1, 100000, [nat2])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 100.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 355: {
                string = "mini(i, 1, 100000, [nat2])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 356: {
                string = "maxi(i, 1, 100000, [nat3])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1000.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 357: {
                string = "mini(i, 1, 100000, [nat3])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 358: {
                string = "maxi(i, 1, 1000000, [nat3])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1000.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 359: {
                string = "mini(i, 1, 1000000, [nat3])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 360: {
                string = "maxi(i, 1, 10000000, [nat4])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 10000.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 361: {
                string = "mini(i, 1, 10000000, [nat4])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 362: {
                string = "maxi(i, 1, 10000000, [nat5])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 100000.0;
                if (MathFunctions.abs(d2 - d) <= 5.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 363: {
                string = "mini(i, 1, 10000000, [nat5])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 5.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 364: {
                string = "maxi(i, 1, 10000000, [nat6])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1000000.0;
                if (MathFunctions.abs(d2 - d) <= 50.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 365: {
                string = "mini(i, 1, 10000000, [nat6])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 50.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 366: {
                string = "maxi(i, 1, 10000000, [nat7])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0E7;
                if (MathFunctions.abs(d2 - d) <= 500.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 367: {
                string = "mini(i, 1, 10000000, [nat7])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 500.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 368: {
                string = "maxi(i, 1, 10000000, [nat8])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0E8;
                if (MathFunctions.abs(d2 - d) <= 5000.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 369: {
                string = "mini(i, 1, 10000000, [nat8])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 5000.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 370: {
                string = "maxi(i, 1, 10000000, [nat9])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0E9;
                if (MathFunctions.abs(d2 - d) <= 50000.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 371: {
                string = "mini(i, 1, 10000000, [nat9])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 50000.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 372: {
                string = "maxi(i, 1, 10000000, [nat])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.147483647E9;
                if (MathFunctions.abs(d2 - d) <= 112374.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 373: {
                string = "mini(i, 1, 10000000, [nat])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 112374.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 374: {
                string = "maxi(i, 1, 100000, [Nat1])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 10.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 375: {
                string = "mini(i, 1, 100000, [Nat1])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 376: {
                string = "maxi(i, 1, 100000, [Nat2])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 100.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 377: {
                string = "mini(i, 1, 100000, [Nat2])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 378: {
                string = "maxi(i, 1, 100000, [Nat3])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1000.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 379: {
                string = "mini(i, 1, 100000, [Nat3])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 380: {
                string = "maxi(i, 1, 1000000, [Nat3])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1000.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 381: {
                string = "mini(i, 1, 1000000, [Nat3])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 382: {
                string = "maxi(i, 1, 10000000, [Nat4])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 10000.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 383: {
                string = "mini(i, 1, 10000000, [Nat4])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) < 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 384: {
                string = "maxi(i, 1, 10000000, [Nat5])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 100000.0;
                if (MathFunctions.abs(d2 - d) <= 5.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 385: {
                string = "mini(i, 1, 10000000, [Nat5])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 5.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 386: {
                string = "maxi(i, 1, 10000000, [Nat6])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1000000.0;
                if (MathFunctions.abs(d2 - d) <= 50.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 387: {
                string = "mini(i, 1, 10000000, [Nat6])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 50.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 388: {
                string = "maxi(i, 1, 10000000, [Nat7])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0E7;
                if (MathFunctions.abs(d2 - d) <= 500.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 389: {
                string = "mini(i, 1, 10000000, [Nat7])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 500.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 390: {
                string = "maxi(i, 1, 10000000, [Nat8])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0E8;
                if (MathFunctions.abs(d2 - d) <= 5000.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 391: {
                string = "mini(i, 1, 10000000, [Nat8])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 5000.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 392: {
                string = "maxi(i, 1, 10000000, [Nat9])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0E9;
                if (MathFunctions.abs(d2 - d) <= 50000.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 393: {
                string = "mini(i, 1, 10000000, [Nat9])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 50000.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 394: {
                string = "maxi(i, 1, 10000000, [Nat])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.147483647E9;
                if (MathFunctions.abs(d2 - d) <= 112374.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 395: {
                string = "mini(i, 1, 10000000, [Nat])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 112374.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 396: {
                string = "int( pUni(x, -1, 3), x, -1, 3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 397: {
                Argument argument = new Argument("x = rUni(-1, 3)", new PrimitiveElement[0]);
                string = "der( cUni(x, -1, 3), x) - pUni(x, -1, 3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 398: {
                Argument argument = new Argument("x = rUni(-1, 3)", new PrimitiveElement[0]);
                string = "x - qUni( cUni(x, -1, 3), -1, 3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 399: {
                string = "mini(i, 1, 1000000, rUni(-1, 3) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1.0;
                if (MathFunctions.abs(d2 - d) <= 0.002) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 400: {
                string = "maxi(i, 1, 1000000, rUni(-1, 3) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 3.0;
                if (MathFunctions.abs(d2 - d) <= 0.002) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
            }
        }
        if (bl) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return bl;
    }

    private static boolean runTest_00401_00500(int n) {
        mXparser.consolePrint("[" + n + "] ");
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        String string = "";
        switch (n) {
            case 401: {
                string = "mini(i, 1, 1000000, pUni( rUni(-10, 10), -1, 3) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.002) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 402: {
                string = "maxi(i, 1, 1000000, pUni( rUni(-10, 10), -1, 3) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.25;
                if (MathFunctions.abs(d2 - d) <= 0.002) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 403: {
                string = "mini(i, 1, 1000000, cUni( rUni(-10, 10), -1, 3) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.002) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 404: {
                string = "maxi(i, 1, 1000000, cUni( rUni(-10, 10), -1, 3) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 0.002) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 405: {
                Argument argument = new Argument("x = rUni(-2,4)", new PrimitiveElement[0]);
                Argument argument2 = new Argument("y = rUni(-2,4)", new PrimitiveElement[0]);
                string = "cUni( min(x, y), -1, 3) <= cUni( max(x, y), -1, 3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument2);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 0.002) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 406: {
                string = "round(2.2, 0)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 407: {
                string = "round(2.6, 0)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 3.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 408: {
                string = "round(2.66, 1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.7;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 409: {
                string = "round(2.123456, 5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.12346;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 410: {
                string = "avg(i, 1, 1000000, [Nor])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 411: {
                string = "stdi(i, 1, 1000000, [Nor])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 412: {
                string = "vari(i, 1, 1000000, [Nor])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 413: {
                string = "avg(i, 1, 1000000, rNor(1,5) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 414: {
                string = "stdi(i, 1, 1000000, rNor(3,3) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 3.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 415: {
                string = "vari(i, 1, 1000000, rNor(-10, 5) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 25.0;
                if (MathFunctions.abs(d2 - d) <= 0.2) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 416: {
                string = "int( pNor(x, 0, 1), x, -10, 0.5) - cNor( 0.5, 0, 1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-4) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 417: {
                Argument argument = new Argument("x = 0.5", new PrimitiveElement[0]);
                string = "der( cNor(x, 1, 2), x) - pNor(x, 1, 2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.002) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 418: {
                string = "int( pNor(x, 1, 2), x, 0.5, 1.5) - ( cNor(1.5, 1, 2) - cNor(0.5, 1, 2) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.002) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 419: {
                Argument argument = new Argument("x = [Nor]", new PrimitiveElement[0]);
                string = "pNor(x, 0, 1) - pNor(-x, 0, 1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.002) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 420: {
                Argument argument = new Argument("x = [Uni]", new PrimitiveElement[0]);
                string = "cNor(2-x, 2, 2) - ( 1 - cNor(2+x, 2, 2) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.002) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 421: {
                Argument argument = new Argument("x = [Nor]", new PrimitiveElement[0]);
                string = "qNor(0.5, -4, 5) + 4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.002) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 422: {
                Argument argument = new Argument("x = rUni(-10,10)", new PrimitiveElement[0]);
                Argument argument3 = new Argument("y = rUni(-10,10)", new PrimitiveElement[0]);
                string = "cNor( min(x, y), -1, 3) <= cNor( max(x, y), -1, 3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument3);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 0.002) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 423: {
                string = "290933.27886809571646 - sum(x, 0.01, 10, Ei(x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 424: {
                string = "-97.065869924036363159 - sum(x, -10, -0.01, Ei(x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-8) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 425: {
                string = "144.17558195220803441 - sum(x, 0, 2, erf(x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-8) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 426: {
                string = "-144.17558195220797757 - sum(x, -2, 0, erf(x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-8) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 427: {
                string = "56.824418047792065067 - sum(x, 0, 2, erfc(x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-8) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 428: {
                string = "345.17558195220811967 - sum(x, -2, 0, erfc(x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-8) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 429: {
                string = "42.417037259662720317 - sum(x, 0, 0.9, erfInv(x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-8) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 430: {
                string = "-42.417037259662699000 - sum(x, -0.9, 0, erfInv(x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-8) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 431: {
                string = "55.303894660741931943 - sum(x, 0.01, 1, erfcInv(x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-8) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 432: {
                string = "-55.303894660741946154 - sum(x, 1, 1.99, erfcInv(x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-8) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 433: {
                string = "round(2.125, 2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.13;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 434: {
                string = "round(2.135, 2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.14;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 435: {
                string = "round(2.145, 2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.15;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 436: {
                string = "round(3.125, 2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 3.13;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 437: {
                string = "round(3.135, 2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 3.14;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 438: {
                string = "round(3.145, 2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 3.15;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 439: {
                string = "rList(1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 440: {
                string = "rList(1, 1, 1, 1, 1, 1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 441: {
                string = "mini(i, 1, 10000, rList(3, 2, 7, 6, 10, 15, 12) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 442: {
                string = "maxi(i, 1, 10000, rList(3, 2, 7, 6, 10, 15, 12) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 15.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 443: {
                mXparser.disableUlpRounding();
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.setExactComparison();
                string = "0.1+0.1+0.1 <> 0.3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 444: {
                mXparser.disableUlpRounding();
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.setEpsilonComparison();
                string = "0.1+0.1+0.1 = 0.3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 445: {
                mXparser.enableUlpRounding();
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.setExactComparison();
                string = "0.1+0.1+0.1 = 0.3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 446: {
                mXparser.setEpsilon(0.5);
                string = "2 < 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 447: {
                mXparser.setEpsilon(0.5);
                string = "2.5 < 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 448: {
                mXparser.setEpsilon(0.5);
                string = "2.7 < 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 449: {
                mXparser.setEpsilon(0.5);
                string = "3 < 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 450: {
                mXparser.setEpsilon(0.5);
                string = "3.2 < 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 451: {
                mXparser.setEpsilon(0.5);
                string = "3.5 < 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 452: {
                mXparser.setEpsilon(0.5);
                string = "4 < 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 453: {
                mXparser.setEpsilon(0.5);
                string = "2 <= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 454: {
                mXparser.setEpsilon(0.5);
                string = "2.5 <= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 455: {
                mXparser.setEpsilon(0.5);
                string = "2.7 <= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 456: {
                mXparser.setEpsilon(0.5);
                string = "3 <= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 457: {
                mXparser.setEpsilon(0.5);
                string = "3.2 <= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 458: {
                mXparser.setEpsilon(0.5);
                string = "3.5 <= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 459: {
                mXparser.setEpsilon(0.5);
                string = "4 <= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 460: {
                mXparser.setEpsilon(0.5);
                string = "2 > 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 461: {
                mXparser.setEpsilon(0.5);
                string = "2.5 > 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 462: {
                mXparser.setEpsilon(0.5);
                string = "2.7 > 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 463: {
                mXparser.setEpsilon(0.5);
                string = "3 > 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 464: {
                mXparser.setEpsilon(0.5);
                string = "3.2 > 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 465: {
                mXparser.setEpsilon(0.5);
                string = "3.5 > 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 466: {
                mXparser.setEpsilon(0.5);
                string = "4 > 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 467: {
                mXparser.setEpsilon(0.5);
                string = "2 >= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 468: {
                mXparser.setEpsilon(0.5);
                string = "2.5 >= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 469: {
                mXparser.setEpsilon(0.5);
                string = "2.7 >= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 470: {
                mXparser.setEpsilon(0.5);
                string = "3 >= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 471: {
                mXparser.setEpsilon(0.5);
                string = "3.2 >= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 472: {
                mXparser.setEpsilon(0.5);
                string = "3.5 >= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 473: {
                mXparser.setEpsilon(0.5);
                string = "4 >= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 474: {
                mXparser.setEpsilon(0.5);
                string = "2 = 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 475: {
                mXparser.setEpsilon(0.5);
                string = "2.5 = 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 476: {
                mXparser.setEpsilon(0.5);
                string = "2.7 = 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 477: {
                mXparser.setEpsilon(0.5);
                string = "3 = 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 478: {
                mXparser.setEpsilon(0.5);
                string = "3.2 = 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 479: {
                mXparser.setEpsilon(0.5);
                string = "3.5 = 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 480: {
                mXparser.setEpsilon(0.5);
                string = "4 = 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 481: {
                mXparser.setEpsilon(0.5);
                string = "2 <> 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 482: {
                mXparser.setEpsilon(0.5);
                string = "2.5 <> 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 483: {
                mXparser.setEpsilon(0.5);
                string = "2.7 <> 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 484: {
                mXparser.setEpsilon(0.5);
                string = "3 <> 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 485: {
                mXparser.setEpsilon(0.5);
                string = "3.2 <> 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 486: {
                mXparser.setEpsilon(0.5);
                string = "3.5 <> 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 487: {
                mXparser.setEpsilon(0.5);
                string = "4 <> 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 488: {
                mXparser.setExactComparison();
                string = "2 < 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 489: {
                mXparser.setExactComparison();
                string = "3 < 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 490: {
                mXparser.setExactComparison();
                string = "4 < 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 491: {
                mXparser.setExactComparison();
                string = "2 <= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 492: {
                mXparser.setExactComparison();
                string = "3 <= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 493: {
                mXparser.setExactComparison();
                string = "4 <= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 494: {
                mXparser.setExactComparison();
                string = "2 > 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 495: {
                mXparser.setExactComparison();
                string = "3 > 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 496: {
                mXparser.setExactComparison();
                string = "4 > 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 497: {
                mXparser.setExactComparison();
                string = "2 >= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 498: {
                mXparser.setExactComparison();
                string = "3 >= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 499: {
                mXparser.setExactComparison();
                string = "4 >= 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 500: {
                mXparser.setExactComparison();
                string = "2 = 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
            }
        }
        if (bl) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return bl;
    }

    private static boolean runTest_00501_00600(int n) {
        mXparser.consolePrint("[" + n + "] ");
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        String string = "";
        switch (n) {
            case 501: {
                mXparser.setExactComparison();
                string = "3 = 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 502: {
                mXparser.setExactComparison();
                string = "4 = 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 503: {
                mXparser.setExactComparison();
                string = "2 <> 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 504: {
                mXparser.setExactComparison();
                string = "3 <> 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 505: {
                mXparser.setExactComparison();
                string = "4 <> 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 506: {
                string = "ulp(0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.3877787807814457E-17;
                if (MathFunctions.abs(d2 - d) <= 1.0E-16) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 507: {
                mXparser.setExactComparison();
                string = "sum(i, 1, 3, 0.1) = 0.3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-16) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 508: {
                mXparser.setExactComparison();
                Argument argument = new Argument("a", new PrimitiveElement[0]);
                Argument argument2 = new Argument("b", new PrimitiveElement[0]);
                argument.setArgumentValue(1.0);
                argument2.setArgumentValue(5.0);
                string = "if(a=6,-b,15)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument2);
                d = exp[n].calculate();
                d2 = 15.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-16) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 509: {
                mXparser.setExactComparison();
                string = "5!^2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 14400.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-16) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 510: {
                mXparser.setExactComparison();
                string = "5!-3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 117.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-16) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 511: {
                mXparser.setExactComparison();
                string = "5!+3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 123.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-16) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 512: {
                mXparser.setExactComparison();
                string = "10/5-(5!)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -118.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-16) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 513: {
                mXparser.setExactComparison();
                string = "10/5+(5!)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 122.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-16) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 514: {
                mXparser.setExactComparison();
                string = "10/5+5!";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 122.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-16) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 515: {
                mXparser.setExactComparison();
                string = "1<-2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-16) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 516: {
                mXparser.setExactComparison();
                string = "1e1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 10.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-16) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 517: {
                mXparser.setEpsilonComparison();
                string = "100*[%]-1000*[%%]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 518: {
                mXparser.setEpsilonComparison();
                string = "[Y]-[sept]+( [Y]/[Z]-1000 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 519: {
                mXparser.setEpsilonComparison();
                string = "[Z]-[sext]+( [Z]/[E]-1000 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 520: {
                mXparser.setEpsilonComparison();
                string = "[E]-[quint]+( [E]/[P]-1000 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 521: {
                mXparser.setEpsilonComparison();
                string = "[P]-[quad]+( [P]/[T]-1000 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 522: {
                mXparser.setEpsilonComparison();
                string = "[T]-[tril]+( [T]/[G]-1000 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 523: {
                mXparser.setEpsilonComparison();
                string = "[G]-[bil]+( [G]/[M]-1000 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 524: {
                mXparser.setEpsilonComparison();
                string = "[M]-[mil]+( [M]/[k]-1000 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 525: {
                mXparser.setEpsilonComparison();
                string = "[k]-[th]+( [k]/[hecto]-10 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 526: {
                mXparser.setEpsilonComparison();
                string = "[hecto]-[hund]+( [hecto]/[deca]-10 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 527: {
                mXparser.setEpsilonComparison();
                string = "[deca]-[ten]+( [deca]-10 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 528: {
                mXparser.setEpsilonComparison();
                string = "[deci]^2-[%]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 529: {
                mXparser.setEpsilonComparison();
                string = "[deci]/[centi]-10";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 530: {
                mXparser.setEpsilonComparison();
                string = "[centi]/[milli]-10";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 531: {
                mXparser.setEpsilonComparison();
                string = "[milli]/[mic]-1000";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 532: {
                mXparser.setEpsilonComparison();
                string = "[mic]/[n]-1000";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 533: {
                mXparser.setEpsilonComparison();
                string = "[n]/[p]-1000";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 534: {
                mXparser.setEpsilonComparison();
                string = "[p]/[f]-1000";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 535: {
                mXparser.setEpsilonComparison();
                string = "[f]/[a]-1000";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 536: {
                mXparser.setEpsilonComparison();
                string = "[a]/[z]-1000";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 537: {
                mXparser.setEpsilonComparison();
                string = "[z]/[y]-1000";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 538: {
                mXparser.setEpsilonComparison();
                string = "1000*[m]-[km]+(10*[mm]-[cm])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 539: {
                mXparser.setEpsilonComparison();
                string = "([inch]-2.54*[cm])+([ft]-0.3048*[m])+([yd]-0.9144*[m])+([mile]-1.609344*[km])+([nmi]-1.852*[km])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 540: {
                mXparser.setEpsilonComparison();
                string = "[m2]-100*[cm]*100*[cm]+[m2]-10000*[cm2]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 541: {
                mXparser.setEpsilonComparison();
                string = "[cm2]-10*[mm]*10*[mm]+[cm2]-100*[mm2]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 542: {
                mXparser.setEpsilonComparison();
                string = "[are]-10*[m]*10*[m]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 543: {
                mXparser.setEpsilonComparison();
                string = "[ha]-100*[m]*100*[m]+[ha]-100*[are]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 544: {
                mXparser.setEpsilonComparison();
                string = "[acre]-66*[ft]*660*[ft]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 545: {
                mXparser.setEpsilonComparison();
                string = "[km2]-100*[ha]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 546: {
                mXparser.setEpsilonComparison();
                string = "[cm3]-10*[mm]*10*[mm]*10*[mm]+[cm3]-1000*[mm3]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 547: {
                mXparser.setEpsilonComparison();
                string = "[m3]-1000*[l]+[m3]-[m]*[m]*[m]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 548: {
                mXparser.setEpsilonComparison();
                string = "[km3]-[bil]*[m3]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 549: {
                mXparser.setEpsilonComparison();
                string = "[l]-[th]*[ml]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 550: {
                mXparser.setEpsilonComparison();
                string = "[gall]-3.78541178*[l]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 551: {
                mXparser.setEpsilonComparison();
                string = "[pint]-473.176473*[ml]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 552: {
                mXparser.setEpsilonComparison();
                string = "[min]-60*[s]+[h]-60*[min]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 553: {
                mXparser.setEpsilonComparison();
                string = "[day]-24*[h]+[week]-7*[day]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 554: {
                mXparser.setEpsilonComparison();
                string = "[yearj]-365.25*[day]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 555: {
                mXparser.setEpsilonComparison();
                string = "[kg]-1000*[gr]+[kg]-100*[dag]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 556: {
                mXparser.setEpsilonComparison();
                string = "[dag]-10*[gr]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 557: {
                mXparser.setEpsilonComparison();
                string = "[gr]-[th]*[mg]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 558: {
                mXparser.setEpsilonComparison();
                string = "[t]-1000*[kg]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 559: {
                mXparser.setEpsilonComparison();
                string = "[oz]-28.3495231*[gr]+[lb]-453.59237*[gr]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 560: {
                mXparser.setEpsilonComparison();
                string = "[b]-1+[kb]/[b]-1024";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 561: {
                mXparser.setEpsilonComparison();
                string = "( [Mb]/[kb]-1024 ) + ( [Gb]/[Mb]-1024 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 562: {
                mXparser.setEpsilonComparison();
                string = "( [Tb]/[Gb]-1024 ) + ( [Pb]/[Tb]-1024 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 563: {
                mXparser.setEpsilonComparison();
                string = "( [Eb]/[Pb]-1024 ) + ( [Zb]/[Eb]-1024 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 564: {
                mXparser.setEpsilonComparison();
                string = "[Yb]/[Zb]-1024";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 565: {
                mXparser.setEpsilonComparison();
                string = "[B]-8*[b]+[kB]/[B]-1024";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 566: {
                mXparser.setEpsilonComparison();
                string = "( [MB]/[kB]-1024 ) + ( [GB]/[MB]-1024 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 567: {
                mXparser.setEpsilonComparison();
                string = "( [TB]/[GB]-1024 ) + ( [PB]/[TB]-1024 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 568: {
                mXparser.setEpsilonComparison();
                string = "( [EB]/[PB]-1024 ) + ( [ZB]/[EB]-1024 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 569: {
                mXparser.setEpsilonComparison();
                string = "[YB]/[ZB]-1024";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 570: {
                mXparser.setEpsilonComparison();
                string = "[J] - ( [kg]*[m2] ) / ( [s]*[s] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 571: {
                mXparser.setEpsilonComparison();
                string = "[eV]-1.60217662*[a]*[deci]*[J]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 572: {
                mXparser.setEpsilonComparison();
                string = "( [keV]/[eV]-1000 ) + ( [MeV]/[keV]-1000 ) + ( [GeV]/[MeV]-1000 ) + ( [TeV]/[GeV]-1000 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 573: {
                mXparser.setEpsilonComparison();
                string = "[m/s] - ([m]/[s])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 574: {
                mXparser.setEpsilonComparison();
                string = "[km/h] - ([km]/[h])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 575: {
                mXparser.setEpsilonComparison();
                string = "[mi/h] - ([mile]/[h])";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 576: {
                mXparser.setEpsilonComparison();
                string = "[knot] - 0.514444444*[m/s]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 577: {
                mXparser.setEpsilonComparison();
                string = "[m/s2]-[m]/([s]^2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 578: {
                mXparser.setEpsilonComparison();
                string = "[km/h2]-[km]/[h]^2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 579: {
                mXparser.setEpsilonComparison();
                string = "[mi/h2]-[mile]/[h]^2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 580: {
                mXparser.setEpsilonComparison();
                string = "2*pi*[rad]-360*[deg]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 581: {
                mXparser.setEpsilonComparison();
                string = "( [deg]/[']-60 ) + ( [']/[''] - 60 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 582: {
                mXparser.setEpsilonComparison();
                string = "[c] - 299792458*[m]/[s]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 583: {
                mXparser.setEpsilonComparison();
                string = "[hP] - [h-]*2*pi";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 584: {
                mXparser.setEpsilonComparison();
                string = "( [lP] - 1.616229*[y]*[p]*10*[m]) + ( [mP] - 2.176470*[n]*10*[kg] ) + ( [tP] - 5.39116*[y]*[z]*10*[s] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 585: {
                mXparser.setEpsilonComparison();
                string = "[ly]-[c]*[yearj]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 586: {
                mXparser.setEpsilonComparison();
                string = "[pc]/(3.08567758*[P]*10*[m])-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 587: {
                mXparser.setEpsilonComparison();
                string = "[kpc]/[pc]-1000";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 588: {
                mXparser.setEpsilonComparison();
                string = "( [Earth-R-eq]-[Earth-R-po] ) / ( 6378.1370*[km]-6356.7523*[km] ) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 589: {
                mXparser.setEpsilonComparison();
                string = "( ( [G.] * [Earth-M] ) / [Earth-R]^2 ) / [g] - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 590: {
                mXparser.setEpsilonComparison();
                string = "( ( [G.] * [Solar-M] ) / [Solar-R]^2 ) / ( 28.2*[g] ) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 591: {
                mXparser.setEpsilonComparison();
                string = "( ( [G.] * [Mercury-M] ) / [Mercury-R]^2 ) / ( 0.38*[g] ) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 592: {
                mXparser.setEpsilonComparison();
                string = "( ( [G.] * [Venus-M] ) / [Venus-R]^2 ) / ( 0.904*[g] ) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 593: {
                mXparser.setEpsilonComparison();
                string = "( ( [G.] * [Moon-M] ) / [Moon-R]^2 ) / ( 0.1654*[g] ) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 594: {
                mXparser.setEpsilonComparison();
                string = "( ( [G.] * [Mars-M] ) / [Mars-R]^2 ) / ( 0.376*[g] ) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 595: {
                mXparser.setEpsilonComparison();
                string = "( ( [G.] * [Jupiter-M] ) / [Jupiter-R]^2 ) / ( 2.527876492*[g] ) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.1) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 596: {
                mXparser.setEpsilonComparison();
                string = "( ( [G.] * [Saturn-M] ) / [Saturn-R]^2 ) / ( 1.065*[g] ) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.1) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 597: {
                mXparser.setEpsilonComparison();
                string = "( ( [G.] * [Uranus-M] ) / [Uranus-R]^2 ) / ( 0.886*[g] ) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.1) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 598: {
                mXparser.setEpsilonComparison();
                string = "( ( [G.] * [Neptune-M] ) / [Neptune-R]^2 ) / ( 1.14*[g] ) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 599: {
                mXparser.setEpsilonComparison();
                string = "[Earth-D]/[au]-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 600: {
                mXparser.setEpsilonComparison();
                string = "[Mercury-D] / ( 57909050*[km] )-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
            }
        }
        if (bl) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return bl;
    }

    private static boolean runTest_00601_00700(int n) {
        mXparser.consolePrint("[" + n + "] ");
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        String string = "";
        switch (n) {
            case 601: {
                mXparser.setEpsilonComparison();
                string = "[Venus-D] / ( 108208000*[km] )-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 602: {
                mXparser.setEpsilonComparison();
                string = "[Mars-D] / ( 1.523679*[au] )-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 603: {
                mXparser.setEpsilonComparison();
                string = "[Jupiter-D] / ( 5.20260*[au] )-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 604: {
                mXparser.setEpsilonComparison();
                string = "[Saturn-D] / ( 1.429*[bil]*[km] )-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 605: {
                mXparser.setEpsilonComparison();
                string = "[Uranus-D] / ( 19.2184*[au] )-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 606: {
                mXparser.setEpsilonComparison();
                string = "[Neptune-D] / ( 30.110387*[au] )-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 607: {
                mXparser.setEpsilonComparison();
                string = "@~100";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -101.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 608: {
                mXparser.setEpsilonComparison();
                string = "-100 @^ 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -98.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 609: {
                mXparser.setEpsilonComparison();
                string = "-100 @| 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -98.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 610: {
                mXparser.setEpsilonComparison();
                string = "-100 @& 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 611: {
                mXparser.setEpsilonComparison();
                string = "-100 @>> 4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -7.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 612: {
                mXparser.setEpsilonComparison();
                string = "-100 @<< 4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1600.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 613: {
                mXparser.setEpsilonComparison();
                string = "pi+1.23e-10";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 3.141592653712793;
                if (MathFunctions.abs(d2 - d) <= 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 614: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.setEpsilonComparison();
                string = "sin(pi+1.23e-10)+e^1.1e1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = MathFunctions.sin(3.141592653712793) + MathFunctions.power(Math.E, 11.0);
                if (MathFunctions.abs(d2 - d) <= 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 615: {
                mXparser.setEpsilonComparison();
                string = "2e-2+2E+2+3.1e4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 31200.02;
                if (MathFunctions.abs(d2 - d) <= 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 616: {
                mXparser.setEpsilonComparison();
                string = "123.34344e-16*0.00001E-2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.2334344E-21;
                if (MathFunctions.abs(d2 - d) <= 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 617: {
                mXparser.setEpsilonComparison();
                string = "-123.34344e-16*(-0.00001E-2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.2334344E-21;
                if (MathFunctions.abs(d2 - d) <= 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 618: {
                mXparser.setEpsilonComparison();
                Function function = new Function("ff", new FunExt());
                string = "5*6-ff(5,6)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 619: {
                mXparser.setEpsilonComparison();
                string = "solve(2*x-4, x, -10, 10)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 620: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x=0", new PrimitiveElement[0]);
                string = "solve( der(sin(x), x), x, 0, pi )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 1.5707963267948966;
                if (MathFunctions.abs(d2 - d) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 621: {
                mXparser.setEpsilonComparison();
                string = "solve( sin(x), x, -pi-1, 1 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                if (MathFunctions.abs(-Math.PI - d) <= 1.0E-6 || MathFunctions.abs(0.0 - d) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... 0 or 3.141592653589793 --> ");
                break;
            }
            case 622: {
                mXparser.setEpsilonComparison();
                string = "if( [true] && ([false] || ([false] && [true])) = [false], 1, 0)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 623: {
                mXparser.setEpsilonComparison();
                string = "if( isNaN(3/0) = [true], 1, 0)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 624: {
                mXparser.setEpsilonComparison();
                string = "if( isNaN(3/1) = [false], 1, 0)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 625: {
                mXparser.setEpsilonComparison();
                string = "if( isNaN([NaN]) = [true], 1, 0)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 626: {
                mXparser.setEpsilonComparison();
                string = "coalesce( 1, 2, 3 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 627: {
                mXparser.setEpsilonComparison();
                string = "coalesce( [NaN], 2, 3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 628: {
                mXparser.setEpsilonComparison();
                string = "coalesce( [NaN], [NaN], 3, 5, 6)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 3.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 629: {
                mXparser.setEpsilonComparison();
                string = "coalesce( [NaN], 3/0, [NaN], 5, 6)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 5.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 630: {
                mXparser.setEpsilonComparison();
                string = "coalesce( [NaN], 3/0, [NaN], 5/0, 6)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 6.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 631: {
                mXparser.setEpsilonComparison();
                string = "if( isNaN( coalesce( [NaN], 3/0, [NaN], 5/0, [NaN]) ) = [true], 1, 0)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 632: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = 2*y", new PrimitiveElement[0]);
                Argument argument2 = new Argument("y = 2*x", new PrimitiveElement[0]);
                argument.addDefinitions(argument2);
                argument2.addDefinitions(argument);
                string = "x+y";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument2);
                d = exp[n].calculate();
                d2 = Double.NaN;
                if (Double.isNaN(d)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 633: {
                mXparser.setEpsilonComparison();
                Function function = new Function("f(x) = 2*g(x)", new PrimitiveElement[0]);
                Function function2 = new Function("g(x) = 2*f(x)", new PrimitiveElement[0]);
                function.addDefinitions(function2);
                function2.addDefinitions(function);
                string = "f(1)+g(1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function, function2);
                d = exp[n].calculate();
                d2 = Double.NaN;
                if (Double.isNaN(d)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 634: {
                mXparser.setEpsilonComparison();
                Function function = new Function("f(n) = f(n-1)", new PrimitiveElement[0]);
                string = "f(10)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = Double.NaN;
                if (Double.isNaN(d)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 635: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = x + 2", new PrimitiveElement[0]);
                argument.addDefinitions(argument);
                string = "x-3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = Double.NaN;
                if (Double.isNaN(d)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 636: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("y = 2", new PrimitiveElement[0]);
                Argument argument3 = new Argument("x = 2*y + x", new PrimitiveElement[0]);
                Function function = new Function("f(x) = 2*g(x)+y", new PrimitiveElement[0]);
                Function function3 = new Function("g(x) = 2*f(x)+x+y", new PrimitiveElement[0]);
                argument3.addDefinitions(argument3, argument);
                function.addDefinitions(function3, argument);
                function3.addDefinitions(function, argument);
                string = "2*sin(x)+2*x-3*y+f(x)-g(y)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument3, argument, function, function3);
                d = exp[n].calculate();
                d2 = Double.NaN;
                if (Double.isNaN(d)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 637: {
                mXparser.setEpsilonComparison();
                string = "00000001";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 638: {
                mXparser.setEpsilonComparison();
                string = "-00000001";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 639: {
                mXparser.setEpsilonComparison();
                string = "+00000001";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 640: {
                mXparser.setEpsilonComparison();
                string = "00000001.001";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.001;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 641: {
                mXparser.setEpsilonComparison();
                string = "-00000001.0002";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1.0002;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 642: {
                mXparser.setEpsilonComparison();
                string = "+00000001.123";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.123;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 643: {
                mXparser.setEpsilonComparison();
                string = "00000001.001e001";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 10.01;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 644: {
                mXparser.setEpsilonComparison();
                string = "-00000001.0002e0002";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -100.02;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 645: {
                mXparser.setEpsilonComparison();
                string = "+00000001.123e004";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 11230.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 646: {
                mXparser.setEpsilonComparison();
                string = "00000001.001e+001";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 10.01;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 647: {
                mXparser.setEpsilonComparison();
                string = "-00000001.0002e+0002";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -100.02;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 648: {
                mXparser.setEpsilonComparison();
                string = "+00000001.123e+004";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 11230.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 649: {
                mXparser.setEpsilonComparison();
                string = "00000001.001e-001";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.1001;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 650: {
                mXparser.setEpsilonComparison();
                string = "-00000001.0002e-0002";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -0.010002;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 651: {
                mXparser.setEpsilonComparison();
                string = "+00000001.123e-004";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.123E-4;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 652: {
                mXparser.setEpsilonComparison();
                string = "+000001.001e+0000000";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.001;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 653: {
                mXparser.setEpsilonComparison();
                string = "00000001-(-00000001)+(+00000001)-00000001.001-(-00000001.0002)-(+00000001.123)+00000001.001e001+(-00000001.0002e0002)-(+00000001.123e004)-00000001.001e+001+00000001.0002e+0002+(+00000001.123e+004)-00000001.001e-001-(-00000001.0002e-0002)-(+00000001.123e-004)-(+00000001.123e-004)-(+000001.001e+0000000)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.7848774000006082;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 654: {
                mXparser.setEpsilonComparison();
                string = "2%";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.02;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 655: {
                mXparser.setEpsilonComparison();
                string = "-2%";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -0.02;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 656: {
                mXparser.setEpsilonComparison();
                string = "100%+2%";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.02;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 657: {
                mXparser.setEpsilonComparison();
                string = "100%-2%";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.98;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 658: {
                mXparser.setEpsilonComparison();
                string = "((1%)%)%";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0E-6;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 659: {
                mXparser.setEpsilonComparison();
                string = "2!+(3!)%";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.06;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 660: {
                mXparser.setEpsilonComparison();
                string = "2*[%]-2%";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 661: {
                mXparser.setEpsilonComparison();
                mXparser.setToOverrideBuiltinTokens();
                Function function = new Function("sin(x,y) = 2*x + y", new PrimitiveElement[0]);
                Argument argument = new Argument("e = 5", new PrimitiveElement[0]);
                Constant constant = new Constant("pi = 2", new PrimitiveElement[0]);
                string = "sin(e,pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function, argument, constant);
                d = exp[n].calculate();
                d2 = 12.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 662: {
                mXparser.setEpsilonComparison();
                string = "or( [false] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setNotToOverrideBuiltinTokens();
                break;
            }
            case 663: {
                mXparser.setEpsilonComparison();
                string = "or( [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 664: {
                mXparser.setEpsilonComparison();
                string = "or( [NaN] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Double.NaN;
                if (Double.isNaN(d)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 665: {
                mXparser.setEpsilonComparison();
                string = "or( [false], 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 666: {
                mXparser.setEpsilonComparison();
                string = "or( [false], [NaN] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Double.NaN;
                if (Double.isNaN(d)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 667: {
                mXparser.setEpsilonComparison();
                string = "or( [false], 0, 0, 0, 0, [false], 0, 0, 0, 0, 0, 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 668: {
                mXparser.setEpsilonComparison();
                string = "or( [false], 0, [NaN], 0, 0, [false], 0, 0, 0, 0, 0, 1 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 669: {
                mXparser.setEpsilonComparison();
                string = "or( 1, 0, [NaN], 0, 0, [false], 0, 0, 0, 0, 0, 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 670: {
                mXparser.setEpsilonComparison();
                string = "or( 0, 1, [NaN], 0, 0, [false], 0, 0, 0, 0, 0, 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 671: {
                mXparser.setEpsilonComparison();
                string = "or( 1, 2, 3, 4, [true], -10, -0.5, 2, 0.01 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 672: {
                mXparser.setEpsilonComparison();
                string = "and( [false] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 673: {
                mXparser.setEpsilonComparison();
                string = "and( [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 674: {
                mXparser.setEpsilonComparison();
                string = "and( [NaN] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Double.NaN;
                if (Double.isNaN(d)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 675: {
                mXparser.setEpsilonComparison();
                string = "and( [false], 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 676: {
                mXparser.setEpsilonComparison();
                string = "and( [false], [NaN] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 677: {
                mXparser.setEpsilonComparison();
                string = "and( [false], 0, 0, 0, 0, [false], 0, 0, 0, 0, 0, 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 678: {
                mXparser.setEpsilonComparison();
                string = "and( [false], 0, [NaN], 0, 0, [false], 0, 0, 0, 0, 0, 1 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 679: {
                mXparser.setEpsilonComparison();
                string = "and( 1, 0, [NaN], 0, 0, [false], 0, 0, 0, 0, 0, 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 680: {
                mXparser.setEpsilonComparison();
                string = "and( 0, 1, [NaN], 0, 0, [false], 0, 0, 0, 0, 0, 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 681: {
                mXparser.setEpsilonComparison();
                string = "and( 1, 2, 3, 4, [true], -10, -0.5, 2, 0.01 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 682: {
                mXparser.setEpsilonComparison();
                string = "xor( [false] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 683: {
                mXparser.setEpsilonComparison();
                string = "xor( [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 684: {
                mXparser.setEpsilonComparison();
                string = "xor( [NaN] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Double.NaN;
                if (Double.isNaN(d)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 685: {
                mXparser.setEpsilonComparison();
                string = "xor( [false], 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 686: {
                mXparser.setEpsilonComparison();
                string = "xor( [false], [NaN] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Double.NaN;
                if (Double.isNaN(d)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 687: {
                mXparser.setEpsilonComparison();
                string = "xor( [false], 0, 0, 0, 0, [false], 0, 0, 0, 0, 0, 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 688: {
                mXparser.setEpsilonComparison();
                string = "xor( [false], 0, [NaN], 0, 0, [false], 0, 0, 0, 0, 0, 1 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Double.NaN;
                if (Double.isNaN(d)) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 689: {
                mXparser.setEpsilonComparison();
                string = "xor( 1, 0, [false], 0, 0, [false], 0, 0, 0, 0, 0, 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 690: {
                mXparser.setEpsilonComparison();
                string = "xor( 0, 1, 1, 0, 0, [false], 0, 0, 0, 0, 0, 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 691: {
                mXparser.setEpsilonComparison();
                string = "xor( 1, 2, 3, 4, [true], -10, -0.5, 2, 0.01 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 692: {
                mXparser.setEpsilonComparison();
                string = "-b1.+0+b1.-2*B1.";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 693: {
                mXparser.setEpsilonComparison();
                string = "(-b1.111+3)-B1.111+3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 694: {
                mXparser.setEpsilonComparison();
                string = "(-b2.101+5)-B2.00101+5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 695: {
                mXparser.setEpsilonComparison();
                string = "(-b3.121+16)-B3.00121+16";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 696: {
                mXparser.setEpsilonComparison();
                string = "(-b4.123+27)-B4.00123+27";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 697: {
                mXparser.setEpsilonComparison();
                string = "(-b5.341+96)-B5.00341+96";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 698: {
                mXparser.setEpsilonComparison();
                string = "(-b6.352+140)-B6.00352+140";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 699: {
                mXparser.setEpsilonComparison();
                string = "(-b7.256+139)-B7.00256+139";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 700: {
                mXparser.setEpsilonComparison();
                string = "(-b8.376+254)-B8.00376+254";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
            }
        }
        if (bl) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return bl;
    }

    private static boolean runTest_00701_00800(int n) {
        mXparser.consolePrint("[" + n + "] ");
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        String string = "";
        switch (n) {
            case 701: {
                mXparser.setEpsilonComparison();
                string = "(-o.376+254)-O.00376+254";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 702: {
                mXparser.setEpsilonComparison();
                string = "(-b.101+5)-B.00101+5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 703: {
                mXparser.setEpsilonComparison();
                string = "(-b9.821+667)-B9.00821+667";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 704: {
                mXparser.setEpsilonComparison();
                string = "(-b10.394+394)-B10.00394+394";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 705: {
                mXparser.setEpsilonComparison();
                string = "(-b11.3A7+480)-B11.003a7+480";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 706: {
                mXparser.setEpsilonComparison();
                string = "(-b12.A5B+1511)-B12.00a5b+1511";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 707: {
                mXparser.setEpsilonComparison();
                string = "(-b13.ACB+1857)-B13.00acb+1857";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 708: {
                mXparser.setEpsilonComparison();
                string = "(-b14.2AD+545)-B14.002ad+545";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 709: {
                mXparser.setEpsilonComparison();
                string = "(-b15.BE4+2689)-B15.00be4+2689";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 710: {
                mXparser.setEpsilonComparison();
                string = "(-b16.FA2+4002)-B16.00fa2+4002";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 711: {
                mXparser.setEpsilonComparison();
                string = "(-h.FA2+4002)-H.00fa2+4002";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 712: {
                mXparser.setEpsilonComparison();
                string = "(-b17.AG6+3168)-B17.00ag6+3168";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 713: {
                mXparser.setEpsilonComparison();
                string = "(-b18.FGH+5165)-B18.00fgh+5165";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 714: {
                mXparser.setEpsilonComparison();
                string = "(-b19.2I3+1067)-B19.002i3+1067";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 715: {
                mXparser.setEpsilonComparison();
                string = "(-b20.9CJ+3859)-B20.009cj+3859";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 716: {
                mXparser.setEpsilonComparison();
                string = "(-b21.K5F+8940)-B21.00k5f+8940";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 717: {
                mXparser.setEpsilonComparison();
                string = "(-b22.FL5+7727)-B22.00fl5+7727";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 718: {
                mXparser.setEpsilonComparison();
                string = "(-b23.1AM+781)-B23.001am+781";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 719: {
                mXparser.setEpsilonComparison();
                string = "(-b24.5ND+3445)-B24.005nd+3445";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 720: {
                mXparser.setEpsilonComparison();
                string = "(-b25.5ND5C+2320762)-B25.005nd5c+2320762";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 721: {
                mXparser.setEpsilonComparison();
                string = "(-b26.3KPB5+1739639)-B26.003kpb5+1739639";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 722: {
                mXparser.setEpsilonComparison();
                string = "(-b27.IQH67+10090258)-B27.00iqh67+10090258";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 723: {
                mXparser.setEpsilonComparison();
                string = "(-b28.RKHB2+17048390)-B28.00rkhb2+17048390";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 724: {
                mXparser.setEpsilonComparison();
                string = "(-b29.8BIFS+5942128)-B29.008bifs+5942128";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 725: {
                mXparser.setEpsilonComparison();
                string = "(-b30.2TGJB+2417981)-B30.002tgjb+2417981";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 726: {
                mXparser.setEpsilonComparison();
                string = "(-b31.6PUC0+6315103)-B31.006puc0+6315103";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 727: {
                mXparser.setEpsilonComparison();
                string = "(-b32.C0PV0+12609504)-B32.00c0pv0+12609504";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 728: {
                mXparser.setEpsilonComparison();
                string = "(-b33.V000W+36763583)-B33.00v000w+36763583";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 729: {
                mXparser.setEpsilonComparison();
                string = "(-b34.NP2XW+31721794)-B34.00np2xw+31721794";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 730: {
                mXparser.setEpsilonComparison();
                string = "(-b35.120Y0+1587565)-B35.00120y0+1587565";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 731: {
                mXparser.setEpsilonComparison();
                string = "(-b36.ZZZZZ+60466175)-B36.00zzzzz+60466175";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 732: {
                mXparser.setEpsilonComparison();
                string = "base(1)-0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 733: {
                mXparser.setEpsilonComparison();
                string = "base(1,1)-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 734: {
                mXparser.setEpsilonComparison();
                string = "base(1,1,1,1,1,1,1,1,1,1,1)-10";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 735: {
                mXparser.setEpsilonComparison();
                string = "base(2,0,0,1)-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 736: {
                mXparser.setEpsilonComparison();
                string = "base(2,1,0,1)-5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 737: {
                mXparser.setEpsilonComparison();
                string = "base(10,1,2,3,4,5,6,7,8,9,0)-1234567890";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 738: {
                mXparser.setEpsilonComparison();
                string = "base(35,b35.0,b35.0,b35.1,b35.2,b35.0,b35.y,b35.0)-B35.00120y0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 739: {
                mXparser.setEpsilonComparison();
                string = "isNaN( base(-1,0,1,2) ) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 740: {
                mXparser.setEpsilonComparison();
                string = "isNaN( base(1,0,1) ) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 741: {
                mXparser.setEpsilonComparison();
                string = "isNaN( base(2) ) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 742: {
                mXparser.setEpsilonComparison();
                string = "isNaN( base(2,2,1) ) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 743: {
                mXparser.setEpsilonComparison();
                string = "isNaN( base(2,-1,1) ) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 744: {
                mXparser.setEpsilonComparison();
                string = "( ndig10(-10)-2 ) + ( ndig10(1234)-4 ) + ( ndig10(0)-1 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 745: {
                mXparser.setEpsilonComparison();
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                string = "sum(i, -1000000, 1000000, ndig10(i) - floor( log10( abs(i) ) ) - 1, 3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 746: {
                mXparser.setEpsilonComparison();
                string = "isNaN( ndig10( [NaN] ) ) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 747: {
                mXparser.setEpsilonComparison();
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                string = "sum( i, -1000000, 1000000, ndig10(i) - ndig(i, 10) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 748: {
                mXparser.setEpsilonComparison();
                string = "(ndig(5, 2) - 3) + (ndig(-5, 2) - 3) + (ndig( b35.124abcdefg,  35) - 10) + (ndig(0, 1) - 0) + (ndig(123, 1) - 123)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 749: {
                mXparser.setEpsilonComparison();
                string = "( isNaN( ndig( [NaN], 10) ) - [true] ) + ( isNaN( ndig( 100, [NaN]) ) - [true] ) + ( isNaN( ndig( 10, -10) ) - [true] ) + ( isNaN( ndig( 10, 0) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 750: {
                mXparser.setEpsilonComparison();
                string = "( dig10(1234567890, 1) - 1 ) + ( dig10(1234567890, 2) - 2 ) + ( dig10(1234567890, 3) - 3 ) + ( dig10(1234567890, 4) - 4 ) + ( dig10(1234567890, 5) - 5 ) + ( dig10(1234567890, 6) - 6 ) + ( dig10(1234567890, 7) - 7 ) + ( dig10(1234567890, 8) - 8 ) + ( dig10(1234567890, 9) - 9 ) + ( dig10(1234567890, 10) - 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 751: {
                mXparser.setEpsilonComparison();
                string = "( dig(1234567890, 1, 10) - 1 ) + ( dig(1234567890, 2, 10) - 2 ) + ( dig(1234567890, 3, 10) - 3 ) + ( dig(1234567890, 4, 10) - 4 ) + ( dig(1234567890, 5, 10) - 5 ) + ( dig(1234567890, 6, 10) - 6 ) + ( dig(1234567890, 7, 10) - 7 ) + ( dig(1234567890, 8, 10) - 8 ) + ( dig(1234567890, 9, 10) - 9 ) + ( dig(1234567890, 10, 10) - 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 752: {
                mXparser.setEpsilonComparison();
                string = "( dig10(1234567890, 0) - 0 ) + ( dig10(1234567890, -1) - 9 ) + ( dig10(1234567890, -2) - 8 ) + ( dig10(1234567890, -3) - 7 ) + ( dig10(1234567890, -4) - 6 ) + ( dig10(1234567890, -5) - 5 ) + ( dig10(1234567890, -6) - 4 ) + ( dig10(1234567890, -7) - 3 ) + ( dig10(1234567890, -8) - 2 ) + ( dig10(1234567890, -9) - 1 ) + ( dig10(1234567890, -10) - 0 ) + ( dig10(1234567890, -11) - 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 753: {
                mXparser.setEpsilonComparison();
                string = "( dig(1234567890, 0, 10) - 0 ) + ( dig(1234567890, -1, 10) - 9 ) + ( dig(1234567890, -2, 10) - 8 ) + ( dig(1234567890, -3, 10) - 7 ) + ( dig(1234567890, -4, 10) - 6 ) + ( dig(1234567890, -5, 10) - 5 ) + ( dig(1234567890, -6, 10) - 4 ) + ( dig(1234567890, -7, 10) - 3 ) + ( dig(1234567890, -8, 10) - 2 ) + ( dig(1234567890, -9, 10) - 1 ) + ( dig(1234567890, -10, 10) - 0 ) + ( dig(1234567890, -11, 10) - 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 754: {
                mXparser.setEpsilonComparison();
                string = "( dig(b35.124abcdefg, 0, 35) - b35.g ) + ( dig(b35.124abcdefg, -1, 35) - b35.f ) + ( dig(b35.124abcdefg, 1, 35) - 1 ) + ( dig(b35.124abcdefg, 2, 35) - 2 ) + ( dig(b35.124abcdefg, 3, 35) - 4 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 755: {
                mXparser.setEpsilonComparison();
                string = "( dig(b1.11111, 1, 1) - 1 ) + ( dig(b1.11111, 2, 1) - 1 ) + ( dig(b1.11111, 3, 1) - 1 ) + ( dig(b1.11111, 4, 1) - 1 ) + ( dig(b1.11111, 5, 1) - 1 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 756: {
                mXparser.setEpsilonComparison();
                string = "( dig(b1.11111, 0, 1) - 1 ) + ( dig(b1.11111, -1, 1) - 1 ) + ( dig(b1.11111, -2, 1) - 1 ) + ( dig(b1.11111, -3, 1) - 1 ) + ( dig(b1.11111, -4, 1) - 1 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 757: {
                mXparser.setEpsilonComparison();
                string = "( dig(b2.10101, 1, 2) - 1 ) + ( dig(b2.10101, 2, 2) - 0 ) + ( dig(b2.10101, 3, 2) - 1 ) + ( dig(b2.10101, 4, 2) - 0 ) + ( dig(b2.10101, 5, 2) - 1 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 758: {
                mXparser.setEpsilonComparison();
                string = "( dig(b2.10101, 0, 2) - 1 ) + ( dig(b2.10101, -1, 2) - 0 ) + ( dig(b2.10101, -2, 2) - 1 ) + ( dig(b2.10101, -3, 2) - 0 ) + ( dig(b2.10101, -4, 2) - 1 ) + ( dig(b2.10101, -5, 2) - 0 ) + ( dig(b2.10101, -6, 2) - 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 759: {
                mXparser.setEpsilonComparison();
                string = "sum(d, 1, ndig10(123456789), dig10(123456789, d) ) - sum(d, 1, ndig10(123456789), d)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 760: {
                mXparser.setEpsilonComparison();
                string = "sum(d, -2*ndig10(123456789), 0, dig10(123456789, d) ) - sum(d, 1, ndig10(123456789), d)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 761: {
                mXparser.setEpsilonComparison();
                string = "sum(d, 1, ndig(123456789, 10), dig(123456789, d, 10) ) - sum(d, 1, ndig(123456789, 10), d)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 762: {
                mXparser.setEpsilonComparison();
                string = "sum(d, -2*ndig(123456789, 10), 0, dig(123456789, d, 10) ) - sum(d, 1, ndig(123456789, 10), d)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 763: {
                mXparser.setEpsilonComparison();
                string = "sum(p, 1, ndig(1234, 1), dig(1234, p, 1) ) - 1234";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 764: {
                mXparser.setEpsilonComparison();
                string = "sum(p, -ndig(1234, 1)+1, 0, dig(1234, p, 1) ) - 1234";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 765: {
                mXparser.setEpsilonComparison();
                string = "( isNaN( dig10( [NaN], 2 ) ) - [true] ) + ( isNaN( dig10( 10, [NaN] ) ) - [true] ) + ( isNaN( dig10( 10, 20 ) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 766: {
                mXparser.setEpsilonComparison();
                string = "( isNaN( dig( 0, 2, 1 ) ) - [true] ) + ( isNaN( dig( 10, -20, 1 ) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 767: {
                mXparser.setEpsilonComparison();
                string = "( isNaN( dig( 100, 1, 0 ) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 768: {
                mXparser.setEpsilonComparison();
                string = "( med(1)-1 ) + ( med(1,2)-1.5 ) + ( med(2,1)-1.5 ) + ( med(2,3,1)-2 ) + ( med(1,2,3)-2 ) + ( med(1,2,3,4)-2.5 ) + ( med(2,3,1,4)-2.5 ) + ( med(1,2,2,3)-2 ) + ( med(5,4,3,2,1)-3 ) + ( med(-5,-4,-3,-2,-1)+3 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 769: {
                mXparser.setEpsilonComparison();
                string = "isNaN( med(1,2,[NaN] ) ) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 770: {
                mXparser.setEpsilonComparison();
                string = "( mode(-1)+1 ) + ( mode(1)-1 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 771: {
                mXparser.setEpsilonComparison();
                string = "( mode(1,2)-1 ) + ( mode(2,1)-2 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 772: {
                mXparser.setEpsilonComparison();
                string = "( mode(1,2,3)-1 ) + ( mode(2,1,3)-2 ) + ( mode(3,2,1)-3 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 773: {
                mXparser.setEpsilonComparison();
                string = "mode(1,1,1,1,1,1)-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 774: {
                mXparser.setEpsilonComparison();
                string = "mode(1,2,1,2,1,2,1,2)-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 775: {
                mXparser.setEpsilonComparison();
                string = "mode(1,2,1,2,1,2,1,2,2)-2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 776: {
                mXparser.setEpsilonComparison();
                string = "mode(2,3,1,4,7,5,6,5,8,9)-5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 777: {
                mXparser.setEpsilonComparison();
                string = "mode(2,3,1,4,7,5,6,5,8,9,4)-4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 778: {
                mXparser.setEpsilonComparison();
                string = "isNaN( mode(1,2,[NaN] ) ) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 779: {
                mXparser.setEpsilonComparison();
                string = "( ndist(1) - 1 ) + ( ndist(1, 2) - 2 ) + ( ndist(1,2,3) - 3 ) + ( ndist(1,1,2) - 2 ) + ( ndist(1,2,1,2) - 2 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 780: {
                mXparser.setEpsilonComparison();
                mXparser.setEpsilon(1.0E-5);
                string = "ndist(1, 2, 1.000001, 1.0001, 3) - 4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 781: {
                mXparser.setEpsilonComparison();
                mXparser.setEpsilon(1.0E-5);
                string = "isNaN( ndist(1,2,3,[NaN]) ) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 782: {
                mXparser.setEpsilonComparison();
                mXparser.setEpsilon(1.0E-5);
                string = "( argmin(1) - 1 ) + ( argmin(1,2) - 1 ) + ( argmin(2,1) - 2 ) + ( argmin(2,2,2,1,3,-1) - 6 ) + ( argmin(1,2,3,-6,2,3,2) - 4 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 783: {
                mXparser.setEpsilonComparison();
                mXparser.setEpsilon(1.0E-5);
                string = "( argmax(-1) - 1 ) + ( argmax(1,2) - 2 ) + ( argmax(2,1) - 1 ) + ( argmax(-1,2,3,2,5) - 5 ) + ( argmax(2,4,1,2,3,10,8,1) - 6 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 784: {
                mXparser.setEpsilonComparison();
                mXparser.setEpsilon(1.0E-5);
                string = "argmax(4, 2, 4.000001, 3) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 785: {
                mXparser.setEpsilonComparison();
                mXparser.setEpsilon(1.0E-5);
                string = "argmin(2, 1.000001, 3, 1) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 786: {
                mXparser.setEpsilonComparison();
                mXparser.setEpsilon(1.0E-5);
                string = "isNaN( argmin(1,2,3,[NaN]) ) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 787: {
                mXparser.setEpsilonComparison();
                mXparser.setEpsilon(1.0E-5);
                string = "isNaN( argmax(1,2,3,[NaN]) ) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 788: {
                mXparser.setEpsilonComparison();
                string = "2^3 - 8";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 789: {
                mXparser.setEpsilonComparison();
                string = "-2^3 + 8";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 790: {
                mXparser.setEpsilonComparison();
                string = "8^(1/3) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 791: {
                mXparser.setEpsilonComparison();
                string = "-8^(1/3) + 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 792: {
                mXparser.setEpsilonComparison();
                string = "125^(1/3) - 5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 793: {
                mXparser.setEpsilonComparison();
                string = "-125^(1/3) + 5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 794: {
                mXparser.setEpsilonComparison();
                string = "128^(1/7) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 795: {
                mXparser.setEpsilonComparison();
                string = "-128^(1/7) + 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 796: {
                mXparser.setEpsilonComparison();
                string = "128^0 - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 797: {
                mXparser.setEpsilonComparison();
                string = "-128^0 - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 798: {
                mXparser.setEpsilonComparison();
                string = "(1/125)^(-1/3) - 5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 799: {
                mXparser.setEpsilonComparison();
                string = "(-1/125)^(-1/3) + 5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 800: {
                mXparser.setEpsilonComparison();
                string = "( nfact(74) - 2 ) + ( factval(74, 1) - 2 ) + ( factval(74, 2) - 37 ) + ( factexp(74, 1) - 1 ) + ( factexp(74, 2) - 1 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
            }
        }
        if (bl) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return bl;
    }

    private static boolean runTest_00801_00900(int n) {
        mXparser.consolePrint("[" + n + "] ");
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        String string = "";
        switch (n) {
            case 801: {
                mXparser.setEpsilonComparison();
                string = "( nfact(5632) - 2 ) + ( factval(5632, 1) - 2 ) + ( factval(5632, 2) - 11 ) + ( factexp(5632, 1) - 9 ) + ( factexp(5632, 2) - 1 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 802: {
                mXparser.setEpsilonComparison();
                string = "( factval(123456789, 0) - 1 ) + ( factval(123456789, -1) - 1 ) + ( factval(123456789, 4) - 1 ) + ( factval(123456789, 5) - 1 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 803: {
                mXparser.setEpsilonComparison();
                string = "( factexp(123456789, 0) - 0 ) + ( factexp(123456789, -1) - 0 ) + ( factexp(123456789, 4) - 0 ) + ( factexp(123456789, 5) - 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 804: {
                mXparser.setEpsilonComparison();
                string = "( factval(123456789, 1) - 3 ) + ( factval(123456789, 2) - 3607 ) + ( factval(123456789, 3) - 3803 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 805: {
                mXparser.setEpsilonComparison();
                string = "( factexp(123456789, 1) - 2 ) + ( factexp(123456789, 2) - 1 ) + ( factexp(123456789, 3) - 1 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 806: {
                mXparser.setEpsilonComparison();
                string = "nfact(123456789) - 3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 807: {
                mXparser.setEpsilonComparison();
                string = "( nfact(0) - 0 ) + ( isNaN( factval(0,1) ) - [true] ) + ( isNaN( factexp(0,1) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 808: {
                mXparser.setEpsilonComparison();
                string = "( isNaN( nfact([NaN]) ) - [true] ) + ( isNaN( factval([NaN],1) ) - [true] ) + ( isNaN( factexp([NaN],1) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 809: {
                mXparser.setEpsilonComparison();
                string = "( isNaN( factval(10,[NaN]) ) - [true] ) + ( isNaN( factexp(10,[NaN]) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 810: {
                mXparser.setEpsilonComparison();
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                string = "sum(n, -100000, 100000,  sgn(n)*prod( id, -10, nfact(n) + 10, factval(n, id)^factexp(n, id) ) - n , 3 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 811: {
                mXparser.setEpsilonComparison();
                string = "( root(7,128) - 2 ) + ( root(7,-128) + 2 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 812: {
                mXparser.setEpsilonComparison();
                string = "( root(3,125) - 5 ) + ( root(3,-125) + 5 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 813: {
                mXparser.setEpsilonComparison();
                string = "( root(3,8) - 2 ) + ( root(3,-8) + 2 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 814: {
                mXparser.setEpsilonComparison();
                string = "( root(1,1) - 1 ) + ( root(1,2) - 2 ) + ( root(1,0) - 0) + ( root(1,-2) +2 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 815: {
                mXparser.setEpsilonComparison();
                string = "( root(0,1) - 1 ) + ( root(0,0) - 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 816: {
                mXparser.setEpsilonComparison();
                string = "( isNaN( root(-2,3) ) - [true]  ) + ( isNaN( root(4,-10) ) - [true]  )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 817: {
                mXparser.setEpsilonComparison();
                string = "( isNaN( root([NaN],3) ) - [true]  ) + ( isNaN( root(3,[NaN]) ) - [true]  )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 818: {
                mXparser.setEpsilonComparison();
                string = "der( sin(x), x, 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 819: {
                mXparser.setEpsilonComparison();
                string = "der+( sin(x), x, 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 820: {
                mXparser.setEpsilonComparison();
                string = "der-( sin(x), x, 0 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 821: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = pi", new PrimitiveElement[0]);
                string = "der( sin(x), x, x )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = -1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 822: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = pi", new PrimitiveElement[0]);
                string = "der( sin(x), x, 2*x )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 823: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = 2", new PrimitiveElement[0]);
                string = "pi-arcsec(x)-arcsec(-x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 824: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = 3", new PrimitiveElement[0]);
                string = "arccsc(-x)+arccsc(x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 825: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = 5", new PrimitiveElement[0]);
                string = "der( arcsec(x), x ) - 1 / ( x^2 * sqrt(1 - 1 / x^2) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 826: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = 6", new PrimitiveElement[0]);
                string = "der( arcsec(x), x ) - 1 / ( abs(x) * sqrt(x^2 - 1) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 827: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = 7", new PrimitiveElement[0]);
                string = "der( arccsc(x), x ) + 1 / ( x^2 * sqrt(1 - 1 / x^2) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 828: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = 8", new PrimitiveElement[0]);
                string = "der( arccsc(x), x ) + 1 / ( abs(x) * sqrt(x^2 - 1) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 829: {
                mXparser.setEpsilonComparison();
                Function function = new Function("Ackermann(m,n) = iff( m = 0, n+1; (m>0) & (n=0), Ackermann(m-1,1); (m>0) & (n>0), Ackermann(m-1, Ackermann(m,n-1)) )", new PrimitiveElement[0]);
                string = "Ackermann(3,4)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 125.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 830: {
                mXparser.setEpsilonComparison();
                Function function = new Function("Tetration(x,n) = if(n > 1, x^Tetration(x,n-1), x)", new PrimitiveElement[0]);
                string = "Tetration(sqrt(2),80)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 831: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = 3.5", new PrimitiveElement[0]);
                string = "Gamma(x+1)-x*Gamma(x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 832: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = -3.5", new PrimitiveElement[0]);
                string = "Gamma(x+1)-x*Gamma(x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 833: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = 1.7", new PrimitiveElement[0]);
                string = "Gamma(x)*Gamma(x+1/2) - ( sqrt(pi) / 2^(2*x-1) ) * Gamma(2*x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 834: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = 0.7", new PrimitiveElement[0]);
                string = "Gamma(x)*Gamma(1-x) - pi / sin(pi * x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 835: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = 0.7", new PrimitiveElement[0]);
                string = "Gamma(x+1/2)*Gamma(1/2-x) - pi / cos(pi * x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 836: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = 0.7", new PrimitiveElement[0]);
                string = "Gamma(x+1/2)*Gamma(1/2-x) - pi / cos(pi * x)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 837: {
                mXparser.setEpsilonComparison();
                string = "Gamma(-3/2) - 4/3 *sqrt(pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 838: {
                mXparser.setEpsilonComparison();
                string = "Gamma(-1/2) + 2 *sqrt(pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 839: {
                mXparser.setEpsilonComparison();
                string = "Gamma(1/2) - sqrt(pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 840: {
                mXparser.setEpsilonComparison();
                string = "Gamma(3/2) - sqrt(pi)/2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 841: {
                mXparser.setEpsilonComparison();
                string = "Gamma(5/2) - 3/4 * sqrt(pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 842: {
                mXparser.setEpsilonComparison();
                string = "Gamma(7/2) - 15/8 * sqrt(pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 843: {
                mXparser.setEpsilonComparison();
                string = "sum(n, 1, 10, Gamma(n) - (n-1)! )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 844: {
                mXparser.setEpsilonComparison();
                string = "sum(n, -100, 0, isNaN( Gamma(n) ) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 845: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x0 = 1.3", new PrimitiveElement[0]);
                string = "der( Gamma(x), x, x0 ) - ( -[gam] + sum(n, 0, 10000000, 1/(n+1) - 1/(n+x0) ) ) * Gamma(x0)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 846: {
                mXparser.setEpsilonComparison();
                Function function = new Function("V(R,n) = if( n > 1, int( V( R/2, n-1 ), x, -R, R ), 1 )", new PrimitiveElement[0]);
                string = "V(1,1) + V(1,2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 3.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 847: {
                mXparser.setEpsilonComparison();
                Function function = new Function("uniSum(n, x) = if( x >= 1, n, uniSum(n+1, x + rUni(0,1) ) )", new PrimitiveElement[0]);
                string = "avg( i, 1, 100000, uniSum(0,0) ) - e";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 848: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("n = 100000", new PrimitiveElement[0]);
                string = "sqrt( 6 / (sum( i, 1, n, if( gcd( [Nat], [Nat] ) = 1, 1, 0) ) / n) ) - pi";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 849: {
                mXparser.setEpsilonComparison();
                string = "root( 3, 7 + sqrt(50) ) + root( 3, 7 - sqrt(50) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 850: {
                mXparser.setEpsilonComparison();
                string = "root( 3, 7 + root(2,50) ) + root( 3, 7 - root(2,50) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 851: {
                mXparser.setEpsilonComparison();
                string = "(7 + sqrt(50))^(1/3) + (7 - sqrt(50))^(1/3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 852: {
                mXparser.setEpsilonComparison();
                string = "(7 + 50^(1/2))^(1/3) + (7 - 50^(1/2))^(1/3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 853: {
                mXparser.setEpsilonComparison();
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                Function function = new Function("Nrec(a, s, k) = if( s >= a, k, Nrec( a, s + [Uni], k+1 ) )", new PrimitiveElement[0]);
                Argument argument = new Argument("N1 = Nrec(1,0,0)", function);
                Argument argument2 = new Argument("N2 = Nrec(2,0,0)", function);
                Argument argument3 = new Argument("N3 = Nrec(3,0,0)", function);
                Argument argument4 = new Argument("N4 = Nrec(4,0,0)", function);
                Argument argument5 = new Argument("N5 = Nrec(5,0,0)", function);
                Argument argument6 = new Argument("EN1 = avg( i, 1, 100000, N1 )", argument);
                Argument argument7 = new Argument("EN2 = avg( i, 1, 100000, N2 )", argument2);
                Argument argument8 = new Argument("EN3 = avg( i, 1, 100000, N3 )", argument3);
                Argument argument9 = new Argument("EN4 = avg( i, 1, 100000, N4 )", argument4);
                Argument argument10 = new Argument("EN5 = avg( i, 1, 100000, N5 )", argument5);
                string = "(EN1 - e) + (EN2 - (e^2 - e)) + (EN3 - (e^3 - 2*e^2 + e/2)) + (EN4 - (e^4 - 3*e^3 + 2*e^2 - e/6)) + (EN5 - (e^5 - 4*e^4 + 9/2 * e^3 - 4/3 * e^2 + e/24))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument6, argument7, argument8, argument9, argument10);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.1) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 854: {
                mXparser.setEpsilonComparison();
                string = "stdi(i, 1, 100000, X)";
                Function function = new Function("f(x) = pNor(x,2,4)", new PrimitiveElement[0]);
                Function function2 = new Function("RejectSampling(a,b,M,x) = if( rUni(0,M) <= f(x), x, RejectSampling(a,b,M, rUni(a,b) ) )", function);
                Argument argument = new Argument("X = RejectSampling( -22, 26, pNor(2,2,4) , rUni(-22, 26) )", function2);
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 4.0;
                if (MathFunctions.abs(d2 - d) <= 0.05) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 855: {
                mXparser.setEpsilonComparison();
                string = "sum(x, -3, 3, pNor(x, 0, 1) - f(x, 30), 0.1)";
                Function function = new Function("f(x,n) = if( (x*sqrt(n/12)+n/2) >= 0 , ( 1 / (n-1)! ) * sum(k, 0, floor((x*sqrt(n/12)+n/2)), (-1)^k * C(n,k) * (x*sqrt(n/12)+n/2-k)^(n-1) )*sqrt(n/12) ; 0)", new PrimitiveElement[0]);
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 856: {
                mXparser.setEpsilonComparison();
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                string = "sum(x, -20.05, 20.05, sin(x)/x - prod(k,1, 10000 , 1 - (x/(k*pi))^2 ) , 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 857: {
                mXparser.setEpsilonComparison();
                Function function = new Function("f(x,a,n) = (sqrt(pi)/2) * sum(k, 0, n, ( a^(1/2 - k) / ( Gamma(3/2 - k) * k! ) ) * (x-a)^k   )", new PrimitiveElement[0]);
                string = "sum(x, 1, 3, sqrt(x) - f(x,2,50) , 0.001)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 858: {
                mXparser.setEpsilonComparison();
                mXparser.setDegreesMode();
                string = "sin(90)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setRadiansMode();
                mXparser.setDefaultEpsilon();
                break;
            }
            case 859: {
                mXparser.setEpsilonComparison();
                mXparser.setDegreesMode();
                string = "asin(-1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -90.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setRadiansMode();
                mXparser.setDefaultEpsilon();
                break;
            }
            case 860: {
                mXparser.setEpsilonComparison();
                mXparser.setDegreesMode();
                string = "cos(90)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setRadiansMode();
                mXparser.setDefaultEpsilon();
                break;
            }
            case 861: {
                mXparser.setEpsilonComparison();
                mXparser.setDegreesMode();
                string = "acos(0)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 90.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setRadiansMode();
                mXparser.setDefaultEpsilon();
                break;
            }
            case 862: {
                mXparser.setEpsilonComparison();
                mXparser.setDegreesMode();
                string = "tan(-45)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setRadiansMode();
                mXparser.setDefaultEpsilon();
                break;
            }
            case 863: {
                mXparser.setEpsilonComparison();
                mXparser.setDegreesMode();
                string = "atan(1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 45.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setRadiansMode();
                mXparser.setDefaultEpsilon();
                break;
            }
            case 864: {
                mXparser.setEpsilonComparison();
                mXparser.setDegreesMode();
                string = "ctan(45)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setRadiansMode();
                mXparser.setDefaultEpsilon();
                break;
            }
            case 865: {
                mXparser.setEpsilonComparison();
                mXparser.setDegreesMode();
                string = "actan(1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 45.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setRadiansMode();
                mXparser.setDefaultEpsilon();
                break;
            }
            case 866: {
                mXparser.setEpsilonComparison();
                mXparser.setDegreesMode();
                string = "sec(60)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setRadiansMode();
                mXparser.setDefaultEpsilon();
                break;
            }
            case 867: {
                mXparser.setEpsilonComparison();
                mXparser.setDegreesMode();
                string = "arcsec(2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 60.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setRadiansMode();
                mXparser.setDefaultEpsilon();
                break;
            }
            case 868: {
                mXparser.setEpsilonComparison();
                mXparser.setDegreesMode();
                string = "csc(30)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setRadiansMode();
                mXparser.setDefaultEpsilon();
                break;
            }
            case 869: {
                mXparser.setEpsilonComparison();
                mXparser.setDegreesMode();
                string = "arccsc(2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 30.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setRadiansMode();
                mXparser.setDefaultEpsilon();
                break;
            }
            case 870: {
                mXparser.setEpsilonComparison();
                mXparser.setDegreesMode();
                string = "Sinc(90)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.011111111111111112;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setRadiansMode();
                mXparser.setDefaultEpsilon();
                break;
            }
            case 871: {
                mXparser.setEpsilonComparison();
                string = "gcd(3333333333333330.0,10000000000000000.0)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 10.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 872: {
                mXparser.setEpsilonComparison();
                string = "gcd(58333333333333, 100000000000000)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 873: {
                mXparser.setEpsilonComparison();
                string = "2.0+2.0/3.0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = new Expression(NumberTheory.toMixedFractionString(2.6666666666666665), new PrimitiveElement[0]).calculate();
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 874: {
                mXparser.setEpsilonComparison();
                string = "-2.0-2.0/3.0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = new Expression(NumberTheory.toMixedFractionString(-2.6666666666666665), new PrimitiveElement[0]).calculate();
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 875: {
                mXparser.setEpsilonComparison();
                string = "17.0/3.0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = new Expression(NumberTheory.toMixedFractionString(5.666666666666667), new PrimitiveElement[0]).calculate();
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 876: {
                mXparser.setEpsilonComparison();
                string = "-17.0/3.0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = new Expression(NumberTheory.toMixedFractionString(-5.666666666666667), new PrimitiveElement[0]).calculate();
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 877: {
                mXparser.setEpsilonComparison();
                string = "(1_2 - 1/2) + (-1_3 + 1/3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 878: {
                mXparser.setEpsilonComparison();
                string = "(11_3 - 11/3) + (-11_3 + 11/3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 879: {
                mXparser.setEpsilonComparison();
                string = "(123121_71 - 123121/71) + (-123121_71 + 123121/71)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 880: {
                mXparser.setEpsilonComparison();
                string = "( 1_1_2 - (1+1/2) ) + (-1_1_2 + (1+1/2) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 881: {
                mXparser.setEpsilonComparison();
                string = "( 110_5_2 - (110+5/2) ) + (-110_5_2 + (110+5/2) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 882: {
                mXparser.setEpsilonComparison();
                string = "( 1234_12345_123456 - (1234+12345/123456) ) + (-1234_12345_123456 + (1234+12345/123456) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 883: {
                mXparser.setEpsilonComparison();
                string = "0_0_1 - 0_0_2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 884: {
                mXparser.setEpsilonComparison();
                string = "0_1 - 0_234";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 885: {
                mXparser.setEpsilonComparison();
                string = "isNaN(0_0_0) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 886: {
                mXparser.setEpsilonComparison();
                string = "isNaN(1_2_0) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 887: {
                mXparser.setEpsilonComparison();
                string = "isNaN(1_0_0) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 888: {
                mXparser.setEpsilonComparison();
                string = "isNaN(0_2_0) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 889: {
                mXparser.setEpsilonComparison();
                string = "isNaN(1_0) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 890: {
                mXparser.setEpsilonComparison();
                string = "isNaN(0_0) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 891: {
                mXparser.setEpsilonComparison();
                string = "isNaN(100_0) - [true]";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 892: {
                mXparser.setEpsilonComparison();
                string = "2^0 - 2^^0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 893: {
                mXparser.setEpsilonComparison();
                string = "2^1 - 2^^1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 894: {
                mXparser.setEpsilonComparison();
                string = "2^2 - 2^^2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 895: {
                mXparser.setEpsilonComparison();
                string = "2^2^2 - 2^^3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 896: {
                mXparser.setEpsilonComparison();
                string = "2^2^2^2 - 2^^4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 897: {
                mXparser.setEpsilonComparison();
                string = "(e^(-e))^^100000000 - 1/e";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-4) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 898: {
                mXparser.setEpsilonComparison();
                string = "(e^(1/e))^^10000000 - e";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 899: {
                mXparser.setEpsilonComparison();
                string = "sqrt(2)^^100 - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 900: {
                mXparser.setEpsilonComparison();
                string = "( (-1)^^10 + 1 ) + ( (-1)^^0 - 1 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
            }
        }
        if (bl) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return bl;
    }

    private static boolean runTest_00901_01000(int n) {
        mXparser.consolePrint("[" + n + "] ");
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        String string = "";
        switch (n) {
            case 901: {
                mXparser.setEpsilonComparison();
                string = "0^^1234";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 902: {
                mXparser.setEpsilonComparison();
                string = "(-2)^^(2) - 1_4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 903: {
                mXparser.setEpsilonComparison();
                string = "sum( x, e^(-e), e^(1/e), LambW0( -ln(x) ) / (-ln(x) ) - solve(y - x^y, y, 1/e, e) , 0.001 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 904: {
                mXparser.setEpsilonComparison();
                string = "sum(x, -1/e + 0.1, 100, der( 0.5 * ( 1 + LambW0(x) )^2 , x, x) - LambW0(x)/x, 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-4) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 905: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.setEpsilonComparison();
                string = "sum(x, -1/e, 100, e^LambW0(x) - x / LambW0(x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 906: {
                mXparser.setEpsilonComparison();
                string = "sum(x, -1/e, -0.01, e^LambW1(x) - x / LambW1(x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-4) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 907: {
                mXparser.setEpsilonComparison();
                string = "int( LambW0(x), x, 0, e) - e + 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 908: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.setEpsilonComparison();
                string = "sum(x, -0.3, 0.3, LambW0(x) - sum(n, 1, 100, ( ( (-n)^(n-1) ) / n! ) * x^n ) , 0.001)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 909: {
                mXparser.setEpsilonComparison();
                string = "sum(x, 0, 200, LambW0(x * e^x) - x, 0.001)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 910: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.setEpsilonComparison();
                string = "sum(x, -1, 0, LambW0(x * e^x) - x, 0.001)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 911: {
                mXparser.setEpsilonComparison();
                string = "avg(x, -10, -1, abs(x - LambW1(x * e^x))/abs(x), 0.001)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.001) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 912: {
                mXparser.setEpsilonComparison();
                string = "sum(x, 0.01, 200, ln( LambW0(x) ) - ln(x) + LambW0(x), 0.001)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 913: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("n = 4", new PrimitiveElement[0]);
                string = "sum(x, 0.01, 200, LambW0( (n*x^n) / LambW0(x)^(n-1) ) - n*LambW0(x), 0.001)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 914: {
                mXparser.setEpsilonComparison();
                Argument argument = new Argument("x = rUni(0,100)", new PrimitiveElement[0]);
                Argument argument2 = new Argument("y = rUni(0,100)", new PrimitiveElement[0]);
                string = "LambW0(x) + LambW0(y) - LambW0( x*y*( 1/LambW0(x) + 1/LambW0(y) ) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument, argument2);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 915: {
                mXparser.setEpsilonComparison();
                string = "int( LambW0(2 * cot(x)^2) * sec(x)^2, x, 0.001182, pi-0.008 ) - 4*sqrt(pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.1) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 916: {
                mXparser.setEpsilonComparison();
                string = "int( LambW0( 1/x^2  ), x, 0.0000000804, 300 )/sqrt(2*pi)-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 917: {
                mXparser.setEpsilonComparison();
                string = "sum(x, 1/e, e, LambW0(-ln(x)/x) + ln(x), 0.001)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 918: {
                mXparser.setEpsilonComparison();
                string = "( LambW0(-1/e) + 1 ) + ( LambW0(0) - 0 ) + ( LambW0(1) - [Om] ) + ( LambW0(1) + ln( LambW0(1) )  ) + ( LambW0(e) - 1 ) + ( LambW0(-ln(sqrt(2))) + 2*ln(sqrt(2)) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 919: {
                mXparser.setEpsilonComparison();
                string = "LambW1(-1/e) + 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 920: {
                mXparser.setEpsilonComparison();
                string = "der( LambW0(x), x, 0) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 921: {
                mXparser.setEpsilonComparison();
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                string = "int( LambW0(x)/( x*sqrt(x) ), x, 0.01 , 240000) - 2*sqrt(2*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 922: {
                mXparser.setEpsilonComparison();
                string = "sum(x, 0.001, 6, x^x - ( e^LambW0( ln(x^x) ) )^( e^LambW0( ln(x^x) ) ), 0.001)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 923: {
                mXparser.setEpsilonComparison();
                string = "( isNaN( LambW0(-10) ) - [true] ) + ( isNaN( LambW1(-10) ) - [true] ) + ( isNaN( LambW1(10) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 924: {
                mXparser.setEpsilonComparison();
                string = "( isNaN( 2^^[NaN] ) - [true] ) + ( isNaN( [NaN]^^2 ) - [true] ) + ( isNaN( 2^^(-1) ) - [true] ) + ( isNaN( 0^^0 ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 925: {
                mXparser.setEpsilonComparison();
                string = "sum(x, 1, 10, sgnGamma(x)) + sum(x, 0.5, 9.5, sgnGamma(x)) - 20";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 926: {
                mXparser.setEpsilonComparison();
                string = "sum(x, -99, 0, isNaN( sgnGamma(x) ) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 927: {
                mXparser.setEpsilonComparison();
                string = "sum(x, -98.5, -0.5, sgnGamma(x), 2) + 50 + sum(x, -99.5, -1.5, sgnGamma(x), 2) - 50";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 928: {
                mXparser.setEpsilonComparison();
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                string = "sum(x, 0.5, 50, logGamma(x) - ( -[gam]*x - ln(x) + sum(k, 1, 10000+x^3, x/k - ln(1 + x/k) ) ), 0.5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 929: {
                mXparser.setEpsilonComparison();
                string = "sum(x, -99, 0, isNaN( logGamma(x) ) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 930: {
                mXparser.setEpsilonComparison();
                string = "sum(s, -50.5, -50.5, sum(x, 0.5, 50.5, GammaL(s,x) + GammaU(s,x) - Gamma(s) ) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setDefaultEpsilon();
                break;
            }
            case 931: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 1, Gamma(x), 0.001) - 2114.212208108448 ) / 2114.212208108448";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-15) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 932: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableUlpRounding();
                string = "( sum(x, 1.1, 2, Gamma(x), 0.001) - 826.2989620272716 ) / 826.2989620272716";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 933: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableUlpRounding();
                string = "( sum(x, 2.1, 3, Gamma(x), 0.001) - 1284.551346724549 ) / 1284.551346724549";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 934: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 3.1, 4, Gamma(x), 0.001) - 3338.776475304076 ) / 3338.776475304076";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 935: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 4.1, 5, Gamma(x), 0.001) - 12102.99996568467 ) / 12102.99996568467";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 936: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 5.1, 6, Gamma(x), 0.001) - 56192.71972868672 ) / 56192.71972868672";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 937: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 6.1, 7, Gamma(x), 0.001) - 317850.3398689155 ) / 317850.3398689155";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 938: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 7.1, 8, Gamma(x), 0.001) - 2119192.458453365 ) / 2119192.458453365";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 939: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 8.1, 9, Gamma(x), 0.001) - 1.626741828826147E7 ) / 1.626741828826147E7";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 940: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 9.1, 10, Gamma(x), 0.001) - 1.412638999378844E8 ) / 1.412638999378844E8";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 941: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 10.1, 20, Gamma(x), 0.1) - 4.758039372588876E17 ) / 4.758039372588876E17";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 942: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 20.1, 100, Gamma(x), 0.1) - 2.532008062312612E156 ) / 2.532008062312612E156";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 943: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -0.9, -0.1, Gamma(x), 0.001) - (-4033.861662372823) ) / (-4033.861662372823)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-15) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 944: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -1.9, -1.1, Gamma(x), 0.001) - 2779.242455572773 ) / 2779.242455572773";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 945: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -2.9, -2.1, Gamma(x), 0.001) - (-1146.484828532192) ) / (-1146.484828532192)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 946: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -3.9, -3.1, Gamma(x), 0.001) - 336.6702016774144 ) / 336.6702016774144";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 947: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -4.9, -4.1, Gamma(x), 0.001) - (-76.66832811614711) ) / (-76.66832811614711)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 948: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -5.9, -5.1, Gamma(x), 0.001) - 14.25043511683485 ) / 14.25043511683485";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 949: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -6.9, -6.1, Gamma(x), 0.001) - (-2.236810549400713) ) / (-2.236810549400713)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 950: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -7.9, -7.1, Gamma(x), 0.001) - 0.3037861166613209 ) / 0.3037861166613209";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 951: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -8.9, -8.1, Gamma(x), 0.001) - (-0.03635359758623678) ) / (-0.03635359758623678)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 952: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -9.9, -9.1, Gamma(x), 0.001) - 0.003887845100640342 ) / 0.003887845100640342";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 953: {
                mXparser.disableUlpRounding();
                mXparser.disableAlmostIntRounding();
                string = "( sum(x, -30.95, -10.05, Gamma(x), 0.1) - (-8.376548071082549E-6) ) / (-8.376548071082549E-6)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                break;
            }
            case 954: {
                mXparser.disableUlpRounding();
                string = "sum(x, -90.95, 100.05, abs(ln(abs(Gamma(x))) - logGamma(x)), 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 955: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 0.1, 1, GammaU(s, x), 0.001), 0.1) - 6870.775811214982 ) / 6870.775811214982";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 956: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 1.1, 2, GammaU(s, x), 0.001), 0.1) - 9785.880306439629 ) / 9785.880306439629";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 957: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 2.1, 3, GammaU(s, x), 0.001), 0.1) - 21205.70354995280 ) / 21205.70354995280";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 958: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 3.1, 4, GammaU(s, x), 0.001), 0.1) - 62496.08447233523 ) / 62496.08447233523";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 959: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 4.1, 5, GammaU(s, x), 0.001), 0.1) - 237127.0905587526 ) / 237127.0905587526";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 960: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 5.1, 6, GammaU(s, x), 0.1), 0.1) - 12659.04924160019 ) / 12659.04924160019";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 961: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 6.1, 7, GammaU(s, x), 0.1), 0.1) - 72192.46327984912 ) / 72192.46327984912";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-8) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 962: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 7.1, 8, GammaU(s, x), 0.1), 0.1) - 483608.0262675140 ) / 483608.0262675140";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-5) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 963: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -0.9, -0.1, GammaU(s, x), 0.001), 0.1) - 8224.880733100714 ) / 8224.880733100714";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 964: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -1.9, -1.1, GammaU(s, x), 0.001), 0.1) - 23629.12458493255 ) / 23629.12458493255";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 965: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -2.9, -2.1, GammaU(s, x), 0.001), 0.1) - 117364.35585450924 ) / 117364.35585450924";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 966: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -3.9, -3.1, GammaU(s, x), 0.001), 0.1) - 771195.4772567508 ) / 771195.4772567508";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 967: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -4.9, -4.1, GammaU(s, x), 0.001), 0.1) - 5800247.185711337 ) / 5800247.185711337";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 968: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -5.9, -5.1, GammaU(s, x), 0.001), 0.1) - 4.685905102859140E7 ) / 4.685905102859140E7";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 969: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -6.9, -6.1, GammaU(s, x), 0.001), 0.1) - 3.949477860591464E8 ) / 3.949477860591464E8";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 970: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -7.9, -7.1, GammaU(s, x), 0.001), 0.1) - 3.421898375421077E9 ) / 3.421898375421077E9";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 971: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 0.1, 1, GammaL(s, x), 0.001), 0.1) - 35413.46835095401 ) / 35413.46835095401";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-15) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 972: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 1.1, 2, GammaL(s, x), 0.001), 0.1) - 6740.098934105806 ) / 6740.098934105806";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 973: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 2.1, 3, GammaL(s, x), 0.001), 0.1) - 4485.323384538212 ) / 4485.323384538212";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 974: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 3.1, 4, GammaL(s, x), 0.001), 0.1) - 4279.445033746266 ) / 4279.445033746266";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 975: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 4.1, 5, GammaL(s, x), 0.001), 0.1) - 4932.908754940856 ) / 4932.908754940856";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 976: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 5.1, 6, GammaL(s, x), 0.1), 0.1) - 71.00936681198708 ) / 71.00936681198708";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 977: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 6.1, 7, GammaL(s, x), 0.1), 0.1) - 99.53718099344381 ) / 99.53718099344381";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 978: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 7.1, 8, GammaL(s, x), 0.1), 0.1) - 147.6273237932475 ) / 147.6273237932475";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 979: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -0.9, -0.1, GammaL(s, x), 0.001), 0.1) - (-88902.11398055719) ) / (-88902.11398055719)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-15) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 980: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -1.9, -1.1, GammaL(s, x), 0.001), 0.1) - 31955.72452652288 ) / 31955.72452652288";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 981: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -2.9, -2.1, GammaL(s, x), 0.001), 0.1) - (-140294.05242515303) ) / (-140294.05242515303)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 982: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -3.9, -3.1, GammaL(s, x), 0.001), 0.1) - (-764462.0732232045) ) / (-764462.0732232045)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 983: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -4.9, -4.1, GammaL(s, x), 0.001), 0.1) - (-5.801780552273669E6) ) / (-5.801780552273669E6)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 984: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -5.9, -5.1, GammaL(s, x), 0.001), 0.1) - (-4.685876601988902E7) ) / (-4.685876601988902E7)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 985: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -6.9, -6.1, GammaL(s, x), 0.001), 0.1) - (-3.949478307953569E8) ) / (-3.949478307953569E8)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 986: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -7.9, -7.1, GammaL(s, x), 0.001), 0.1) - (-3.421898369345358E9) ) / (-3.421898369345358E9)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 987: {
                mXparser.disableUlpRounding();
                string = "sum(x, -2.95, 2.95, GammaU(0,x) - ( -Ei(-x) ), 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-16) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 988: {
                mXparser.disableUlpRounding();
                string = "sum(s, -2.95, 2.95, GammaL(s,0), 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-16) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 989: {
                mXparser.disableUlpRounding();
                string = "sum(s, -2.95, 2.95, GammaU(s,0) - Gamma(s), 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-16) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 990: {
                mXparser.disableUlpRounding();
                string = "sum(s, 1, 5, sum(x, 0.5, 3.5, GammaU(s, x) - ((s-1)!) * e^(-x) * sum(k, 0, s-1, x^k / k! ) , 0.01) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 991: {
                mXparser.disableUlpRounding();
                string = "sum(x, -5, 5, GammaU(1,x) - e^(-x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 992: {
                mXparser.disableUlpRounding();
                string = "sum(x, -5, 5, GammaL(1,x) - ( 1 - e^(-x) ), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 993: {
                mXparser.disableUlpRounding();
                string = "sum(x, 0.1, 8, GammaU(0.5, x) - sqrt(pi) * erfc( sqrt(x) ), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 994: {
                mXparser.disableUlpRounding();
                string = "sum(x, 0.1, 8, GammaL(0.5, x) - sqrt(pi) * erf( sqrt(x) ), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 995: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 0.1, 1, GammaRegU(s, x), 0.001), 0.1) - 4128.619249122392 ) / 4128.619249122392";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 996: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 1.1, 2, GammaRegU(s, x), 0.001), 0.1) - 10648.33231753313 ) / 10648.33231753313";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 997: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 2.1, 3, GammaRegU(s, x), 0.001), 0.1) - 14732.67120032403 ) / 14732.67120032403";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 998: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 3.1, 4, GammaRegU(s, x), 0.001), 0.1) - 16769.95611832584 ) / 16769.95611832584";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 999: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 4.1, 5, GammaRegU(s, x), 0.001), 0.1) - 17609.29585783721 ) / 17609.29585783721";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1000: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 5.1, 6, GammaRegU(s, x), 0.1), 0.1) - 198.6732618854221 ) / 198.6732618854221";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
            }
        }
        if (bl) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return bl;
    }

    private static boolean runTest_01001_01100(int n) {
        mXparser.consolePrint("[" + n + "] ");
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        String string = "";
        switch (n) {
            case 1001: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 6.1, 7, GammaRegU(s, x), 0.1), 0.1) - 199.6608252491266 ) / 199.6608252491266";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-8) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1002: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 7.1, 8, GammaRegU(s, x), 0.1), 0.1) - 199.9222940005033 ) / 199.9222940005033";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-6) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1003: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -0.9, -0.1, GammaRegU(s, x), 0.001), 0.1) - (-1776.380588210588) ) / (-1776.380588210588)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1004: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -1.9, -1.1, GammaRegU(s, x), 0.001), 0.1) - 7890.923829786565 ) / 7890.923829786565";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1005: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -2.9, -2.1, GammaRegU(s, x), 0.001), 0.1) - (-102249.9066253191) ) / (-102249.9066253191)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1006: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -3.9, -3.1, GammaRegU(s, x), 0.001), 0.1) - 2.440576583013389E6 ) / 2.440576583013389E6";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1007: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -4.9, -4.1, GammaRegU(s, x), 0.001), 0.1) - (-8.522034351730967E7) ) / (-8.522034351730967E7)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1008: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -5.9, -5.1, GammaRegU(s, x), 0.001), 0.1) - 3.889240488572830E9 ) / 3.889240488572830E9";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1009: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -6.9, -6.1, GammaRegU(s, x), 0.001), 0.1) - (-2.181166295073751E11) ) / (-2.181166295073751E11)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1010: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -7.9, -7.1, GammaRegU(s, x), 0.001), 0.1) - 1.447213822212101E13 ) / 1.447213822212101E13";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1011: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 0.1, 1, GammaRegL(s, x), 0.001), 0.1) - 13891.38075087760 ) / 13891.38075087760";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-15) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1012: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 1.1, 2, GammaRegL(s, x), 0.001), 0.1) - 7371.667682466868 ) / 7371.667682466868";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1013: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 2.1, 3, GammaRegL(s, x), 0.001), 0.1) - 3287.328799675970 ) / 3287.328799675970";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1014: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 3.1, 4, GammaRegL(s, x), 0.001), 0.1) - 1250.043881674157 ) / 1250.043881674157";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1015: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 4.1, 5, GammaRegL(s, x), 0.001), 0.1) - 410.7041421627869 ) / 410.7041421627869";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1016: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 5.1, 6, GammaRegL(s, x), 0.1), 0.1) - 1.326738114577891 ) / 1.326738114577891";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1017: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 6.1, 7, GammaRegL(s, x), 0.1), 0.1) - 0.3391747508734272 ) / 0.3391747508734272";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1018: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, 7.1, 8, GammaRegL(s, x), 0.1), 0.1) - 0.07770599949669701 ) / 0.07770599949669701";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1019: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -0.9, -0.1, GammaRegL(s, x), 0.001), 0.1) - 17796.38058821059 ) / 17796.38058821059";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-15) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1020: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -1.9, -1.1, GammaRegL(s, x), 0.001), 0.1) - 8129.076170213447 ) / 8129.076170213447";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1021: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -2.9, -2.1, GammaRegL(s, x), 0.001), 0.1) - 118269.9066253191 ) / 118269.9066253191";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1022: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -3.9, -3.1, GammaRegL(s, x), 0.001), 0.1) - (-2.424556583013388E6) ) / (-2.424556583013388E6)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1023: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -4.9, -4.1, GammaRegL(s, x), 0.001), 0.1) - 8.523636351730967E7 ) / 8.523636351730967E7";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1024: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -5.9, -5.1, GammaRegL(s, x), 0.001), 0.1) - (-3.889224468572830E9) ) / (-3.889224468572830E9)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1025: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -6.9, -6.1, GammaRegL(s, x), 0.001), 0.1) - 2.181166455273751E11 ) / 2.181166455273751E11";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1026: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.1, 2, sum(s, -7.9, -7.1, GammaRegL(s, x), 0.001), 0.1) - (-1.447213820610101E13) ) / (-1.447213820610101E13)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1027: {
                mXparser.disableUlpRounding();
                string = "sum(x, -2.95, 2.95, GammaRegU(0,x) - ( -Ei(-x) )/[gam], 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-15) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1028: {
                mXparser.disableUlpRounding();
                string = "sum(s, -2.95, 2.95, GammaRegL(s,0), 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-15) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1029: {
                mXparser.disableUlpRounding();
                string = "sum(s, -2.95, 2.95, GammaRegU(s,0) - 1, 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-15) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1030: {
                mXparser.disableUlpRounding();
                string = "sum(s, 1, 5, sum(x, 0.5, 3.5, GammaRegU(s, x) - ((s-1)!) * e^(-x) * sum(k, 0, s-1, x^k / k! ) / Gamma(s) , 0.01) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1031: {
                mXparser.disableUlpRounding();
                string = "sum(x, -5, 5, GammaRegU(1,x) - e^(-x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1032: {
                mXparser.disableUlpRounding();
                string = "sum(x, -5, 5, GammaRegL(1,x) - ( 1 - e^(-x) ), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-11) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1033: {
                mXparser.disableUlpRounding();
                string = "sum(x, 0.1, 8, GammaRegU(0.5, x) - erfc( sqrt(x) ), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1034: {
                mXparser.disableUlpRounding();
                string = "sum(x, 0.1, 8, GammaRegL(0.5, x) - erf( sqrt(x) ), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1035: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.01, 0.5, diGamma(x), 0.001) - (-4079.209360654330) ) / (-4079.209360654330)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-15) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1036: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 0.5, 1, diGamma(x), 0.001) - (-573.6355799257133) ) / (-573.6355799257133)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1037: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 1, 2, diGamma(x), 0.001) - (-0.07729899822650133) ) / (-0.07729899822650133)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-9) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1038: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 2, 3, diGamma(x), 0.001) - 693.8199440617115 ) / 693.8199440617115";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1039: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 3, 4, diGamma(x), 0.001) - 1099.701730410615 ) / 1099.701730410615";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1040: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 4, 5, diGamma(x), 0.001) - 1387.675473579989 ) / 1387.675473579989";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1041: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 5, 6, diGamma(x), 0.001) - 1611.044026769199 ) / 1611.044026769199";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1042: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 6, 7, diGamma(x), 0.001) - 1793.548917915007 ) / 1793.548917915007";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1043: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 7, 8, diGamma(x), 0.001) - 1947.854360261161 ) / 1947.854360261161";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1044: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 8, 9, diGamma(x), 0.001) - 2081.519681855709 ) / 2081.519681855709";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1045: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 9, 10, diGamma(x), 0.001) - 2199.420773340920 ) / 2199.420773340920";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1046: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 10, 100, diGamma(x), 0.01) - 34636.66366690680 ) / 34636.66366690680";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1047: {
                mXparser.disableUlpRounding();
                string = "( sum(x, 100, 1000, diGamma(x), 0.1) - 55466.61581150640 ) / 55466.61581150640";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1048: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -0.99, -0.01, diGamma(x), 0.001) - 1.422412463589325 ) / 1.422412463589325";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1049: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -1.99, -1.01, diGamma(x), 0.001) - 680.3530867812680 ) / 680.3530867812680";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1050: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -2.99, -2.01, diGamma(x), 0.001) - 1077.907743717255 ) / 1077.907743717255";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1051: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -3.99, -3.01, diGamma(x), 0.001) - 1360.050326061623 ) / 1360.050326061623";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1052: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -4.99, -4.01, diGamma(x), 0.001) - 1578.919885022366 ) / 1578.919885022366";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1053: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -5.99, -5.01, diGamma(x), 0.001) - 1757.758655903731 ) / 1757.758655903731";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1054: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -6.99, -6.01, diGamma(x), 0.001) - 1908.969189637675 ) / 1908.969189637675";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1055: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -7.99, -7.01, diGamma(x), 0.001) - 2039.956153658795 ) / 2039.956153658795";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1056: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -8.99, -8.01, diGamma(x), 0.001) - 2155.496280654945 ) / 2155.496280654945";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1057: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -9.99, -9.01, diGamma(x), 0.001) - 2258.851345832401 ) / 2258.851345832401";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1058: {
                mXparser.disableUlpRounding();
                string = "( sum(x, -10.99, -10.01, diGamma(x), 0.001) - 2352.347967017835 ) / 2352.347967017835";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-10) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1059: {
                mXparser.disableUlpRounding();
                string = "sum(x0, 0.1, 2, diGamma(x0) - der( Gamma(x), x, x0) / Gamma(x0), 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-7) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1060: {
                mXparser.disableUlpRounding();
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                string = "sum(x, 0.01, 0.99, diGamma(1-x)-diGamma(x) - pi * cot(pi*x), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.setCanonicalRounding(tmp);
                mXparser.enableUlpRounding();
                break;
            }
            case 1061: {
                mXparser.disableUlpRounding();
                string = "sum(x, 0.01, 0.99, diGamma(x+1)-diGamma(x) - 1/x, 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1062: {
                mXparser.disableUlpRounding();
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                string = "sum(x, 0.01, 0.99, diGamma(x+1) - ( -[gam] + sum(k, 1, 10000, 1/k - 1/(x+k) ) ), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 0.01) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1063: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableUlpRounding();
                string = "sum(x, 0.01, 0.99, sum(N, 1, 10, diGamma(x+N) - diGamma(x) - sum(k, 0, N-1, 1/(x+k)) ), 0.01)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1064: {
                mXparser.disableUlpRounding();
                string = "sum(m, 3, 20, sum(r, 1, m-1, diGamma(r/m) - ( -[gam] - ln(2*m) - (pi/2)*cot( r * pi/m ) + 2 * sum(n, 1, floor( (m-1)/2 ), cos(2*pi*n*r / m) * ln( sin(pi*n / m) ) ) ) ) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-12) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1065: {
                string = "sum(n, 1, 10, 1) - 10";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1066: {
                string = "sum(n, 10, 1, 1) - 10";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1067: {
                string = "sum(n, 10, 10, 1) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1068: {
                string = "prod(n, 1, 10, 2) - 2^10";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1069: {
                string = "prod(n, 10, 1, 2) - 2^10";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1070: {
                string = "prod(n, 10, 10, 2) - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1071: {
                string = "avg(n, 1, 10, n) - 5.5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1072: {
                string = "avg(n, 10, 1, n) - 5.5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1073: {
                string = "avg(n, 10, 10, 1) - 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1074: {
                Function function = new Function("f(x) = par(0) + par(1) + par(-1) + [npar]", new PrimitiveElement[0]);
                string = "f(1) - (1 + 1 + 1 + 1) + f(2) - (1 + 2 + 2 + 1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1075: {
                Function function = new Function("f(x, y) = par(0) + par(1) + par(2) + par(-1) + par(-2) + [npar]", new PrimitiveElement[0]);
                string = "f(1, 2) - (2 + 1 + 2 + 2 + 1 + 2) + f(-2,-1) - (2 + (-2) + (-1) + (-1) + (-2) + 2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1076: {
                Function function = new Function("f(x1, x2, x3, x4, x5) = prod(i, 1, [npar], par(i) )", new PrimitiveElement[0]);
                string = "f(1,2,3,4,5) - 5!";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1077: {
                Function function = new Function("f(x1, x2, x3, x4, x5) = prod(i, 1, [npar], par(-i) )", new PrimitiveElement[0]);
                string = "f(1,2,3,4,5) - 5!";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1078: {
                Function function = new Function("f(x1, x2, x3, x4, x5) = prod(i, -1, -[npar], par(i) )", new PrimitiveElement[0]);
                string = "f(1,2,3,4,5) - 5!";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1079: {
                Function function = new Function("f(...) = maxi(i, 1, [npar], par(i) )", new PrimitiveElement[0]);
                string = "( f(1) - 1 ) + ( f(-1) + 1 ) + ( f(1,2,3,4,5) - 5 ) + ( f(1,2,6,10,4,5) - 10 ) + ( f(20, 1,2,3,4,5) - 20 )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1080: {
                Function function = new Function("f(...) = sum(i, 1, par(0), sum(k, 1, [npar], par(i) + par(k)) )", new PrimitiveElement[0]);
                string = "(f(1)-2)+(f(1,2)-12)+(f(1,2,3)-36)+(f(1,2,3,4)-80)+(f(1,2,3,4,5)-150)+(f(1,2,3,4,5,6)-252)+(f(1,2,3,4,5,6,7)-392)+(f(1,2,3,4,5,6,7,8)-576)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1081: {
                Function function = new Function("f(...) = iff( [npar]>5, f(par(1),par(2),par(3),par(4),par(5)); [npar]=5, par(5)*f(par(1),par(2),par(3),par(4)); [npar]=4, par(4)*f(par(1),par(2),par(3)); [npar]=3, par(3)*f(par(1),par(2)); [npar]=2, par(2)*f(par(1)); [npar]=1, par(1) )", new PrimitiveElement[0]);
                string = "f(1,2,3,4,5) - 1*2*3*4*5 + f(1,2,3,4,5,6) - 1*2*3*4*5 + f(1,2,3) - 1*2*3 + f(5,4,3,2,1) - 5*4*3*2*1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1082: {
                Function function = new Function("sumv(...) = sum( i, 1, [npar], par(i) )", new PrimitiveElement[0]);
                string = "( sumv(1) - add(1) ) + ( sumv(1,2) - add(1,2) ) + ( sumv(1,2,3) - add(1,2,3) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1083: {
                Function function = new Function("multiv(...) = prod( i, 1, [npar], par(i) )", new PrimitiveElement[0]);
                string = "( multiv(1) - multi(1) ) + ( multiv(1,2) - multi(1,2) ) + ( multiv(1,2,3) - multi(1,2,3) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1084: {
                Function function = new Function("meanv(...) = avg( i, 1, [npar], par(i) )", new PrimitiveElement[0]);
                string = "( meanv(1) - mean(1) ) + ( meanv(1,2) - mean(1,2) ) + ( meanv(1,2,3) - mean(1,2,3) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1085: {
                Function function = new Function("varv(...) = vari( i, 1, [npar], par(i) )", new PrimitiveElement[0]);
                string = "( varv(1) - var(1) ) + ( varv(1,2) - var(1,2) ) + ( varv(1,2,3) - var(1,2,3) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1086: {
                Function function = new Function("stdv(...) = stdi( i, 1, [npar], par(i) )", new PrimitiveElement[0]);
                string = "( stdv(1) - std(1) ) + ( stdv(1,2) - std(1,2) ) + ( stdv(1,2,3) - std(1,2,3) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1087: {
                Function function = new Function("minv(...) = mini( i, 1, [npar], par(i) )", new PrimitiveElement[0]);
                string = "( minv(1) - min(1) ) + ( minv(1,2) - min(1,2) ) + ( minv(1,2,3) - min(1,2,3) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1088: {
                Function function = new Function("maxv(...) = maxi( i, 1, [npar], par(i) )", new PrimitiveElement[0]);
                string = "( maxv(1) - max(1) ) + ( maxv(1,2) - max(1,2) ) + ( maxv(1,2,3) - max(1,2,3) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1089: {
                FunExtVar funExtVar = new FunExtVar();
                Function function = new Function("fx", funExtVar);
                string = "( fx(1) - add(1) ) + ( fx(1,2) - add(1,2) ) + ( fx(1,2,3) - add(1,2,3) ) + ( fx(1,2,3,4) - add(1,2,3,4) ) +  ( fx(1,2,3,4,5) - add(1,2,3,4,5) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, function);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1090: {
                mXparser.disableUlpRounding();
                mXparser.disableAlmostIntRounding();
                string = "1 + 1e-14";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.00000000000001;
                if (MathFunctions.abs(d2 - d) <= 1.0E-50) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1091: {
                mXparser.disableUlpRounding();
                mXparser.disableAlmostIntRounding();
                string = "-1 - 1e-14";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1.00000000000001;
                if (MathFunctions.abs(d2 - d) <= 1.0E-50) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1092: {
                mXparser.disableUlpRounding();
                mXparser.enableAlmostIntRounding();
                string = "1 + 1e-14";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-50) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1093: {
                mXparser.disableUlpRounding();
                mXparser.enableAlmostIntRounding();
                string = "-1 - 1e-14";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-50) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                break;
            }
            case 1094: {
                string = "sum(n, -10, 10, sum(k, 0, abs(n), C(n,k) ) ) - sum(n, -10, 10, sum(k, 0, abs(n), nCk(n,k) ) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-50) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1095: {
                string = "sum(n, -10, 10, sum(k, 0, abs(n), nPk(n,k) ) ) - sum(n, -10, 10, sum(k, 0, abs(n), nCk(n,k) * k! ) )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-50) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1096: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 0.1, 10, sum(x, 0.1, 1, Beta(x,y), 0.01) , 0.01) - 156045.8382688423 ) / 156045.8382688423";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1097: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 0.1, 10, sum(x, 1, 2, Beta(x,y), 0.01) , 0.01) - 32015.62331640863 ) / 32015.62331640863";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1098: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 0.1, 10, sum(x, 2, 3, Beta(x,y), 0.01) , 0.01) - 20432.57249276379 ) / 20432.57249276379";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1099: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 0.1, 10, sum(x, 3, 4, Beta(x,y), 0.01) , 0.01) - 16648.09228879020 ) / 16648.09228879020";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1100: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 0.1, 10, sum(x, 4, 5, Beta(x,y), 0.01) , 0.01) - 14709.95317941022 ) / 14709.95317941022";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
            }
        }
        if (bl) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return bl;
    }

    private static boolean runTest_01101_01200(int n) {
        mXparser.consolePrint("[" + n + "] ");
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        String string = "";
        switch (n) {
            case 1101: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 0.1, 10, sum(x, 5, 6, Beta(x,y), 0.01) , 0.01) - 13491.02099096915 ) / 13491.02099096915";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1102: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 0.1, 10, sum(x, 6, 7, Beta(x,y), 0.01) , 0.01) - 12632.76303747905 ) / 12632.76303747905";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1103: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 0.1, 10, sum(x, 7, 8, Beta(x,y), 0.01) , 0.01) - 11984.64820297520 ) / 11984.64820297520";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1104: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 0.1, 10, sum(x, 8, 9, Beta(x,y), 0.01) , 0.01) - 11471.56326266911 ) / 11471.56326266911";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1105: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 0.1, 10, sum(x, 9, 10, Beta(x,y), 0.01) , 0.01) - 11051.38593753202 ) / 11051.38593753202";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1106: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 10, 100, sum(x, 10, 100, Beta(x,y), 0.1) , 0.1) - 0.0002504318934669270 ) / 0.0002504318934669270";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1107: {
                string = "( isNaN( Beta(-1, 10 ) ) - [true] ) + ( isNaN( Beta(10, -1 ) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1108: {
                string = "( isNaN( Beta(0, 10 ) ) - [true] ) + ( isNaN( Beta(10, 0 ) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1109: {
                string = "( isNaN( Beta([NaN], 10 ) ) - [true] ) + ( isNaN( Beta(10, [NaN] ) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1110: {
                string = "sum(x, 1, 10,  sum(y, 1, 10, der( Beta(x, y), x, x) - Beta(x,y) * ( diGamma(x) - diGamma(x+y) ) , 0.1), 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-4) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1111: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 0.1, 10, sum(x, 0.1, 10, logBeta(x,y), 0.1) , 0.1) - (-52463.38489346371) ) / (-52463.38489346371)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1112: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 10, 30, sum(x, 10, 30, logBeta(x,y), 0.1) , 0.1) - (-1.092606400417545E6) ) / (-1.092606400417545E6)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1113: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 30, 60, sum(x, 30, 60, logBeta(x,y), 0.1) , 0.1) - (-5.631010749308205E6) ) / (-5.631010749308205E6)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1114: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(y, 60, 100, sum(x, 60, 100, logBeta(x,y), 0.1) , 0.1) - (-1.784485348348011E7) ) / (-1.784485348348011E7)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1115: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(b, 0.1, 1, sum(a, 0.1, 1, sum(x, 0, 1, BetaInc(x, a, b) ,0.1) , 0.01) , 0.01) - 196515.9203818563 ) / 196515.9203818563";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1116: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(b, 1, 2, sum(a, 1, 2, sum(x, 0, 1, BetaInc(x, a, b) ,0.1) , 0.01) , 0.01) - 24722.41740481695 ) / 24722.41740481695";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1117: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(b, 2, 3, sum(a, 2, 3, sum(x, 0, 1, BetaInc(x, a, b) ,0.1) , 0.01) , 0.01) - 4464.859252111892 ) / 4464.859252111892";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1118: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(b, 3, 4, sum(a, 3, 4, sum(x, 0, 1, BetaInc(x, a, b) ,0.1) , 0.01) , 0.01) - 918.5527313884891 ) / 918.5527313884891";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1119: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(b, 4, 5, sum(a, 4, 5, sum(x, 0, 1, BetaInc(x, a, b) ,0.1) , 0.01) , 0.01) - 199.6846597371872 ) / 199.6846597371872";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1120: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(b, 5, 6, sum(a, 5, 6, sum(x, 0, 1, BetaInc(x, a, b) ,0.1) , 0.01) , 0.01) - 44.76264323950131 ) / 44.76264323950131";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1121: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(b, 6, 7, sum(a, 6, 7, sum(x, 0, 1, BetaInc(x, a, b) ,0.1) , 0.01) , 0.01) - 10.23292155881704 ) / 10.23292155881704";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1122: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(b, 7, 8, sum(a, 7, 8, sum(x, 0, 1, BetaInc(x, a, b) ,0.1) , 0.01) , 0.01) - 2.371353239618641 ) / 2.371353239618641";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1123: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(b, 8, 9, sum(a, 8, 9, sum(x, 0, 1, BetaInc(x, a, b) ,0.1) , 0.01) , 0.01) - 0.5550610613543622 ) / 0.5550610613543622";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1124: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(b, 9, 10, sum(a, 9, 10, sum(x, 0, 1, BetaInc(x, a, b) ,0.1) , 0.01) , 0.01) - 0.1309235541230968 ) / 0.1309235541230968";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1125: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( sum(b, 10, 80, sum(a, 10, 80, sum(x, 0, 1, BetaInc(x, a, b) ,0.1) , 0.25) , 0.25) - 0.0002449250611436628 ) / 0.0002449250611436628";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1126: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                string = "sum(b, 1, 10, sum(a, 1, 10, sum(x, 0.1, 0.9, der( BetaInc(x, a, b), x, x ) - ( (1-x)^(b-1) ) * ( x^(a-1) ) ,0.1) , 0.1) , 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-4) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1127: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "sum(b, 0.1, 10, sum(a, 0.1, 10, BetaInc(1, a, b) - Beta(a,b) , 0.1) , 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1128: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "sum(b, 0.1, 10, sum(a, 0.1, 10, BetaInc(0, a, b) , 0.1) , 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1129: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( isNaN( BetaInc(-1,1,1) ) - [true] ) + ( isNaN( BetaInc(2,1,1) ) - [true] ) + ( isNaN( BetaInc( [NaN] ,1,1) ) - [true] ) + ( isNaN( BetaInc(0.5, [NaN], 1) ) - [true] ) + ( isNaN( BetaInc(0.5, 1 , [NaN]) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1130: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( isNaN( BetaInc(0.5,-1,1) ) - [true] ) + ( isNaN( BetaInc(0.5,1,-1) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1131: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "sum(b, 0.1, 10, sum(a, 0.1, 10, BetaI(1, a, b) - 1 , 0.1) , 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1132: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "sum(b, 0.1, 10, sum(a, 0.1, 10, BetaI(0, a, b) , 0.1) , 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1133: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( isNaN( BetaI(-1,1,1) ) - [true] ) + ( isNaN( BetaI(2,1,1) ) - [true] ) + ( isNaN( BetaI( [NaN] ,1,1) ) - [true] ) + ( isNaN( BetaI(0.5, [NaN], 1) ) - [true] ) + ( isNaN( BetaI(0.5, 1 , [NaN]) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1134: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                string = "( isNaN( BetaI(0.5,-1,1) ) - [true] ) + ( isNaN( BetaI(0.5,1,-1) ) - [true] )";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1135: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                string = "sum(b, 0.1, 80, sum(a, 0.1, 80, sum(x, 0, 1, BetaI(x, a, b) * Beta(a,b) - BetaInc(x,a,b) ,0.1) , 0.25) , 0.25)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1136: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setCanonicalRounding(tmp);
                string = "sum(b, 0.1, 80, sum(a, 0.1, 80, sum(x, 0, 1, BetaI(x, a, b) - BetaReg(x,a,b) ,0.1) , 0.25) , 0.25)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1137: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "5! = 120";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1138: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "5! == 120";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1139: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "5!=5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1140: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "5 != 5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1141: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = ".2-0.2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1142: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "-.2+0.2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1143: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "0.2-.2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1144: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "-0.2+.2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1145: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "4^.5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1146: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "4^(-.5)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.5;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1147: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "2+0.2+.4";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.6;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1148: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "2+.4+0.2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.6;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1149: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = ".4+2+0.2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.6;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1150: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "2+0.2-.2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1151: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "2-.2+0.2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1152: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "-.2+2+0.2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1153: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "12+.2e-1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 12.02;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1154: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "12+.2e+1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 14.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1155: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "+ 5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 5.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1156: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "- 5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -5.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1157: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "+sqrt(1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1158: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "-sqrt(1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1159: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "sin(+(1.2))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Math.sin(1.2);
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1160: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "+(1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1161: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "-(1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1162: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "2 * [xyz], [xyz] = 3";
                Constant constant = new Constant("[xyz] = 3", new PrimitiveElement[0]);
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression("2 * [xyz]", constant);
                d = exp[n].calculate();
                d2 = 6.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1163: {
                mXparser.enableAlmostIntRounding();
                mXparser.enableUlpRounding();
                string = "2 * [abc], [abc] = -3";
                Constant constant = new Constant("[abc]", -3.0);
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression("2 * [abc]", constant);
                d = exp[n].calculate();
                d2 = -6.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-14) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1164: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "sin(0) + sin(2*pi) + sin(-2*pi) + sin(4*pi) + sin(-4*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Math.sin(0.0) + Math.sin(Math.PI * 2) + Math.sin(Math.PI * -2) + Math.sin(Math.PI * 4) + Math.sin(Math.PI * -4);
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1165: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "cos(0) + cos(2*pi) + cos(-2*pi) + cos(4*pi) + cos(-4*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Math.cos(0.0) + Math.cos(Math.PI * 2) + Math.cos(Math.PI * -2) + Math.cos(Math.PI * 4) + Math.cos(Math.PI * -4);
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1166: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "tan(0) + tan(2*pi) + tan(-2*pi) + tan(4*pi) + tan(-4*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Math.tan(0.0) + Math.tan(Math.PI * 2) + Math.tan(Math.PI * -2) + Math.tan(Math.PI * 4) + Math.tan(Math.PI * -4);
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1167: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "sec(0) + sec(2*pi) + sec(-2*pi) + sec(4*pi) + sec(-4*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0 / Math.cos(0.0) + 1.0 / Math.cos(Math.PI * 2) + 1.0 / Math.cos(Math.PI * -2) + 1.0 / Math.cos(Math.PI * 4) + 1.0 / Math.cos(Math.PI * -4);
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1168: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "sin(0) + sin(2*pi) + sin(-2*pi) + sin(4*pi) + sin(-4*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1169: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "cos(0) + cos(2*pi) + cos(-2*pi) + cos(4*pi) + cos(-4*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 5.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1170: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "tan(0) + tan(2*pi) + tan(-2*pi) + tan(4*pi) + tan(-4*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1171: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "sec(0) + sec(2*pi) + sec(-2*pi) + sec(4*pi) + sec(-4*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 5.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1172: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "isNaN(ctan(0)) + isNaN(ctan(2*pi)) + isNaN(ctan(-2*pi)) + isNaN(ctan(4*pi)) + isNaN(ctan(-4*pi))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 5.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1173: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "isNaN(csc(0)) + isNaN(csc(2*pi)) + isNaN(csc(-2*pi)) + isNaN(csc(4*pi)) + isNaN(csc(-4*pi))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 5.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1174: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "sin((1/6)*pi) + sin((13/6)*pi) + sin((-11/6)*pi) + sin((25/6)*pi) + sin((-23/6)*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Math.sin(0.5235987755982988) + Math.sin(6.8067840827778845) + Math.sin(-5.759586531581287) + Math.sin(13.089969389957473) + Math.sin(-12.042771838760874);
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1175: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "cos((1/6)*pi) + cos((13/6)*pi) + cos((-11/6)*pi) + cos((25/6)*pi) + cos((-23/6)*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Math.cos(0.5235987755982988) + Math.cos(6.8067840827778845) + Math.cos(-5.759586531581287) + Math.cos(13.089969389957473) + Math.cos(-12.042771838760874);
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1176: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "tan((1/6)*pi) + tan((13/6)*pi) + tan((-11/6)*pi) + tan((25/6)*pi) + tan((-23/6)*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = Math.tan(0.5235987755982988) + Math.tan(6.8067840827778845) + Math.tan(-5.759586531581287) + Math.tan(13.089969389957473) + Math.tan(-12.042771838760874);
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1177: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "ctan((1/6)*pi) + ctan((13/6)*pi) + ctan((-11/6)*pi) + ctan((25/6)*pi) + ctan((-23/6)*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0 / Math.tan(0.5235987755982988) + 1.0 / Math.tan(6.8067840827778845) + 1.0 / Math.tan(-5.759586531581287) + 1.0 / Math.tan(13.089969389957473) + 1.0 / Math.tan(-12.042771838760874);
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1178: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "sec((1/6)*pi) + sec((13/6)*pi) + sec((-11/6)*pi) + sec((25/6)*pi) + sec((-23/6)*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0 / Math.cos(0.5235987755982988) + 1.0 / Math.cos(6.8067840827778845) + 1.0 / Math.cos(-5.759586531581287) + 1.0 / Math.cos(13.089969389957473) + 1.0 / Math.cos(-12.042771838760874);
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1179: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "csc((1/6)*pi) + csc((13/6)*pi) + csc((-11/6)*pi) + csc((25/6)*pi) + csc((-23/6)*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0 / Math.sin(0.5235987755982988) + 1.0 / Math.sin(6.8067840827778845) + 1.0 / Math.sin(-5.759586531581287) + 1.0 / Math.sin(13.089969389957473) + 1.0 / Math.sin(-12.042771838760874);
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1180: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "sin((1/6)*pi) + sin((13/6)*pi) + sin((-11/6)*pi) + sin((25/6)*pi) + sin((-23/6)*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.5;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1181: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "cos((1/6)*pi) + cos((13/6)*pi) + cos((-11/6)*pi) + cos((25/6)*pi) + cos((-23/6)*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = SpecialValueTrigonometric.COS_30 + SpecialValueTrigonometric.COS_30 + SpecialValueTrigonometric.COS_30 + SpecialValueTrigonometric.COS_30 + SpecialValueTrigonometric.COS_30;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1182: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "tan((1/6)*pi) + tan((13/6)*pi) + tan((-11/6)*pi) + tan((25/6)*pi) + tan((-23/6)*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = SpecialValueTrigonometric.TAN_30 + SpecialValueTrigonometric.TAN_30 + SpecialValueTrigonometric.TAN_30 + SpecialValueTrigonometric.TAN_30 + SpecialValueTrigonometric.TAN_30;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1183: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "ctan((1/6)*pi) + ctan((13/6)*pi) + ctan((-11/6)*pi) + ctan((25/6)*pi) + ctan((-23/6)*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = SpecialValueTrigonometric.CTAN_30 + SpecialValueTrigonometric.CTAN_30 + SpecialValueTrigonometric.CTAN_30 + SpecialValueTrigonometric.CTAN_30 + SpecialValueTrigonometric.CTAN_30;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1184: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "sec((1/6)*pi) + sec((13/6)*pi) + sec((-11/6)*pi) + sec((25/6)*pi) + sec((-23/6)*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = SpecialValueTrigonometric.SEC_30 + SpecialValueTrigonometric.SEC_30 + SpecialValueTrigonometric.SEC_30 + SpecialValueTrigonometric.SEC_30 + SpecialValueTrigonometric.SEC_30;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1185: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "csc((1/6)*pi) + csc((13/6)*pi) + csc((-11/6)*pi) + csc((25/6)*pi) + csc((-23/6)*pi)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 10.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1186: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "sin(asin(sin(asin(sin(asin(sin((1/6)*pi)))))))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.5;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1187: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "cos(acos(cos(acos(cos(acos(cos((1/6)*pi)))))))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = SpecialValueTrigonometric.COS_30;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1188: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "tan(atan(tan(atan(tan(atan(tan((1/6)*pi)))))))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = SpecialValueTrigonometric.TAN_30;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1189: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "ctan(actan(ctan(actan(ctan(actan(ctan((1/6)*pi)))))))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = SpecialValueTrigonometric.CTAN_30;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1190: {
                tmp = mXparser.checkIfCanonicalRounding();
                mXparser.disableCanonicalRounding();
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "sec(arcsec(sec(arcsec(sec(arcsec(sec((1/6)*pi)))))))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = SpecialValueTrigonometric.SEC_30;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setCanonicalRounding(tmp);
                break;
            }
            case 1191: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setRadiansMode();
                string = "csc(arccsc(csc(arccsc(csc(arccsc(csc((1/6)*pi)))))))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 2.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                break;
            }
            case 1192: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setDegreesMode();
                string = "asin(sin(asin(sin(30))))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 30.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1193: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setDegreesMode();
                string = "acos(cos(acos(cos(30))))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 30.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1194: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setDegreesMode();
                string = "atan(tan(atan(tan(30))))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 30.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1195: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setDegreesMode();
                string = "actan(ctan(actan(ctan(30))))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 30.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1196: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setDegreesMode();
                string = "arcsec(sec(arcsec(sec(30))))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 30.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1197: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setDegreesMode();
                string = "arccsc(csc(arccsc(csc(30))))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 30.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1198: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.setDegreesMode();
                string = "asin(sin(31)) + acos(cos(32)) + atan(tan(33)) + actan(ctan(34)) + arcsec(sec(35)) + arccsc(csc(36))";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 201.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1199: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "0.1 + 0.1 + 0.1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.3;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1200: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "2.5 - 2.3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.2;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
            }
        }
        if (bl) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return bl;
    }

    private static boolean runTest_01201_01300(int n) {
        mXparser.consolePrint("[" + n + "] ");
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        String string = "";
        switch (n) {
            case 1201: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "2.53 + 2.0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 4.53;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1202: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "2.53 * 2.675";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 6.76775;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1203: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "-2.53 * 2.675";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -6.76775;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1204: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "5.55 / 5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.11;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1205: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "-5.55 / 5";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -1.11;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1206: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "6.2^2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 38.44;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1207: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "-6.2^3";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -238.328;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1208: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "(1/6.2)^(-2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 38.44;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1209: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "(1/6.2)^(-3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 238.328;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1210: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "(-1/6.2)^(-3)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -238.328;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1211: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "sum(i, 1, 1000, 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 100.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1212: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "sum(i, 1, 1000, -0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -100.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1213: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "sum(i, -1000, -1, 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 100.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1214: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "sum(i, -1000, -1, -0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -100.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1215: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "prod(i, 1, 3, 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.001;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1216: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "prod(i, 1, 3, -0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -0.001;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1217: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "prod(i, -3, -1, 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.001;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1218: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "prod(i, -3, -1, -0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -0.001;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1219: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "prod(i, 1, 2, 6.2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 38.44;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1220: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "prod(i, 1, 3, 6.2)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 238.328;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1221: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "add(0.1, 0.1, 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.3;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1222: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "add(-0.1, -0.1, -0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -0.3;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1223: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "multi(0.1, 0.1, 0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 0.001;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1224: {
                mXparser.disableAlmostIntRounding();
                mXparser.disableUlpRounding();
                mXparser.enableCanonicalRounding();
                string = "multi(-0.1, -0.1, -0.1)";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = -0.001;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                mXparser.enableAlmostIntRounding();
                mXparser.enableAlmostIntRounding();
                mXparser.setRadiansMode();
                break;
            }
            case 1225: {
                string = "(0 & 1) | (1 & 1) | 1 & 0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1226: {
                string = "1 | 0 & 0";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1227: {
                string = "1 | ~1 --> ~0 & 1";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, new PrimitiveElement[0]);
                d = exp[n].calculate();
                d2 = 1.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1228: {
                Argument argument = new Argument("x = 20", new PrimitiveElement[0]);
                string = "x + 4 * - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 12.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1229: {
                Argument argument = new Argument("x = 20", new PrimitiveElement[0]);
                string = "x + 4* - 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 12.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1230: {
                Argument argument = new Argument("x = 20", new PrimitiveElement[0]);
                string = "x + 4*- 2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 12.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1231: {
                Argument argument = new Argument("x = 20", new PrimitiveElement[0]);
                string = "x + 4*-2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 12.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1232: {
                Argument argument = new Argument("x = 20", new PrimitiveElement[0]);
                string = "x + 4  *    -      2";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = 12.0;
                if (MathFunctions.abs(d2 - d) <= 1.0E-100) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
                break;
            }
            case 1233: {
                Argument argument = new Argument("x", new PiMultArgExt());
                string = "x + x + x + x";
                mXparser.consolePrint(string + " ...... ");
                RegTestExpression.exp[n] = new Expression(string, argument);
                d = exp[n].calculate();
                d2 = Math.PI * 10;
                if (MathFunctions.abs(d2 - d) <= 1.0E-13) {
                    bl = true;
                }
                mXparser.consolePrint(d + " reg ... " + d2 + " --> ");
            }
        }
        if (bl) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return bl;
    }

    public static int start(int n) {
        mXparser.setDefaultOptions();
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        exp = new Expression[n2 + 1];
        boolean[] blArray = new boolean[n2 + 1];
        long l = System.currentTimeMillis();
        for (int i = 0; i <= n2; ++i) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return -1;
            }
            mXparser.setEpsilonComparison();
            mXparser.setDefaultEpsilon();
            mXparser.enableUlpRounding();
            boolean bl = i <= 100 ? RegTestExpression.runTest_00000_00100(i) : (i <= 200 ? RegTestExpression.runTest_00101_00200(i) : (i <= 300 ? RegTestExpression.runTest_00201_00300(i) : (i <= 400 ? RegTestExpression.runTest_00301_00400(i) : (i <= 500 ? RegTestExpression.runTest_00401_00500(i) : (i <= 600 ? RegTestExpression.runTest_00501_00600(i) : (i <= 700 ? RegTestExpression.runTest_00601_00700(i) : (i <= 800 ? RegTestExpression.runTest_00701_00800(i) : (i <= 900 ? RegTestExpression.runTest_00801_00900(i) : (i <= 1000 ? RegTestExpression.runTest_00901_01000(i) : (i <= 1100 ? RegTestExpression.runTest_01001_01100(i) : (i <= 1200 ? RegTestExpression.runTest_01101_01200(i) : (i <= 1300 ? RegTestExpression.runTest_01201_01300(i) : false))))))))))));
            blArray[i] = bl;
            if (bl) {
                ++n3;
            } else {
                ++n4;
            }
            if (!exp[i].checkSyntax() && i > 0) {
                mXparser.consolePrintln(exp[i].getErrorMessage());
            }
            mXparser.consolePrintln(", time: " + exp[i].getComputingTime() + " s.");
        }
        long l2 = System.currentTimeMillis();
        mXparser.consolePrintln("OK : " + n3 + ", ERRORs: " + n4 + ", total time: " + (double)(l2 - l) / 1000.0 + " s.");
        for (int i = 0; i <= n2; ++i) {
            if (blArray[i]) continue;
            mXparser.consolePrintln("ERROR: " + i);
            mXparser.consolePrintln(exp[i].getErrorMessage());
        }
        mXparser.resetCancelCurrentCalculationFlag();
        return n4;
    }

    public static int start() {
        return RegTestExpression.start(1233);
    }

    public static void main(String[] stringArray) {
        RegTestExpression.start();
        mXparser.resetCancelCurrentCalculationFlag();
    }
}

