/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.BinaryRelations;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;

public final class BooleanAlgebra {
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int NULL = 2;
    public static final double F = 0.0;
    public static final double T = 1.0;
    public static final double N = Double.NaN;
    public static final double[][] AND_TRUTH_TABLE = new double[][]{{0.0, 0.0, 0.0}, {0.0, 1.0, Double.NaN}, {0.0, Double.NaN, Double.NaN}};
    public static final double[][] NAND_TRUTH_TABLE = new double[][]{{1.0, 1.0, 1.0}, {1.0, 0.0, Double.NaN}, {1.0, Double.NaN, Double.NaN}};
    public static final double[][] OR_TRUTH_TABLE = new double[][]{{0.0, 1.0, Double.NaN}, {1.0, 1.0, 1.0}, {Double.NaN, 1.0, Double.NaN}};
    public static final double[][] NOR_TRUTH_TABLE = new double[][]{{1.0, 0.0, Double.NaN}, {0.0, 0.0, 0.0}, {Double.NaN, 0.0, Double.NaN}};
    public static final double[][] XOR_TRUTH_TABLE = new double[][]{{0.0, 1.0, Double.NaN}, {1.0, 0.0, Double.NaN}, {Double.NaN, Double.NaN, Double.NaN}};
    public static final double[][] XNOR_TRUTH_TABLE = new double[][]{{1.0, 0.0, Double.NaN}, {0.0, 1.0, Double.NaN}, {Double.NaN, Double.NaN, Double.NaN}};
    public static final double[][] IMP_TRUTH_TABLE = new double[][]{{1.0, 1.0, 1.0}, {0.0, 1.0, Double.NaN}, {Double.NaN, 1.0, Double.NaN}};
    public static final double[][] CIMP_TRUTH_TABLE = new double[][]{{1.0, 0.0, Double.NaN}, {1.0, 1.0, 1.0}, {1.0, Double.NaN, Double.NaN}};
    public static final double[][] EQV_TRUTH_TABLE = new double[][]{{1.0, 0.0, Double.NaN}, {0.0, 1.0, Double.NaN}, {Double.NaN, Double.NaN, Double.NaN}};
    public static final double[][] NIMP_TRUTH_TABLE = new double[][]{{0.0, 0.0, 0.0}, {1.0, 0.0, Double.NaN}, {Double.NaN, 0.0, Double.NaN}};
    public static final double[][] CNIMP_TRUTH_TABLE = new double[][]{{0.0, 1.0, Double.NaN}, {0.0, 0.0, 0.0}, {0.0, Double.NaN, Double.NaN}};
    public static final double[] NOT_TRUTH_TABLE = new double[]{1.0, 0.0, Double.NaN};

    public static final int double2IntBoolean(double d) {
        if (Double.isNaN(d)) {
            return 2;
        }
        if (BinaryRelations.epsilonComparison) {
            if (MathFunctions.abs(d) > BinaryRelations.epsilon) {
                return 1;
            }
            return 0;
        }
        if (d != 0.0) {
            return 1;
        }
        return 0;
    }

    public static final double and(double d, double d2) {
        int n = BooleanAlgebra.double2IntBoolean(d);
        int n2 = BooleanAlgebra.double2IntBoolean(d2);
        return AND_TRUTH_TABLE[n][n2];
    }

    public static final double or(double d, double d2) {
        int n = BooleanAlgebra.double2IntBoolean(d);
        int n2 = BooleanAlgebra.double2IntBoolean(d2);
        return OR_TRUTH_TABLE[n][n2];
    }

    public static final double xor(double d, double d2) {
        int n = BooleanAlgebra.double2IntBoolean(d);
        int n2 = BooleanAlgebra.double2IntBoolean(d2);
        return XOR_TRUTH_TABLE[n][n2];
    }

    public static final double nand(double d, double d2) {
        int n = BooleanAlgebra.double2IntBoolean(d);
        int n2 = BooleanAlgebra.double2IntBoolean(d2);
        return NAND_TRUTH_TABLE[n][n2];
    }

    public static final double nor(double d, double d2) {
        int n = BooleanAlgebra.double2IntBoolean(d);
        int n2 = BooleanAlgebra.double2IntBoolean(d2);
        return NOR_TRUTH_TABLE[n][n2];
    }

    public static final double xnor(double d, double d2) {
        int n = BooleanAlgebra.double2IntBoolean(d);
        int n2 = BooleanAlgebra.double2IntBoolean(d2);
        return XNOR_TRUTH_TABLE[n][n2];
    }

    public static final double imp(double d, double d2) {
        int n = BooleanAlgebra.double2IntBoolean(d);
        int n2 = BooleanAlgebra.double2IntBoolean(d2);
        return IMP_TRUTH_TABLE[n][n2];
    }

    public static final double eqv(double d, double d2) {
        int n = BooleanAlgebra.double2IntBoolean(d);
        int n2 = BooleanAlgebra.double2IntBoolean(d2);
        return EQV_TRUTH_TABLE[n][n2];
    }

    public static final double not(double d) {
        int n = BooleanAlgebra.double2IntBoolean(d);
        return NOT_TRUTH_TABLE[n];
    }

    public static final double cimp(double d, double d2) {
        int n = BooleanAlgebra.double2IntBoolean(d);
        int n2 = BooleanAlgebra.double2IntBoolean(d2);
        return CIMP_TRUTH_TABLE[n][n2];
    }

    public static final double nimp(double d, double d2) {
        int n = BooleanAlgebra.double2IntBoolean(d);
        int n2 = BooleanAlgebra.double2IntBoolean(d2);
        return NIMP_TRUTH_TABLE[n][n2];
    }

    public static final double cnimp(double d, double d2) {
        int n = BooleanAlgebra.double2IntBoolean(d);
        int n2 = BooleanAlgebra.double2IntBoolean(d2);
        return CNIMP_TRUTH_TABLE[n][n2];
    }

    public static final double andVariadic(double[] dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        int n = 0;
        for (double d : dArray) {
            int n2 = BooleanAlgebra.double2IntBoolean(d);
            if (n2 == 0) {
                return 0.0;
            }
            if (n2 == 1) {
                ++n;
            }
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return Double.NaN;
        }
        if (n == dArray.length) {
            return 1.0;
        }
        return Double.NaN;
    }

    public static final double orVariadic(double[] dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        int n = 0;
        for (double d : dArray) {
            int n2 = BooleanAlgebra.double2IntBoolean(d);
            if (n2 == 1) {
                return 1.0;
            }
            if (n2 == 0) {
                ++n;
            }
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return Double.NaN;
        }
        if (n == dArray.length) {
            return 0.0;
        }
        return Double.NaN;
    }

    public static final double xorVariadic(double[] dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        int n = 0;
        for (double d : dArray) {
            int n2 = BooleanAlgebra.double2IntBoolean(d);
            if (n2 == 1 && ++n > 1) {
                return 0.0;
            }
            if (n2 == 2) {
                return Double.NaN;
            }
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return Double.NaN;
        }
        if (n == 1) {
            return 1.0;
        }
        return 0.0;
    }
}

