/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IntSet;
import explicit.SCCConsumer;
import java.util.Arrays;
import java.util.PrimitiveIterator;
import prism.PrismLog;

public class SCCInfo
implements SCCConsumer {
    private int numStates;
    private int[] stateList;
    private int[] sccEnd;
    private int[] stateToSCCIndex;
    private int storedSCCCount;
    private int storedStateCount;

    public SCCInfo(int n) {
        this.numStates = n;
        this.stateList = new int[n];
        this.sccEnd = new int[n];
        this.stateToSCCIndex = new int[n];
        Arrays.fill(this.stateToSCCIndex, -1);
        this.storedSCCCount = 0;
        this.storedStateCount = 0;
    }

    @Override
    public void notifyStartSCC() {
    }

    @Override
    public void notifyEndSCC() {
        int n = this.storedSCCCount++;
        this.sccEnd[n] = this.storedStateCount - 1;
    }

    @Override
    public void notifyStateInSCC(int n) {
        int n2 = this.storedSCCCount;
        this.stateList[this.storedStateCount] = n;
        this.stateToSCCIndex[n] = n2;
        ++this.storedStateCount;
    }

    public int getNumSCCs() {
        return this.storedSCCCount;
    }

    public int countNonSingletonSCCs() {
        int n = 0;
        for (int i = 0; i < this.getNumSCCs(); ++i) {
            if (this.isSingletonSCC(i)) continue;
            ++n;
        }
        return n;
    }

    public int getNumStatesInSCC(int n) {
        this.checkSCCIndex(n);
        return this.endOfSCC(n) - this.startOfSCC(n) + 1;
    }

    public boolean isSingletonSCC(int n) {
        this.checkSCCIndex(n);
        return this.getNumStatesInSCC(n) == 1;
    }

    public int getSCCIndex(int n) {
        this.checkStateIndex(n);
        return this.stateToSCCIndex[n];
    }

    public IntSet getStatesForSCC(final int n) {
        this.checkSCCIndex(n);
        final int n2 = this.startOfSCC(n);
        final int n3 = this.endOfSCC(n);
        return new IntSet(){

            @Override
            public PrimitiveIterator.OfInt iterator() {
                return new PrimitiveIterator.OfInt(){
                    int cur;
                    {
                        this.cur = n2;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.cur <= n3;
                    }

                    @Override
                    public int nextInt() {
                        return SCCInfo.this.stateList[this.cur++];
                    }
                };
            }

            @Override
            public PrimitiveIterator.OfInt reversedIterator() {
                return new PrimitiveIterator.OfInt(){
                    int cur;
                    {
                        this.cur = n3;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.cur >= n2;
                    }

                    @Override
                    public int nextInt() {
                        return SCCInfo.this.stateList[this.cur--];
                    }
                };
            }

            @Override
            public int cardinality() {
                return SCCInfo.this.getNumStatesInSCC(n);
            }

            @Override
            public boolean contains(int n4) {
                int n22 = SCCInfo.this.getSCCIndex(n4);
                return n22 == n;
            }

            public String toString() {
                return this.asString();
            }
        };
    }

    public void print(PrismLog prismLog) {
        for (int i = 0; i < this.getNumSCCs(); ++i) {
            prismLog.println("SCC " + i + " (" + this.getNumStatesInSCC(i) + "):");
            PrimitiveIterator.OfInt ofInt = this.getStatesForSCC(i).iterator();
            while (ofInt.hasNext()) {
                int n = ofInt.nextInt();
                prismLog.print(" ");
                prismLog.print(n);
            }
            prismLog.println();
        }
    }

    private void checkStateIndex(int n) {
        if (n < 0 || n >= this.numStates) {
            throw new IllegalArgumentException("SCCInfo: State index " + n + " is out of range");
        }
    }

    private void checkSCCIndex(int n) {
        if (n < 0 || n >= this.storedSCCCount) {
            throw new IllegalArgumentException("SCCInfo: SCC index " + n + " is out of range");
        }
    }

    private int startOfSCC(int n) {
        if (n == 0) {
            return 0;
        }
        return this.sccEnd[n - 1] + 1;
    }

    private int endOfSCC(int n) {
        return this.sccEnd[n];
    }
}

