/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.DTMCFromMDPAndMDStrategy;
import explicit.MDP;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.graphviz.Decoration;
import explicit.graphviz.Decorator;
import java.io.FileWriter;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismUtils;
import strat.MDStrategy;

public abstract class MDPExplicit
extends ModelExplicit
implements MDP {
    @Override
    public ModelType getModelType() {
        return ModelType.MDP;
    }

    @Override
    public String infoString() {
        Object object = "";
        object = (String)object + this.numStates + " states (" + this.getNumInitialStates() + " initial)";
        object = (String)object + ", " + this.getNumTransitions() + " transitions";
        object = (String)object + ", " + this.getNumChoices() + " choices";
        object = (String)object + ", dist max/avg = " + this.getMaxNumChoices() + "/" + PrismUtils.formatDouble2dp((double)this.getNumChoices() / (double)this.numStates);
        return object;
    }

    @Override
    public String infoStringTable() {
        Object object = "";
        object = (String)object + "States:      " + this.numStates + " (" + this.getNumInitialStates() + " initial)\n";
        object = (String)object + "Transitions: " + this.getNumTransitions() + "\n";
        object = (String)object + "Choices:     " + this.getNumChoices() + "\n";
        object = (String)object + "Max/avg:     " + this.getMaxNumChoices() + "/" + PrismUtils.formatDouble2dp((double)this.getNumChoices() / (double)this.numStates) + "\n";
        return object;
    }

    @Override
    public void exportToPrismExplicitTra(PrismLog prismLog) {
        prismLog.print(this.numStates + " " + this.getNumChoices() + " " + this.getNumTransitions() + "\n");
        TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
        for (int i = 0; i < this.numStates; ++i) {
            int n = this.getNumChoices(i);
            for (int j = 0; j < n; ++j) {
                Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(i, j);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    treeMap.put((Integer)entry.getKey(), (Double)entry.getValue());
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    prismLog.print(i + " " + j + " " + entry.getKey() + " " + PrismUtils.formatDouble((Double)entry.getValue()));
                    Object object = this.getAction(i, j);
                    prismLog.print((String)(object == null ? "\n" : " " + object + "\n"));
                }
                treeMap.clear();
            }
        }
    }

    @Override
    public void exportTransitionsToDotFile(int n, PrismLog prismLog, Iterable<Decorator> iterable) {
        int n2 = this.getNumChoices(n);
        for (int i = 0; i < n2; ++i) {
            Object object = this.getAction(n, i);
            String string = "n" + n + "_" + i;
            prismLog.print(n + " -> " + string + " ");
            Decoration decoration = new Decoration();
            decoration.attributes().put("arrowhead", "none");
            decoration.setLabel(i + (String)(object != null ? ":" + object : ""));
            if (iterable != null) {
                for (Decorator decorator : iterable) {
                    decoration = decorator.decorateTransition(n, i, decoration);
                }
            }
            prismLog.print(decoration);
            prismLog.println(";");
            prismLog.print(string + " [ shape=point,width=0.1,height=0.1,label=\"\" ];\n");
            Iterator<Object> iterator = this.getTransitionsIterator(n, i);
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                prismLog.print(string + " -> " + entry.getKey() + " ");
                decoration = new Decoration();
                decoration.setLabel(((Double)entry.getValue()).toString());
                if (iterable != null) {
                    for (Decorator decorator : iterable) {
                        decoration = decorator.decorateProbability(n, (Integer)entry.getKey(), i, entry.getValue(), decoration);
                    }
                }
                prismLog.print(decoration);
                prismLog.println(";");
            }
        }
    }

    @Override
    public void exportToDotFileWithStrat(PrismLog prismLog, BitSet bitSet, int[] nArray) {
        prismLog.print("digraph " + this.getModelType() + " {\nnode [shape=box];\n");
        for (int i = 0; i < this.numStates; ++i) {
            if (bitSet != null && bitSet.get(i)) {
                prismLog.print(i + " [style=filled  fillcolor=\"#cccccc\"]\n");
            }
            int n = this.getNumChoices(i);
            for (int j = 0; j < n; ++j) {
                String string = nArray[i] == j ? ",color=\"#ff0000\",fontcolor=\"#ff0000\"" : "";
                Object object = this.getAction(i, j);
                String string2 = "n" + i + "_" + j;
                prismLog.print(i + " -> " + string2 + " [ arrowhead=none,label=\"" + j);
                if (object != null) {
                    prismLog.print(":" + object);
                }
                prismLog.print("\"" + string + " ];\n");
                prismLog.print(string2 + " [ shape=point,height=0.1,label=\"\"" + string + " ];\n");
                Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(i, j);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    prismLog.print(string2 + " -> " + entry.getKey() + " [ label=\"" + entry.getValue() + "\"" + string + " ];\n");
                }
            }
        }
        prismLog.print("}\n");
    }

    @Override
    public void exportToPrismLanguage(String string) throws PrismException {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(this.getModelType().keyword() + "\n");
            fileWriter.write("module M\nx : [0.." + (this.numStates - 1) + "];\n");
            TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
            for (int i = 0; i < this.numStates; ++i) {
                int n = this.getNumChoices(i);
                for (int j = 0; j < n; ++j) {
                    Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(i, j);
                    while (iterator.hasNext()) {
                        Map.Entry<Integer, Double> entry = iterator.next();
                        treeMap.put(entry.getKey(), entry.getValue());
                    }
                    Object object = this.getAction(i, j);
                    fileWriter.write((String)(object != null ? "[" + object + "]" : "[]"));
                    fileWriter.write("x=" + i + "->");
                    boolean bl = true;
                    for (Map.Entry entry : treeMap.entrySet()) {
                        if (bl) {
                            bl = false;
                        } else {
                            fileWriter.write("+");
                        }
                        fileWriter.write(PrismUtils.formatDouble((Double)entry.getValue()) + ":(x'=" + entry.getKey() + ")");
                    }
                    fileWriter.write(";\n");
                    treeMap.clear();
                }
            }
            fileWriter.write("endmodule\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new PrismException("Could not export " + this.getModelType() + " to file \"" + string + "\"" + iOException);
        }
    }

    @Override
    public boolean areAllChoiceActionsUnique() {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < this.numStates; ++i) {
            int n = this.getNumChoices(i);
            if (n <= 1) continue;
            hashSet.clear();
            for (int j = 0; j < n; ++j) {
                if (hashSet.add(this.getAction(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Model constructInducedModel(MDStrategy mDStrategy) {
        return new DTMCFromMDPAndMDStrategy(this, mDStrategy);
    }
}

