/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbsolute;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FactorAlgebraic<C extends GcdRingElem<C>>
extends FactorAbsolute<AlgebraicNumber<C>> {
    private static final Logger logger = Logger.getLogger(FactorAlgebraic.class);
    private final boolean debug = logger.isDebugEnabled();
    public final FactorAbstract<C> factorCoeff;

    protected FactorAlgebraic() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorAlgebraic(AlgebraicNumberRing<C> algebraicNumberRing) {
        this(algebraicNumberRing, FactorFactory.getImplementation(algebraicNumberRing.ring.coFac));
    }

    public FactorAlgebraic(AlgebraicNumberRing<C> algebraicNumberRing, FactorAbstract<C> factorAbstract) {
        super(algebraicNumberRing);
        this.factorCoeff = factorAbstract;
    }

    @Override
    public List<GenPolynomial<AlgebraicNumber<C>>> baseFactorsSquarefree(GenPolynomial<AlgebraicNumber<C>> genPolynomial) {
        long l;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<AlgebraicNumber<C>>> arrayList = new ArrayList<GenPolynomial<AlgebraicNumber<C>>>();
        if (genPolynomial.isZERO()) {
            return arrayList;
        }
        if (genPolynomial.isONE()) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.coFac;
        AlgebraicNumber<C> algebraicNumber = genPolynomial.leadingBaseCoefficient();
        if (!algebraicNumber.isONE()) {
            genPolynomial = genPolynomial.monic();
            arrayList.add(((GenPolynomial)genPolynomialRing.getONE()).multiply(algebraicNumber));
        }
        if (this.debug) {
            SquarefreeAbstract<AlgebraicNumber<C>> squarefreeAbstract = SquarefreeFactory.getImplementation(algebraicNumberRing);
            if (!squarefreeAbstract.isSquarefree(genPolynomial)) {
                throw new RuntimeException("P not squarefree: " + squarefreeAbstract.squarefreeFactors(genPolynomial));
            }
            GenPolynomial genPolynomial2 = algebraicNumberRing.modul;
            if (!this.factorCoeff.isIrreducible(genPolynomial2)) {
                throw new RuntimeException("modul not irreducible: " + this.factorCoeff.factors(genPolynomial2));
            }
            System.out.println("P squarefree and modul irreducible");
        }
        long l2 = l = 0L;
        GenPolynomial<C> genPolynomial3 = null;
        boolean bl = false;
        int[] nArray = new int[]{0, -1, -2, 1, 2};
        for (int i = 0; !bl && i < nArray.length; ++i) {
            l = nArray[i];
            l2 = l;
            genPolynomial3 = PolyUfdUtil.norm(genPolynomial, l2);
            if (genPolynomial3.isZERO() || genPolynomial3.isConstant()) continue;
            bl = this.factorCoeff.isSquarefree(genPolynomial3);
        }
        if (!bl) {
            System.out.println("sqf(" + l2 + ") = " + genPolynomial3.degree());
        }
        if (logger.isInfoEnabled()) {
            logger.info("res = " + genPolynomial3);
        }
        List<GenPolynomial<C>> list = this.factorCoeff.baseFactorsRadical(genPolynomial3);
        if (logger.isInfoEnabled()) {
            logger.info("res facs = " + list);
        }
        if (list.size() == 1) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        GenPolynomial<AlgebraicNumber<AlgebraicNumber<C>>> genPolynomial4 = genPolynomial;
        for (GenPolynomial<C> genPolynomial5 : list) {
            GenPolynomial<AlgebraicNumber<C>> genPolynomial6;
            GenPolynomial genPolynomial7 = PolyUfdUtil.substituteConvertToAlgebraicCoefficients(genPolynomialRing, genPolynomial5, l2);
            if (logger.isInfoEnabled()) {
                logger.info("Ni = " + genPolynomial7);
            }
            if (!(genPolynomial6 = this.engine.gcd(genPolynomial7, genPolynomial4)).leadingBaseCoefficient().isONE()) {
                genPolynomial6 = genPolynomial6.monic();
            }
            if (logger.isInfoEnabled()) {
                logger.info("gcd(Ni,Pp) = " + genPolynomial6);
            }
            if (genPolynomial6.isONE()) continue;
            arrayList.add(genPolynomial6);
            genPolynomial4 = genPolynomial4.divide(genPolynomial6);
        }
        if (!genPolynomial4.isZERO() && !genPolynomial4.isONE()) {
            arrayList.add(genPolynomial4);
        }
        return arrayList;
    }
}

