/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.Rectangle;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.io.Serializable;

public class Boundary<C extends RingElem<C> & Rational>
implements Serializable {
    public final Rectangle<C> rect;
    public final GenPolynomial<Complex<C>> A;
    public final GenPolynomial<Complex<C>>[] polys;
    GenPolynomialRing<C> rfac;

    public Boundary(Rectangle<C> rectangle, GenPolynomial<Complex<C>> genPolynomial) throws InvalidBoundaryException {
        Serializable serializable;
        if (genPolynomial.isConstant() || genPolynomial.isZERO()) {
            throw new InvalidBoundaryException("p is constant or 0 " + genPolynomial);
        }
        this.rect = rectangle;
        this.A = genPolynomial;
        GreatestCommonDivisorAbstract<Complex<Complex<C>>> greatestCommonDivisorAbstract = GCDFactory.getImplementation(this.A.ring.coFac);
        this.polys = new GenPolynomial[5];
        Complex<C>[] complexArray = this.rect.corners;
        for (int i = 0; i < 4; ++i) {
            serializable = complexArray[i + 1].subtract(complexArray[i]);
            GenPolynomial genPolynomial2 = this.A.ring.univariate(0, 1L).multiply(serializable);
            GenPolynomial<Complex<Complex<C>>> genPolynomial3 = PolyUtil.seriesOfTaylor(this.A, complexArray[i]);
            GenPolynomial genPolynomial4 = greatestCommonDivisorAbstract.gcd(this.A, genPolynomial3 = PolyUtil.substituteUnivariate(genPolynomial3, genPolynomial2));
            if (!genPolynomial4.isONE()) {
                throw new InvalidBoundaryException("A has a zero on rectangle " + this.rect + ", A = " + this.A);
            }
            this.polys[i] = genPolynomial3;
        }
        this.polys[4] = this.polys[0];
        ComplexRing complexRing = (ComplexRing)this.A.ring.coFac;
        serializable = complexRing.ring;
        this.rfac = new GenPolynomialRing(serializable, this.A.ring);
    }

    protected Boundary(Rectangle<C> rectangle, GenPolynomial<Complex<C>> genPolynomial, GenPolynomial<Complex<C>>[] genPolynomialArray) {
        this.rect = rectangle;
        this.A = genPolynomial;
        this.polys = genPolynomialArray;
        ComplexRing complexRing = (ComplexRing)this.A.ring.coFac;
        RingFactory ringFactory = complexRing.ring;
        this.rfac = new GenPolynomialRing(ringFactory, this.A.ring);
    }

    public String toString() {
        return this.rect.toString();
    }

    public String toScript() {
        return this.rect.toScript();
    }

    public GenPolynomial<C> getRealPart(int n) {
        GenPolynomial<C> genPolynomial = PolyUtil.realPartFromComplex(this.rfac, this.polys[n]);
        return genPolynomial;
    }

    public GenPolynomial<C> getImagPart(int n) {
        GenPolynomial<C> genPolynomial = PolyUtil.imaginaryPartFromComplex(this.rfac, this.polys[n]);
        return genPolynomial;
    }

    public Boundary<C> copy() {
        return new Boundary<C>(this.rect, this.A, this.polys);
    }

    public boolean equals(Object object) {
        Boundary boundary = null;
        try {
            boundary = (Boundary)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (boundary == null) {
            return false;
        }
        return this.rect.equals(boundary.rect) && this.A.equals(boundary.A);
    }

    public int hashCode() {
        int n = 0;
        return 37 * (n += 37 * this.rect.hashCode()) + this.A.hashCode();
    }
}

