/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gbufd.SolvablePseudoReduction;
import edu.jas.gbufd.SolvablePseudoReductionSeq;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorFake;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class SolvableGroebnerBasePseudoSeq<C extends GcdRingElem<C>>
extends SolvableGroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(SolvableGroebnerBasePseudoSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final SolvablePseudoReduction<C> sred;
    protected final RingFactory<C> cofac;

    public SolvableGroebnerBasePseudoSeq(RingFactory<C> ringFactory) {
        this(new SolvablePseudoReductionSeq(), ringFactory, new OrderedPairlist());
    }

    public SolvableGroebnerBasePseudoSeq(RingFactory<C> ringFactory, PairList<C> pairList) {
        this(new SolvablePseudoReductionSeq(), ringFactory, pairList);
    }

    public SolvableGroebnerBasePseudoSeq(SolvablePseudoReduction<C> solvablePseudoReduction, RingFactory<C> ringFactory, PairList<C> pairList) {
        super(solvablePseudoReduction, pairList);
        this.sred = solvablePseudoReduction;
        this.cofac = ringFactory;
        if (!this.cofac.isCommutative()) {
            logger.warn("right reduction not correct for " + this.cofac.toScript());
            this.engine = new GreatestCommonDivisorFake();
        } else {
            this.engine = GCDFactory.getProxy(ringFactory);
        }
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftGB(int n, List<GenSolvablePolynomial<C>> list) {
        List<GenSolvablePolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolynomialList.castToSolvableList(this.engine.basePrimitivePart(PolynomialList.castToList(list2)))).size() <= 1) {
            return list2;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list2.get((int)0).ring;
        if (genSolvablePolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients from a field");
        }
        PairList<C> pairList = this.strategy.create(n, genSolvablePolynomialRing);
        pairList.put(PolynomialList.castToList(list2));
        while (pairList.hasNext()) {
            GenSolvablePolynomial genSolvablePolynomial;
            GenSolvablePolynomial genSolvablePolynomial2;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)pair.pi;
            GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)pair.pj;
            if (this.debug) {
                logger.debug("pi    = " + genSolvablePolynomial3);
                logger.debug("pj    = " + genSolvablePolynomial4);
            }
            if ((genSolvablePolynomial2 = this.sred.leftSPolynomial(genSolvablePolynomial3, genSolvablePolynomial4)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.debug("ht(S) = " + genSolvablePolynomial2.leadingExpVector());
            }
            if ((genSolvablePolynomial = this.sred.leftNormalform(list2, genSolvablePolynomial2)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.debug("ht(H) = " + genSolvablePolynomial.leadingExpVector());
            }
            genSolvablePolynomial = (GenSolvablePolynomial)this.engine.basePrimitivePart(genSolvablePolynomial);
            if ((genSolvablePolynomial = (GenSolvablePolynomial)genSolvablePolynomial.abs()).isConstant()) {
                list2.clear();
                list2.add(genSolvablePolynomial);
                return list2;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("H = " + genSolvablePolynomial);
            }
            if (genSolvablePolynomial.length() <= 0) continue;
            list2.add(genSolvablePolynomial);
            pairList.put(genSolvablePolynomial);
        }
        logger.debug("#sequential list = " + list2.size());
        list2 = this.leftMinimalGB(list2);
        logger.info("" + pairList);
        return list2;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftMinimalGB(List<GenSolvablePolynomial<C>> list) {
        GenSolvablePolynomial<C> genSolvablePolynomial;
        List<GenSolvablePolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if (list2.size() <= 1) {
            return list2;
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(list2.size());
        while (list2.size() > 0) {
            genSolvablePolynomial = list2.remove(0);
            if (this.sred.isTopReducible(list2, genSolvablePolynomial) || this.sred.isTopReducible(arrayList, genSolvablePolynomial)) {
                if (!this.debug) continue;
                System.out.println("dropped " + genSolvablePolynomial);
                ArrayList<GenSolvablePolynomial<C>> arrayList2 = new ArrayList<GenSolvablePolynomial<C>>(list2);
                arrayList2.addAll(arrayList);
                if ((genSolvablePolynomial = this.sred.leftNormalform(arrayList2, genSolvablePolynomial)).isZERO()) continue;
                System.out.println("error, nf(a) " + genSolvablePolynomial);
                continue;
            }
            arrayList.add(genSolvablePolynomial);
        }
        list2 = arrayList;
        if (list2.size() <= 1) {
            return list2;
        }
        Collections.reverse(list2);
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            genSolvablePolynomial = list2.remove(0);
            genSolvablePolynomial = this.sred.leftNormalform(list2, genSolvablePolynomial);
            genSolvablePolynomial = (GenSolvablePolynomial<C>)this.engine.basePrimitivePart(genSolvablePolynomial);
            genSolvablePolynomial = (GenSolvablePolynomial)genSolvablePolynomial.abs();
            list2.add(genSolvablePolynomial);
        }
        return list2;
    }

    @Override
    public List<GenSolvablePolynomial<C>> twosidedGB(int n, List<GenSolvablePolynomial<C>> list) {
        GenSolvablePolynomial genSolvablePolynomial;
        GenSolvablePolynomial genSolvablePolynomial2;
        List<GenSolvablePolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolynomialList.castToSolvableList(this.engine.basePrimitivePart(PolynomialList.castToList(list2)))).size() < 1) {
            return list2;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list2.get((int)0).ring;
        if (genSolvablePolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients from a field");
        }
        List list3 = PolynomialList.castToSolvableList(genSolvablePolynomialRing.generators(n));
        logger.info("right multipliers = " + list3);
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(list2.size() * (1 + list3.size()));
        arrayList.addAll(list2);
        for (int i = 0; i < arrayList.size(); ++i) {
            genSolvablePolynomial2 = (GenSolvablePolynomial)arrayList.get(i);
            for (int j = 0; j < list3.size(); ++j) {
                genSolvablePolynomial = list3.get(j);
                GenSolvablePolynomial genSolvablePolynomial3 = genSolvablePolynomial2.multiply(genSolvablePolynomial);
                if ((genSolvablePolynomial3 = this.sred.leftNormalform(arrayList, genSolvablePolynomial3)).isZERO()) continue;
                genSolvablePolynomial3 = (GenSolvablePolynomial)this.engine.basePrimitivePart(genSolvablePolynomial3);
                genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.abs();
                arrayList.add(genSolvablePolynomial3);
            }
        }
        list2 = arrayList;
        PairList<C> pairList = this.strategy.create(n, genSolvablePolynomialRing);
        pairList.put(PolynomialList.castToList(list2));
        while (pairList.hasNext()) {
            GenSolvablePolynomial genSolvablePolynomial4;
            GenSolvablePolynomial genSolvablePolynomial5;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            GenSolvablePolynomial genSolvablePolynomial6 = (GenSolvablePolynomial)pair.pi;
            GenSolvablePolynomial genSolvablePolynomial7 = (GenSolvablePolynomial)pair.pj;
            if (this.debug) {
                logger.debug("pi    = " + genSolvablePolynomial6);
                logger.debug("pj    = " + genSolvablePolynomial7);
            }
            if ((genSolvablePolynomial5 = this.sred.leftSPolynomial(genSolvablePolynomial6, genSolvablePolynomial7)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.debug("ht(S) = " + genSolvablePolynomial5.leadingExpVector());
            }
            if ((genSolvablePolynomial4 = this.sred.leftNormalform(list2, genSolvablePolynomial5)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.debug("ht(H) = " + genSolvablePolynomial4.leadingExpVector());
            }
            genSolvablePolynomial4 = (GenSolvablePolynomial)this.engine.basePrimitivePart(genSolvablePolynomial4);
            if ((genSolvablePolynomial4 = (GenSolvablePolynomial)genSolvablePolynomial4.abs()).isONE()) {
                list2.clear();
                list2.add(genSolvablePolynomial4);
                return list2;
            }
            if (this.debug) {
                logger.debug("H = " + genSolvablePolynomial4);
            }
            if (genSolvablePolynomial4.length() <= 0) continue;
            list2.add(genSolvablePolynomial4);
            pairList.put(genSolvablePolynomial4);
            for (int i = 0; i < list3.size(); ++i) {
                genSolvablePolynomial = list3.get(i);
                genSolvablePolynomial2 = genSolvablePolynomial4.multiply(genSolvablePolynomial);
                if ((genSolvablePolynomial2 = this.sred.leftNormalform(list2, genSolvablePolynomial2)).isZERO()) continue;
                genSolvablePolynomial2 = (GenSolvablePolynomial)this.engine.basePrimitivePart(genSolvablePolynomial2);
                if ((genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial2.abs()).isONE()) {
                    list2.clear();
                    list2.add(genSolvablePolynomial2);
                    return list2;
                }
                list2.add(genSolvablePolynomial2);
                pairList.put(genSolvablePolynomial2);
            }
        }
        logger.debug("#sequential list = " + list2.size());
        list2 = this.leftMinimalGB(list2);
        logger.info("" + pairList);
        return list2;
    }

    @Override
    public SolvableExtendedGB<C> extLeftGB(int n, List<GenSolvablePolynomial<C>> list) {
        throw new UnsupportedOperationException("TODO");
    }
}

