/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.Pair;
import edu.jas.gbufd.OrderedRPairlist;
import edu.jas.gbufd.RGroebnerBaseSeq;
import edu.jas.gbufd.RPseudoReduction;
import edu.jas.gbufd.RPseudoReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RegularRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class RGroebnerBasePseudoSeq<C extends RegularRingElem<C>>
extends RGroebnerBaseSeq<C> {
    private static final Logger logger = Logger.getLogger(RGroebnerBasePseudoSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final RPseudoReduction<C> red;
    protected final RingFactory<C> cofac;

    public RGroebnerBasePseudoSeq(RingFactory<C> ringFactory) {
        this(new RPseudoReductionSeq(), ringFactory);
    }

    public RGroebnerBasePseudoSeq(RPseudoReduction<C> rPseudoReduction, RingFactory<C> ringFactory) {
        super(rPseudoReduction);
        this.red = rPseudoReduction;
        this.cofac = ringFactory;
        this.engine = GCDFactory.getImplementation(ringFactory);
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        if (list == null) {
            return list;
        }
        List<GenPolynomial<C>> list2 = this.red.reducedBooleanClosure(list);
        logger.info("#bcF-#F = " + (list2.size() - list.size()));
        list = list2;
        List<GenPolynomial<C>> list3 = new ArrayList<GenPolynomial<C>>();
        OrderedRPairlist<GenPolynomial<C>> orderedRPairlist = null;
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial.isZERO()) continue;
            genPolynomial = this.engine.basePrimitivePart(genPolynomial);
            if ((genPolynomial = genPolynomial.abs()).isConstant() && ((RegularRingElem)genPolynomial.leadingBaseCoefficient()).isFull()) {
                list3.clear();
                list3.add(genPolynomial);
                return list3;
            }
            list3.add(genPolynomial);
            if (orderedRPairlist == null) {
                orderedRPairlist = new OrderedRPairlist<GenPolynomial<C>>(n, genPolynomial.ring);
            }
            orderedRPairlist.put(genPolynomial);
        }
        if (list3.size() <= 1) {
            return list3;
        }
        while (orderedRPairlist.hasNext()) {
            AbelianGroupElem<GenPolynomial<C>> abelianGroupElem;
            GenPolynomial<C> genPolynomial;
            Pair pair = orderedRPairlist.removeNext();
            if (pair == null) continue;
            genPolynomial = pair.pi;
            GenPolynomial genPolynomial2 = pair.pj;
            if (logger.isDebugEnabled()) {
                logger.info("pi    = " + genPolynomial);
                logger.info("pj    = " + genPolynomial2);
            }
            if (!this.red.moduleCriterion(n, genPolynomial, genPolynomial2)) continue;
            GenPolynomial genPolynomial3 = this.red.SPolynomial(genPolynomial, genPolynomial2);
            if (genPolynomial3.isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ht(S) = " + genPolynomial3.leadingExpVector());
            }
            if (((GenPolynomial)(abelianGroupElem = this.red.normalform(list3, genPolynomial3))).isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ht(H) = " + ((GenPolynomial)abelianGroupElem).leadingExpVector());
            }
            abelianGroupElem = this.engine.basePrimitivePart((GenPolynomial<C>)abelianGroupElem);
            if (((GenPolynomial)(abelianGroupElem = ((GenPolynomial)abelianGroupElem).abs())).isConstant() && ((RegularRingElem)((GenPolynomial)abelianGroupElem).leadingBaseCoefficient()).isFull()) {
                list3.clear();
                list3.add((GenPolynomial<C>)abelianGroupElem);
                return list3;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("H = " + abelianGroupElem);
            }
            if (((GenPolynomial)abelianGroupElem).isZERO()) continue;
            List<GenPolynomial<GenPolynomial<C>>> list4 = this.red.reducedBooleanClosure((List<GenPolynomial<GenPolynomial<C>>>)list3, (GenPolynomial<GenPolynomial<C>>)abelianGroupElem);
            for (AbelianGroupElem<GenPolynomial<C>> abelianGroupElem2 : list4) {
                abelianGroupElem2 = this.engine.basePrimitivePart((GenPolynomial<GenPolynomial<C>>)abelianGroupElem2);
                abelianGroupElem2 = abelianGroupElem2.abs();
                logger.info("bc(Sred) = " + abelianGroupElem2);
                list3.add((GenPolynomial<C>)abelianGroupElem2);
                orderedRPairlist.put((GenPolynomial<GenPolynomial<C>>)abelianGroupElem2);
            }
            if (!this.debug || pair.getUseCriterion3() && pair.getUseCriterion4()) continue;
            logger.info("H != 0 but: " + pair);
        }
        logger.debug("#sequential list = " + list3.size());
        list3 = this.minimalGB(list3);
        logger.info("" + orderedRPairlist);
        return list3;
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> list) {
        GenPolynomial<GenPolynomial> genPolynomial;
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList(list.size());
        for (GenPolynomial<C> genPolynomial2 : list) {
            if (genPolynomial2 == null || genPolynomial2.isZERO()) continue;
            AbelianGroupElem abelianGroupElem = genPolynomial2.abs();
            arrayList.add((GenPolynomial<C>)abelianGroupElem);
        }
        logger.info("minGB start with " + arrayList.size());
        ArrayList<GenPolynomial<Object>> arrayList2 = new ArrayList(arrayList.size());
        while (arrayList.size() > 0) {
            genPolynomial = (GenPolynomial)arrayList.remove(0);
            GenPolynomial genPolynomial3 = genPolynomial;
            if (this.red.isTopReducible(arrayList, genPolynomial) || this.red.isTopReducible(arrayList2, genPolynomial)) {
                ArrayList arrayList3 = new ArrayList(arrayList);
                arrayList3.addAll(arrayList2);
                genPolynomial = this.red.normalform(arrayList3, genPolynomial);
                if (genPolynomial.isZERO()) {
                    if (!this.debug) continue;
                    logger.debug("minGB dropped " + genPolynomial3);
                    continue;
                }
                logger.info("minGB not zero " + genPolynomial);
                arrayList2.add((GenPolynomial<Object>)genPolynomial);
                continue;
            }
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        Collections.reverse(arrayList);
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ++n2;
            genPolynomial = (GenPolynomial)arrayList.remove(0);
            GenPolynomial genPolynomial4 = genPolynomial;
            genPolynomial = this.red.normalform(arrayList, genPolynomial);
            genPolynomial = this.engine.basePrimitivePart(genPolynomial);
            if (this.red.isBooleanClosed(genPolynomial = genPolynomial.abs())) {
                if (this.debug) {
                    logger.debug("minGB reduced " + genPolynomial4 + " to " + genPolynomial);
                }
                arrayList.add(genPolynomial);
                continue;
            }
            logger.info("minGB not boolean closed " + genPolynomial);
            arrayList.add(genPolynomial4);
        }
        arrayList2 = new ArrayList(arrayList.size());
        ArrayList arrayList4 = new ArrayList(arrayList);
        for (int i = 0; i < arrayList4.size(); ++i) {
            genPolynomial = (GenPolynomial<GenPolynomial>)arrayList4.get(i);
            if (genPolynomial == null || genPolynomial.isZERO()) continue;
            ExpVector expVector = genPolynomial.leadingExpVector();
            for (int j = i + 1; j < arrayList4.size(); ++j) {
                ExpVector expVector2;
                GenPolynomial genPolynomial5 = (GenPolynomial)arrayList4.get(j);
                if (genPolynomial5 == null || genPolynomial5.isZERO() || !expVector.equals(expVector2 = genPolynomial5.leadingExpVector())) continue;
                genPolynomial = genPolynomial.sum(genPolynomial5);
                arrayList4.set(j, null);
            }
            arrayList2.add((GenPolynomial<Object>)genPolynomial);
        }
        arrayList = arrayList2;
        logger.info("minGB end with #G = " + arrayList.size());
        return arrayList;
    }

    List<GenPolynomial<C>> minimalGBtesting(List<GenPolynomial<C>> list) {
        Iterator iterator;
        List list2;
        AbelianGroupElem<GenPolynomial<GenPolynomial>> abelianGroupElem;
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList arrayList = new ArrayList(list.size());
        for (GenPolynomial<C> genPolynomial2 : list) {
            if (genPolynomial2 == null || genPolynomial2.isZERO()) continue;
            arrayList.add(genPolynomial2);
        }
        ArrayList<GenPolynomial<Object>> arrayList2 = new ArrayList(arrayList.size());
        while (arrayList.size() > 0) {
            abelianGroupElem = (GenPolynomial)arrayList.remove(0);
            GenPolynomial genPolynomial = abelianGroupElem;
            if (this.red.isTopReducible(arrayList, abelianGroupElem) || this.red.isTopReducible(arrayList2, abelianGroupElem)) {
                if (!logger.isInfoEnabled()) continue;
                ArrayList arrayList3 = new ArrayList(arrayList);
                arrayList3.addAll(arrayList2);
                abelianGroupElem = this.red.normalform(arrayList3, abelianGroupElem);
                if (!((GenPolynomial)abelianGroupElem).isZERO()) {
                    System.out.println("minGB nf(a) != 0 " + abelianGroupElem);
                    list2 = this.red.reducedBooleanClosure(arrayList, abelianGroupElem);
                    if (list2.size() > 1) {
                        System.out.println("minGB not bc: bcH size = " + list2.size());
                        arrayList2.add(genPolynomial);
                        continue;
                    }
                    arrayList2.add(genPolynomial);
                    continue;
                }
                if (!this.isGB(arrayList3)) {
                    System.out.println("minGB not dropped " + genPolynomial);
                    arrayList2.add(genPolynomial);
                    continue;
                }
                System.out.println("minGB dropped " + genPolynomial);
                continue;
            }
            arrayList2.add((GenPolynomial<Object>)abelianGroupElem);
        }
        arrayList = arrayList2;
        Collections.reverse(arrayList);
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ++n2;
            abelianGroupElem = (GenPolynomial)arrayList.remove(0);
            GenPolynomial genPolynomial = abelianGroupElem;
            abelianGroupElem = this.red.normalform(arrayList, abelianGroupElem);
            if (this.red.isBooleanClosed(abelianGroupElem = this.engine.basePrimitivePart(abelianGroupElem))) {
                iterator = new ArrayList<GenPolynomial<Object>>(arrayList);
                iterator.add(abelianGroupElem);
                if (this.isGB(iterator)) {
                    System.out.println("minGB reduced " + genPolynomial + " to " + abelianGroupElem);
                    arrayList.add(abelianGroupElem);
                    continue;
                }
                System.out.println("minGB not reduced " + genPolynomial + " to " + abelianGroupElem);
                arrayList.add(genPolynomial);
                continue;
            }
            System.out.println("minGB not bc: a = " + abelianGroupElem + "\n BC(a) = " + this.red.booleanClosure(abelianGroupElem) + ", BR(a) = " + this.red.booleanRemainder(abelianGroupElem));
            list2 = this.red.reducedBooleanClosure(arrayList, abelianGroupElem);
            if (list2.size() > 1) {
                System.out.println("minGB not bc: bcH size = " + list2.size());
                arrayList.add(genPolynomial);
                continue;
            }
            arrayList.add(genPolynomial);
            for (GenPolynomial genPolynomial2 : list2) {
                GenPolynomial genPolynomial3 = this.engine.basePrimitivePart(genPolynomial2);
                AbelianGroupElem abelianGroupElem2 = genPolynomial3.abs();
            }
        }
        arrayList2 = new ArrayList(arrayList.size());
        for (GenPolynomial genPolynomial : arrayList) {
            abelianGroupElem = genPolynomial.abs();
            arrayList2.add((GenPolynomial<Object>)abelianGroupElem);
        }
        arrayList = arrayList2;
        arrayList2 = new ArrayList(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            abelianGroupElem = (GenPolynomial)arrayList.get(i);
            if (abelianGroupElem == null || ((GenPolynomial)abelianGroupElem).isZERO()) continue;
            iterator = ((GenPolynomial)abelianGroupElem).leadingExpVector();
            for (int j = i + 1; j < arrayList.size(); ++j) {
                ExpVector expVector;
                GenPolynomial genPolynomial = (GenPolynomial)arrayList.get(j);
                if (genPolynomial == null || genPolynomial.isZERO() || !((ExpVector)((Object)iterator)).equals(expVector = genPolynomial.leadingExpVector())) continue;
                abelianGroupElem = ((GenPolynomial)abelianGroupElem).sum(genPolynomial);
                arrayList.set(j, null);
            }
            arrayList2.add((GenPolynomial<Object>)abelianGroupElem);
        }
        arrayList = arrayList2;
        TreeMap<RegularRingElem, ArrayList<GenPolynomial>> treeMap = new TreeMap<RegularRingElem, ArrayList<GenPolynomial>>();
        for (GenPolynomial genPolynomial : arrayList) {
            RegularRingElem regularRingElem = (RegularRingElem)genPolynomial.leadingBaseCoefficient();
            ArrayList<GenPolynomial> arrayList4 = (ArrayList<GenPolynomial>)treeMap.get(regularRingElem = regularRingElem.idempotent());
            if (arrayList4 == null) {
                arrayList4 = new ArrayList<GenPolynomial>();
            }
            arrayList4.add(genPolynomial);
            treeMap.put(regularRingElem, arrayList4);
        }
        System.out.println("\nminGB bd:");
        for (Map.Entry entry : treeMap.entrySet()) {
            System.out.println("\nkey = " + entry.getKey() + ":");
            System.out.println("val = " + entry.getValue());
        }
        System.out.println();
        return arrayList;
    }
}

