/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gbufd.MultiplicativeSet;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.List;
import org.apache.log4j.Logger;

public class MultiplicativeSetCoPrime<C extends GcdRingElem<C>>
extends MultiplicativeSet<C> {
    private static final Logger logger = Logger.getLogger(MultiplicativeSetCoPrime.class);
    protected final GreatestCommonDivisorAbstract<C> engine;

    public MultiplicativeSetCoPrime(GenPolynomialRing<C> genPolynomialRing) {
        super(genPolynomialRing);
        this.engine = GCDFactory.getProxy(genPolynomialRing.coFac);
    }

    protected MultiplicativeSetCoPrime(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list, GreatestCommonDivisorAbstract<C> greatestCommonDivisorAbstract) {
        super(genPolynomialRing, list);
        this.engine = greatestCommonDivisorAbstract;
    }

    @Override
    public String toString() {
        return "MultiplicativeSetCoPrime" + this.mset;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MultiplicativeSetCoPrime)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public MultiplicativeSetCoPrime<C> add(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return this;
        }
        if (this.ring.coFac.isField()) {
            genPolynomial = genPolynomial.monic();
        }
        if (this.mset.size() == 0) {
            List<GenPolynomial<C>> list = this.engine.coPrime(genPolynomial, this.mset);
            if (this.ring.coFac.isField()) {
                list = PolyUtil.monic(list);
            }
            return new MultiplicativeSetCoPrime<C>(this.ring, list, this.engine);
        }
        GenPolynomial<C> genPolynomial2 = this.removeFactors(genPolynomial);
        if (genPolynomial2.isConstant()) {
            logger.info("skipped unit or constant = " + genPolynomial2);
            return this;
        }
        logger.info("added to co-prime mset = " + genPolynomial2);
        List<GenPolynomial<C>> list = this.engine.coPrime(genPolynomial2, this.mset);
        if (this.ring.coFac.isField()) {
            list = PolyUtil.monic(list);
        }
        return new MultiplicativeSetCoPrime<C>(this.ring, list, this.engine);
    }

    @Override
    public MultiplicativeSetCoPrime<C> replace(List<GenPolynomial<C>> list) {
        MultiplicativeSet multiplicativeSet = new MultiplicativeSetCoPrime<C>(this.ring);
        if (list == null || list.size() == 0) {
            return multiplicativeSet;
        }
        for (GenPolynomial<C> genPolynomial : list) {
            multiplicativeSet = multiplicativeSet.add((GenPolynomial)genPolynomial);
        }
        return multiplicativeSet;
    }
}

