/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gbufd.GroebnerBaseRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class GroebnerBaseRationalTest
extends TestCase {
    private static final Logger logger = Logger.getLogger(GroebnerBaseRationalTest.class);
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    List<GenPolynomial<BigRational>> Lp;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    List<GenPolynomial<BigRational>> Gp;
    GroebnerBaseAbstract<BigRational> bb;
    GroebnerBaseAbstract<BigRational> bbp;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int threads = 2;
    int rl = 4;
    int kl = 7;
    int ll = 7;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GroebnerBaseRationalTest.suite());
    }

    public GroebnerBaseRationalTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBaseRationalTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new GroebnerBaseRational();
        this.bbp = new GroebnerBaseRational(this.threads);
    }

    protected void tearDown() {
        this.bbp.terminate();
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
        this.bbp = null;
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        GroebnerBaseRationalTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        GroebnerBaseRationalTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( { a } )", (boolean)this.bb.isMinimalGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        GroebnerBaseRationalTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( { a, b } )", (boolean)this.bb.isMinimalGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        GroebnerBaseRationalTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( { a, b, c } )", (boolean)this.bb.isMinimalGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        GroebnerBaseRationalTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( { a, b, c, d } )", (boolean)this.bb.isMinimalGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        GroebnerBaseRationalTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( { a, b, c, d, e } )", (boolean)this.bb.isMinimalGB(this.L));
    }

    public void testParallelGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        GroebnerBaseRationalTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bbp.GB(this.L);
        GroebnerBaseRationalTest.assertTrue((String)"isGB( { a } )", (boolean)this.bbp.isGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( { a } )", (boolean)this.bbp.isMinimalGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bbp.GB(this.L);
        GroebnerBaseRationalTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bbp.isGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( { a, b } )", (boolean)this.bbp.isMinimalGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bbp.GB(this.L);
        GroebnerBaseRationalTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bbp.isGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( { a, b, c } )", (boolean)this.bbp.isMinimalGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bbp.GB(this.L);
        GroebnerBaseRationalTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bbp.isGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( { a, b, c, d } )", (boolean)this.bbp.isMinimalGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.bbp.GB(this.L);
        GroebnerBaseRationalTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bbp.isGB(this.L));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( { a, b, c, d, e } )", (boolean)this.bbp.isMinimalGB(this.L));
    }

    public void testTrinks7GBase() {
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        String string2 = "(x,y,z) L ( ( z y**2 + 2 x + 1/2 )( z x**2 - y**2 - 1/2 x )( -z + y**2 x + 4 x**2 + 1/4 ) )";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseRationalTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseRationalTest.fail((String)("" + iOException));
        }
        this.G = this.bb.GB(this.F.list);
        GroebnerBaseRationalTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( GB(Trinks7) )", (boolean)this.bb.isMinimalGB(this.G));
        GroebnerBaseRationalTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        this.Gp = this.bbp.GB(this.F.list);
        GroebnerBaseRationalTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.Gp));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( GB(Trinks7) )", (boolean)this.bb.isMinimalGB(this.Gp));
        GroebnerBaseRationalTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.Gp.size());
        GroebnerBaseRationalTest.assertEquals((String)"G == Gp: ", this.G, this.Gp);
    }

    public void testTrinks7CompareGBase() {
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseRationalTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseRationalTest.fail((String)("" + iOException));
        }
        long l = System.currentTimeMillis();
        this.G = this.bb.GB(this.F.list);
        l = System.currentTimeMillis() - l;
        GroebnerBaseRationalTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( GB(Trinks7) )", (boolean)this.bb.isMinimalGB(this.G));
        GroebnerBaseRationalTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        long l2 = System.currentTimeMillis();
        this.Gp = this.bbp.GB(this.F.list);
        l2 = System.currentTimeMillis() - l2;
        GroebnerBaseRationalTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbp.isGB(this.G));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( GB(Trinks7) )", (boolean)this.bbp.isMinimalGB(this.G));
        GroebnerBaseRationalTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.Gp.size());
        GroebnerBaseSeq groebnerBaseSeq = new GroebnerBaseSeq();
        long l3 = System.currentTimeMillis();
        List list = groebnerBaseSeq.GB(this.F.list);
        l3 = System.currentTimeMillis() - l3;
        GroebnerBaseRationalTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)groebnerBaseSeq.isGB(list));
        GroebnerBaseRationalTest.assertTrue((String)"isMinimalGB( GB(Trinks7) )", (boolean)groebnerBaseSeq.isMinimalGB(list));
        GroebnerBaseRationalTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)list.size());
        if (logger.isInfoEnabled()) {
            logger.info("time: seq = " + l + ", par = " + l2 + ", rat = " + l3);
        }
        GroebnerBaseRationalTest.assertEquals((String)"GB_r == GB_i", this.G, list);
        GroebnerBaseRationalTest.assertEquals((String)"GB_r == GB_p", this.G, this.Gp);
    }
}

