/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.LeftSolvableReducer;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableMiReducer;
import edu.jas.gb.SolvableReduction;
import edu.jas.gb.SolvableReductionPar;
import edu.jas.gb.TwosidedSolvableReducer;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class SolvableGroebnerBaseParallel<C extends RingElem<C>>
extends SolvableGroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(SolvableGroebnerBaseParallel.class);
    protected final int threads;
    protected final transient ThreadPool pool;

    public SolvableGroebnerBaseParallel() {
        this(2);
    }

    public SolvableGroebnerBaseParallel(int n) {
        this(n, new ThreadPool(n));
    }

    public SolvableGroebnerBaseParallel(int n, ThreadPool threadPool) {
        this(n, threadPool, new SolvableReductionPar());
    }

    public SolvableGroebnerBaseParallel(int n, SolvableReduction<C> solvableReduction) {
        this(n, new ThreadPool(n), solvableReduction);
    }

    public SolvableGroebnerBaseParallel(int n, PairList<C> pairList) {
        this(n, new ThreadPool(n), new SolvableReductionPar(), pairList);
    }

    public SolvableGroebnerBaseParallel(int n, SolvableReduction<C> solvableReduction, PairList<C> pairList) {
        this(n, new ThreadPool(n), solvableReduction, pairList);
    }

    public SolvableGroebnerBaseParallel(int n, ThreadPool threadPool, SolvableReduction<C> solvableReduction) {
        this(n, threadPool, solvableReduction, new OrderedPairlist());
    }

    public SolvableGroebnerBaseParallel(int n, ThreadPool threadPool, SolvableReduction<C> solvableReduction, PairList<C> pairList) {
        super(solvableReduction, pairList);
        if (!(solvableReduction instanceof SolvableReductionPar)) {
            logger.warn("parallel GB should use parallel aware reduction");
        }
        if (n < 1) {
            n = 1;
        }
        this.threads = n;
        this.pool = threadPool;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.terminate();
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftGB(int n, List<GenSolvablePolynomial<C>> list) {
        List<GenSolvablePolynomial<C>> list2 = new ArrayList<GenSolvablePolynomial<C>>();
        if (list == null) {
            return list2;
        }
        PairList pairList = null;
        int n2 = list.size();
        ListIterator<GenSolvablePolynomial<C>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GenPolynomial genPolynomial = listIterator.next();
            if (genPolynomial.length() > 0) {
                if ((genPolynomial = ((GenSolvablePolynomial)genPolynomial).monic()).isONE()) {
                    list2.clear();
                    list2.add((GenSolvablePolynomial<C>)genPolynomial);
                    return list2;
                }
                list2.add((GenSolvablePolynomial<C>)genPolynomial);
                if (pairList == null) {
                    pairList = this.strategy.create(n, ((GenSolvablePolynomial)genPolynomial).ring);
                    if (!((GenSolvablePolynomial)genPolynomial).ring.coFac.isField()) {
                        throw new IllegalArgumentException("coefficients not from a field");
                    }
                }
                pairList.put(genPolynomial);
                continue;
            }
            --n2;
        }
        if (n2 <= 1) {
            return list2;
        }
        Terminator terminator = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            LeftSolvableReducer<C> leftSolvableReducer = new LeftSolvableReducer<C>(terminator, list2, pairList);
            this.pool.addJob(leftSolvableReducer);
        }
        terminator.waitDone();
        logger.debug("#parallel list = " + list2.size());
        list2 = this.leftMinimalGB(list2);
        logger.info("" + pairList);
        return list2;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftMinimalGB(List<GenSolvablePolynomial<C>> list) {
        GenSolvablePolynomial<C> genSolvablePolynomial;
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(list.size());
        ListIterator<GenSolvablePolynomial<Object>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            genSolvablePolynomial = listIterator.next();
            if (genSolvablePolynomial.length() == 0) continue;
            arrayList.add(genSolvablePolynomial);
        }
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList2 = new ArrayList<GenSolvablePolynomial<C>>(arrayList.size());
        while (arrayList.size() > 0) {
            ExpVector expVector;
            GenSolvablePolynomial<Object> genSolvablePolynomial2;
            genSolvablePolynomial = arrayList.remove(0);
            ExpVector expVector2 = genSolvablePolynomial.leadingExpVector();
            listIterator = arrayList.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genSolvablePolynomial2 = listIterator.next();
                expVector = genSolvablePolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() && !bl) {
                genSolvablePolynomial2 = listIterator.next();
                expVector = genSolvablePolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            if (bl) continue;
            arrayList2.add(genSolvablePolynomial);
        }
        arrayList = arrayList2;
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        SolvableMiReducer[] solvableMiReducerArray = new SolvableMiReducer[arrayList.size()];
        int n = 0;
        arrayList2 = new ArrayList(arrayList.size());
        while (arrayList.size() > 0) {
            genSolvablePolynomial = arrayList.remove(0);
            ArrayList arrayList3 = new ArrayList(arrayList.size() + arrayList2.size());
            arrayList3.addAll(arrayList);
            arrayList3.addAll(arrayList2);
            solvableMiReducerArray[n] = new SolvableMiReducer(arrayList3, genSolvablePolynomial);
            this.pool.addJob(solvableMiReducerArray[n]);
            ++n;
            arrayList2.add(genSolvablePolynomial);
        }
        arrayList = arrayList2;
        arrayList2 = new ArrayList(arrayList.size());
        for (n = 0; n < solvableMiReducerArray.length; ++n) {
            genSolvablePolynomial = solvableMiReducerArray[n].getNF();
            arrayList2.add(genSolvablePolynomial);
        }
        return arrayList2;
    }

    @Override
    public SolvableExtendedGB<C> extLeftGB(int n, List<GenSolvablePolynomial<C>> list) {
        throw new UnsupportedOperationException("parallel extLeftGB not implemented");
    }

    @Override
    public List<GenSolvablePolynomial<C>> twosidedGB(int n, List<GenSolvablePolynomial<C>> list) {
        GenPolynomial genPolynomial;
        if (list == null || list.size() == 0) {
            return new ArrayList<GenSolvablePolynomial<C>>();
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list.get((int)0).ring;
        List list2 = PolynomialList.castToSolvableList(genSolvablePolynomialRing.generators(n));
        logger.info("right multipliers = " + list2);
        ArrayList arrayList = new ArrayList(list.size() * (1 + list2.size()));
        arrayList.addAll(list);
        for (int i = 0; i < arrayList.size(); ++i) {
            genPolynomial = (GenSolvablePolynomial)arrayList.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                GenSolvablePolynomial genSolvablePolynomial = list2.get(j);
                if (genSolvablePolynomial.isONE()) continue;
                GenSolvablePolynomial genSolvablePolynomial2 = ((GenSolvablePolynomial)genPolynomial).multiply(genSolvablePolynomial);
                if ((genSolvablePolynomial2 = this.sred.leftNormalform(arrayList, genSolvablePolynomial2)).isZERO()) continue;
                arrayList.add(genSolvablePolynomial2);
            }
        }
        List<GenSolvablePolynomial<C>> list3 = new ArrayList<GenSolvablePolynomial<C>>();
        PairList pairList = null;
        int n2 = arrayList.size();
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            genPolynomial = (GenSolvablePolynomial)listIterator.next();
            if (genPolynomial.length() > 0) {
                if ((genPolynomial = ((GenSolvablePolynomial)genPolynomial).monic()).isONE()) {
                    list3.clear();
                    list3.add((GenSolvablePolynomial<C>)genPolynomial);
                    return list3;
                }
                list3.add((GenSolvablePolynomial<C>)genPolynomial);
                if (pairList == null) {
                    pairList = this.strategy.create(n, ((GenSolvablePolynomial)genPolynomial).ring);
                    if (!((GenSolvablePolynomial)genPolynomial).ring.coFac.isField()) {
                        throw new IllegalArgumentException("coefficients not from a field");
                    }
                }
                pairList.put(genPolynomial);
                continue;
            }
            --n2;
        }
        if (n2 <= 1) {
            return list3;
        }
        Terminator terminator = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            TwosidedSolvableReducer twosidedSolvableReducer = new TwosidedSolvableReducer(terminator, n, list2, list3, pairList);
            this.pool.addJob(twosidedSolvableReducer);
        }
        terminator.waitDone();
        logger.debug("#parallel list = " + list3.size());
        list3 = this.leftMinimalGB(list3);
        logger.info("" + pairList);
        return list3;
    }
}

