/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.SolvableReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import java.util.List;
import org.apache.log4j.Logger;

class LeftSolvableReducer<C extends RingElem<C>>
implements Runnable {
    private final List<GenSolvablePolynomial<C>> G;
    private final PairList<C> pairlist;
    private final Terminator pool;
    private final SolvableReductionPar<C> sred;
    private static final Logger logger = Logger.getLogger(LeftSolvableReducer.class);
    private static final boolean debug = logger.isDebugEnabled();

    LeftSolvableReducer(Terminator terminator, List<GenSolvablePolynomial<C>> list, PairList<C> pairList) {
        this.pool = terminator;
        this.G = list;
        this.pairlist = pairList;
        this.sred = new SolvableReductionPar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (this.pairlist.hasNext() || this.pool.hasJobs()) {
            List<GenSolvablePolynomial<C>> list;
            GenSolvablePolynomial genSolvablePolynomial;
            Pair<C> pair;
            while (!this.pairlist.hasNext()) {
                this.pool.beIdle();
                bl = true;
                try {
                    if (++n2 % 10 == 0) {
                        logger.info(" reducer is sleeping");
                    } else {
                        logger.debug("r");
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    this.pool.allIdle();
                    logger.info("shutdown " + this.pool + " after: " + interruptedException);
                    break;
                }
                if (Thread.currentThread().isInterrupted()) {
                    this.pool.allIdle();
                    logger.info("shutdown after .isInterrupted(): " + this.pool);
                    break;
                }
                if (this.pool.hasJobs()) continue;
            }
            if (!this.pairlist.hasNext() && !this.pool.hasJobs()) break;
            if (bl) {
                this.pool.notIdle();
                bl = false;
            }
            if ((pair = this.pairlist.removeNext()) == null) continue;
            if (debug) {
                logger.debug("pi = " + pair.pi);
                logger.debug("pj = " + pair.pj);
            }
            if ((genSolvablePolynomial = this.sred.leftSPolynomial((GenSolvablePolynomial)pair.pi, (GenSolvablePolynomial)pair.pj)).isZERO()) continue;
            if (debug) {
                logger.debug("ht(S) = " + genSolvablePolynomial.leadingExpVector());
            }
            GenPolynomial genPolynomial = this.sred.leftNormalform(this.G, genSolvablePolynomial);
            ++n;
            if (genPolynomial.isZERO()) continue;
            if (debug) {
                logger.debug("ht(H) = " + genPolynomial.leadingExpVector());
            }
            if ((genPolynomial = ((GenSolvablePolynomial)genPolynomial).monic()).isONE()) {
                this.pairlist.putOne();
                list = this.G;
                synchronized (list) {
                    this.G.clear();
                    this.G.add((GenSolvablePolynomial<C>)genPolynomial);
                }
                this.pool.allIdle();
                return;
            }
            if (debug) {
                logger.debug("H = " + genPolynomial);
            }
            list = this.G;
            synchronized (list) {
                this.G.add((GenSolvablePolynomial<C>)genPolynomial);
            }
            this.pairlist.put(genPolynomial);
        }
        logger.info("terminated, done " + n + " reductions");
    }
}

