/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBTransportMess;
import edu.jas.gb.GBTransportMessEnd;
import edu.jas.gb.GBTransportMessPoly;
import edu.jas.gb.GroebnerBaseDistributedHybrid;
import edu.jas.gb.PairList;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistHashTable;
import edu.jas.util.TaggedSocketChannel;
import edu.jas.util.Terminator;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

class HybridReducerReceiver<C extends RingElem<C>>
extends Thread {
    public static final Logger logger = Logger.getLogger(HybridReducerReceiver.class);
    public final boolean debug = logger.isDebugEnabled();
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final PairList<C> pairlist;
    private final TaggedSocketChannel pairChannel;
    private final Terminator finner;
    private final int threadsPerNode;
    private final AtomicInteger active;
    private volatile boolean goon;
    public final Integer pairTag = GroebnerBaseDistributedHybrid.pairTag;
    public final Integer resultTag = GroebnerBaseDistributedHybrid.resultTag;
    public final Integer ackTag = GroebnerBaseDistributedHybrid.ackTag;

    HybridReducerReceiver(int n, Terminator terminator, AtomicInteger atomicInteger, TaggedSocketChannel taggedSocketChannel, DistHashTable<Integer, GenPolynomial<C>> distHashTable, PairList<C> pairList) {
        this.active = atomicInteger;
        this.threadsPerNode = n;
        this.finner = terminator;
        this.pairChannel = taggedSocketChannel;
        this.theList = distHashTable;
        this.pairlist = pairList;
        this.goon = true;
    }

    @Override
    public void run() {
        GenPolynomial genPolynomial = null;
        int n = 0;
        int n2 = -1;
        while (this.goon) {
            logger.debug("receive result");
            Object object = null;
            try {
                object = this.pairChannel.receive(this.resultTag);
                int n3 = this.active.getAndDecrement();
            }
            catch (InterruptedException interruptedException) {
                this.goon = false;
                break;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.goon = false;
                this.finner.initIdle(1);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                this.goon = false;
                this.finner.initIdle(1);
                break;
            }
            logger.info("received H polynomial");
            if (object == null) {
                if (this.isInterrupted()) {
                    this.goon = false;
                    this.finner.initIdle(1);
                    break;
                }
            } else {
                if (object instanceof GBTransportMessEnd) {
                    logger.info("received GBTransportMessEnd");
                    this.goon = false;
                    break;
                }
                if (object instanceof GBTransportMessPoly) {
                    ++n;
                    GBTransportMessPoly gBTransportMessPoly = (GBTransportMessPoly)object;
                    genPolynomial = gBTransportMessPoly.pol;
                    if (genPolynomial != null) {
                        if (this.debug) {
                            logger.info("H = " + genPolynomial.leadingExpVector());
                        }
                        if (!genPolynomial.isZERO()) {
                            GenPolynomial genPolynomial2;
                            if (genPolynomial.isONE()) {
                                n2 = this.pairlist.putOne();
                                genPolynomial2 = this.theList.put(n2, genPolynomial);
                                if (genPolynomial2 != null) {
                                    logger.info("double polynomials nn = " + genPolynomial2 + ", H = " + genPolynomial);
                                }
                            } else {
                                n2 = this.pairlist.put(genPolynomial);
                                genPolynomial2 = this.theList.put(n2, genPolynomial);
                                if (genPolynomial2 != null) {
                                    logger.info("double polynomials nn = " + genPolynomial2 + ", H = " + genPolynomial);
                                }
                            }
                        }
                    }
                }
            }
            this.finner.initIdle(1);
            try {
                this.pairChannel.send(this.ackTag, new GBTransportMess());
                logger.debug("send acknowledgement");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.goon = false;
                break;
            }
        }
        this.goon = false;
        logger.info("terminated, received " + n + " reductions");
    }

    public void terminate() {
        this.goon = false;
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.debug("HybridReducerReceiver terminated");
    }
}

