/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.DReduction;
import edu.jas.gb.ReductionAbstract;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class DReductionSeq<C extends RingElem<C>>
extends ReductionAbstract<C>
implements DReduction<C> {
    private static final Logger logger = Logger.getLogger(DReductionSeq.class);

    @Override
    public boolean isTopReducible(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return false;
        }
        boolean bl = false;
        ExpVector expVector = genPolynomial.leadingExpVector();
        C c = genPolynomial.leadingBaseCoefficient();
        for (GenPolynomial<C> genPolynomial2 : list) {
            C c2;
            RingElem ringElem;
            bl = expVector.multipleOf(genPolynomial2.leadingExpVector());
            if (!bl || !(bl = (ringElem = (RingElem)c.remainder(c2 = genPolynomial2.leadingBaseCoefficient())).isZERO())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNormalform(List<GenPolynomial<C>> expVectorArray, GenPolynomial<C> genPolynomial) {
        if (expVectorArray == null || expVectorArray.isEmpty()) {
            return true;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return true;
        }
        ExpVector[] expVectorArray2 = expVectorArray;
        synchronized (expVectorArray) {
            int n;
            int n2 = expVectorArray.size();
            GenPolynomial[] genPolynomialArray = new GenPolynomial[n2];
            for (int i = 0; i < expVectorArray.size(); ++i) {
                genPolynomialArray[i] = expVectorArray.get(i);
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            expVectorArray2 = new ExpVector[n2];
            RingElem[] ringElemArray = new RingElem[n2];
            GenPolynomial[] genPolynomialArray2 = new GenPolynomial[n2];
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                genPolynomialArray2[n] = genPolynomialArray[n];
                Map.Entry entry = genPolynomialArray2[n].leadingMonomial();
                if (entry == null) continue;
                genPolynomialArray2[n3] = genPolynomialArray2[n];
                expVectorArray2[n3] = entry.getKey();
                ringElemArray[n3] = (RingElem)entry.getValue();
                ++n3;
            }
            n2 = n3;
            boolean bl = false;
            SortedMap<ExpVector, C> sortedMap = genPolynomial.getMap();
            for (Map.Entry entry : sortedMap.entrySet()) {
                ExpVector expVector = (ExpVector)entry.getKey();
                RingElem ringElem = (RingElem)entry.getValue();
                for (n = 0; n < n2; ++n) {
                    RingElem ringElem2;
                    bl = expVector.multipleOf(expVectorArray2[n]);
                    if (!bl || !(bl = (ringElem2 = ringElem.remainder(ringElemArray[n])).isZERO())) continue;
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenPolynomial<C> normalform(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        int n;
        GenPolynomial[] genPolynomialArray;
        int n2;
        if (list == null || list.isEmpty()) {
            return genPolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        Map.Entry<ExpVector, C> entry = list;
        synchronized (entry) {
            n2 = list.size();
            genPolynomialArray = new GenPolynomial[n2];
            for (int i = 0; i < list.size(); ++i) {
                genPolynomialArray[i] = list.get(i).abs();
            }
        }
        ExpVector[] expVectorArray = new ExpVector[n2];
        RingElem[] ringElemArray = new RingElem[n2];
        GenPolynomial[] genPolynomialArray2 = new GenPolynomial[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            genPolynomialArray2[n] = genPolynomialArray[n];
            entry = genPolynomialArray2[n].leadingMonomial();
            if (entry == null) continue;
            genPolynomialArray2[n3] = genPolynomialArray2[n];
            expVectorArray[n3] = entry.getKey();
            ringElemArray[n3] = (RingElem)entry.getValue();
            ++n3;
        }
        n2 = n3;
        RingElem ringElem = null;
        boolean bl = false;
        GenPolynomial<RingElem> genPolynomial2 = genPolynomial.ring.getZERO();
        GenPolynomial<RingElem> genPolynomial3 = null;
        GenPolynomial<Object> genPolynomial4 = genPolynomial;
        while (genPolynomial4.length() > 0) {
            entry = genPolynomial4.leadingMonomial();
            ExpVector expVector = entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            for (n = 0; n < n2; ++n) {
                bl = expVector.multipleOf(expVectorArray[n]);
                if (bl) {
                    ringElem = ringElem2.remainder(ringElemArray[n]);
                    bl = ringElem.isZERO();
                }
                if (bl) break;
            }
            if (!bl) {
                genPolynomial2 = genPolynomial2.sum(ringElem2, expVector);
                genPolynomial4 = genPolynomial4.reductum();
                continue;
            }
            ExpVector expVector2 = expVector.subtract(expVectorArray[n]);
            RingElem ringElem3 = ringElem2.divide(ringElemArray[n]);
            genPolynomial2 = genPolynomial2.sum(ringElem, expVector);
            genPolynomial3 = genPolynomialArray2[n].multiply(ringElem3, expVector2);
            genPolynomial4 = genPolynomial4.reductum().subtract(genPolynomial3.reductum());
        }
        return genPolynomial2.abs();
    }

    @Override
    public GenPolynomial<C> SPolynomial(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (logger.isInfoEnabled()) {
            if (genPolynomial2 == null || genPolynomial2.isZERO()) {
                return genPolynomial.ring.getZERO();
            }
            if (genPolynomial == null || genPolynomial.isZERO()) {
                return genPolynomial2.ring.getZERO();
            }
            if (!genPolynomial.ring.equals(genPolynomial2.ring)) {
                logger.error("rings not equal");
            }
        }
        Map.Entry<ExpVector, C> entry = genPolynomial.leadingMonomial();
        Map.Entry<ExpVector, C> entry2 = genPolynomial2.leadingMonomial();
        ExpVector expVector = entry.getKey();
        ExpVector expVector2 = entry2.getKey();
        ExpVector expVector3 = expVector.lcm(expVector2);
        ExpVector expVector4 = expVector3.subtract(expVector);
        ExpVector expVector5 = expVector3.subtract(expVector2);
        RingElem ringElem = (RingElem)entry.getValue();
        RingElem ringElem2 = (RingElem)entry2.getValue();
        RingElem ringElem3 = ringElem.gcd(ringElem2);
        RingElem ringElem4 = ringElem.multiply(ringElem2);
        RingElem ringElem5 = ringElem4.divide(ringElem3);
        RingElem ringElem6 = ringElem5.divide(ringElem);
        RingElem ringElem7 = ringElem5.divide(ringElem2);
        GenPolynomial<RingElem> genPolynomial3 = genPolynomial.multiply(ringElem6, expVector4);
        GenPolynomial<RingElem> genPolynomial4 = genPolynomial2.multiply(ringElem7, expVector5);
        GenPolynomial<GenPolynomial<RingElem>> genPolynomial5 = genPolynomial3.subtract((RingElem)genPolynomial4);
        return genPolynomial5;
    }

    @Override
    public GenPolynomial<C> GPolynomial(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (logger.isInfoEnabled()) {
            if (genPolynomial2 == null || genPolynomial2.isZERO()) {
                return genPolynomial.ring.getZERO();
            }
            if (genPolynomial == null || genPolynomial.isZERO()) {
                return genPolynomial2.ring.getZERO();
            }
            if (!genPolynomial.ring.equals(genPolynomial2.ring)) {
                logger.error("rings not equal");
            }
        }
        Map.Entry<ExpVector, C> entry = genPolynomial.leadingMonomial();
        Map.Entry<ExpVector, C> entry2 = genPolynomial2.leadingMonomial();
        ExpVector expVector = entry.getKey();
        ExpVector expVector2 = entry2.getKey();
        ExpVector expVector3 = expVector.lcm(expVector2);
        ExpVector expVector4 = expVector3.subtract(expVector);
        ExpVector expVector5 = expVector3.subtract(expVector2);
        RingElem ringElem = (RingElem)entry.getValue();
        RingElem ringElem2 = (RingElem)entry2.getValue();
        RingElem[] ringElemArray = ringElem.egcd(ringElem2);
        GenPolynomial<RingElem> genPolynomial3 = genPolynomial.multiply(ringElemArray[1], expVector4);
        GenPolynomial<RingElem> genPolynomial4 = genPolynomial2.multiply(ringElemArray[2], expVector5);
        GenPolynomial<GenPolynomial<RingElem>> genPolynomial5 = genPolynomial3.sum((RingElem)genPolynomial4);
        return genPolynomial5;
    }

    @Override
    public GenPolynomial<C> GPolynomial(List<GenPolynomial<C>> list, int n, GenPolynomial<C> genPolynomial, int n2, GenPolynomial<C> genPolynomial2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public boolean criterion4(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, ExpVector expVector) {
        C c;
        C c2;
        C c3;
        ExpVector expVector2;
        ExpVector expVector3;
        ExpVector expVector4;
        ExpVector expVector5;
        int n;
        if (logger.isInfoEnabled()) {
            if (!genPolynomial.ring.equals(genPolynomial2.ring)) {
                logger.error("rings equal");
            }
            if (genPolynomial instanceof GenSolvablePolynomial || genPolynomial2 instanceof GenSolvablePolynomial) {
                logger.error("GBCriterion4 not applicabable to SolvablePolynomials");
                return true;
            }
        }
        return (n = (expVector5 = (expVector4 = (expVector3 = genPolynomial.leadingExpVector()).sum(expVector2 = genPolynomial2.leadingExpVector())).subtract(expVector)).signum()) != 0 || !(c3 = (c2 = genPolynomial.leadingBaseCoefficient()).gcd(c = genPolynomial2.leadingBaseCoefficient())).isONE();
    }

    @Override
    public boolean criterion4(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        C c;
        C c2;
        C c3;
        ExpVector expVector;
        ExpVector expVector2;
        if (logger.isInfoEnabled() && (genPolynomial instanceof GenSolvablePolynomial || genPolynomial2 instanceof GenSolvablePolynomial)) {
            logger.error("GBCriterion4 not applicabable to SolvablePolynomials");
            return true;
        }
        ExpVector expVector3 = genPolynomial.leadingExpVector();
        ExpVector expVector4 = expVector3.sum(expVector2 = genPolynomial2.leadingExpVector());
        ExpVector expVector5 = expVector4.subtract(expVector = expVector3.lcm(expVector2));
        int n = expVector5.signum();
        return n != 0 || !(c3 = (c2 = genPolynomial.leadingBaseCoefficient()).gcd(c = genPolynomial2.leadingBaseCoefficient())).isONE();
    }

    @Override
    public GenPolynomial<C> normalform(List<GenPolynomial<C>> list, List<GenPolynomial<C>> list2, GenPolynomial<C> genPolynomial) {
        if (list2 == null || list2.isEmpty()) {
            return genPolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public List<GenPolynomial<C>> irreducibleSet(List<GenPolynomial<C>> list) {
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        if (list == null) {
            return null;
        }
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial.isZERO()) continue;
            arrayList.add(genPolynomial);
        }
        int n = arrayList.size();
        if (n <= 1) {
            return arrayList;
        }
        int n2 = 0;
        logger.debug("irr = ");
        while (n2 != n) {
            GenPolynomial<C> genPolynomial = arrayList.remove(0);
            ExpVector expVector = genPolynomial.leadingExpVector();
            genPolynomial = this.normalform(arrayList, genPolynomial);
            logger.debug(String.valueOf(n2));
            if (genPolynomial.isZERO()) {
                if (--n > 1) continue;
                return arrayList;
            }
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            n2 = expVector.equals(expVector2) ? ++n2 : 0;
            arrayList.add(genPolynomial);
        }
        return arrayList;
    }
}

