/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.CReductionSeq;
import edu.jas.application.ColorPolynomial;
import edu.jas.application.ColoredSystem;
import edu.jas.application.Condition;
import edu.jas.application.Ideal;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.AbelianGroupElem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ReductionTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    PolynomialList<BigRational> G;
    int rl = 2;
    int kl = 2;
    int ll = 3;
    int el = 3;
    float q = 0.4f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ReductionTest.suite());
        ComputerThreads.terminate();
    }

    public ReductionTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ReductionTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenPolynomialRing<BigRational>(new BigRational(0L), this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testRatPolReduction() {
        BigRational bigRational = new BigRational(0L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 2, new String[]{"a", "b"});
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(genPolynomialRing, this.rl);
        CReductionSeq<BigRational> cReductionSeq = new CReductionSeq<BigRational>(bigRational);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing2.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isZERO()) {
            genPolynomial = genPolynomialRing2.random(this.kl, this.ll, this.el, this.q).sum((BigRational)genPolynomialRing2.getONE());
        }
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial2.isZERO()) {
            genPolynomial2 = genPolynomialRing2.random(this.kl, this.ll, this.el, this.q).subtract((BigRational)genPolynomialRing2.getONE());
        }
        AbelianGroupElem abelianGroupElem = genPolynomialRing2.getZERO();
        Map.Entry<ExpVector, BigRational> entry = genPolynomial.leadingMonomial();
        ExpVector expVector = entry.getKey();
        GenPolynomial genPolynomial3 = (GenPolynomial)((Object)entry.getValue());
        GenPolynomial genPolynomial4 = genPolynomialRing2.getZERO();
        if ((genPolynomial4 = genPolynomial4.sum(genPolynomial3, expVector)).isZERO()) {
            genPolynomial4 = genPolynomialRing2.getONE();
        }
        GenPolynomial<BigRational> genPolynomial5 = genPolynomial.reductum();
        ColorPolynomial colorPolynomial = new ColorPolynomial(abelianGroupElem, genPolynomial4, genPolynomial5);
        ReductionTest.assertTrue((String)"check(p) ", (boolean)colorPolynomial.checkInvariant());
        ReductionTest.assertTrue((String)"deter(p) ", (boolean)colorPolynomial.isDetermined());
        colorPolynomial = new ColorPolynomial(genPolynomial4, abelianGroupElem, genPolynomial5);
        ReductionTest.assertTrue((String)"check(p) ", (boolean)colorPolynomial.checkInvariant());
        if (!genPolynomial5.isZERO()) {
            ReductionTest.assertFalse((String)"deter(p) ", (boolean)colorPolynomial.isDetermined());
        }
        colorPolynomial = new ColorPolynomial(genPolynomial4, genPolynomial5, abelianGroupElem);
        ReductionTest.assertTrue((String)"check(p) ", (boolean)colorPolynomial.checkInvariant());
        ReductionTest.assertTrue((String)"deter(p) ", (boolean)colorPolynomial.isDetermined());
        colorPolynomial = new ColorPolynomial(genPolynomial5, abelianGroupElem, abelianGroupElem);
        ReductionTest.assertTrue((String)"check(p) ", (boolean)colorPolynomial.checkInvariant());
        ReductionTest.assertTrue((String)"deter(p) ", (boolean)colorPolynomial.isDetermined());
        ReductionTest.assertTrue((String)"p == 0 ", (boolean)colorPolynomial.isZERO());
        ArrayList arrayList = new ArrayList();
        Ideal<BigRational> ideal = new Ideal<BigRational>(genPolynomialRing, arrayList);
        ArrayList arrayList2 = new ArrayList();
        Condition<BigRational> condition = new Condition<BigRational>(ideal);
        ColoredSystem<BigRational> coloredSystem = new ColoredSystem<BigRational>(condition, arrayList2);
        ReductionTest.assertTrue((String)"isDetermined ", (boolean)coloredSystem.isDetermined());
        ReductionTest.assertTrue((String)"checkInvariant ", (boolean)coloredSystem.checkInvariant());
        ArrayList<ColoredSystem<BigRational>> arrayList3 = new ArrayList<ColoredSystem<BigRational>>();
        arrayList3.add(coloredSystem);
        List<Object> list = arrayList3;
        for (ColoredSystem colorPolynomial2 : arrayList3) {
            ReductionTest.assertTrue((String)"isDetermined ", (boolean)colorPolynomial2.isDetermined());
            ReductionTest.assertTrue((String)"checkInvariant ", (boolean)colorPolynomial2.checkInvariant());
        }
        ArrayList arrayList4 = new ArrayList();
        arrayList4.add(genPolynomial);
        arrayList4.add(genPolynomial2);
        list = cReductionSeq.determine(arrayList4);
        for (ColoredSystem coloredSystem2 : list) {
            ReductionTest.assertTrue((String)"isDetermined ", (boolean)coloredSystem2.isDetermined());
            ReductionTest.assertTrue((String)"checkInvariant ", (boolean)coloredSystem2.checkInvariant());
        }
        for (ColoredSystem coloredSystem3 : list) {
            int n = coloredSystem3.list.size();
            for (int i = 0; i < n; ++i) {
                colorPolynomial = coloredSystem3.list.get(i);
                for (int j = i + 1; j < n; ++j) {
                    ColorPolynomial colorPolynomial2 = coloredSystem3.list.get(j);
                    ColorPolynomial<BigRational> colorPolynomial3 = cReductionSeq.SPolynomial(colorPolynomial, colorPolynomial2);
                    boolean bl = true;
                    ColorPolynomial<BigRational> colorPolynomial4 = cReductionSeq.normalform(coloredSystem3.condition, coloredSystem3.list, colorPolynomial3);
                    bl = cReductionSeq.isNormalform(coloredSystem3.list, colorPolynomial4);
                    ReductionTest.assertTrue((String)"isNF(NF(spol(a,b))) ", (boolean)bl);
                }
            }
        }
    }
}

