/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties.computation;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.SwingUtilities;
import userinterface.properties.GUIExperiment;
import userinterface.properties.GUIMultiProperties;
import userinterface.util.GUIComputationEvent;

public class ExportResultsThread
extends Thread {
    private GUIMultiProperties parent;
    private GUIExperiment[] exps;
    private File f;
    private Exception saveError;
    private boolean exportMatrix;
    private String sep;

    public ExportResultsThread(GUIMultiProperties gUIMultiProperties, GUIExperiment gUIExperiment, File file) {
        this.parent = gUIMultiProperties;
        this.exps = new GUIExperiment[1];
        this.exps[0] = gUIExperiment;
        this.f = file;
        this.exportMatrix = false;
        this.sep = " ";
    }

    public ExportResultsThread(GUIMultiProperties gUIMultiProperties, GUIExperiment[] gUIExperimentArray, File file) {
        this.parent = gUIMultiProperties;
        this.exps = gUIExperimentArray;
        this.f = file;
        this.exportMatrix = false;
        this.sep = " ";
    }

    public ExportResultsThread(GUIMultiProperties gUIMultiProperties, GUIExperiment[] gUIExperimentArray, File file, boolean bl, String string) {
        this.parent = gUIMultiProperties;
        this.exps = gUIExperimentArray;
        this.f = file;
        this.exportMatrix = bl;
        this.sep = string;
    }

    @Override
    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExportResultsThread.this.parent.startProgress();
                ExportResultsThread.this.parent.notifyEventListeners(new GUIComputationEvent(0, ExportResultsThread.this.parent));
                ExportResultsThread.this.parent.setTaskBarText("Exporting results...");
            }
        });
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.f));
            int n = this.exps.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    printWriter.println();
                }
                if (n > 1) {
                    if (this.sep.equals(", ")) {
                        printWriter.print("\"" + this.exps[i].getPropertyString() + ":\"\n");
                    } else {
                        printWriter.print(this.exps[i].getPropertyString() + ":\n");
                    }
                }
                if (!this.exportMatrix) {
                    printWriter.println(this.exps[i].getResults().toString(false, this.sep, this.sep));
                    continue;
                }
                printWriter.println(this.exps[i].getResults().toStringMatrix(this.sep));
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExportResultsThread.this.parent.stopProgress();
                    ExportResultsThread.this.parent.notifyEventListeners(new GUIComputationEvent(2, ExportResultsThread.this.parent));
                    ExportResultsThread.this.parent.setTaskBarText("Exporting results... error.");
                    ExportResultsThread.this.parent.error("Could not export results: " + ExportResultsThread.this.saveError.getMessage());
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExportResultsThread.this.parent.stopProgress();
                ExportResultsThread.this.parent.setTaskBarText("Exporting results... done.");
                ExportResultsThread.this.parent.notifyEventListeners(new GUIComputationEvent(1, ExportResultsThread.this.parent));
            }
        });
    }
}

