/*
 * Decompiled with CFR 0.152.
 */
package simulator.sampler;

import prism.ModelGenerator;
import prism.PrismException;
import simulator.Path;
import simulator.sampler.Sampler;

public abstract class SamplerBoolean
extends Sampler {
    protected boolean value;
    protected boolean negated = false;
    protected int numSamples;
    protected int numTrue;

    @Override
    public void reset() {
        this.valueKnown = false;
        this.value = false;
    }

    @Override
    public void resetStats() {
        this.numSamples = 0;
        this.numTrue = 0;
    }

    @Override
    public abstract boolean update(Path var1, ModelGenerator var2) throws PrismException;

    @Override
    public void updateStats() {
        ++this.numSamples;
        if (this.value != this.negated) {
            ++this.numTrue;
        }
    }

    @Override
    public Object getCurrentValue() {
        return new Boolean(this.value != this.negated);
    }

    @Override
    public double getMeanValue() {
        return (double)this.numTrue / (double)this.numSamples;
    }

    @Override
    public double getVariance() {
        if (this.numSamples <= 1) {
            return 0.0;
        }
        return (double)this.numTrue * ((double)this.numSamples - (double)this.numTrue) / ((double)this.numSamples * ((double)this.numSamples - 1.0));
    }

    @Override
    public double getLikelihoodRatio(double d, double d2) throws PrismException {
        return Math.pow(d / d2, this.numTrue) * Math.pow((1.0 - d) / (1.0 - d2), this.numSamples - this.numTrue);
    }

    public boolean negate() {
        this.negated = !this.negated;
        return this.negated;
    }

    public boolean getNegated() {
        return this.negated;
    }
}

