/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayList;
import java.util.List;
import parser.State;

public abstract class PathDisplayer {
    protected boolean showSnapshots = false;
    protected double snapshotTimeStep = 0.0;
    protected double nextTime = 0.0;
    protected boolean showChangesOnly = true;
    protected List<Integer> varsToShow = null;
    protected boolean showProbs = false;
    protected boolean showRewards = false;

    public boolean getShowSnapshots() {
        return this.showSnapshots;
    }

    public double getSnapshotTimeStep() {
        return this.snapshotTimeStep;
    }

    public boolean getShowChangesOnly() {
        return this.showChangesOnly;
    }

    public boolean getShowProbs() {
        return this.showProbs;
    }

    public boolean getShowRewards() {
        return this.showRewards;
    }

    public void setToShowSteps() {
        this.showSnapshots = false;
    }

    public void setToShowSnapShots(double d) {
        this.showSnapshots = true;
        this.snapshotTimeStep = d;
    }

    public void setShowChangesOnly(boolean bl) {
        this.showChangesOnly = bl;
    }

    public void setVarsToShow(List<Integer> list) {
        this.varsToShow = list == null ? null : new ArrayList<Integer>(list);
    }

    public void setShowProbs(boolean bl) {
        this.showProbs = bl;
    }

    public void setShowRewards(boolean bl) {
        this.showRewards = bl;
    }

    public void start(State state, double[] dArray) {
        this.startDisplay(state, dArray);
        if (this.showSnapshots) {
            this.nextTime = this.snapshotTimeStep;
        }
    }

    public void step(double d, double d2, String string, double d3, double[] dArray, long l, State state, double[] dArray2) {
        if (this.showSnapshots) {
            if (d2 < this.nextTime) {
                return;
            }
            while (d2 >= this.nextTime) {
                this.displaySnapshot(this.nextTime, l, state, dArray2);
                this.nextTime += this.snapshotTimeStep;
            }
        } else {
            this.displayStep(d, d2, string, d3, dArray, l, state, dArray2);
        }
    }

    public void end() {
        this.endDisplay();
    }

    public abstract void startDisplay(State var1, double[] var2);

    public abstract void displayStep(double var1, double var3, String var5, double var6, double[] var8, long var9, State var11, double[] var12);

    public abstract void displaySnapshot(double var1, long var3, State var5, double[] var6);

    public abstract void endDisplay();

    public void close() {
    }
}

