/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayList;
import java.util.List;
import param.Function;
import param.FunctionFactory;
import param.ModelBuilder;
import param.SymbolicEngine;
import param.TransitionList;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.ConstantList;
import parser.ast.Expression;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.RewardStruct;
import parser.type.Type;
import prism.ModelGeneratorSymbolic;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.RewardGenerator;

public class ModulesFileModelGeneratorSymbolic
implements ModelGeneratorSymbolic,
RewardGenerator {
    protected PrismComponent parent;
    private ModulesFile originalModulesFile;
    private ModulesFile modulesFile;
    private ModelType modelType;
    private Values mfConstants;
    private VarList varList;
    private LabelList labelList;
    private List<String> labelNames;
    private State exploreState;
    protected SymbolicEngine engine;
    protected TransitionList transitionList;
    protected boolean transitionListBuilt;
    boolean symbolic = false;
    protected ModelBuilder modelBuilder;
    protected FunctionFactory functionFactory;

    public ModulesFileModelGeneratorSymbolic(ModulesFile modulesFile) throws PrismException {
        this(modulesFile, null);
    }

    public ModulesFileModelGeneratorSymbolic(ModulesFile modulesFile, PrismComponent prismComponent) throws PrismException {
        this.parent = prismComponent;
        if (modulesFile.getModelType() == ModelType.PTA) {
            throw new PrismException("PTAs are not currently supported");
        }
        if (modulesFile.getSystemDefn() != null) {
            throw new PrismException("The system...endsystem construct is not currently supported");
        }
        this.modulesFile = modulesFile;
        this.originalModulesFile = modulesFile;
        this.modelType = modulesFile.getModelType();
        this.mfConstants = modulesFile.getConstantValues();
        if (this.mfConstants != null) {
            this.initialise();
        }
    }

    private void initialise() throws PrismLangException {
        this.modulesFile = (ModulesFile)this.modulesFile.deepCopy().replaceConstants(this.mfConstants);
        this.varList = this.modulesFile.createVarList();
        this.labelList = this.modulesFile.getLabelList();
        this.labelNames = this.labelList.getLabelNames();
        this.engine = new SymbolicEngine(this.modulesFile, this.modelBuilder, this.functionFactory);
        this.transitionListBuilt = false;
    }

    @Override
    public void setSymbolic(ModelBuilder modelBuilder, FunctionFactory functionFactory) {
        this.symbolic = true;
        this.modelBuilder = modelBuilder;
        this.functionFactory = functionFactory;
        this.engine = new SymbolicEngine(this.modulesFile, modelBuilder, functionFactory);
    }

    @Override
    public ModelType getModelType() {
        return this.modelType;
    }

    @Override
    public void setSomeUndefinedConstants(Values values) throws PrismException {
        this.setSomeUndefinedConstants(values, false);
    }

    @Override
    public void setSomeUndefinedConstants(Values values, boolean bl) throws PrismException {
        this.modulesFile = (ModulesFile)this.originalModulesFile.deepCopy();
        this.modulesFile.setSomeUndefinedConstants(values, bl);
        this.mfConstants = this.modulesFile.getConstantValues();
        this.initialise();
    }

    @Override
    public Values getConstantValues() {
        return this.mfConstants;
    }

    @Override
    public boolean containsUnboundedVariables() {
        return this.modulesFile.containsUnboundedVariables();
    }

    @Override
    public int getNumVars() {
        return this.modulesFile.getNumVars();
    }

    @Override
    public List<String> getVarNames() {
        return this.modulesFile.getVarNames();
    }

    @Override
    public List<Type> getVarTypes() {
        return this.modulesFile.getVarTypes();
    }

    @Override
    public int getNumLabels() {
        return this.labelList.size();
    }

    @Override
    public String getActionStringDescription() {
        return "Module/[action]";
    }

    @Override
    public List<String> getLabelNames() {
        return this.labelNames;
    }

    @Override
    public String getLabelName(int n) throws PrismException {
        return this.labelList.getLabelName(n);
    }

    @Override
    public int getLabelIndex(String string) {
        return this.labelList.getLabelIndex(string);
    }

    @Override
    public VarList createVarList() {
        return this.varList;
    }

    @Override
    public boolean hasSingleInitialState() throws PrismException {
        return this.modulesFile.getInitialStates() == null;
    }

    @Override
    public State getInitialState() throws PrismException {
        if (this.modulesFile.getInitialStates() == null) {
            return this.modulesFile.getDefaultInitialState(true);
        }
        return this.getInitialStates().get(0);
    }

    @Override
    public List<State> getInitialStates() throws PrismException {
        ArrayList<State> arrayList = new ArrayList<State>();
        if (this.modulesFile.getInitialStates() == null) {
            State state = this.modulesFile.getDefaultInitialState(true);
            arrayList.add(state);
        } else {
            Expression expression = this.modulesFile.getInitialStates();
            List<State> list = this.varList.getAllStates();
            for (State state : list) {
                if (!expression.evaluateExact(this.modulesFile.getConstantValues(), state).toBoolean()) continue;
                arrayList.add(state);
            }
        }
        return arrayList;
    }

    @Override
    public void exploreState(State state) throws PrismException {
        this.exploreState = state;
        this.transitionListBuilt = false;
    }

    @Override
    public int getNumChoices() throws PrismException {
        return this.getTransitionList().getNumChoices();
    }

    @Override
    public int getNumTransitions() throws PrismException {
        return this.getTransitionList().getNumTransitions();
    }

    @Override
    public int getNumTransitions(int n) throws PrismException {
        return this.getTransitionList().getChoice(n).size();
    }

    @Override
    public int getChoiceIndexOfTransition(int n) throws PrismException {
        return this.getTransitionList().getChoiceIndexOfTransition(n);
    }

    @Override
    public int getChoiceOffsetOfTransition(int n) throws PrismException {
        return this.getTransitionList().getChoiceOffsetOfTransition(n);
    }

    @Override
    public int getTotalIndexOfTransition(int n, int n2) throws PrismException {
        return this.getTransitionList().getTotalIndexOfTransition(n, n2);
    }

    @Override
    public Object getTransitionAction(int n, int n2) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        int n3 = transitionList.getTransitionModuleOrActionIndex(transitionList.getTotalIndexOfTransition(n, n2));
        return n3 < 0 ? null : this.modulesFile.getSynch(n3 - 1);
    }

    @Override
    public String getTransitionActionString(int n, int n2) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        int n3 = transitionList.getTransitionModuleOrActionIndex(transitionList.getTotalIndexOfTransition(n, n2));
        return this.getDescriptionForModuleOrActionIndex(n3);
    }

    @Override
    public Object getChoiceAction(int n) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        int n2 = transitionList.getChoiceModuleOrActionIndex(n);
        return n2 < 0 ? null : this.modulesFile.getSynch(n2 - 1);
    }

    @Override
    public String getChoiceActionString(int n) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        int n2 = transitionList.getChoiceModuleOrActionIndex(n);
        return this.getDescriptionForModuleOrActionIndex(n2);
    }

    private String getDescriptionForModuleOrActionIndex(int n) {
        if (n < 0) {
            return this.modulesFile.getModuleName(-n - 1);
        }
        if (n > 0) {
            return "[" + this.modulesFile.getSynchs().get(n - 1) + "]";
        }
        return "?";
    }

    @Override
    public double getTransitionProbability(int n, int n2) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Function getTransitionProbabilityFunction(int n, int n2) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        return transitionList.getChoice(n).getProbability(n2);
    }

    @Override
    public double getChoiceProbabilitySum(int n) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getProbabilitySum() throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTransitionUpdateString(int n, int n2) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        return transitionList.getTransitionUpdateString(transitionList.getTotalIndexOfTransition(n, n2), this.exploreState);
    }

    @Override
    public String getTransitionUpdateStringFull(int n, int n2) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        return transitionList.getTransitionUpdateStringFull(transitionList.getTotalIndexOfTransition(n, n2));
    }

    @Override
    public State computeTransitionTarget(int n, int n2) throws PrismException {
        return this.getTransitionList().getChoice(n).computeTarget(n2, this.exploreState);
    }

    @Override
    public boolean isLabelTrue(int n) throws PrismException {
        Expression expression = this.labelList.getLabel(n);
        return expression.evaluateExact(this.exploreState).toBoolean();
    }

    @Override
    public List<String> getRewardStructNames() {
        return this.modulesFile.getRewardStructNames();
    }

    @Override
    public boolean rewardStructHasStateRewards(int n) {
        return this.modulesFile.rewardStructHasStateRewards(n);
    }

    @Override
    public boolean rewardStructHasTransitionRewards(int n) {
        return this.modulesFile.rewardStructHasTransitionRewards(n);
    }

    @Override
    public double getStateReward(int n, State state) throws PrismException {
        RewardStruct rewardStruct = this.modulesFile.getRewardStruct(n);
        int n2 = rewardStruct.getNumItems();
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            Expression expression;
            if (rewardStruct.getRewardStructItem(i).isTransitionReward() || !(expression = rewardStruct.getStates(i)).evaluateExact(this.modulesFile.getConstantValues(), state).toBoolean()) continue;
            double d2 = rewardStruct.getReward(i).evaluateExact(this.modulesFile.getConstantValues(), state).doubleValue();
            if (Double.isNaN(d2)) {
                throw new PrismLangException("Reward structure evaluates to NaN at state " + state, rewardStruct.getReward(i));
            }
            d += d2;
        }
        return d;
    }

    @Override
    public double getStateActionReward(int n, State state, Object object) throws PrismException {
        RewardStruct rewardStruct = this.modulesFile.getRewardStruct(n);
        int n2 = rewardStruct.getNumItems();
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            if (!rewardStruct.getRewardStructItem(i).isTransitionReward()) continue;
            Expression expression = rewardStruct.getStates(i);
            String string = rewardStruct.getSynch(i);
            if (!(object == null ? string.isEmpty() : object.equals(string)) || !expression.evaluateExact(this.modulesFile.getConstantValues(), state).toBoolean()) continue;
            double d2 = rewardStruct.getReward(i).evaluateExact(this.modulesFile.getConstantValues(), state).doubleValue();
            if (Double.isNaN(d2)) {
                throw new PrismLangException("Reward structure evaluates to NaN at state " + state, rewardStruct.getReward(i));
            }
            d += d2;
        }
        return d;
    }

    @Override
    public Expression getUnknownConstantDefinition(String string) throws PrismException {
        ConstantList constantList = this.modulesFile.getConstantList();
        int n = constantList.getConstantIndex(string);
        if (n == -1) {
            throw new PrismException("Unknown constant " + string);
        }
        return constantList.getConstant(n);
    }

    private TransitionList getTransitionList() throws PrismException {
        if (!this.transitionListBuilt) {
            this.transitionList = this.engine.calculateTransitions(this.exploreState, true);
            this.transitionListBuilt = true;
        }
        return this.transitionList;
    }
}

