/*
 * Decompiled with CFR 0.152.
 */
package pta;

import explicit.IndexedSet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import parser.ParserUtils;
import parser.State;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.Command;
import parser.ast.Declaration;
import parser.ast.DeclarationInt;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionVar;
import parser.ast.FormulaList;
import parser.ast.LabelList;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.ast.Update;
import parser.ast.Updates;
import parser.type.TypeClock;
import parser.type.TypeInt;
import parser.visitor.ASTTraverse;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismUtils;
import pta.Constraint;
import pta.Edge;
import pta.PTA;
import pta.PTAParallel;
import pta.Transition;

public class Modules2PTA
extends PrismComponent {
    protected double sumRoundOff;
    private ModulesFile modulesFile;
    private Values constantValues;

    public Modules2PTA(PrismComponent prismComponent, ModulesFile modulesFile) throws PrismException {
        super(prismComponent);
        this.sumRoundOff = this.settings.getDouble("prism.sumRoundOff");
        this.modulesFile = modulesFile;
        this.constantValues = modulesFile.getConstantValues();
    }

    public PTA translate() throws PrismLangException {
        Module module;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.modulesFile.getModelType() != ModelType.PTA) {
            throw new PrismLangException("Model is not a PTA");
        }
        if (this.modulesFile.getNumGlobals() > 0) {
            throw new PrismLangException("PTA models cannot have global variables");
        }
        if (this.modulesFile.getInitialStates() != null) {
            throw new PrismLangException("PTA models cannot use init...endinit");
        }
        this.modulesFile.accept(new ASTTraverse(){
            private Module inModule = null;

            @Override
            public void visitPre(Module module) throws PrismLangException {
                this.inModule = module;
            }

            @Override
            public void visitPost(Module module) throws PrismLangException {
                this.inModule = null;
            }

            @Override
            public void visitPost(ExpressionVar expressionVar) throws PrismLangException {
                if (this.inModule != null && !this.inModule.isLocalVariable(expressionVar.getName())) {
                    throw new PrismLangException("Modules in a PTA cannot access non-local variables", expressionVar);
                }
            }
        });
        this.modulesFile = (ModulesFile)this.modulesFile.deepCopy().replaceConstants(this.constantValues).simplify();
        this.modulesFile.setFormulaList(new FormulaList());
        this.modulesFile.setLabelList(new LabelList());
        this.modulesFile.clearRewardStructs();
        int n2 = this.modulesFile.getNumModules();
        ArrayList arrayList2 = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            module = this.modulesFile.getModule(n);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (Declaration declaration : module.getDeclarations()) {
                if (declaration.getType() instanceof TypeClock) continue;
                arrayList3.add(declaration.getName());
            }
            arrayList.addAll(arrayList3);
            arrayList2.add(new ArrayList());
            module = this.modulesFile.getModule(n);
            Module module2 = this.convertModuleToPCForm(module, arrayList3, (ArrayList)arrayList2.get(n));
            this.modulesFile.setModule(n, module2);
        }
        this.modulesFile.recomputeVariableinformation();
        n2 = this.modulesFile.getNumModules();
        PTA pTA = null;
        for (n = 0; n < n2; ++n) {
            module = this.modulesFile.getModule(n);
            PTA pTA2 = this.translateModule(module, (ArrayList)arrayList2.get(n));
            pTA = pTA == null ? pTA2 : new PTAParallel().compose(pTA, pTA2);
        }
        pTA.setLocationNameVars(arrayList);
        return pTA;
    }

    private PTA translateModule(Module module, ArrayList<State> arrayList) throws PrismLangException {
        List<Expression> list;
        Values values;
        int n;
        String string = module.getDeclaration(0).getName();
        int n2 = ((DeclarationInt)module.getDeclaration(0).getDeclType()).getHigh().evaluateInt();
        int n3 = module.getNumDeclarations();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 1; n < n3; ++n) {
            arrayList2.add(module.getDeclaration(n).getName());
        }
        PTA pTA = new PTA(new ArrayList<String>(module.getAllSynchs()));
        for (String object : arrayList2) {
            pTA.addClock(object);
        }
        for (n = 0; n < n2 + 1; ++n) {
            pTA.addLocation(arrayList.get(n));
        }
        for (n = 0; n < n2 + 1; ++n) {
            Expression expression = module.getInvariant();
            if (expression == null) continue;
            expression = module.getInvariant().deepCopy();
            values = new Values();
            values.setValue(string, n);
            expression = (Expression)expression.evaluatePartially(null, values).simplify();
            list = ParserUtils.splitConjunction(expression);
            for (Expression expression2 : list) {
                if (Expression.isTrue(expression2) || Expression.isFalse(expression2)) continue;
                this.checkIsSimpleClockConstraint(expression2);
            }
            for (Expression expression3 : list) {
                if (Expression.isTrue(expression3)) continue;
                for (Constraint constraint : this.exprToConstraint(expression3, pTA)) {
                    pTA.addInvariantCondition(n, constraint);
                }
            }
        }
        for (Command command : module.getCommands()) {
            Expression expression = ((ExpressionBinaryOp)command.getGuard()).getOperand1();
            int n4 = ((ExpressionBinaryOp)expression).getOperand2().evaluateInt();
            values = new Values();
            values.setValue(string, n4);
            Transition transition = pTA.addTransition(n4, command.getSynch());
            list = ParserUtils.splitConjunction(((ExpressionBinaryOp)command.getGuard()).getOperand2());
            for (Expression expression4 : list) {
                if (Expression.isTrue(expression4) || Expression.isFalse(expression4)) continue;
                this.checkIsSimpleClockConstraint(expression4);
            }
            for (Expression expression5 : list) {
                if (Expression.isTrue(expression5)) continue;
                for (Constraint constraint : this.exprToConstraint(expression5, pTA)) {
                    transition.addGuardConstraint(constraint);
                }
            }
            int n5 = command.getUpdates().getNumUpdates();
            double d = 0.0;
            for (int i = 0; i < n5; ++i) {
                double d2;
                Update update = command.getUpdates().getUpdate(i);
                expression = command.getUpdates().getProbability(i);
                double d3 = d2 = expression == null ? 1.0 : expression.evaluateDouble(this.constantValues, values);
                if (d2 < 0.0) {
                    throw new PrismLangException("Negative probability (" + d2 + ") found in PTA");
                }
                if (d2 > 1.0) {
                    throw new PrismLangException("Probability greater than 1 (" + d2 + ") found in PTA");
                }
                d += d2;
                Edge edge = transition.addEdge(d2, -1);
                int n6 = update.getNumElements();
                for (int j = 0; j < n6; ++j) {
                    if (update.getVar(j).equals(string)) {
                        edge.setDestination(update.getExpression(j).evaluateInt(this.constantValues, values));
                        continue;
                    }
                    if (!arrayList2.contains(update.getVar(j))) {
                        throw new PrismLangException("Update to non-clock found", update);
                    }
                    int n7 = update.getExpression(j).evaluateInt(this.constantValues, values);
                    edge.addReset(pTA.getClockIndex(update.getVar(j)), n7);
                }
                if (edge.getDestination() != -1) continue;
                edge.setDestination(transition.getSource());
            }
            if (PrismUtils.doublesAreCloseAbs(d, 1.0, this.sumRoundOff)) continue;
            throw new PrismLangException("Probabilities do not sum to one (" + d + ") in PTA");
        }
        return pTA;
    }

    private void checkIsSimpleClockConstraint(Expression expression) throws PrismLangException {
        int n = 0;
        if (!Expression.isRelOp(expression)) {
            throw new PrismLangException("Invalid clock constraint \"" + expression + "\"", expression);
        }
        ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)expression;
        int n2 = expressionBinaryOp.getOperator();
        Expression expression2 = expressionBinaryOp.getOperand1();
        Expression expression3 = expressionBinaryOp.getOperand2();
        if (!ExpressionBinaryOp.isRelOp(n2)) {
            throw new PrismLangException("Can't use operator " + expressionBinaryOp.getOperatorSymbol() + " in clock constraint \"" + expression + "\"", expression);
        }
        if (n2 == 6) {
            throw new PrismLangException("Can't use negation in clock constraint \"" + expression + "\"", expression);
        }
        if (expression2.getType() instanceof TypeClock) {
            if (!(expression2 instanceof ExpressionVar)) {
                throw new PrismLangException("Invalid clock expression \"" + expression2 + "\"", expression2);
            }
            ++n;
        } else if (expression2.getType() instanceof TypeInt) {
            if (!expression2.isConstant()) {
                throw new PrismLangException("Invalid clock constraint \"" + expression + "\"", expression);
            }
        } else {
            throw new PrismLangException("Invalid clock constraint \"" + expression + "\"", expression);
        }
        if (expression3.getType() instanceof TypeClock) {
            if (!(expression3 instanceof ExpressionVar)) {
                throw new PrismLangException("Invalid clock expression \"" + expression3 + "\"", expression3);
            }
            ++n;
        } else if (expression3.getType() instanceof TypeInt) {
            if (!expression3.isConstant()) {
                throw new PrismLangException("Invalid clock constraint \"" + expression + "\"", expression);
            }
        } else {
            throw new PrismLangException("Invalid clock constraint \"" + expression + "\"", expression);
        }
        if (n == 0) {
            throw new PrismLangException("Invalid clock constraint \"" + expression + "\"", expression);
        }
    }

    private List<Constraint> exprToConstraint(Expression expression, PTA pTA) throws PrismLangException {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        if (!Expression.isRelOp(expression)) {
            throw new PrismLangException("Invalid clock constraint \"" + expression + "\"", expression);
        }
        ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)expression;
        Expression expression2 = expressionBinaryOp.getOperand1();
        Expression expression3 = expressionBinaryOp.getOperand2();
        if (expression2.getType() instanceof TypeClock) {
            if (expression3.getType() instanceof TypeClock) {
                int n = pTA.getClockIndex(((ExpressionVar)expression2).getName());
                if (n < 0) {
                    throw new PrismLangException("Unknown clock \"" + ((ExpressionVar)expression2).getName() + "\"", expression);
                }
                int n2 = pTA.getClockIndex(((ExpressionVar)expression3).getName());
                if (n2 < 0) {
                    throw new PrismLangException("Unknown clock \"" + ((ExpressionVar)expression3).getName() + "\"", expression);
                }
                switch (expressionBinaryOp.getOperator()) {
                    case 5: {
                        arrayList.add(Constraint.buildXGeqY(n, n2));
                        arrayList.add(Constraint.buildXLeqY(n, n2));
                        break;
                    }
                    case 6: {
                        throw new PrismLangException("Can't use negation in clock constraint \"" + expression + "\"", expression);
                    }
                    case 7: {
                        arrayList.add(Constraint.buildXGtY(n, n2));
                        break;
                    }
                    case 8: {
                        arrayList.add(Constraint.buildXGeqY(n, n2));
                        break;
                    }
                    case 9: {
                        arrayList.add(Constraint.buildXLtY(n, n2));
                        break;
                    }
                    case 10: {
                        arrayList.add(Constraint.buildXLeqY(n, n2));
                    }
                }
                return arrayList;
            }
            int n = pTA.getClockIndex(((ExpressionVar)expression2).getName());
            if (n < 0) {
                throw new PrismLangException("Unknown clock \"" + ((ExpressionVar)expression2).getName() + "\"", expression);
            }
            int n3 = expression3.evaluateInt(this.constantValues);
            switch (expressionBinaryOp.getOperator()) {
                case 5: {
                    arrayList.add(Constraint.buildGeq(n, n3));
                    arrayList.add(Constraint.buildLeq(n, n3));
                    break;
                }
                case 6: {
                    throw new PrismLangException("Can't use negation in clock constraint \"" + expression + "\"", expression);
                }
                case 7: {
                    arrayList.add(Constraint.buildGt(n, n3));
                    break;
                }
                case 8: {
                    arrayList.add(Constraint.buildGeq(n, n3));
                    break;
                }
                case 9: {
                    arrayList.add(Constraint.buildLt(n, n3));
                    break;
                }
                case 10: {
                    arrayList.add(Constraint.buildLeq(n, n3));
                }
            }
            return arrayList;
        }
        if (expression3.getType() instanceof TypeClock) {
            int n = pTA.getClockIndex(((ExpressionVar)expression3).getName());
            if (n < 0) {
                throw new PrismLangException("Unknown clock \"" + ((ExpressionVar)expression3).getName() + "\"", expression);
            }
            int n4 = expression2.evaluateInt(this.constantValues);
            switch (expressionBinaryOp.getOperator()) {
                case 5: {
                    arrayList.add(Constraint.buildGeq(n, n4));
                    arrayList.add(Constraint.buildLeq(n, n4));
                    break;
                }
                case 6: {
                    throw new PrismLangException("Can't use negation in clock constraint \"" + expression + "\"", expression);
                }
                case 7: {
                    arrayList.add(Constraint.buildLt(n, n4));
                    break;
                }
                case 8: {
                    arrayList.add(Constraint.buildLeq(n, n4));
                    break;
                }
                case 9: {
                    arrayList.add(Constraint.buildGt(n, n4));
                    break;
                }
                case 10: {
                    arrayList.add(Constraint.buildGeq(n, n4));
                }
            }
            return arrayList;
        }
        throw new PrismLangException("Invalid clock constraint \"" + expression + "\"", expression);
    }

    private Module convertModuleToPCForm(Module module, List<String> list, ArrayList<State> arrayList) throws PrismLangException {
        int n;
        int n2 = list.size();
        State state = new State(n2);
        for (n = 0; n < n2; ++n) {
            Declaration declaration = this.modulesFile.getVarDeclaration(this.modulesFile.getVarIndex(list.get(n)));
            state.setValue(n, declaration.getStartOrDefault().evaluate(this.constantValues));
        }
        int n3 = this.modulesFile.getNumVars();
        int[] nArray = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < n2; ++n) {
            nArray[this.modulesFile.getVarIndex((String)list.get((int)n))] = n;
        }
        Object object = "";
        for (n = 0; n < n2; ++n) {
            object = (String)object + "_" + list.get(n);
        }
        while (!this.identIsUnused((String)object)) {
            object = (String)object + "_";
        }
        Module module2 = new Module(module.getName());
        module2.setAlphabet(module.getAllSynchs());
        Expression expression = null;
        IndexedSet<State> indexedSet = new IndexedSet<State>();
        LinkedList<State> linkedList = new LinkedList<State>();
        State state2 = state;
        indexedSet.add(state2);
        linkedList.add(state2);
        int n4 = -1;
        try {
            while (!linkedList.isEmpty()) {
                state2 = (State)linkedList.removeFirst();
                Expression expression2 = new ExpressionVar((String)object, TypeInt.getInstance());
                expression2 = new ExpressionBinaryOp(5, expression2, Expression.Int(++n4));
                int n5 = module.getNumCommands();
                for (n = 0; n < n5; ++n) {
                    Command command = module.getCommand(n);
                    Expression expression3 = command.getGuard();
                    if (Expression.isFalse(expression3 = (Expression)expression3.deepCopy().evaluatePartially(state2, nArray).simplify())) continue;
                    Command command2 = new Command();
                    command2.setSynch(command.getSynch());
                    ExpressionBinaryOp expressionBinaryOp = Expression.And(expression2, expression3);
                    command2.setGuard(expressionBinaryOp);
                    Updates updates = command.getUpdates();
                    Updates updates2 = new Updates();
                    int n6 = updates.getNumUpdates();
                    for (int i = 0; i < n6; ++i) {
                        Update update = updates.getUpdate(i);
                        State state3 = new State(state2);
                        update.updatePartially(state2, state3, nArray);
                        if (indexedSet.add(state3)) {
                            linkedList.add(state3);
                        }
                        int n7 = indexedSet.getIndexOfLastAdd();
                        Update update2 = new Update();
                        update2.addElement(new ExpressionIdent((String)object), Expression.Int(n7));
                        int n8 = update.getNumElements();
                        for (int j = 0; j < n8; ++j) {
                            if (nArray[update.getVarIndex(j)] != -1) continue;
                            update2.addElement(update.getVarIdent(j), update.getExpression(j));
                        }
                        Object object2 = updates.getProbability(i);
                        if (object2 != null) {
                            object2 = ((Expression)object2).deepCopy();
                            object2 = (Expression)((ASTElement)object2).evaluatePartially(state2, nArray).simplify();
                        }
                        updates2.addUpdate((Expression)object2, update2);
                    }
                    command2.setUpdates(updates2);
                    module2.addCommand(command2);
                }
                Expression expression4 = module.getInvariant();
                if (expression4 == null) continue;
                expression4 = expression4.deepCopy();
                if (Expression.isTrue(expression4 = (Expression)expression4.evaluatePartially(state2, nArray).simplify())) continue;
                expression4 = Expression.Parenth(Expression.Implies(expression2, expression4));
                expression = expression == null ? expression4 : Expression.And(expression, expression4);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            indexedSet.clear();
            System.gc();
            throw new PrismLangException("Out of memory after exploring " + (n4 + 1) + " states of module " + module.getName(), module);
        }
        module2.setInvariant(expression);
        Declaration declaration = new Declaration((String)object, new DeclarationInt(Expression.Int(0), Expression.Int(indexedSet.size() - 1)));
        module2.addDeclaration(declaration);
        for (Declaration declaration2 : module.getDeclarations()) {
            if (list.contains(declaration2.getName())) continue;
            module2.addDeclaration((Declaration)declaration2.deepCopy());
        }
        if (arrayList != null) {
            indexedSet.toArrayList(arrayList);
        }
        return module2;
    }

    private boolean identIsUnused(String string) {
        return !this.modulesFile.isIdentUsed(string);
    }
}

