/*
 * Decompiled with CFR 0.152.
 */
package prism;

import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import prism.Model;
import prism.ModelTransformation;
import prism.PrismException;
import prism.StateValues;

public class Product<M extends Model>
implements ModelTransformation<M, M> {
    protected M originalModel = null;
    protected M productModel = null;
    protected JDDNode productStatesOfInterest = null;
    protected JDDVars automatonRowVars = null;

    public Product(M m, M m2, JDDNode jDDNode, JDDVars jDDVars) {
        this.originalModel = m2;
        this.productModel = m;
        this.productStatesOfInterest = jDDNode;
        this.automatonRowVars = jDDVars;
    }

    public M getProductModel() {
        return this.productModel;
    }

    @Override
    public M getTransformedModel() {
        return this.getProductModel();
    }

    @Override
    public M getOriginalModel() {
        return this.originalModel;
    }

    public JDDVars getAutomatonRowVars() {
        return this.automatonRowVars;
    }

    @Override
    public void clear() {
        if (this.productModel != null) {
            this.productModel.clear();
        }
        if (this.productStatesOfInterest != null) {
            JDD.Deref(this.productStatesOfInterest);
        }
        if (this.automatonRowVars != null) {
            this.automatonRowVars.derefAll();
        }
    }

    @Override
    public StateValues projectToOriginalModel(StateValues stateValues) throws PrismException {
        stateValues.filter(this.productStatesOfInterest);
        StateValues stateValues2 = stateValues.sumOverDDVars(this.automatonRowVars, (Model)this.originalModel);
        stateValues.clear();
        return stateValues2;
    }

    @Override
    public JDDNode getTransformedStatesOfInterest() {
        return this.productStatesOfInterest.copy();
    }
}

