/*
 * Decompiled with CFR 0.152.
 */
package prism;

import acceptance.AcceptanceBuchiDD;
import acceptance.AcceptanceGenRabinDD;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceRabinDD;
import acceptance.AcceptanceReach;
import acceptance.AcceptanceType;
import automata.DA;
import automata.LTL2DA;
import automata.LTL2WDBA;
import common.StopWatch;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import jltl2ba.SimpleLTL;
import parser.VarList;
import parser.ast.Declaration;
import parser.ast.DeclarationInt;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.type.TypeBool;
import parser.type.TypePathBool;
import prism.ECComputer;
import prism.Model;
import prism.ModelChecker;
import prism.ModelType;
import prism.ModelVariablesDD;
import prism.NondetModel;
import prism.NondetModelChecker;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import prism.ProbModel;
import prism.ProbModelChecker;
import prism.Product;
import prism.SCCComputer;
import prism.queueElement;

public class LTLModelChecker
extends PrismComponent {
    public LTLModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    public static boolean isSupportedLTLFormula(ModelType modelType, Expression expression) throws PrismLangException {
        if (!expression.isPathFormula(true)) {
            return false;
        }
        if (Expression.containsTemporalTimeBounds(expression)) {
            if (modelType.continuousTime()) {
                return false;
            }
            if (!expression.isSimplePathFormula()) {
                return false;
            }
        }
        return true;
    }

    public Expression checkMaximalStateFormulas(ModelChecker modelChecker, Model model, Expression expression, Vector<JDDNode> vector) throws PrismException {
        if (expression.getType() instanceof TypeBool) {
            JDDNode jDDNode = modelChecker.checkExpressionDD(expression, model.getReach().copy());
            if (jDDNode.equals(JDD.ZERO)) {
                JDD.Deref(jDDNode);
                return Expression.False();
            }
            if (jDDNode.equals(model.getReach())) {
                JDD.Deref(jDDNode);
                return Expression.True();
            }
            int n = vector.indexOf(jDDNode);
            if (n != -1) {
                JDD.Deref(jDDNode);
                return new ExpressionLabel("L" + n);
            }
            JDD.Ref(jDDNode);
            JDD.Ref(model.getReach());
            JDDNode jDDNode2 = JDD.And(JDD.Not(jDDNode), model.getReach());
            n = vector.indexOf(jDDNode2);
            JDD.Deref(jDDNode2);
            if (n != -1) {
                JDD.Deref(jDDNode);
                return Expression.Not(new ExpressionLabel("L" + n));
            }
            vector.add(jDDNode);
            return new ExpressionLabel("L" + (vector.size() - 1));
        }
        if (expression.getType() instanceof TypePathBool) {
            if (expression instanceof ExpressionBinaryOp) {
                ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)expression;
                expressionBinaryOp.setOperand1(this.checkMaximalStateFormulas(modelChecker, model, expressionBinaryOp.getOperand1(), vector));
                expressionBinaryOp.setOperand2(this.checkMaximalStateFormulas(modelChecker, model, expressionBinaryOp.getOperand2(), vector));
            } else if (expression instanceof ExpressionUnaryOp) {
                ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
                expressionUnaryOp.setOperand(this.checkMaximalStateFormulas(modelChecker, model, expressionUnaryOp.getOperand(), vector));
            } else if (expression instanceof ExpressionTemporal) {
                ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
                if (expressionTemporal.getOperand1() != null) {
                    expressionTemporal.setOperand1(this.checkMaximalStateFormulas(modelChecker, model, expressionTemporal.getOperand1(), vector));
                }
                if (expressionTemporal.getOperand2() != null) {
                    expressionTemporal.setOperand2(this.checkMaximalStateFormulas(modelChecker, model, expressionTemporal.getOperand2(), vector));
                }
            }
        }
        return expression;
    }

    public DA<BitSet, AcceptanceReach> constructDFAForCosafetyRewardLTL(ModelChecker modelChecker, Model model, Expression expression, Vector<JDDNode> vector) throws PrismException {
        Object object;
        Expression expression2 = this.checkMaximalStateFormulas(modelChecker, model, expression.deepCopy(), vector);
        SimpleLTL simpleLTL = expression2.convertForJltl2ba();
        simpleLTL = simpleLTL.toBasicOperators();
        if ((simpleLTL = simpleLTL.pushNegation()).hasNextStep()) {
            object = "L" + vector.size();
            vector.add(model.getReach().copy());
            simpleLTL = simpleLTL.extendNextStepWithAP((String)object);
        }
        object = new LTL2WDBA(this);
        this.mainLog.println("\nBuilding deterministic finite automaton via LTL2WDBA construction (for " + simpleLTL + ")...");
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("constructing DFA");
        DA<BitSet, AcceptanceReach> dA = ((LTL2WDBA)object).cosafeltl2dfa(simpleLTL);
        stopWatch.stop("DFA has " + dA.size() + " states");
        return dA;
    }

    public DA<BitSet, ? extends AcceptanceOmega> constructDAForLTLFormula(ModelChecker modelChecker, Model model, Expression expression, Vector<JDDNode> vector, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        if (Expression.containsTemporalTimeBounds(expression)) {
            if (model.getModelType().continuousTime()) {
                throw new PrismException("DA construction for time-bounded operators not supported for " + model.getModelType() + ".");
            }
            if (!expression.isSimplePathFormula()) {
                throw new PrismException("Time-bounded operators not supported in LTL: " + expression);
            }
        }
        Expression expression2 = this.checkMaximalStateFormulas(modelChecker, model, expression.deepCopy(), vector);
        this.mainLog.println("\nBuilding deterministic automaton (for " + expression2 + ")...");
        long l = System.currentTimeMillis();
        LTL2DA lTL2DA = new LTL2DA(this);
        DA<BitSet, ? extends AcceptanceOmega> dA = lTL2DA.convertLTLFormulaToDA(expression2, modelChecker.getConstantValues(), acceptanceTypeArray);
        dA.checkForCanonicalAPs(vector.size());
        this.mainLog.println(dA.getAutomataType() + " has " + dA.size() + " states, " + dA.getAcceptance().getSizeStatistics() + ".");
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Time for deterministic automaton translation: " + (double)l / 1000.0 + " seconds.");
        if (this.getSettings().getExportPropAut()) {
            this.mainLog.println("Exporting DA to file \"" + this.getSettings().getExportPropAutFilename() + "\"...");
            PrintStream printStream = PrismUtils.newPrintStream(this.getSettings().getExportPropAutFilename());
            dA.print(printStream, this.getSettings().getExportPropAutType());
            printStream.close();
        }
        return dA;
    }

    public ProbModel constructProductMC(DA<BitSet, ? extends AcceptanceOmega> dA, ProbModel probModel, Vector<JDDNode> vector, JDDNode jDDNode) throws PrismException {
        return this.constructProductMC(dA, probModel, vector, null, null, jDDNode);
    }

    @Deprecated
    public ProbModel constructProductMC(DA<BitSet, ? extends AcceptanceOmega> dA, ProbModel probModel, Vector<JDDNode> vector) throws PrismException {
        return this.constructProductMC(dA, probModel, vector, null, null, true);
    }

    @Deprecated
    public ProbModel constructProductMC(DA<BitSet, ? extends AcceptanceOmega> dA, ProbModel probModel, Vector<JDDNode> vector, JDDVars jDDVars, JDDVars jDDVars2) throws PrismException {
        return this.constructProductMC(dA, probModel, vector, jDDVars, jDDVars2, true);
    }

    @Deprecated
    public ProbModel constructProductMC(DA<BitSet, ? extends AcceptanceOmega> dA, ProbModel probModel, Vector<JDDNode> vector, JDDVars jDDVars, JDDVars jDDVars2, boolean bl) throws PrismException {
        JDDNode jDDNode = bl ? probModel.getReach().copy() : probModel.getStart().copy();
        JDDVars jDDVars3 = jDDVars == null ? new JDDVars() : jDDVars;
        JDDVars jDDVars4 = jDDVars2 == null ? new JDDVars() : jDDVars2;
        ProbModel probModel2 = this.constructProductMC(dA, probModel, vector, jDDVars3, jDDVars4, jDDNode);
        JDDNode jDDNode2 = this.buildStartMask(dA, vector, jDDVars3);
        JDD.Ref(probModel.getStart());
        jDDNode2 = JDD.And(probModel.getStart(), jDDNode2);
        probModel2.setStart(jDDNode2);
        if (jDDVars == null) {
            jDDVars3.derefAll();
        }
        if (jDDVars2 == null) {
            jDDVars4.derefAll();
        }
        return probModel2;
    }

    public ProbModel constructProductMC(DA<BitSet, ? extends AcceptanceOmega> dA, ProbModel probModel, Vector<JDDNode> vector, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode) throws PrismException {
        JDDVars jDDVars3;
        JDDVars jDDVars4;
        int n;
        JDDVars[] jDDVarsArray = probModel.getVarDDRowVars();
        JDDVars[] jDDVarsArray2 = probModel.getVarDDColVars();
        JDDVars jDDVars5 = probModel.getAllDDRowVars();
        JDDVars jDDVars6 = probModel.getAllDDColVars();
        VarList varList = probModel.getVarList();
        Object object = "_da";
        while (varList.getIndex((String)object) != -1) {
            object = "_" + (String)object;
        }
        ModelVariablesDD modelVariablesDD = probModel.getModelVariables().copy();
        int n2 = (int)Math.ceil(PrismUtils.log2(dA.size()));
        n2 = Math.max(n2, 1);
        boolean bl = modelVariablesDD.canPrependExtraStateVariable(n2);
        JDDVars jDDVars7 = new JDDVars();
        JDDVars jDDVars8 = new JDDVars();
        JDDVars jDDVars9 = modelVariablesDD.allocateExtraStateVariable(n2, (String)object, bl);
        for (n = 0; n < n2; ++n) {
            jDDVars7.addVar(jDDVars9.getVar(2 * n));
            jDDVars8.addVar(jDDVars9.getVar(2 * n + 1));
        }
        JDDVars[] jDDVarsArray3 = new JDDVars[jDDVarsArray.length + 1];
        JDDVars[] jDDVarsArray4 = new JDDVars[jDDVarsArray.length + 1];
        jDDVarsArray3[bl ? 0 : jDDVarsArray.length] = jDDVars7.copy();
        jDDVarsArray4[bl ? 0 : jDDVarsArray2.length] = jDDVars8.copy();
        for (n = 0; n < jDDVarsArray.length; ++n) {
            jDDVarsArray3[bl ? n + 1 : n] = jDDVarsArray[n].copy();
            jDDVarsArray4[bl ? n + 1 : n] = jDDVarsArray2[n].copy();
        }
        if (bl) {
            jDDVars4 = jDDVars7.copy();
            jDDVars3 = jDDVars8.copy();
            jDDVars4.copyVarsFrom(jDDVars5);
            jDDVars3.copyVarsFrom(jDDVars6);
        } else {
            jDDVars4 = jDDVars5.copy();
            jDDVars3 = jDDVars6.copy();
            jDDVars4.copyVarsFrom(jDDVars7);
            jDDVars3.copyVarsFrom(jDDVars8);
        }
        VarList varList2 = (VarList)varList.clone();
        Declaration declaration = new Declaration((String)object, new DeclarationInt(Expression.Int(0), Expression.Int(Math.max(dA.size() - 1, 1))));
        varList2.addVar(bl ? 0 : varList.getNumVars(), declaration, 1, probModel.getConstantValues());
        JDDNode jDDNode2 = this.buildTransMask(dA, vector, jDDVars5, jDDVars6, jDDVars7, jDDVars8);
        JDD.Ref(probModel.getTrans());
        jDDNode2 = JDD.Apply(3, probModel.getTrans(), jDDNode2);
        JDDNode jDDNode3 = this.buildStartMask(dA, vector, jDDVars7);
        jDDNode3 = JDD.And(probModel.getReach().copy(), jDDNode.copy(), jDDNode3);
        ProbModel probModel2 = new ProbModel(jDDNode2, jDDNode3, new JDDNode[0], new JDDNode[0], new String[0], jDDVars4, jDDVars3, modelVariablesDD, probModel.getNumModules(), probModel.getModuleNames(), JDDVars.copyArray(probModel.getModuleDDRowVars()), JDDVars.copyArray(probModel.getModuleDDColVars()), probModel.getNumVars() + 1, varList2, jDDVarsArray3, jDDVarsArray4, probModel.getConstantValues());
        probModel2.doReachability();
        probModel2.filterReachableStates();
        probModel2.findDeadlocks(false);
        if (probModel2.getDeadlockStates().size() > 0) {
            throw new PrismException("Model-" + dA.getAutomataType() + " product has deadlock states");
        }
        if (jDDVars != null) {
            jDDVars.copyVarsFrom(jDDVars7);
        }
        if (jDDVars2 != null) {
            jDDVars2.copyVarsFrom(jDDVars8);
        }
        JDD.Deref(jDDNode);
        jDDVars7.derefAll();
        jDDVars8.derefAll();
        return probModel2;
    }

    public NondetModel constructProductMDP(DA<BitSet, ? extends AcceptanceOmega> dA, NondetModel nondetModel, Vector<JDDNode> vector, JDDNode jDDNode) throws PrismException {
        return this.constructProductMDP(dA, nondetModel, vector, null, null, jDDNode);
    }

    @Deprecated
    public NondetModel constructProductMDP(DA<BitSet, ? extends AcceptanceOmega> dA, NondetModel nondetModel, Vector<JDDNode> vector) throws PrismException {
        return this.constructProductMDP(dA, nondetModel, vector, null, null, true, null);
    }

    public LTLProduct<ProbModel> constructProductMC(ProbModelChecker probModelChecker, ProbModel probModel, Expression expression, JDDNode jDDNode, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        Vector<JDDNode> vector = new Vector<JDDNode>();
        DA<BitSet, ? extends AcceptanceOmega> dA = this.constructDAForLTLFormula(probModelChecker, probModel, expression, vector, acceptanceTypeArray);
        return this.constructProductMC(probModel, dA, vector, jDDNode);
    }

    public LTLProduct<ProbModel> constructProductMC(ProbModel probModel, DA<BitSet, ? extends AcceptanceOmega> dA, Vector<JDDNode> vector, JDDNode jDDNode) throws PrismException {
        this.mainLog.println("\nConstructing MC-" + dA.getAutomataType() + " product...");
        JDDVars jDDVars = new JDDVars();
        JDDVars jDDVars2 = new JDDVars();
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("product construction");
        ProbModel probModel2 = this.constructProductMC(dA, probModel, vector, jDDVars, jDDVars2, jDDNode);
        stopWatch.stop();
        this.mainLog.println();
        probModel2.printTransInfo(this.mainLog, false);
        AcceptanceOmegaDD acceptanceOmegaDD = dA.getAcceptance().toAcceptanceDD(jDDVars);
        jDDVars2.derefAll();
        for (int i = 0; i < vector.size(); ++i) {
            JDD.Deref(vector.get(i));
        }
        return new LTLProduct<ProbModel>(probModel2, probModel, acceptanceOmegaDD, probModel2.getStart().copy(), jDDVars);
    }

    @Deprecated
    public NondetModel constructProductMDP(DA<BitSet, ? extends AcceptanceOmega> dA, NondetModel nondetModel, Vector<JDDNode> vector, JDDVars jDDVars, JDDVars jDDVars2) throws PrismException {
        return this.constructProductMDP(dA, nondetModel, vector, jDDVars, jDDVars2, true, null);
    }

    @Deprecated
    public NondetModel constructProductMDP(DA<BitSet, ? extends AcceptanceOmega> dA, NondetModel nondetModel, Vector<JDDNode> vector, JDDVars jDDVars, JDDVars jDDVars2, boolean bl, JDDNode jDDNode) throws PrismException {
        JDDNode jDDNode2 = bl ? nondetModel.getReach().copy() : jDDNode.copy();
        JDDVars jDDVars3 = jDDVars == null ? new JDDVars() : jDDVars;
        JDDVars jDDVars4 = jDDVars2 == null ? new JDDVars() : jDDVars2;
        NondetModel nondetModel2 = this.constructProductMDP(dA, nondetModel, vector, jDDVars3, jDDVars4, jDDNode2);
        JDDNode jDDNode3 = this.buildStartMask(dA, vector, jDDVars3);
        JDD.Ref(jDDNode != null ? jDDNode : nondetModel.getStart());
        jDDNode3 = JDD.And(jDDNode != null ? jDDNode : nondetModel.getStart(), jDDNode3);
        nondetModel2.setStart(jDDNode3);
        if (jDDVars == null) {
            jDDVars3.derefAll();
        }
        if (jDDVars2 == null) {
            jDDVars4.derefAll();
        }
        return nondetModel2;
    }

    public NondetModel constructProductMDP(DA<BitSet, ? extends AcceptanceOmega> dA, NondetModel nondetModel, Vector<JDDNode> vector, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode) throws PrismException {
        JDDVars jDDVars3;
        JDDVars jDDVars4;
        int n;
        JDDVars[] jDDVarsArray = nondetModel.getVarDDRowVars();
        JDDVars[] jDDVarsArray2 = nondetModel.getVarDDColVars();
        JDDVars jDDVars5 = nondetModel.getAllDDRowVars();
        JDDVars jDDVars6 = nondetModel.getAllDDColVars();
        VarList varList = nondetModel.getVarList();
        Object object = "_da";
        while (varList.getIndex((String)object) != -1) {
            object = "_" + (String)object;
        }
        ModelVariablesDD modelVariablesDD = nondetModel.getModelVariables().copy();
        int n2 = (int)Math.ceil(PrismUtils.log2(dA.size()));
        n2 = Math.max(n2, 1);
        boolean bl = modelVariablesDD.canPrependExtraStateVariable(n2);
        JDDVars jDDVars7 = new JDDVars();
        JDDVars jDDVars8 = new JDDVars();
        JDDVars jDDVars9 = modelVariablesDD.allocateExtraStateVariable(n2, (String)object, bl);
        for (n = 0; n < n2; ++n) {
            jDDVars7.addVar(jDDVars9.getVar(2 * n));
            jDDVars8.addVar(jDDVars9.getVar(2 * n + 1));
        }
        JDDVars[] jDDVarsArray3 = new JDDVars[jDDVarsArray.length + 1];
        JDDVars[] jDDVarsArray4 = new JDDVars[jDDVarsArray.length + 1];
        jDDVarsArray3[bl ? 0 : jDDVarsArray.length] = jDDVars7.copy();
        jDDVarsArray4[bl ? 0 : jDDVarsArray2.length] = jDDVars8.copy();
        for (n = 0; n < jDDVarsArray.length; ++n) {
            jDDVarsArray3[bl ? n + 1 : n] = jDDVarsArray[n].copy();
            jDDVarsArray4[bl ? n + 1 : n] = jDDVarsArray2[n].copy();
        }
        if (bl) {
            jDDVars4 = jDDVars7.copy();
            jDDVars3 = jDDVars8.copy();
            jDDVars4.copyVarsFrom(jDDVars5);
            jDDVars3.copyVarsFrom(jDDVars6);
        } else {
            jDDVars4 = jDDVars5.copy();
            jDDVars3 = jDDVars6.copy();
            jDDVars4.copyVarsFrom(jDDVars7);
            jDDVars3.copyVarsFrom(jDDVars8);
        }
        VarList varList2 = (VarList)varList.clone();
        Declaration declaration = new Declaration((String)object, new DeclarationInt(Expression.Int(0), Expression.Int(Math.max(dA.size() - 1, 1))));
        varList2.addVar(bl ? 0 : varList.getNumVars(), declaration, 1, nondetModel.getConstantValues());
        JDDNode jDDNode2 = this.buildTransMask(dA, vector, jDDVars5, jDDVars6, jDDVars7, jDDVars8);
        JDD.Ref(nondetModel.getTrans());
        jDDNode2 = JDD.Apply(3, nondetModel.getTrans(), jDDNode2);
        JDDNode jDDNode3 = this.buildStartMask(dA, vector, jDDVars7);
        jDDNode3 = JDD.And(nondetModel.getReach().copy(), jDDNode.copy(), jDDNode3);
        NondetModel nondetModel2 = new NondetModel(jDDNode2, jDDNode3, new JDDNode[0], new JDDNode[0], new String[0], jDDVars4, jDDVars3, nondetModel.getAllDDSchedVars().copy(), nondetModel.getAllDDSynchVars().copy(), nondetModel.getAllDDChoiceVars().copy(), nondetModel.getAllDDNondetVars().copy(), modelVariablesDD, nondetModel.getNumModules(), nondetModel.getModuleNames(), JDDVars.copyArray(nondetModel.getModuleDDRowVars()), JDDVars.copyArray(nondetModel.getModuleDDColVars()), nondetModel.getNumVars() + 1, varList2, jDDVarsArray3, jDDVarsArray4, nondetModel.getConstantValues());
        if (nondetModel.getTransActions() != null) {
            JDD.Ref(nondetModel.getTransActions());
            nondetModel2.setTransActions(nondetModel.getTransActions());
        }
        nondetModel2.setSynchs(new Vector<String>(nondetModel.getSynchs()));
        nondetModel2.doReachability();
        nondetModel2.filterReachableStates();
        nondetModel2.findDeadlocks(false);
        if (nondetModel2.getDeadlockStates().size() > 0) {
            throw new PrismException("Model-DA product has deadlock states");
        }
        if (jDDVars != null) {
            jDDVars.copyVarsFrom(jDDVars7);
        }
        if (jDDVars2 != null) {
            jDDVars2.copyVarsFrom(jDDVars8);
        }
        JDD.Deref(jDDNode);
        jDDVars7.derefAll();
        jDDVars8.derefAll();
        return nondetModel2;
    }

    public LTLProduct<NondetModel> constructProductMDP(NondetModelChecker nondetModelChecker, NondetModel nondetModel, Expression expression, JDDNode jDDNode, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        Vector<JDDNode> vector = new Vector<JDDNode>();
        DA<BitSet, ? extends AcceptanceOmega> dA = this.constructDAForLTLFormula(nondetModelChecker, nondetModel, expression, vector, acceptanceTypeArray);
        return this.constructProductMDP(nondetModel, dA, vector, jDDNode);
    }

    public LTLProduct<NondetModel> constructProductMDP(NondetModel nondetModel, DA<BitSet, ? extends AcceptanceOmega> dA, Vector<JDDNode> vector, JDDNode jDDNode) throws PrismException {
        this.mainLog.println("\nConstructing MDP-" + dA.getAutomataType() + " product...");
        JDDVars jDDVars = new JDDVars();
        JDDVars jDDVars2 = new JDDVars();
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("product construction");
        NondetModel nondetModel2 = this.constructProductMDP(dA, nondetModel, vector, jDDVars, jDDVars2, jDDNode);
        stopWatch.stop();
        this.mainLog.println();
        nondetModel2.printTransInfo(this.mainLog, this.getSettings().getBoolean("prism.extraDDInfo"));
        AcceptanceOmegaDD acceptanceOmegaDD = dA.getAcceptance().toAcceptanceDD(jDDVars);
        jDDVars2.derefAll();
        for (int i = 0; i < vector.size(); ++i) {
            JDD.Deref(vector.get(i));
        }
        return new LTLProduct<NondetModel>(nondetModel2, nondetModel, acceptanceOmegaDD, nondetModel2.getStart().copy(), jDDVars);
    }

    public JDDNode buildTransMask(DA<BitSet, ? extends AcceptanceOmega> dA, Vector<JDDNode> vector, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDVars jDDVars4) {
        int n = dA.getAPList().size();
        JDDNode jDDNode = JDD.Constant(0.0);
        int n2 = dA.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = dA.getNumEdges(i);
            for (int j = 0; j < n3; ++j) {
                JDDNode jDDNode2 = JDD.Constant(1.0);
                for (int k = 0; k < n; ++k) {
                    JDDNode jDDNode3 = vector.get(Integer.parseInt(dA.getAPList().get(k).substring(1)));
                    JDD.Ref(jDDNode3);
                    if (!dA.getEdgeLabel(i, j).get(k)) {
                        jDDNode3 = JDD.Not(jDDNode3);
                    }
                    jDDNode2 = JDD.And(jDDNode2, jDDNode3);
                }
                jDDNode2 = JDD.PermuteVariables(jDDNode2, jDDVars, jDDVars2);
                JDDNode jDDNode4 = JDD.SetMatrixElement(JDD.Constant(0.0), jDDVars3, jDDVars4, i, dA.getEdgeDest(i, j), 1.0);
                jDDNode4 = JDD.And(jDDNode4, jDDNode2);
                jDDNode = JDD.Or(jDDNode, jDDNode4);
            }
        }
        return jDDNode;
    }

    public JDDNode buildStartMask(DA<BitSet, ? extends AcceptanceOmega> dA, Vector<JDDNode> vector, JDDVars jDDVars) {
        int n = dA.getAPList().size();
        JDDNode jDDNode = JDD.Constant(0.0);
        int n2 = dA.getStartState();
        int n3 = dA.getNumEdges(n2);
        for (int i = 0; i < n3; ++i) {
            JDDNode jDDNode2 = JDD.Constant(1.0);
            for (int j = 0; j < n; ++j) {
                JDDNode jDDNode3 = vector.get(Integer.parseInt(dA.getAPList().get(j).substring(1)));
                JDD.Ref(jDDNode3);
                if (!dA.getEdgeLabel(n2, i).get(j)) {
                    jDDNode3 = JDD.Not(jDDNode3);
                }
                jDDNode2 = JDD.And(jDDNode2, jDDNode3);
            }
            JDDNode jDDNode4 = JDD.Constant(0.0);
            jDDNode4 = JDD.SetVectorElement(jDDNode4, jDDVars, dA.getEdgeDest(n2, i), 1.0);
            JDDNode jDDNode5 = JDD.And(jDDNode4, jDDNode2);
            jDDNode = JDD.Or(jDDNode, jDDNode5);
        }
        return jDDNode;
    }

    public JDDNode findAcceptingBSCCs(AcceptanceOmegaDD acceptanceOmegaDD, ProbModel probModel) throws PrismException {
        JDDNode jDDNode = JDD.Constant(0.0);
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, probModel);
        sCCComputer.computeBSCCs();
        List<JDDNode> list = sCCComputer.getBSCCs();
        JDD.Deref(sCCComputer.getNotInBSCCs());
        for (JDDNode jDDNode2 : list) {
            if (acceptanceOmegaDD.isBSCCAccepting(jDDNode2)) {
                JDD.Ref(jDDNode2);
                jDDNode = JDD.Or(jDDNode, jDDNode2);
            }
            JDD.Deref(jDDNode2);
        }
        return jDDNode;
    }

    public JDDNode findAcceptingECStates(AcceptanceOmegaDD acceptanceOmegaDD, NondetModel nondetModel, JDDVars jDDVars, JDDVars jDDVars2, boolean bl) throws PrismException {
        switch (acceptanceOmegaDD.getType()) {
            case BUCHI: {
                return this.findAcceptingECStatesForBuchi((AcceptanceBuchiDD)acceptanceOmegaDD, nondetModel, bl);
            }
            case RABIN: {
                return this.findAcceptingECStatesForRabin((AcceptanceRabinDD)acceptanceOmegaDD, nondetModel, jDDVars, jDDVars2, bl);
            }
            case GENERALIZED_RABIN: {
                return this.findAcceptingECStatesForGeneralizedRabin((AcceptanceGenRabinDD)acceptanceOmegaDD, nondetModel, jDDVars, jDDVars2, bl);
            }
        }
        throw new PrismNotSupportedException("Computing the accepting EC states for " + acceptanceOmegaDD.getTypeName() + " acceptance is not yet implemented (symbolic engine)");
    }

    public JDDNode findAcceptingECStatesForBuchi(AcceptanceBuchiDD acceptanceBuchiDD, NondetModel nondetModel, boolean bl) throws PrismException {
        JDDNode jDDNode = null;
        if (!bl) {
            List<JDDNode> list = this.findMECStates(nondetModel, nondetModel.getReach().copy());
            jDDNode = this.filteredUnion(list, acceptanceBuchiDD.getAcceptingStates());
        } else {
            JDDNode jDDNode2 = nondetModel.getTransReln().copy();
            JDDNode jDDNode3 = this.backwardSet(nondetModel, acceptanceBuchiDD.getAcceptingStates(), jDDNode2);
            jDDNode = this.findFairECs(nondetModel, jDDNode3);
        }
        return jDDNode;
    }

    public JDDNode findAcceptingECStatesForRabin(AcceptanceRabinDD acceptanceRabinDD, NondetModel nondetModel, JDDVars jDDVars, JDDVars jDDVars2, boolean bl) throws PrismException {
        JDDNode jDDNode = null;
        JDDNode jDDNode2 = JDD.Constant(0.0);
        if (acceptanceRabinDD.size() > 1) {
            JDDNode jDDNode3;
            Iterator iterator;
            Object object;
            int n;
            JDDNode jDDNode4 = JDD.Constant(0.0);
            JDDNode jDDNode5 = JDD.Constant(0.0);
            ArrayList<JDDNode> arrayList = new ArrayList<JDDNode>();
            ArrayList<JDDNode> arrayList2 = new ArrayList<JDDNode>();
            for (n = 0; n < acceptanceRabinDD.size(); ++n) {
                object = JDD.Not(((AcceptanceRabinDD.RabinPairDD)acceptanceRabinDD.get(n)).getL());
                iterator = ((AcceptanceRabinDD.RabinPairDD)acceptanceRabinDD.get(n)).getK();
                arrayList.add((JDDNode)object);
                JDD.Ref((JDDNode)object);
                jDDNode4 = JDD.Or(jDDNode4, (JDDNode)object);
                arrayList2.add((JDDNode)((Object)iterator));
                JDD.Ref((JDDNode)((Object)iterator));
                jDDNode5 = JDD.Or(jDDNode5, (JDDNode)((Object)iterator));
            }
            JDD.Ref(nondetModel.getTrans01());
            JDD.Ref(jDDNode4);
            JDDNode jDDNode6 = JDD.Apply(3, nondetModel.getTrans01(), jDDNode4);
            jDDNode4 = JDD.PermuteVariables(jDDNode4, jDDVars, jDDVars2);
            jDDNode6 = JDD.Apply(3, jDDNode6, jDDNode4);
            jDDNode6 = JDD.ThereExists(jDDNode6, nondetModel.getAllDDColVars());
            jDDNode6 = JDD.ThereExists(jDDNode6, nondetModel.getAllDDNondetVars());
            object = this.findMECStates(nondetModel, jDDNode6, jDDNode5);
            JDD.Deref(jDDNode5);
            JDD.Deref(jDDNode6);
            for (n = 0; n < acceptanceRabinDD.size(); ++n) {
                jDDNode4 = (JDDNode)arrayList.get(n);
                jDDNode5 = (JDDNode)arrayList2.get(n);
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object object2;
                    List<JDDNode> list;
                    jDDNode3 = (JDDNode)iterator.next();
                    if (bl) {
                        list = JDD.And(jDDNode3.copy(), jDDNode5.copy());
                        object2 = JDD.And(jDDNode3.copy(), jDDNode4.copy());
                        JDDNode jDDNode7 = nondetModel.getTransReln().copy();
                        jDDNode7 = JDD.And(jDDNode7, ((JDDNode)object2).copy());
                        JDDNode jDDNode8 = this.backwardSet(nondetModel, (JDDNode)((Object)list), jDDNode7);
                        JDDNode jDDNode9 = JDD.And((JDDNode)object2, jDDNode8);
                        jDDNode = this.findFairECs(nondetModel, jDDNode9);
                        jDDNode2 = JDD.Or(jDDNode2, jDDNode);
                        continue;
                    }
                    JDD.Ref(jDDNode3);
                    JDD.Ref(jDDNode4);
                    jDDNode6 = JDD.And(jDDNode3, jDDNode4);
                    if (jDDNode6.equals(jDDNode3)) {
                        list = new Vector();
                        JDD.Ref(jDDNode3);
                        list.add(jDDNode3);
                    } else {
                        if (jDDNode6.equals(JDD.ZERO)) {
                            JDD.Deref(jDDNode6);
                            continue;
                        }
                        JDD.Ref(nondetModel.getTrans01());
                        JDD.Ref(jDDNode6);
                        object2 = JDD.Apply(3, nondetModel.getTrans01(), jDDNode6);
                        jDDNode6 = JDD.PermuteVariables(jDDNode6, jDDVars, jDDVars2);
                        object2 = JDD.Apply(3, jDDNode6, (JDDNode)object2);
                        object2 = JDD.ThereExists((JDDNode)object2, nondetModel.getAllDDColVars());
                        jDDNode6 = JDD.ThereExists((JDDNode)object2, nondetModel.getAllDDNondetVars());
                        list = this.findMECStates(nondetModel, jDDNode6, jDDNode5);
                    }
                    JDD.Deref(jDDNode6);
                    jDDNode = JDD.Constant(0.0);
                    for (JDDNode jDDNode7 : list) {
                        if (JDD.AreIntersecting(jDDNode7, jDDNode5)) {
                            jDDNode = JDD.Or(jDDNode, jDDNode7);
                            continue;
                        }
                        JDD.Deref(jDDNode7);
                    }
                    jDDNode2 = JDD.Or(jDDNode2, jDDNode);
                }
                JDD.Deref(jDDNode5);
                JDD.Deref(jDDNode4);
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                jDDNode3 = (JDDNode)iterator.next();
                JDD.Deref(jDDNode3);
            }
        } else {
            for (int i = 0; i < acceptanceRabinDD.size(); ++i) {
                Object object;
                JDDNode jDDNode10 = JDD.Not(((AcceptanceRabinDD.RabinPairDD)acceptanceRabinDD.get(i)).getL());
                JDDNode jDDNode11 = ((AcceptanceRabinDD.RabinPairDD)acceptanceRabinDD.get(i)).getK();
                JDD.Ref(nondetModel.getTrans01());
                JDD.Ref(jDDNode10);
                JDDNode jDDNode12 = JDD.Apply(3, nondetModel.getTrans01(), jDDNode10);
                jDDNode10 = JDD.PermuteVariables(jDDNode10, jDDVars, jDDVars2);
                jDDNode12 = JDD.Apply(3, jDDNode12, jDDNode10);
                jDDNode12 = JDD.ThereExists(jDDNode12, nondetModel.getAllDDColVars());
                jDDNode12 = JDD.ThereExists(jDDNode12, nondetModel.getAllDDNondetVars());
                if (!bl) {
                    object = this.findMECStates(nondetModel, jDDNode12);
                    JDD.Deref(jDDNode12);
                    jDDNode = this.filteredUnion((List<JDDNode>)object, jDDNode11);
                } else {
                    JDD.Ref(jDDNode12);
                    object = JDD.And(jDDNode12, jDDNode11);
                    JDD.Ref(nondetModel.getTrans01());
                    JDDNode jDDNode13 = JDD.ThereExists(nondetModel.getTrans01(), nondetModel.getAllDDNondetVars());
                    JDDNode jDDNode14 = this.backwardSet(nondetModel, (JDDNode)object, jDDNode13);
                    jDDNode12 = JDD.And(jDDNode12, jDDNode14);
                    jDDNode = this.findFairECs(nondetModel, jDDNode12);
                }
                jDDNode2 = JDD.Or(jDDNode2, jDDNode);
            }
        }
        return jDDNode2;
    }

    public JDDNode findAcceptingECStatesForGeneralizedRabin(AcceptanceGenRabinDD acceptanceGenRabinDD, NondetModel nondetModel, JDDVars jDDVars, JDDVars jDDVars2, boolean bl) throws PrismException {
        if (bl) {
            throw new PrismNotSupportedException("Accepting end-component computation for generalized Rabin is currently not supported with fairness");
        }
        JDDNode jDDNode = JDD.Constant(0.0);
        for (int i = 0; i < acceptanceGenRabinDD.size(); ++i) {
            JDDNode jDDNode2 = JDD.Not(((AcceptanceGenRabinDD.GenRabinPairDD)acceptanceGenRabinDD.get(i)).getL());
            JDD.Ref(nondetModel.getTrans01());
            JDD.Ref(jDDNode2);
            JDDNode jDDNode3 = JDD.Apply(3, nondetModel.getTrans01(), jDDNode2);
            jDDNode2 = JDD.PermuteVariables(jDDNode2, jDDVars, jDDVars2);
            jDDNode3 = JDD.Apply(3, jDDNode3, jDDNode2);
            jDDNode3 = JDD.ThereExists(jDDNode3, nondetModel.getAllDDColVars());
            jDDNode3 = JDD.ThereExists(jDDNode3, nondetModel.getAllDDNondetVars());
            List<JDDNode> list = this.findMECStates(nondetModel, jDDNode3);
            JDD.Deref(jDDNode3);
            JDDNode jDDNode4 = JDD.Constant(0.0);
            for (int j = 0; j < list.size(); ++j) {
                if (((AcceptanceGenRabinDD.GenRabinPairDD)acceptanceGenRabinDD.get(i)).isBSCCAccepting(list.get(j))) {
                    jDDNode4 = JDD.Or(jDDNode4, list.get(j));
                    continue;
                }
                JDD.Deref(list.get(j));
            }
            jDDNode = JDD.Or(jDDNode, jDDNode4);
        }
        return jDDNode;
    }

    public JDDNode findMultiAcceptingStates(DA<BitSet, AcceptanceRabin> dA, NondetModel nondetModel, JDDVars jDDVars, JDDVars jDDVars2, boolean bl, List<JDDNode> list, List<JDDNode> list2, List<JDDNode> list3) throws PrismException {
        JDDNode jDDNode = null;
        JDDNode jDDNode2 = JDD.Constant(0.0);
        for (int i = 0; i < dA.getAcceptance().size(); ++i) {
            JDDNode jDDNode3 = list2.get(i);
            JDDNode jDDNode4 = list3.get(i);
            for (JDDNode jDDNode5 : list) {
                List<JDDNode> list4 = null;
                JDD.Ref(jDDNode5);
                JDD.Ref(jDDNode3);
                JDDNode jDDNode6 = JDD.And(jDDNode5, jDDNode3);
                if (jDDNode6.equals(jDDNode5)) {
                    list4 = new Vector<JDDNode>();
                    list4.add(jDDNode5.copy());
                    JDD.Deref(jDDNode6);
                } else {
                    if (jDDNode6.equals(JDD.ZERO)) {
                        JDD.Deref(jDDNode6);
                        continue;
                    }
                    JDD.Ref(nondetModel.getTrans01());
                    JDD.Ref(jDDNode6);
                    Object object = JDD.Apply(3, nondetModel.getTrans01(), jDDNode6);
                    jDDNode6 = JDD.PermuteVariables(jDDNode6, jDDVars, jDDVars2);
                    object = JDD.Apply(3, jDDNode6, (JDDNode)object);
                    object = JDD.ThereExists((JDDNode)object, nondetModel.getAllDDColVars());
                    jDDNode6 = JDD.ThereExists((JDDNode)object, nondetModel.getAllDDNondetVars());
                    list4 = this.findMECStates(nondetModel, jDDNode6, jDDNode4);
                    JDD.Deref(jDDNode6);
                }
                jDDNode = JDD.Constant(0.0);
                for (JDDNode jDDNode7 : list4) {
                    if (JDD.AreIntersecting(jDDNode7, jDDNode4)) {
                        jDDNode = JDD.Or(jDDNode, jDDNode7);
                        continue;
                    }
                    JDD.Deref(jDDNode7);
                }
                jDDNode2 = JDD.Or(jDDNode2, jDDNode);
            }
            JDD.Deref(jDDNode4);
            JDD.Deref(jDDNode3);
        }
        return jDDNode2;
    }

    public void findMultiConflictAcceptingStates(DA<BitSet, AcceptanceRabin>[] dAArray, NondetModel nondetModel, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2, List<JDDNode> list, List<List<JDDNode>> list2, List<List<JDDNode>> list3, List<JDDNode> list4, List<List<Integer>> list5) throws PrismException {
        int n;
        Object object;
        ArrayList<queueElement> arrayList = new ArrayList<queueElement>();
        int n2 = 0;
        for (int i = 0; i < dAArray.length; ++i) {
            ArrayList<Integer> object2 = new ArrayList<Integer>();
            object2.add(i);
            object = new queueElement(list2.get(i), list3.get(i), list.get(i), object2, i + 1);
            arrayList.add((queueElement)object);
        }
        while (n2 < arrayList.size()) {
            this.computeCombinations(dAArray, nondetModel, jDDVarsArray, jDDVarsArray2, list, list2, list3, arrayList, n2);
            ++n2;
        }
        for (queueElement queueElement2 : arrayList) {
            if (queueElement2.children == null) continue;
            object = queueElement2.targetDD;
            for (queueElement queueElement3 : queueElement2.children) {
                JDD.Ref(queueElement3.targetDD);
                object = JDD.And((JDDNode)object, JDD.Not(queueElement3.targetDD));
            }
            queueElement2.targetDD = object;
        }
        list.clear();
        for (n = 0; n < dAArray.length; ++n) {
            list.add(((queueElement)arrayList.get((int)n)).targetDD);
        }
        for (n = dAArray.length; n < arrayList.size(); ++n) {
            list4.add(((queueElement)arrayList.get((int)n)).targetDD);
            list5.add(((queueElement)arrayList.get((int)n)).draIDs);
        }
    }

    private void computeCombinations(DA<BitSet, AcceptanceRabin>[] dAArray, NondetModel nondetModel, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2, List<JDDNode> list, List<List<JDDNode>> list2, List<List<JDDNode>> list3, List<queueElement> list4, int n) throws PrismException {
        Object object;
        int n2;
        queueElement queueElement2 = list4.get(n);
        int n3 = list4.size();
        for (n2 = queueElement2.next; n2 < dAArray.length; ++n2) {
            Object object2;
            object = new ArrayList();
            ArrayList<JDDNode> arrayList = new ArrayList<JDDNode>();
            JDDNode jDDNode = JDD.Constant(0.0);
            List<JDDNode> list5 = list2.get(n2);
            List<JDDNode> list6 = list3.get(n2);
            JDD.Ref(queueElement2.targetDD);
            JDD.Ref(list.get(n2));
            JDDNode jDDNode2 = JDD.And(queueElement2.targetDD, list.get(n2));
            for (int i = 0; i < queueElement2.statesH.size(); ++i) {
                JDD.Ref(jDDNode2);
                JDD.Ref(queueElement2.statesH.get(i));
                object2 = JDD.And(jDDNode2, queueElement2.statesH.get(i));
                for (int j = 0; j < list5.size(); ++j) {
                    JDD.Ref((JDDNode)object2);
                    JDD.Ref(list5.get(j));
                    JDDNode jDDNode3 = JDD.And((JDDNode)object2, list5.get(j));
                    JDD.Ref(nondetModel.getTrans01());
                    JDD.Ref(jDDNode3);
                    JDDNode jDDNode4 = JDD.Apply(3, nondetModel.getTrans01(), jDDNode3);
                    jDDNode3 = JDD.PermuteVariables(jDDNode3, nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars());
                    jDDNode4 = JDD.Apply(3, jDDNode3, jDDNode4);
                    jDDNode4 = JDD.ThereExists(jDDNode4, nondetModel.getAllDDColVars());
                    jDDNode3 = JDD.ThereExists(jDDNode4, nondetModel.getAllDDNondetVars());
                    JDD.Ref(queueElement2.statesL.get(i));
                    JDD.Ref(list6.get(j));
                    JDDNode jDDNode5 = JDD.And(queueElement2.statesL.get(i), list6.get(j));
                    List<JDDNode> list7 = null;
                    list7 = this.findMECStates(nondetModel, jDDNode3, jDDNode5);
                    JDD.Deref(jDDNode3);
                    if (list7 != null) {
                        boolean bl = false;
                        for (JDDNode jDDNode6 : list7) {
                            if (JDD.AreIntersecting(jDDNode6, jDDNode5)) {
                                jDDNode = JDD.Or(jDDNode, jDDNode6);
                                bl = true;
                                continue;
                            }
                            JDD.Deref(jDDNode6);
                        }
                        if (bl) {
                            JDD.Ref(queueElement2.statesH.get(i));
                            JDD.Ref(list5.get(j));
                            JDDNode jDDNode7 = JDD.And(queueElement2.statesH.get(i), list5.get(j));
                            object.add(jDDNode7);
                            JDD.Ref(jDDNode5);
                            arrayList.add(jDDNode5);
                        }
                    }
                    JDD.Deref(jDDNode5);
                }
                JDD.Deref((JDDNode)object2);
            }
            JDD.Deref(jDDNode2);
            if (!object.isEmpty()) {
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>(queueElement2.draIDs);
                arrayList2.add(n2);
                object2 = new queueElement((List<JDDNode>)object, arrayList, jDDNode, arrayList2, n2 + 1);
                list4.add((queueElement)object2);
                queueElement2.addChildren((queueElement)object2);
                continue;
            }
            JDD.Deref(jDDNode);
        }
        for (n2 = n3 - 1; n2 > n; --n2) {
            object = list4.get(n2);
            if (((queueElement)object).draIDs.size() <= queueElement2.draIDs.size()) break;
            if (!((queueElement)object).draIDs.containsAll(queueElement2.draIDs)) continue;
            queueElement2.addChildren((queueElement)object);
        }
        if (queueElement2.draIDs.size() > 1) {
            for (n2 = 0; n2 < queueElement2.statesH.size(); ++n2) {
                JDD.Deref(queueElement2.statesH.get(n2));
                JDD.Deref(queueElement2.statesL.get(n2));
            }
        }
    }

    private JDDNode findFairECs(NondetModel nondetModel, JDDNode jDDNode) {
        JDDNode jDDNode2 = JDD.Constant(0.0);
        JDDNode jDDNode3 = jDDNode;
        while (!jDDNode3.equals(jDDNode2)) {
            JDD.Deref(jDDNode2);
            JDD.Ref(jDDNode3);
            jDDNode2 = jDDNode3;
            JDD.Ref(jDDNode3);
            JDD.Ref(nondetModel.getTrans01());
            JDDNode jDDNode4 = JDD.And(nondetModel.getTrans01(), jDDNode3);
            JDD.Ref(jDDNode3);
            JDDNode jDDNode5 = JDD.Not(JDD.PermuteVariables(jDDNode3, nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars()));
            jDDNode5 = JDD.And(jDDNode4, jDDNode5);
            jDDNode5 = JDD.ThereExists(jDDNode5, nondetModel.getAllDDColVars());
            jDDNode5 = JDD.ThereExists(jDDNode5, nondetModel.getAllDDNondetVars());
            jDDNode3 = JDD.And(jDDNode3, JDD.Not(jDDNode5));
        }
        JDD.Deref(jDDNode2);
        return jDDNode3;
    }

    private JDDNode backwardSet(NondetModel nondetModel, JDDNode jDDNode, JDDNode jDDNode2) {
        JDDNode jDDNode3 = JDD.Constant(0.0);
        JDDNode jDDNode4 = jDDNode;
        while (!jDDNode4.equals(jDDNode3)) {
            JDD.Deref(jDDNode3);
            JDD.Ref(jDDNode4);
            jDDNode3 = jDDNode4;
            JDD.Ref(jDDNode4);
            JDD.Ref(jDDNode2);
            jDDNode4 = JDD.Or(jDDNode4, this.preimage(nondetModel, jDDNode4, jDDNode2));
        }
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode3);
        return jDDNode4;
    }

    private JDDNode preimage(NondetModel nondetModel, JDDNode jDDNode, JDDNode jDDNode2) {
        JDDNode jDDNode3 = JDD.PermuteVariables(jDDNode, nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars());
        jDDNode3 = JDD.And(jDDNode2, jDDNode3);
        jDDNode3 = JDD.ThereExists(jDDNode3, nondetModel.getAllDDColVars());
        return jDDNode3;
    }

    public List<JDDNode> findMECStates(NondetModel nondetModel, JDDNode jDDNode) throws PrismException {
        ECComputer eCComputer = ECComputer.createECComputer(this, nondetModel);
        eCComputer.computeMECStates(jDDNode, null);
        return eCComputer.getMECStates();
    }

    public List<JDDNode> findMECStates(NondetModel nondetModel, JDDNode jDDNode, JDDNode jDDNode2) throws PrismException {
        ECComputer eCComputer = ECComputer.createECComputer(this, nondetModel);
        eCComputer.computeMECStates(jDDNode, jDDNode2);
        return eCComputer.getMECStates();
    }

    public List<JDDNode> findBottomEndComponents(NondetModel nondetModel, JDDNode jDDNode) throws PrismException {
        List<JDDNode> list = this.findMECStates(nondetModel, jDDNode);
        Vector<JDDNode> vector = new Vector<JDDNode>();
        for (JDDNode jDDNode2 : list) {
            JDD.Ref(nondetModel.getTrans01());
            JDD.Ref(jDDNode2);
            JDDNode jDDNode3 = JDD.And(nondetModel.getTrans01(), jDDNode2);
            JDD.Ref(jDDNode2);
            jDDNode3 = JDD.And(jDDNode3, JDD.Not(JDD.PermuteVariables(jDDNode2, nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars())));
            if (jDDNode3.equals(JDD.ZERO)) {
                vector.add(jDDNode2);
            } else {
                JDD.Deref(jDDNode2);
            }
            JDD.Deref(jDDNode3);
        }
        return vector;
    }

    public JDDNode maxStableSetTrans1(NondetModel nondetModel, JDDNode jDDNode) {
        JDD.Ref(jDDNode);
        JDD.Ref(nondetModel.getTrans());
        JDDNode jDDNode2 = JDD.Apply(3, nondetModel.getTrans(), jDDNode);
        JDDNode jDDNode3 = JDD.PermuteVariables(jDDNode, nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars());
        jDDNode3 = JDD.Apply(3, jDDNode2, jDDNode3);
        jDDNode3 = JDD.SumAbstract(jDDNode3, nondetModel.getAllDDColVars());
        jDDNode3 = JDD.GreaterThan(jDDNode3, 1.0 - this.settings.getDouble("prism.sumRoundOff"));
        JDD.Ref(nondetModel.getTrans01());
        JDDNode jDDNode4 = JDD.And(nondetModel.getTrans01(), jDDNode3);
        return jDDNode4;
    }

    private JDDNode filteredUnion(List<JDDNode> list, JDDNode jDDNode) {
        JDDNode jDDNode2 = JDD.Constant(0.0);
        for (JDDNode jDDNode3 : list) {
            if (JDD.AreIntersecting(jDDNode3, jDDNode)) {
                jDDNode2 = JDD.Or(jDDNode2, jDDNode3);
                continue;
            }
            JDD.Deref(jDDNode3);
        }
        JDD.Deref(jDDNode);
        return jDDNode2;
    }

    public static class LTLProduct<M extends Model>
    extends Product<M> {
        private AcceptanceOmegaDD acceptance;
        private AcceptanceOmegaDD prodAcceptance = null;

        public LTLProduct(M m, M m2, AcceptanceOmegaDD acceptanceOmegaDD, JDDNode jDDNode, JDDVars jDDVars) {
            super(m, m2, jDDNode, jDDVars);
            this.acceptance = acceptanceOmegaDD;
        }

        public AcceptanceOmegaDD getAcceptance() {
            return this.acceptance;
        }

        public AcceptanceOmegaDD getProductAcceptance() {
            if (this.prodAcceptance == null) {
                this.prodAcceptance = this.acceptance.clone();
                this.prodAcceptance.intersect(this.getProductModel().getReach());
            }
            return this.prodAcceptance;
        }

        public void setAcceptance(AcceptanceOmegaDD acceptanceOmegaDD) {
            if (this.acceptance != null) {
                this.acceptance.clear();
            }
            this.acceptance = acceptanceOmegaDD;
        }

        @Override
        public void clear() {
            super.clear();
            this.acceptance.clear();
            this.acceptance = null;
            if (this.prodAcceptance != null) {
                this.prodAcceptance.clear();
                this.prodAcceptance = null;
            }
        }
    }
}

