/*
 * Decompiled with CFR 0.152.
 */
package prism;

import explicit.DTMC;
import explicit.MDP;
import explicit.MDPSimple;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.Declaration;
import parser.ast.DeclarationInt;
import parser.ast.Expression;
import parser.ast.Module;
import parser.ast.ModulesFile;
import prism.Model;
import prism.ModelType;
import prism.ModelVariablesDD;
import prism.NondetModel;
import prism.Prism;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismLog;
import prism.ProbModel;
import prism.ProgressDisplay;
import prism.StochModel;

public class ExplicitModel2MTBDD {
    private Prism prism;
    private PrismLog mainLog;
    private explicit.Model modelExpl;
    private ModulesFile modulesFile;
    private ModelType modelType;
    private int numVars;
    private VarList varList;
    private int numStates = 0;
    private List<State> statesList = null;
    private JDDNode trans;
    private JDDNode start;
    private JDDNode stateRewards;
    private JDDNode transRewards;
    private JDDVars allDDRowVars;
    private JDDVars allDDColVars;
    private JDDVars allDDSynchVars;
    private JDDVars allDDSchedVars;
    private JDDVars allDDChoiceVars;
    private JDDVars allDDNondetVars;
    private JDDVars[] moduleDDRowVars;
    private JDDVars[] moduleDDColVars;
    private JDDVars[] varDDRowVars;
    private JDDVars[] varDDColVars;
    private JDDNode[] ddSynchVars;
    private JDDNode[] ddSchedVars;
    private JDDNode[] ddChoiceVars;
    private ModelVariablesDD modelVariables;
    private Vector<String> synchs;
    private JDDNode transActions;
    private Vector<JDDNode> transPerAction;
    private int maxNumChoices = 0;

    public ExplicitModel2MTBDD(Prism prism) {
        this.prism = prism;
        this.mainLog = prism.getMainLog();
    }

    public Model buildModel(explicit.Model model, List<State> list, ModulesFile modulesFile, boolean bl) throws PrismException {
        JDDNode jDDNode;
        JDDNode jDDNode2;
        String[] stringArray;
        Model model2 = null;
        this.modelExpl = model;
        this.modelType = model.getModelType();
        this.numStates = model.getNumStates();
        this.statesList = list;
        if (list != null) {
            this.modulesFile = modulesFile;
        } else {
            this.modulesFile = modulesFile = new ModulesFile();
            Module module = new Module("M");
            stringArray = new Declaration("x", new DeclarationInt(Expression.Int(0), Expression.Int(this.numStates - 1)));
            stringArray.setStart(Expression.Int(0));
            module.addDeclaration((Declaration)stringArray);
            modulesFile.addModule(module);
            modulesFile.tidyUp();
        }
        this.varList = modulesFile.createVarList();
        this.numVars = this.varList.getNumVars();
        if (this.modelType == ModelType.MDP) {
            this.maxNumChoices = ((MDPSimple)model).getMaxNumChoices();
        }
        this.allocateDDVars();
        this.sortDDVars();
        this.buildTrans(model);
        if (this.modelType == ModelType.MDP) {
            jDDNode2 = JDD.GetSupport(this.trans);
            jDDNode2 = JDD.ThereExists(jDDNode2, this.allDDRowVars);
            jDDNode = jDDNode2 = JDD.ThereExists(jDDNode2, this.allDDColVars);
            JDDVars jDDVars = new JDDVars();
            while (!jDDNode.equals(JDD.ONE)) {
                jDDVars.addVar(JDD.Var(jDDNode.getIndex()));
                jDDNode = jDDNode.getThen();
            }
            JDD.Deref(jDDNode2);
            this.allDDNondetVars.derefAll();
            this.allDDNondetVars = jDDVars;
        }
        this.buildInit();
        this.computeStateRewards();
        int n = 1;
        stringArray = modulesFile.getModuleNames();
        Values values = new Values();
        JDDNode[] jDDNodeArray = new JDDNode[]{};
        JDDNode[] jDDNodeArray2 = new JDDNode[]{};
        String[] stringArray2 = new String[]{};
        if (this.modelType == ModelType.DTMC) {
            model2 = new ProbModel(this.trans, this.start, jDDNodeArray, jDDNodeArray2, stringArray2, this.allDDRowVars, this.allDDColVars, this.modelVariables, n, stringArray, this.moduleDDRowVars, this.moduleDDColVars, this.numVars, this.varList, this.varDDRowVars, this.varDDColVars, values);
        } else if (this.modelType == ModelType.MDP) {
            model2 = new NondetModel(this.trans, this.start, jDDNodeArray, jDDNodeArray2, stringArray2, this.allDDRowVars, this.allDDColVars, this.allDDSynchVars, this.allDDSchedVars, this.allDDChoiceVars, this.allDDNondetVars, this.modelVariables, n, stringArray, this.moduleDDRowVars, this.moduleDDColVars, this.numVars, this.varList, this.varDDRowVars, this.varDDColVars, values);
        } else if (this.modelType == ModelType.CTMC) {
            model2 = new StochModel(this.trans, this.start, jDDNodeArray, jDDNodeArray2, stringArray2, this.allDDRowVars, this.allDDColVars, this.modelVariables, n, stringArray, this.moduleDDRowVars, this.moduleDDColVars, this.numVars, this.varList, this.varDDRowVars, this.varDDColVars, values);
        }
        model2.setSynchs(this.synchs);
        if (this.modelType != ModelType.MDP) {
            model2.setTransPerAction(this.transPerAction.toArray(new JDDNode[0]));
        } else {
            model2.setTransActions(this.transActions);
        }
        if (bl) {
            this.mainLog.print("\nComputing reachable states...\n");
            model2.doReachability();
            model2.filterReachableStates();
        } else {
            JDD.Ref(this.trans);
            jDDNode2 = JDD.GreaterThan(this.trans, 0.0);
            if (this.modelType == ModelType.MDP) {
                jDDNode2 = JDD.ThereExists(jDDNode2, this.allDDNondetVars);
            }
            JDD.Ref(jDDNode2);
            jDDNode = JDD.ThereExists(jDDNode2, this.allDDRowVars);
            jDDNode = JDD.SwapVariables(jDDNode, this.allDDColVars, this.allDDRowVars);
            jDDNode2 = JDD.ThereExists(jDDNode2, this.allDDColVars);
            jDDNode2 = JDD.Or(jDDNode2, jDDNode);
            model2.setReach(jDDNode2);
            model2.filterReachableStates();
        }
        if (this.prism.getExtraDDInfo()) {
            this.mainLog.print("Reach: " + JDD.GetNumNodes(model2.getReach()) + " nodes\n");
        }
        model2.findDeadlocks(this.prism.getFixDeadlocks());
        if (this.modelType == ModelType.MDP) {
            int n2;
            for (n2 = 0; n2 < this.ddSynchVars.length; ++n2) {
                JDD.Deref(this.ddSynchVars[n2]);
            }
            for (n2 = 0; n2 < this.ddSchedVars.length; ++n2) {
                JDD.Deref(this.ddSchedVars[n2]);
            }
            for (n2 = 0; n2 < this.ddChoiceVars.length; ++n2) {
                JDD.Deref(this.ddChoiceVars[n2]);
            }
        }
        return model2;
    }

    private void allocateDDVars() {
        int n;
        this.modelVariables = new ModelVariablesDD();
        if (this.modelType == ModelType.MDP) {
            this.ddSynchVars = new JDDNode[0];
            this.ddSchedVars = new JDDNode[0];
            this.ddChoiceVars = new JDDNode[this.maxNumChoices];
        }
        this.varDDRowVars = new JDDVars[this.numVars];
        this.varDDColVars = new JDDVars[this.numVars];
        for (n = 0; n < this.numVars; ++n) {
            this.varDDRowVars[n] = new JDDVars();
            this.varDDColVars[n] = new JDDVars();
        }
        if (this.modelType == ModelType.MDP) {
            for (n = 0; n < this.maxNumChoices; ++n) {
                this.ddChoiceVars[n] = this.modelVariables.allocateVariable("l" + n);
            }
        }
        for (n = 0; n < this.numVars; ++n) {
            int n2 = this.varList.getRangeLogTwo(n);
            for (int i = 0; i < n2; ++i) {
                this.varDDRowVars[n].addVar(this.modelVariables.allocateVariable(this.varList.getName(n) + "." + i));
                this.varDDColVars[n].addVar(this.modelVariables.allocateVariable(this.varList.getName(n) + "'." + i));
            }
        }
    }

    private void sortDDVars() {
        int n;
        this.moduleDDRowVars = new JDDVars[1];
        this.moduleDDColVars = new JDDVars[1];
        this.moduleDDRowVars[0] = new JDDVars();
        this.moduleDDColVars[0] = new JDDVars();
        for (n = 0; n < this.numVars; ++n) {
            this.moduleDDRowVars[0].copyVarsFrom(this.varDDRowVars[n]);
            this.moduleDDColVars[0].copyVarsFrom(this.varDDColVars[n]);
        }
        this.allDDRowVars = new JDDVars();
        this.allDDColVars = new JDDVars();
        if (this.modelType == ModelType.MDP) {
            this.allDDSynchVars = new JDDVars();
            this.allDDSchedVars = new JDDVars();
            this.allDDChoiceVars = new JDDVars();
            this.allDDNondetVars = new JDDVars();
        }
        for (n = 0; n < this.numVars; ++n) {
            this.allDDRowVars.copyVarsFrom(this.varDDRowVars[n]);
            this.allDDColVars.copyVarsFrom(this.varDDColVars[n]);
        }
        if (this.modelType == ModelType.MDP) {
            for (n = 0; n < this.ddChoiceVars.length; ++n) {
                JDD.Ref(this.ddChoiceVars[n]);
                JDD.Ref(this.ddChoiceVars[n]);
                this.allDDChoiceVars.addVar(this.ddChoiceVars[n]);
                this.allDDNondetVars.addVar(this.ddChoiceVars[n]);
            }
        }
    }

    private void buildTrans(explicit.Model model) throws PrismException {
        int n = 0;
        this.mainLog.print("Converting to MTBDD: ");
        this.synchs = new Vector();
        this.trans = JDD.Constant(0.0);
        this.transRewards = JDD.Constant(0.0);
        if (this.modelType != ModelType.MDP) {
            this.transPerAction = new Vector();
            this.transPerAction.add(JDD.Constant(0.0));
        } else {
            this.transActions = JDD.Constant(0.0);
        }
        int n2 = model.getNumTransitions();
        int n3 = 0;
        ProgressDisplay progressDisplay = new ProgressDisplay(this.mainLog);
        progressDisplay.setTotalCount(n2);
        progressDisplay.start();
        if (this.modelType == ModelType.DTMC || this.modelType == ModelType.CTMC) {
            DTMC dTMC = (DTMC)model;
            for (int i = 0; i < this.numStates; ++i) {
                Iterator<Map.Entry<Integer, Double>> iterator = dTMC.getTransitionsIterator(i);
                while (iterator.hasNext()) {
                    JDDNode jDDNode;
                    int n4;
                    Map.Entry<Integer, Double> entry = iterator.next();
                    int n5 = entry.getKey();
                    double d = entry.getValue();
                    String string = "";
                    JDDNode jDDNode2 = this.encodeStatePair(i, n5);
                    JDD.Ref(jDDNode2);
                    this.trans = JDD.Apply(1, this.trans, JDD.Apply(3, JDD.Constant(d), jDDNode2));
                    if (!"".equals(string)) {
                        n4 = this.synchs.indexOf(string);
                        if (n4 == -1) {
                            this.synchs.add(string);
                            n4 = this.synchs.size() - 1;
                        }
                        ++n4;
                    } else {
                        n4 = 0;
                    }
                    if (n4 < this.transPerAction.size()) {
                        jDDNode = this.transPerAction.get(n4);
                    } else {
                        jDDNode = JDD.Constant(0.0);
                        this.transPerAction.add(jDDNode);
                    }
                    JDD.Ref(jDDNode2);
                    jDDNode = JDD.Apply(1, jDDNode, JDD.Apply(3, JDD.Constant(d), jDDNode2));
                    this.transPerAction.set(n4, jDDNode);
                    JDD.Deref(jDDNode2);
                    progressDisplay.updateIfReady(++n3);
                }
            }
        } else if (this.modelType == ModelType.MDP) {
            MDP mDP = (MDP)model;
            for (int i = 0; i < this.numStates; ++i) {
                int n6 = mDP.getNumChoices(i);
                for (n = 0; n < n6; ++n) {
                    Iterator<Map.Entry<Integer, Double>> iterator = mDP.getTransitionsIterator(i, n);
                    while (iterator.hasNext()) {
                        int n7;
                        Map.Entry<Integer, Double> entry = iterator.next();
                        int n8 = entry.getKey();
                        double d = entry.getValue();
                        String string = "";
                        JDDNode jDDNode = JDD.SetVectorElement(JDD.Constant(0.0), this.allDDChoiceVars, n, 1.0);
                        jDDNode = JDD.Apply(3, jDDNode, this.encodeStatePair(i, n8));
                        JDD.Ref(jDDNode);
                        this.trans = JDD.Apply(1, this.trans, JDD.Apply(3, JDD.Constant(d), jDDNode));
                        if (!"".equals(string)) {
                            n7 = this.synchs.indexOf(string);
                            if (n7 == -1) {
                                this.synchs.add(string);
                                n7 = this.synchs.size() - 1;
                            }
                            ++n7;
                        } else {
                            n7 = 0;
                        }
                        JDD.Ref(jDDNode);
                        JDDNode jDDNode3 = JDD.ThereExists(jDDNode, this.allDDColVars);
                        this.transActions = JDD.Apply(6, this.transActions, JDD.Apply(3, JDD.Constant(n7), jDDNode3));
                        JDD.Deref(jDDNode);
                        progressDisplay.updateIfReady(++n3);
                    }
                }
            }
        } else {
            throw new PrismException("Unknown model type");
        }
        progressDisplay.update(n2);
        progressDisplay.end();
    }

    private void buildInit() throws PrismException {
        this.start = JDD.Constant(0.0);
        for (int n : this.modelExpl.getInitialStates()) {
            this.start = JDD.Or(this.start, this.encodeState(n));
        }
    }

    public void computeStateRewards() throws PrismException {
    }

    private JDDNode encodeState(int n) {
        JDDNode jDDNode;
        int n2 = 0;
        if (this.statesList == null) {
            jDDNode = JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[0], n, 1.0);
        } else {
            jDDNode = JDD.Constant(1.0);
            for (int i = 0; i < this.numVars; ++i) {
                try {
                    n2 = this.varList.encodeToInt(i, this.statesList.get((int)n).varValues[i]);
                }
                catch (PrismLangException prismLangException) {
                    // empty catch block
                }
                jDDNode = JDD.Apply(3, jDDNode, JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[i], n2, 1.0));
            }
        }
        return jDDNode;
    }

    private JDDNode encodeStatePair(int n, int n2) {
        JDDNode jDDNode;
        int n3 = 0;
        int n4 = 0;
        if (this.statesList == null) {
            jDDNode = JDD.SetMatrixElement(JDD.Constant(0.0), this.varDDRowVars[0], this.varDDColVars[0], n, n2, 1.0);
        } else {
            jDDNode = JDD.Constant(1.0);
            for (int i = 0; i < this.numVars; ++i) {
                try {
                    n3 = this.varList.encodeToInt(i, this.statesList.get((int)n).varValues[i]);
                    n4 = this.varList.encodeToInt(i, this.statesList.get((int)n2).varValues[i]);
                }
                catch (PrismLangException prismLangException) {
                    // empty catch block
                }
                jDDNode = JDD.Apply(3, jDDNode, JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[i], n3, 1.0));
                jDDNode = JDD.Apply(3, jDDNode, JDD.SetVectorElement(JDD.Constant(0.0), this.varDDColVars[i], n4, 1.0));
            }
        }
        return jDDNode;
    }
}

