/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import parser.State;
import prism.PrismComponent;
import prism.PrismException;
import prism.RewardGenerator;

public class ExplicitFilesRewardGenerator
extends PrismComponent
implements RewardGenerator {
    private File stateRewardsFile;
    private int numStates;
    private List<State> statesList = null;
    private boolean stateRewardsLoaded = false;
    private double[] stateRewards;

    public ExplicitFilesRewardGenerator(PrismComponent prismComponent) {
        super(prismComponent);
    }

    public ExplicitFilesRewardGenerator(PrismComponent prismComponent, File file, int n) throws PrismException {
        this(prismComponent);
        this.stateRewardsFile = file;
        this.numStates = n;
    }

    public void setStatesList(List<State> list) {
        this.statesList = list;
    }

    private void extractStateRewards() throws PrismException {
        int n = -1;
        this.stateRewards = new double[this.numStates];
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.stateRewardsFile));){
            bufferedReader.readLine();
            n = 1;
            String string = bufferedReader.readLine();
            ++n;
            while (string != null) {
                if ((string = string.trim()).length() > 0) {
                    double d;
                    String[] stringArray = string.split(" ");
                    int n2 = Integer.parseInt(stringArray[0]);
                    if (n2 < 0 || n2 >= this.numStates) {
                        throw new PrismException("Invalid state index " + n2);
                    }
                    this.stateRewards[n2] = d = Double.parseDouble(stringArray[1]);
                }
                string = bufferedReader.readLine();
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + this.stateRewardsFile + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected " + numberFormatException.getMessage() + "at line " + n + " of states file \"" + this.stateRewardsFile + "\"");
        }
    }

    @Override
    public List<String> getRewardStructNames() {
        return Collections.singletonList("");
    }

    @Override
    public boolean rewardStructHasTransitionRewards(int n) {
        return false;
    }

    @Override
    public boolean isRewardLookupSupported(RewardGenerator.RewardLookup rewardLookup) {
        return rewardLookup == RewardGenerator.RewardLookup.BY_STATE_INDEX || rewardLookup == RewardGenerator.RewardLookup.BY_STATE && this.statesList != null;
    }

    @Override
    public double getStateReward(int n, State state) throws PrismException {
        if (this.statesList == null) {
            throw new PrismException("Reward lookup by State not possible since state list is missing");
        }
        int n2 = this.statesList.indexOf(state);
        if (n2 == -1) {
            throw new PrismException("Unknown state " + state);
        }
        return this.getStateReward(n, n2);
    }

    @Override
    public double getStateReward(int n, int n2) throws PrismException {
        if (n != 0) {
            throw new PrismException("Only one reward structure has been imported");
        }
        if (!this.stateRewardsLoaded) {
            this.extractStateRewards();
        }
        return this.stateRewards[n2];
    }
}

