/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import param.BigRational;
import parser.EvaluateContext;
import parser.ast.Expression;
import parser.ast.ExpressionLabel;
import parser.type.TypeBool;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class ExpressionFilter
extends Expression {
    private FilterOperator opType;
    private String opName;
    private Expression operand;
    private Expression filter;
    private boolean invisible = false;
    private boolean explanationEnabled = true;
    private boolean param = false;

    public ExpressionFilter(String string, Expression expression) {
        this(string, expression, null);
    }

    public ExpressionFilter(String string, Expression expression, Expression expression2) {
        this.setOperator(string);
        this.setOperand(expression);
        this.setFilter(expression2);
    }

    public void setOperator(String string) {
        this.opName = string;
        for (FilterOperator filterOperator : FilterOperator.values()) {
            if (!filterOperator.keyword.equals(string)) continue;
            this.opType = filterOperator;
            return;
        }
        this.opType = "+".equals(string) ? FilterOperator.SUM : ("&".equals(string) ? FilterOperator.FORALL : ("|".equals(string) ? FilterOperator.EXISTS : null));
    }

    public void setOperand(Expression expression) {
        this.operand = expression;
    }

    public void setFilter(Expression expression) {
        this.filter = expression;
    }

    public void setInvisible(boolean bl) {
        this.invisible = bl;
    }

    public void setExplanationEnabled(boolean bl) {
        this.explanationEnabled = bl;
    }

    public void setParam() {
        this.param = true;
    }

    public FilterOperator getOperatorType() {
        return this.opType;
    }

    public String getOperatorName() {
        return this.opName;
    }

    public Expression getOperand() {
        return this.operand;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public boolean getExplanationEnabled() {
        return this.explanationEnabled;
    }

    public boolean isParam() {
        return this.param;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isProposition() {
        return false;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        throw new PrismLangException("Cannot evaluate a filter without a model");
    }

    @Override
    public BigRational evaluateExact(EvaluateContext evaluateContext) throws PrismLangException {
        throw new PrismLangException("Cannot evaluate a filter without a model");
    }

    @Override
    public boolean returnsSingleValue() {
        if (this.opType == FilterOperator.PRINT) {
            return false;
        }
        if (this.opType == FilterOperator.PRINTALL) {
            return false;
        }
        if (this.opType == FilterOperator.ARGMIN) {
            return false;
        }
        if (this.opType == FilterOperator.ARGMAX) {
            return false;
        }
        if (this.opType == FilterOperator.STORE) {
            return false;
        }
        return !this.param;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public Expression deepCopy() {
        ExpressionFilter expressionFilter = new ExpressionFilter(this.opName, this.operand.deepCopy(), this.filter == null ? null : this.filter.deepCopy());
        expressionFilter.setInvisible(this.invisible);
        expressionFilter.setType(this.type);
        expressionFilter.setPosition(this);
        expressionFilter.param = this.param;
        return expressionFilter;
    }

    @Override
    public String toString() {
        Object object = "";
        if (this.invisible) {
            return this.operand.toString();
        }
        object = (String)object + (this.param ? "paramfilter(" : "filter(") + this.opName + ", " + this.operand;
        if (this.filter != null) {
            object = (String)object + ", " + this.filter;
        }
        object = (String)object + ")";
        return object;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.explanationEnabled ? 1231 : 1237);
        n = 31 * n + (this.filter == null ? 0 : this.filter.hashCode());
        n = 31 * n + (this.invisible ? 1231 : 1237);
        n = 31 * n + (this.opName == null ? 0 : this.opName.hashCode());
        n = 31 * n + (this.opType == null ? 0 : this.opType.hashCode());
        n = 31 * n + (this.operand == null ? 0 : this.operand.hashCode());
        n = 31 * n + (this.param ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionFilter expressionFilter = (ExpressionFilter)object;
        if (this.explanationEnabled != expressionFilter.explanationEnabled) {
            return false;
        }
        if (this.filter == null ? expressionFilter.filter != null : !this.filter.equals(expressionFilter.filter)) {
            return false;
        }
        if (this.invisible != expressionFilter.invisible) {
            return false;
        }
        if (this.opName == null ? expressionFilter.opName != null : !this.opName.equals(expressionFilter.opName)) {
            return false;
        }
        if (this.opType != expressionFilter.opType) {
            return false;
        }
        if (this.operand == null ? expressionFilter.operand != null : !this.operand.equals(expressionFilter.operand)) {
            return false;
        }
        return this.param == expressionFilter.param;
    }

    public static ExpressionFilter addDefaultFilterIfNeeded(Expression expression, boolean bl) throws PrismLangException {
        ExpressionFilter expressionFilter = null;
        if (!expression.returnsSingleValue()) {
            expressionFilter = expression.getType() instanceof TypeBool ? new ExpressionFilter("forall", expression, new ExpressionLabel("init")) : (bl ? new ExpressionFilter("state", expression, new ExpressionLabel("init")) : new ExpressionFilter("range", expression, new ExpressionLabel("init")));
        } else if (!(expression instanceof ExpressionFilter)) {
            expressionFilter = new ExpressionFilter("first", expression, new ExpressionLabel("init"));
            expressionFilter.setExplanationEnabled(false);
        }
        if (expressionFilter != null) {
            expressionFilter.setInvisible(true);
            expressionFilter.typeCheck();
            return expressionFilter;
        }
        return (ExpressionFilter)expression;
    }

    public static enum FilterOperator {
        MIN("min"),
        MAX("max"),
        ARGMIN("argmin"),
        ARGMAX("argmax"),
        COUNT("count"),
        SUM("sum"),
        AVG("avg"),
        FIRST("first"),
        RANGE("range"),
        FORALL("forall"),
        EXISTS("exists"),
        PRINT("print"),
        PRINTALL("printall"),
        STATE("state"),
        STORE("store");

        public final String keyword;

        private FilterOperator(String string2) {
            this.keyword = string2;
        }
    }
}

