/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import param.BigRational;
import parser.EvaluateContext;
import parser.ast.Expression;
import parser.type.Type;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class ExpressionConstant
extends Expression {
    protected String name;

    public ExpressionConstant() {
    }

    public ExpressionConstant(String string, Type type) {
        this.setType(type);
        this.name = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isProposition() {
        return true;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        Object object = evaluateContext.getConstantValue(this.name);
        if (object == null) {
            throw new PrismLangException("Could not evaluate constant", this);
        }
        if (object instanceof BigRational) {
            BigRational bigRational = (BigRational)object;
            return this.getType().castFromBigRational(bigRational);
        }
        return object;
    }

    @Override
    public BigRational evaluateExact(EvaluateContext evaluateContext) throws PrismLangException {
        Object object = evaluateContext.getConstantValue(this.name);
        if (object == null) {
            throw new PrismLangException("Could not evaluate constant", this);
        }
        return BigRational.from(object);
    }

    @Override
    public boolean returnsSingleValue() {
        return true;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public Expression deepCopy() {
        ExpressionConstant expressionConstant = new ExpressionConstant(this.name, this.type);
        expressionConstant.setPosition(this);
        return expressionConstant;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionConstant expressionConstant = (ExpressionConstant)object;
        return !(this.name == null ? expressionConstant.name != null : !this.name.equals(expressionConstant.name));
    }
}

