/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import jltl2ba.SimpleLTL;
import parser.BooleanUtils;
import parser.ParseException;
import parser.PrismParserConstants;
import parser.PrismParserTokenManager;
import parser.SimpleCharStream;
import parser.Token;
import parser.ast.Command;
import parser.ast.ConstantList;
import parser.ast.Declaration;
import parser.ast.DeclarationBool;
import parser.ast.DeclarationClock;
import parser.ast.DeclarationInt;
import parser.ast.DeclarationIntUnbounded;
import parser.ast.DeclarationType;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionExists;
import parser.ast.ExpressionFilter;
import parser.ast.ExpressionForAll;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionITE;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.ExpressionStrategy;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.ast.ExpressionVar;
import parser.ast.Filter;
import parser.ast.ForLoop;
import parser.ast.FormulaList;
import parser.ast.LabelList;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.ast.RenamedModule;
import parser.ast.RewardStruct;
import parser.ast.RewardStructItem;
import parser.ast.SystemBrackets;
import parser.ast.SystemDefn;
import parser.ast.SystemFullParallel;
import parser.ast.SystemHide;
import parser.ast.SystemInterleaved;
import parser.ast.SystemModule;
import parser.ast.SystemParallel;
import parser.ast.SystemReference;
import parser.ast.SystemRename;
import parser.ast.Update;
import parser.ast.Updates;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.visitor.ASTTraverseModify;
import prism.ModelInfo;
import prism.ModelType;
import prism.PrismLangException;

public class PrismParser
implements PrismParserConstants {
    private static ModelInfo modelInfo;
    private static ArrayList<String> keywordList;
    private static boolean jj_initialized_once;
    public static PrismParserTokenManager token_source;
    static SimpleCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static Token jj_scanpos;
    private static Token jj_lastpos;
    private static int jj_la;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static final JJCalls[] jj_2_rtns;
    private static boolean jj_rescan;
    private static int jj_gc;
    private static final LookaheadSuccess jj_ls;
    private static List<int[]> jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;
    private static int[] jj_lasttokens;
    private static int jj_endpos;

    public static void main(String[] stringArray) {
        PrismParser prismParser = null;
        InputStream inputStream = null;
        String string = null;
        try {
            if (stringArray.length == 0) {
                System.out.println("Usage: java parser.PrismParser <switch> [<file>]");
                System.out.println("Where: <switch> = -modulesfile or -mf");
                System.out.println("                  -propertiesfile or -pf");
                System.out.println("                  -expression or -e");
                System.out.println("                  -ltl or -l");
                System.exit(1);
            }
            prismParser = new PrismParser();
            inputStream = stringArray.length > 1 ? new FileInputStream(stringArray[1]) : System.in;
            string = stringArray.length > 1 ? "file " + stringArray[1] : "stdin";
            System.out.println("Reading from " + string + "...\n");
            if (stringArray[0].equals("-modulesfile") || stringArray[0].equals("-mf")) {
                ModulesFile modulesFile = prismParser.parseModulesFile(inputStream);
                System.out.print("Modules file:\n=============\n\n" + modulesFile);
                System.out.print("\nTree:\n=====\n" + modulesFile.toTreeString());
                modulesFile.tidyUp();
                System.out.print("\nAnd after expansion:\n====================\n\n" + modulesFile);
            } else if (stringArray[0].equals("-propertiesfile") || stringArray[0].equals("-pf")) {
                PropertiesFile propertiesFile = prismParser.parsePropertiesFile(new ModulesFile(), inputStream);
                System.out.print("Properties file:\n================\n\n" + propertiesFile);
                System.out.print("\nTree:\n=====\n" + propertiesFile.toTreeString());
                propertiesFile.tidyUp();
                System.out.print("\nAnd after expansion:\n====================\n\n" + propertiesFile);
            } else if (stringArray[0].equals("-expression") || stringArray[0].equals("-e")) {
                Expression expression = prismParser.parseSingleExpression(inputStream);
                System.out.println("Expression: " + expression.toString());
                System.out.print("Tree:\n=====\n" + expression.toTreeString());
                expression.typeCheck();
                expression.semanticCheck();
                System.out.println("Type: " + expression.getType().getTypeString());
                System.out.println("Eval: " + expression.evaluate());
            } else if (stringArray[0].equals("-ltl") || stringArray[0].equals("-l")) {
                Expression expression;
                Expression expression2 = prismParser.parseSingleLTLFormula(inputStream);
                expression2 = (Expression)expression2.accept(new ASTTraverseModify(){

                    @Override
                    public Object visit(ExpressionIdent expressionIdent) throws PrismLangException {
                        return new ExpressionVar(expressionIdent.getName(), TypeBool.getInstance());
                    }
                });
                System.out.println("LTL formula: " + expression2.toString());
                System.out.print("Tree:\n=====\n" + expression2.toTreeString());
                expression2.typeCheck();
                System.out.println("Type: " + expression2.getType().getTypeString());
                boolean bl = Expression.isPositiveNormalFormLTL(expression2);
                System.out.println("Positive normal form: " + bl);
                System.out.println("Syntactically co-safe: " + Expression.isCoSafeLTLSyntactic(expression2));
                if (!bl) {
                    expression = BooleanUtils.convertLTLToPositiveNormalForm(expression2.deepCopy());
                    System.out.println("Positive normal form conversion: " + expression);
                    System.out.println("Syntactically co-safe: " + Expression.isCoSafeLTLSyntactic(expression));
                }
                expression = (Expression)expression2.deepCopy().accept(new ASTTraverseModify(){

                    @Override
                    public Object visit(ExpressionVar expressionVar) throws PrismLangException {
                        return new ExpressionLabel(expressionVar.getName());
                    }
                });
                SimpleLTL simpleLTL = expression.convertForJltl2ba();
                System.out.println("LBT: " + simpleLTL.toStringLBT());
                System.out.println("Spot: " + simpleLTL.toStringSpot());
                System.out.println("Spin: " + simpleLTL.toStringSpin());
            } else {
                System.out.println("Unknown switch");
                System.exit(1);
            }
        }
        catch (PrismLangException prismLangException) {
            System.out.println("Error in " + string + ": " + prismLangException.getMessage() + ".");
            System.exit(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
            System.exit(1);
        }
    }

    public PrismParser() {
        this(System.in);
    }

    public ModulesFile parseModulesFile(InputStream inputStream) throws PrismLangException {
        return this.parseModulesFile(inputStream, null);
    }

    public ModulesFile parseModulesFile(InputStream inputStream, ModelType modelType) throws PrismLangException {
        ModulesFile modulesFile = null;
        PrismParser.ReInit(inputStream);
        try {
            modulesFile = PrismParser.ModulesFile();
        }
        catch (ParseException parseException) {
            throw this.generateSyntaxError(parseException);
        }
        if (modelType != null) {
            modulesFile.setModelType(modelType);
        }
        return modulesFile;
    }

    public PropertiesFile parsePropertiesFile(ModelInfo modelInfo, InputStream inputStream) throws PrismLangException {
        return this.parsePropertiesFile(modelInfo, inputStream, false);
    }

    public PropertiesFile parsePropertiesFile(ModelInfo modelInfo, InputStream inputStream, boolean bl) throws PrismLangException {
        PropertiesFile propertiesFile = null;
        PrismParser.ReInit(inputStream);
        PrismParser.modelInfo = modelInfo;
        try {
            propertiesFile = bl ? PrismParser.PropertiesFile() : PrismParser.PropertiesFileSemicolonless();
        }
        catch (ParseException parseException) {
            throw this.generateSyntaxError(parseException);
        }
        return propertiesFile;
    }

    public Expression parseSingleExpression(InputStream inputStream) throws PrismLangException {
        Expression expression = null;
        PrismParser.ReInit(inputStream);
        try {
            expression = PrismParser.SingleExpression();
        }
        catch (ParseException parseException) {
            throw this.generateSyntaxError(parseException);
        }
        return expression;
    }

    public Expression parseSingleLTLFormula(InputStream inputStream) throws PrismLangException {
        Expression expression = null;
        PrismParser.ReInit(inputStream);
        try {
            expression = PrismParser.SingleLTLFormula();
        }
        catch (ParseException parseException) {
            throw this.generateSyntaxError(parseException);
        }
        return expression;
    }

    public ForLoop parseForLoop(InputStream inputStream) throws PrismLangException {
        ForLoop forLoop = null;
        PrismParser.ReInit(inputStream);
        try {
            forLoop = PrismParser.ForLoop();
        }
        catch (ParseException parseException) {
            throw this.generateSyntaxError(parseException);
        }
        return forLoop;
    }

    public static String getPrecedingCommentBlock(Token token) {
        Object object = "";
        Token token2 = token;
        if (!(token2.specialToken == null || token2.specialToken.kind == 1 && token2.specialToken.image.matches("[\\n\\r]*"))) {
            token2 = token2.specialToken;
            while (!(token2.specialToken == null || token2.specialToken.kind == 1 && token2.specialToken.image.matches("[\\n\\r]*"))) {
                token2 = token2.specialToken;
            }
            while (token2 != null) {
                String string = token2.image;
                string = string.replaceAll("\r", "");
                if (token2.kind == 2) {
                    while (((String)object).length() > 0 && ("" + ((String)object).charAt(((String)object).length() - 1)).matches("[ \t]")) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    string = string.substring(2);
                    string = string.replaceFirst("[ \t]*", "");
                }
                object = (String)object + string;
                token2 = token2.next;
            }
        }
        if (((String)object).length() > 0 && ((String)object).charAt(((String)object).length() - 1) == '\n') {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        return object;
    }

    public static String slashCommentBlock(String string) {
        int n;
        Object object = "";
        while ((n = string.indexOf("\n")) != -1) {
            String string2 = string.substring(0, n);
            string = string.substring(n + 1);
            if (string2.trim().length() > 0) {
                object = (String)object + "// " + string2;
            }
            object = (String)object + "\n";
        }
        if (string.trim().length() > 0) {
            object = (String)object + "// " + string + "\n";
        }
        return object;
    }

    public static boolean isKeyword(String string) {
        return keywordList.contains(string);
    }

    public static List<String> getListOfKeywords() {
        return keywordList;
    }

    public void setTabSize(int n) {
        SimpleCharStream.setTabSize(n);
    }

    public int getTabSize() {
        return SimpleCharStream.getTabSize();
    }

    protected PrismLangException generateSyntaxError(ParseException parseException) {
        ExpressionIdent expressionIdent;
        if (parseException == null) {
            return new PrismLangException("Syntax error");
        }
        if (parseException.currentToken == null) {
            String string = parseException.getMessage();
            Object object = "Syntax error";
            if (string != null && string.length() > 0) {
                object = (String)object + ": " + string;
            }
            return new PrismLangException((String)object);
        }
        if (parseException.currentToken.next == null) {
            expressionIdent = new ExpressionIdent(parseException.currentToken.image);
            expressionIdent.setPosition(parseException.currentToken);
        } else {
            expressionIdent = new ExpressionIdent(parseException.currentToken.next.image);
            expressionIdent.setPosition(parseException.currentToken.next);
        }
        String string = parseException.getMessage();
        Object object = "Syntax error";
        if (string != null && string.length() > 0 && string.length() < 20) {
            object = (String)object + ": " + string;
        }
        return new PrismLangException((String)object, expressionIdent);
    }

    public static final ModulesFile ModulesFile() throws ParseException, PrismLangException {
        Token token;
        ModulesFile modulesFile;
        Expression expression;
        Token token2;
        ModelType modelType;
        block20: {
            modelType = ModelType.MDP;
            int n = 0;
            token2 = null;
            Module module = null;
            RenamedModule renamedModule = null;
            RewardStruct rewardStruct = null;
            Expression expression2 = null;
            int n2 = 0;
            expression = null;
            modulesFile = new ModulesFile();
            token = null;
            block16: while (true) {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 6: 
                    case 7: 
                    case 10: 
                    case 18: 
                    case 22: 
                    case 24: 
                    case 28: 
                    case 30: 
                    case 32: 
                    case 34: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 47: 
                    case 48: {
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[0] = jj_gen;
                        break block20;
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 7: 
                    case 10: 
                    case 30: 
                    case 34: 
                    case 38: 
                    case 40: 
                    case 47: {
                        token = PrismParser.getToken(1);
                        modelType = PrismParser.ModulesFileType();
                        if (++n != 2) continue block16;
                        token2 = PrismParser.getToken(0);
                        continue block16;
                    }
                    case 18: {
                        PrismParser.FormulaDef(modulesFile.getFormulaList());
                        continue block16;
                    }
                    case 28: {
                        PrismParser.LabelDef(modulesFile.getLabelList());
                        continue block16;
                    }
                    case 6: 
                    case 39: 
                    case 41: {
                        PrismParser.ConstantDef(modulesFile.getConstantList());
                        continue block16;
                    }
                    case 22: {
                        Declaration declaration = PrismParser.GlobalDecl();
                        modulesFile.addGlobal(declaration);
                        continue block16;
                    }
                }
                PrismParser.jj_la1[1] = jj_gen;
                if (PrismParser.jj_2_1(Integer.MAX_VALUE)) {
                    renamedModule = PrismParser.RenamedModule();
                    modulesFile.addRenamedModule(renamedModule);
                    continue;
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 32: {
                        module = PrismParser.Module();
                        modulesFile.addModule(module);
                        continue block16;
                    }
                    case 42: {
                        rewardStruct = PrismParser.RewardStruct();
                        modulesFile.addRewardStruct(rewardStruct);
                        continue block16;
                    }
                    case 24: {
                        expression2 = PrismParser.Init();
                        modulesFile.setInitialStates(expression2);
                        if (++n2 != 2) continue block16;
                        expression = expression2;
                        continue block16;
                    }
                    case 48: {
                        PrismParser.SystemEndsystem(modulesFile);
                        continue block16;
                    }
                }
                break;
            }
            PrismParser.jj_la1[2] = jj_gen;
            PrismParser.jj_consume_token(-1);
            throw new ParseException();
        }
        PrismParser.jj_consume_token(0);
        if (token2 != null) {
            ExpressionIdent expressionIdent = new ExpressionIdent(token2.image);
            expressionIdent.setPosition(token2);
            throw new PrismLangException("There were multiple model type declarations", expressionIdent);
        }
        if (expression != null) {
            throw new PrismLangException("There were multiple init...endinit constructs", expression);
        }
        modulesFile.setModelType(modelType);
        modulesFile.setPosition(token != null ? token : PrismParser.getToken(0), PrismParser.getToken(0));
        return modulesFile;
    }

    public static final PropertiesFile PropertiesFile() throws ParseException, PrismLangException {
        Token token;
        PropertiesFile propertiesFile;
        block13: {
            propertiesFile = new PropertiesFile(modelInfo);
            token = null;
            token = PrismParser.getToken(1);
            block11: while (true) {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 3: 
                    case 6: 
                    case 11: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 28: 
                    case 29: 
                    case 31: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 39: 
                    case 41: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 49: 
                    case 52: 
                    case 62: 
                    case 66: 
                    case 74: 
                    case 79: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 89: {
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[3] = jj_gen;
                        break block13;
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 3: 
                    case 11: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 29: 
                    case 31: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 49: 
                    case 52: 
                    case 62: 
                    case 66: 
                    case 74: 
                    case 79: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 89: {
                        Property property = PrismParser.Property();
                        propertiesFile.addProperty(property);
                        block12: while (true) {
                            PrismParser.jj_consume_token(59);
                            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                                case 59: {
                                    continue block12;
                                }
                            }
                            break;
                        }
                        PrismParser.jj_la1[4] = jj_gen;
                        continue block11;
                    }
                    case 28: {
                        PrismParser.LabelDef(propertiesFile.getLabelList());
                        continue block11;
                    }
                    case 6: 
                    case 39: 
                    case 41: {
                        PrismParser.ConstantDef(propertiesFile.getConstantList());
                        continue block11;
                    }
                }
                break;
            }
            PrismParser.jj_la1[5] = jj_gen;
            PrismParser.jj_consume_token(-1);
            throw new ParseException();
        }
        PrismParser.jj_consume_token(0);
        propertiesFile.setPosition(token, PrismParser.getToken(0));
        return propertiesFile;
    }

    public static final PropertiesFile PropertiesFileSemicolonless() throws ParseException, PrismLangException {
        Token token;
        PropertiesFile propertiesFile;
        block13: {
            propertiesFile = new PropertiesFile(modelInfo);
            token = null;
            token = PrismParser.getToken(1);
            block11: while (true) {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 3: 
                    case 6: 
                    case 11: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 28: 
                    case 29: 
                    case 31: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 39: 
                    case 41: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 49: 
                    case 52: 
                    case 62: 
                    case 66: 
                    case 74: 
                    case 79: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 89: {
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[6] = jj_gen;
                        break block13;
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 3: 
                    case 11: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 29: 
                    case 31: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 49: 
                    case 52: 
                    case 62: 
                    case 66: 
                    case 74: 
                    case 79: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 89: {
                        Property property = PrismParser.Property();
                        block12: while (true) {
                            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                                case 59: {
                                    break;
                                }
                                default: {
                                    PrismParser.jj_la1[7] = jj_gen;
                                    break block12;
                                }
                            }
                            PrismParser.jj_consume_token(59);
                        }
                        propertiesFile.addProperty(property);
                        continue block11;
                    }
                    case 28: {
                        PrismParser.LabelDef(propertiesFile.getLabelList());
                        continue block11;
                    }
                    case 6: 
                    case 39: 
                    case 41: {
                        PrismParser.ConstantDef(propertiesFile.getConstantList());
                        continue block11;
                    }
                }
                break;
            }
            PrismParser.jj_la1[8] = jj_gen;
            PrismParser.jj_consume_token(-1);
            throw new ParseException();
        }
        PrismParser.jj_consume_token(0);
        propertiesFile.setPosition(token, PrismParser.getToken(0));
        return propertiesFile;
    }

    public static final Property Property() throws ParseException {
        String string = null;
        Token token = null;
        token = PrismParser.getToken(1);
        if (PrismParser.jj_2_2(Integer.MAX_VALUE)) {
            PrismParser.jj_consume_token(85);
            string = PrismParser.Identifier();
            PrismParser.jj_consume_token(85);
            PrismParser.jj_consume_token(58);
        }
        Expression expression = PrismParser.ExpressionITE(true, false);
        Property property = new Property(expression, string, PrismParser.getPrecedingCommentBlock(token));
        property.setPosition(token, PrismParser.getToken(0));
        return property;
    }

    public static final Expression SingleExpression() throws ParseException {
        Expression expression = PrismParser.Expression(false, false);
        PrismParser.jj_consume_token(0);
        return expression;
    }

    public static final Expression SingleLTLFormula() throws ParseException {
        Expression expression = PrismParser.Expression(true, true);
        PrismParser.jj_consume_token(0);
        return expression;
    }

    public static final ModelType ModulesFileType() throws ParseException {
        ModelType modelType = null;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 10: 
            case 38: {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 10: {
                        PrismParser.jj_consume_token(10);
                        break;
                    }
                    case 38: {
                        PrismParser.jj_consume_token(38);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[9] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                modelType = ModelType.DTMC;
                break;
            }
            case 30: 
            case 34: {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 30: {
                        PrismParser.jj_consume_token(30);
                        break;
                    }
                    case 34: {
                        PrismParser.jj_consume_token(34);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[10] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                modelType = ModelType.MDP;
                break;
            }
            case 7: 
            case 47: {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 7: {
                        PrismParser.jj_consume_token(7);
                        break;
                    }
                    case 47: {
                        PrismParser.jj_consume_token(47);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[11] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                modelType = ModelType.CTMC;
                break;
            }
            case 40: {
                PrismParser.jj_consume_token(40);
                modelType = ModelType.PTA;
                break;
            }
            default: {
                PrismParser.jj_la1[12] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return modelType;
    }

    public static final void FormulaDef(FormulaList formulaList) throws ParseException {
        ExpressionIdent expressionIdent = null;
        Expression expression = null;
        PrismParser.jj_consume_token(18);
        expressionIdent = PrismParser.IdentifierExpression();
        PrismParser.jj_consume_token(70);
        expression = PrismParser.Expression(false, false);
        PrismParser.jj_consume_token(59);
        formulaList.addFormula(expressionIdent, expression);
    }

    public static final void LabelDef(LabelList labelList) throws ParseException, PrismLangException {
        ExpressionIdent expressionIdent = null;
        Expression expression = null;
        if (!PrismParser.jj_2_3(Integer.MAX_VALUE)) {
            if (PrismParser.jj_2_4(Integer.MAX_VALUE)) {
                PrismParser.jj_consume_token(28);
                expressionIdent = PrismParser.IdentifierExpression();
                throw new PrismLangException("Label names must be enclosed in double-quotes", expressionIdent);
            }
            PrismParser.jj_consume_token(-1);
            throw new ParseException();
        }
        PrismParser.jj_consume_token(28);
        PrismParser.jj_consume_token(85);
        expressionIdent = PrismParser.IdentifierExpression();
        PrismParser.jj_consume_token(85);
        PrismParser.jj_consume_token(70);
        expression = PrismParser.Expression(false, false);
        PrismParser.jj_consume_token(59);
        labelList.addLabel(expressionIdent, expression);
    }

    public static final void ConstantDef(ConstantList constantList) throws ParseException {
        Type type = TypeInt.getInstance();
        ExpressionIdent expressionIdent = null;
        Expression expression = null;
        block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 6: {
                PrismParser.jj_consume_token(6);
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 4: 
                    case 9: 
                    case 27: {
                        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                            case 27: {
                                PrismParser.jj_consume_token(27);
                                type = TypeInt.getInstance();
                                break block0;
                            }
                            case 9: {
                                PrismParser.jj_consume_token(9);
                                type = TypeDouble.getInstance();
                                break block0;
                            }
                            case 4: {
                                PrismParser.jj_consume_token(4);
                                type = TypeBool.getInstance();
                                break block0;
                            }
                        }
                        PrismParser.jj_la1[13] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                PrismParser.jj_la1[14] = jj_gen;
                break;
            }
            case 39: 
            case 41: {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 41: {
                        PrismParser.jj_consume_token(41);
                        break;
                    }
                    case 39: {
                        PrismParser.jj_consume_token(39);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[15] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                type = TypeDouble.getInstance();
                break;
            }
            default: {
                PrismParser.jj_la1[16] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        expressionIdent = PrismParser.IdentifierExpression();
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 70: {
                PrismParser.jj_consume_token(70);
                expression = PrismParser.Expression(false, false);
                break;
            }
            default: {
                PrismParser.jj_la1[17] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(59);
        constantList.addConstant(expressionIdent, expression, type);
    }

    public static final Declaration GlobalDecl() throws ParseException {
        Declaration declaration = null;
        PrismParser.jj_consume_token(22);
        declaration = PrismParser.Declaration();
        return declaration;
    }

    public static final Declaration Declaration() throws ParseException {
        String string = null;
        Expression expression = null;
        Token token = null;
        token = PrismParser.getToken(1);
        string = PrismParser.Identifier();
        PrismParser.jj_consume_token(58);
        DeclarationType declarationType = PrismParser.DeclarationVarType();
        Declaration declaration = new Declaration(string, declarationType);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 24: {
                PrismParser.jj_consume_token(24);
                expression = PrismParser.Expression(false, false);
                declaration.setStart(expression);
                break;
            }
            default: {
                PrismParser.jj_la1[18] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(59);
        declaration.setPosition(token, PrismParser.getToken(0));
        return declaration;
    }

    public static final DeclarationType DeclarationVarType() throws ParseException {
        DeclarationType declarationType;
        Expression expression = null;
        Expression expression2 = null;
        Token token = null;
        token = PrismParser.getToken(1);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 64: {
                PrismParser.jj_consume_token(64);
                expression = PrismParser.Expression(false, false);
                PrismParser.jj_consume_token(61);
                expression2 = PrismParser.Expression(false, false);
                PrismParser.jj_consume_token(65);
                declarationType = new DeclarationInt(expression, expression2);
                break;
            }
            case 27: {
                PrismParser.jj_consume_token(27);
                declarationType = new DeclarationIntUnbounded();
                break;
            }
            case 4: {
                PrismParser.jj_consume_token(4);
                declarationType = new DeclarationBool();
                break;
            }
            case 5: {
                PrismParser.jj_consume_token(5);
                declarationType = new DeclarationClock();
                break;
            }
            default: {
                PrismParser.jj_la1[19] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        declarationType.setPosition(token, PrismParser.getToken(0));
        return declarationType;
    }

    public static final Module Module() throws ParseException {
        ExpressionIdent expressionIdent = null;
        Declaration declaration = null;
        Command command = null;
        Module module = null;
        Token token = null;
        token = PrismParser.jj_consume_token(32);
        expressionIdent = PrismParser.IdentifierExpression();
        module = new Module(expressionIdent.getName());
        block9: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 89: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[20] = jj_gen;
                    break block9;
                }
            }
            declaration = PrismParser.Declaration();
            module.addDeclaration(declaration);
        }
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 25: {
                PrismParser.jj_consume_token(25);
                Expression expression = PrismParser.Expression(false, false);
                PrismParser.jj_consume_token(13);
                module.setInvariant(expression);
                break;
            }
            default: {
                PrismParser.jj_la1[21] = jj_gen;
            }
        }
        block10: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 64: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[22] = jj_gen;
                    break block10;
                }
            }
            command = PrismParser.Command();
            module.addCommand(command);
        }
        PrismParser.jj_consume_token(14);
        module.setPosition(token, PrismParser.getToken(0));
        module.setNameASTElement(expressionIdent);
        return module;
    }

    public static final Command Command() throws ParseException {
        String string = null;
        Expression expression = null;
        Updates updates = null;
        Command command = new Command();
        Token token = null;
        token = PrismParser.jj_consume_token(64);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 89: {
                string = PrismParser.Identifier();
                command.setSynch(string);
                break;
            }
            default: {
                PrismParser.jj_la1[23] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(65);
        expression = PrismParser.Expression(false, false);
        command.setGuard(expression);
        PrismParser.jj_consume_token(57);
        updates = PrismParser.Updates();
        command.setUpdates(updates);
        PrismParser.jj_consume_token(59);
        command.setPosition(token, PrismParser.getToken(0));
        return command;
    }

    public static final Updates Updates() throws ParseException {
        Updates updates = new Updates();
        Token token = null;
        token = PrismParser.getToken(1);
        if (PrismParser.jj_2_5(Integer.MAX_VALUE)) {
            Update update = PrismParser.Update();
            updates.addUpdate(null, update);
        } else {
            block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 3: 
                case 11: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 23: 
                case 29: 
                case 31: 
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 49: 
                case 52: 
                case 62: 
                case 66: 
                case 74: 
                case 79: 
                case 85: 
                case 86: 
                case 87: 
                case 89: {
                    Expression expression = PrismParser.Expression(false, false);
                    PrismParser.jj_consume_token(58);
                    Update update = PrismParser.Update();
                    updates.addUpdate(expression, update);
                    while (true) {
                        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                            case 78: {
                                break;
                            }
                            default: {
                                PrismParser.jj_la1[24] = jj_gen;
                                break block0;
                            }
                        }
                        PrismParser.jj_consume_token(78);
                        expression = PrismParser.Expression(false, false);
                        PrismParser.jj_consume_token(58);
                        update = PrismParser.Update();
                        updates.addUpdate(expression, update);
                    }
                }
                default: {
                    PrismParser.jj_la1[25] = jj_gen;
                    PrismParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        updates.setPosition(token, PrismParser.getToken(0));
        return updates;
    }

    public static final Update Update() throws ParseException {
        Update update = new Update();
        Token token = null;
        token = PrismParser.getToken(1);
        block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 62: {
                PrismParser.UpdateElement(update);
                while (true) {
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 53: {
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[26] = jj_gen;
                            break block0;
                        }
                    }
                    PrismParser.jj_consume_token(53);
                    PrismParser.UpdateElement(update);
                }
            }
            case 49: {
                PrismParser.jj_consume_token(49);
                break;
            }
            default: {
                PrismParser.jj_la1[27] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        update.setPosition(token, PrismParser.getToken(0));
        return update;
    }

    public static final void UpdateElement(Update update) throws ParseException {
        ExpressionIdent expressionIdent = null;
        Expression expression = null;
        PrismParser.jj_consume_token(62);
        expressionIdent = PrismParser.IdentifierPrime();
        PrismParser.jj_consume_token(70);
        expression = PrismParser.Expression(false, false);
        PrismParser.jj_consume_token(63);
        update.addElement(expressionIdent, expression);
    }

    public static final RenamedModule RenamedModule() throws ParseException {
        ExpressionIdent expressionIdent = null;
        ExpressionIdent expressionIdent2 = null;
        RenamedModule renamedModule = null;
        Token token = null;
        token = PrismParser.jj_consume_token(32);
        expressionIdent = PrismParser.IdentifierExpression();
        PrismParser.jj_consume_token(70);
        expressionIdent2 = PrismParser.IdentifierExpression();
        renamedModule = new RenamedModule(expressionIdent.getName(), expressionIdent2.getName());
        PrismParser.jj_consume_token(64);
        PrismParser.Rename(renamedModule);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 60: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[28] = jj_gen;
                    break block3;
                }
            }
            PrismParser.jj_consume_token(60);
            PrismParser.Rename(renamedModule);
        }
        PrismParser.jj_consume_token(65);
        PrismParser.jj_consume_token(14);
        renamedModule.setPosition(token, PrismParser.getToken(0));
        renamedModule.setNameASTElement(expressionIdent);
        renamedModule.setBaseModuleASTElement(expressionIdent2);
        return renamedModule;
    }

    public static final void Rename(RenamedModule renamedModule) throws ParseException {
        ExpressionIdent expressionIdent = null;
        ExpressionIdent expressionIdent2 = null;
        expressionIdent = PrismParser.IdentifierExpressionMinMax();
        PrismParser.jj_consume_token(70);
        expressionIdent2 = PrismParser.IdentifierExpressionMinMax();
        renamedModule.addRename(expressionIdent.getName(), expressionIdent2.getName(), expressionIdent, expressionIdent2);
    }

    public static final RewardStruct RewardStruct() throws ParseException {
        String string = null;
        String string2 = null;
        Expression expression = null;
        Expression expression2 = null;
        RewardStruct rewardStruct = new RewardStruct();
        Token token = null;
        Token token2 = null;
        token = PrismParser.jj_consume_token(42);
        if (PrismParser.jj_2_6(Integer.MAX_VALUE)) {
            PrismParser.jj_consume_token(85);
            string = PrismParser.Identifier();
            PrismParser.jj_consume_token(85);
            rewardStruct.setName(string);
        }
        block9: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 3: 
                case 11: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 23: 
                case 29: 
                case 31: 
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 49: 
                case 52: 
                case 62: 
                case 64: 
                case 66: 
                case 74: 
                case 79: 
                case 85: 
                case 86: 
                case 87: 
                case 89: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[29] = jj_gen;
                    break block9;
                }
            }
            token2 = PrismParser.getToken(1);
            string2 = null;
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 64: {
                    PrismParser.jj_consume_token(64);
                    string2 = "";
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 89: {
                            string2 = PrismParser.Identifier();
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[30] = jj_gen;
                        }
                    }
                    PrismParser.jj_consume_token(65);
                    break;
                }
                default: {
                    PrismParser.jj_la1[31] = jj_gen;
                }
            }
            expression = PrismParser.Expression(false, false);
            PrismParser.jj_consume_token(58);
            expression2 = PrismParser.Expression(false, false);
            PrismParser.jj_consume_token(59);
            RewardStructItem rewardStructItem = new RewardStructItem(string2, expression, expression2);
            rewardStructItem.setPosition(token2, PrismParser.getToken(0));
            rewardStruct.addItem(rewardStructItem);
        }
        PrismParser.jj_consume_token(15);
        rewardStruct.setPosition(token, PrismParser.getToken(0));
        return rewardStruct;
    }

    public static final Expression Init() throws ParseException {
        Expression expression = null;
        PrismParser.jj_consume_token(24);
        expression = PrismParser.Expression(false, false);
        PrismParser.jj_consume_token(12);
        return expression;
    }

    public static final void SystemEndsystem(ModulesFile modulesFile) throws ParseException {
        String string = null;
        PrismParser.jj_consume_token(48);
        if (PrismParser.jj_2_7(Integer.MAX_VALUE)) {
            PrismParser.jj_consume_token(85);
            string = PrismParser.Identifier();
            PrismParser.jj_consume_token(85);
        }
        SystemDefn systemDefn = PrismParser.SystemDefn();
        PrismParser.jj_consume_token(16);
        modulesFile.addSystemDefn(systemDefn, string);
    }

    public static final SystemDefn SystemDefn() throws ParseException {
        SystemDefn systemDefn = PrismParser.SystemFullParallel();
        return systemDefn;
    }

    public static final SystemDefn SystemFullParallel() throws ParseException {
        SystemDefn systemDefn = null;
        SystemDefn systemDefn2 = null;
        SystemFullParallel systemFullParallel = null;
        Token token = PrismParser.getToken(1);
        systemDefn = PrismParser.SystemInterleaved();
        systemFullParallel = new SystemFullParallel();
        systemFullParallel.addOperand(systemDefn);
        while (PrismParser.jj_2_8(Integer.MAX_VALUE)) {
            PrismParser.jj_consume_token(54);
            PrismParser.jj_consume_token(54);
            systemDefn2 = PrismParser.SystemParallel();
            systemFullParallel.addOperand(systemDefn2);
        }
        if (systemFullParallel == null || systemFullParallel.getNumOperands() == 1) {
            return systemDefn;
        }
        systemFullParallel.setPosition(token, PrismParser.getToken(0));
        return systemFullParallel;
    }

    public static final SystemDefn SystemInterleaved() throws ParseException {
        SystemDefn systemDefn = null;
        SystemDefn systemDefn2 = null;
        SystemInterleaved systemInterleaved = null;
        Token token = PrismParser.getToken(1);
        systemDefn = PrismParser.SystemParallel();
        systemInterleaved = new SystemInterleaved();
        systemInterleaved.addOperand(systemDefn);
        while (PrismParser.jj_2_9(Integer.MAX_VALUE)) {
            PrismParser.jj_consume_token(54);
            PrismParser.jj_consume_token(54);
            PrismParser.jj_consume_token(54);
            systemDefn2 = PrismParser.SystemFullParallel();
            systemInterleaved.addOperand(systemDefn2);
        }
        if (systemInterleaved == null || systemInterleaved.getNumOperands() == 1) {
            return systemDefn;
        }
        systemInterleaved.setPosition(token, PrismParser.getToken(0));
        return systemInterleaved;
    }

    public static final SystemDefn SystemParallel() throws ParseException {
        SystemDefn systemDefn = null;
        SystemDefn systemDefn2 = null;
        SystemParallel systemParallel = null;
        Token token = PrismParser.getToken(1);
        systemDefn = PrismParser.SystemHideRename();
        if (PrismParser.jj_2_10(Integer.MAX_VALUE)) {
            systemParallel = new SystemParallel();
            systemParallel.setOperand1(systemDefn);
            PrismParser.jj_consume_token(54);
            PrismParser.jj_consume_token(64);
            String string = PrismParser.Identifier();
            systemParallel.addAction(string);
            block3: while (true) {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 60: {
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[32] = jj_gen;
                        break block3;
                    }
                }
                PrismParser.jj_consume_token(60);
                string = PrismParser.Identifier();
                systemParallel.addAction(string);
            }
            PrismParser.jj_consume_token(65);
            PrismParser.jj_consume_token(54);
            systemDefn2 = PrismParser.SystemHideRename();
            systemParallel.setOperand2(systemDefn2);
        }
        if (systemParallel == null) {
            return systemDefn;
        }
        systemParallel.setPosition(token, PrismParser.getToken(0));
        return systemParallel;
    }

    public static final SystemDefn SystemHideRename() throws ParseException {
        Token token;
        SystemDefn systemDefn;
        block16: {
            systemDefn = null;
            SystemHide systemHide = null;
            SystemRename systemRename = null;
            String string = null;
            String string2 = null;
            token = PrismParser.getToken(1);
            systemDefn = PrismParser.SystemAtomic();
            block13: while (true) {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 68: 
                    case 81: {
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[33] = jj_gen;
                        break block16;
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 81: {
                        systemHide = new SystemHide(systemDefn);
                        PrismParser.jj_consume_token(81);
                        PrismParser.jj_consume_token(68);
                        string = PrismParser.Identifier();
                        systemHide.addAction(string);
                        block14: while (true) {
                            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                                case 60: {
                                    break;
                                }
                                default: {
                                    PrismParser.jj_la1[34] = jj_gen;
                                    break block14;
                                }
                            }
                            PrismParser.jj_consume_token(60);
                            string = PrismParser.Identifier();
                            systemHide.addAction(string);
                        }
                        PrismParser.jj_consume_token(69);
                        systemDefn = systemHide;
                        continue block13;
                    }
                    case 68: {
                        systemRename = new SystemRename(systemDefn);
                        PrismParser.jj_consume_token(68);
                        string = PrismParser.Identifier();
                        PrismParser.jj_consume_token(83);
                        string2 = PrismParser.Identifier();
                        systemRename.addRename(string, string2);
                        block15: while (true) {
                            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                                case 60: {
                                    break;
                                }
                                default: {
                                    PrismParser.jj_la1[35] = jj_gen;
                                    break block15;
                                }
                            }
                            PrismParser.jj_consume_token(60);
                            string = PrismParser.Identifier();
                            PrismParser.jj_consume_token(83);
                            string2 = PrismParser.Identifier();
                            systemRename.addRename(string, string2);
                        }
                        PrismParser.jj_consume_token(69);
                        systemDefn = systemRename;
                        continue block13;
                    }
                }
                break;
            }
            PrismParser.jj_la1[36] = jj_gen;
            PrismParser.jj_consume_token(-1);
            throw new ParseException();
        }
        systemDefn.setPosition(token, PrismParser.getToken(0));
        return systemDefn;
    }

    public static final SystemDefn SystemAtomic() throws ParseException {
        String string = null;
        SystemDefn systemDefn = null;
        Token token = PrismParser.getToken(1);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 89: {
                string = PrismParser.Identifier();
                systemDefn = new SystemModule(string);
                break;
            }
            case 85: {
                PrismParser.jj_consume_token(85);
                string = PrismParser.Identifier();
                PrismParser.jj_consume_token(85);
                systemDefn = new SystemReference(string);
                break;
            }
            case 62: {
                PrismParser.jj_consume_token(62);
                systemDefn = PrismParser.SystemDefn();
                PrismParser.jj_consume_token(63);
                systemDefn = new SystemBrackets(systemDefn);
                break;
            }
            default: {
                PrismParser.jj_la1[37] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        systemDefn.setPosition(token, PrismParser.getToken(0));
        return systemDefn;
    }

    public static final Expression Expression(boolean bl, boolean bl2) throws ParseException {
        Expression expression = PrismParser.ExpressionTemporalBinary(bl, bl2);
        return expression;
    }

    public static final Expression ExpressionTemporalBinary(boolean bl, boolean bl2) throws ParseException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionTemporalUnary(bl, bl2);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 45: 
            case 50: 
            case 51: {
                if (!bl2) {
                    throw PrismParser.generateParseException();
                }
                ExpressionTemporal expressionTemporal = new ExpressionTemporal();
                expressionTemporal.setOperand1(expression);
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 50: {
                        PrismParser.jj_consume_token(50);
                        expressionTemporal.setOperator(2);
                        break;
                    }
                    case 51: {
                        PrismParser.jj_consume_token(51);
                        expressionTemporal.setOperator(5);
                        break;
                    }
                    case 45: {
                        PrismParser.jj_consume_token(45);
                        expressionTemporal.setOperator(6);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[38] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 64: 
                    case 70: 
                    case 72: 
                    case 73: 
                    case 76: 
                    case 77: {
                        PrismParser.TimeBound(expressionTemporal);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[39] = jj_gen;
                    }
                }
                Expression expression2 = PrismParser.ExpressionTemporalUnary(bl, bl2);
                expressionTemporal.setOperand2(expression2);
                expressionTemporal.setPosition(token, PrismParser.getToken(0));
                expression = expressionTemporal;
                break;
            }
            default: {
                PrismParser.jj_la1[40] = jj_gen;
            }
        }
        return expression;
    }

    public static final Expression ExpressionTemporalUnary(boolean bl, boolean bl2) throws ParseException {
        Expression expression;
        Token token = null;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 21: 
            case 23: 
            case 33: {
                if (!bl2) {
                    throw PrismParser.generateParseException();
                }
                token = PrismParser.getToken(1);
                ExpressionTemporal expressionTemporal = new ExpressionTemporal();
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 33: {
                        PrismParser.jj_consume_token(33);
                        expressionTemporal.setOperator(1);
                        break;
                    }
                    case 21: {
                        PrismParser.jj_consume_token(21);
                        expressionTemporal.setOperator(3);
                        break;
                    }
                    case 23: {
                        PrismParser.jj_consume_token(23);
                        expressionTemporal.setOperator(4);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[41] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 64: 
                    case 70: 
                    case 72: 
                    case 73: 
                    case 76: 
                    case 77: {
                        PrismParser.TimeBound(expressionTemporal);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[42] = jj_gen;
                    }
                }
                Expression expression2 = PrismParser.ExpressionTemporalUnary(bl, bl2);
                expressionTemporal.setOperand2(expression2);
                expressionTemporal.setPosition(token, PrismParser.getToken(0));
                expression = expressionTemporal;
                break;
            }
            case 3: 
            case 11: 
            case 17: 
            case 19: 
            case 20: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 52: 
            case 62: 
            case 66: 
            case 74: 
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 89: {
                expression = PrismParser.ExpressionITE(bl, bl2);
                break;
            }
            default: {
                PrismParser.jj_la1[43] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public static final void TimeBound(ExpressionTemporal expressionTemporal) throws ParseException {
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 76: {
                Expression expression;
                PrismParser.jj_consume_token(76);
                if (PrismParser.jj_2_11(Integer.MAX_VALUE)) {
                    expression = PrismParser.IdentifierExpression();
                } else {
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 3: 
                        case 11: 
                        case 17: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 23: 
                        case 29: 
                        case 31: 
                        case 33: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 49: 
                        case 52: 
                        case 62: 
                        case 66: 
                        case 74: 
                        case 79: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 89: {
                            expression = PrismParser.Expression(false, false);
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[44] = jj_gen;
                            PrismParser.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                expressionTemporal.setUpperBound(expression, false);
                break;
            }
            case 72: {
                Expression expression;
                PrismParser.jj_consume_token(72);
                if (PrismParser.jj_2_12(Integer.MAX_VALUE)) {
                    expression = PrismParser.IdentifierExpression();
                } else {
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 3: 
                        case 11: 
                        case 17: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 23: 
                        case 29: 
                        case 31: 
                        case 33: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 49: 
                        case 52: 
                        case 62: 
                        case 66: 
                        case 74: 
                        case 79: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 89: {
                            expression = PrismParser.Expression(false, false);
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[45] = jj_gen;
                            PrismParser.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                expressionTemporal.setUpperBound(expression, true);
                break;
            }
            case 77: {
                Expression expression;
                PrismParser.jj_consume_token(77);
                if (PrismParser.jj_2_13(Integer.MAX_VALUE)) {
                    expression = PrismParser.IdentifierExpression();
                } else {
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 3: 
                        case 11: 
                        case 17: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 23: 
                        case 29: 
                        case 31: 
                        case 33: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 49: 
                        case 52: 
                        case 62: 
                        case 66: 
                        case 74: 
                        case 79: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 89: {
                            expression = PrismParser.Expression(false, false);
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[46] = jj_gen;
                            PrismParser.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                expressionTemporal.setLowerBound(expression, false);
                break;
            }
            case 73: {
                Expression expression;
                PrismParser.jj_consume_token(73);
                if (PrismParser.jj_2_14(Integer.MAX_VALUE)) {
                    expression = PrismParser.IdentifierExpression();
                } else {
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 3: 
                        case 11: 
                        case 17: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 23: 
                        case 29: 
                        case 31: 
                        case 33: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 49: 
                        case 52: 
                        case 62: 
                        case 66: 
                        case 74: 
                        case 79: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 89: {
                            expression = PrismParser.Expression(false, false);
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[47] = jj_gen;
                            PrismParser.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                expressionTemporal.setLowerBound(expression, true);
                break;
            }
            case 64: {
                PrismParser.jj_consume_token(64);
                Expression expression = PrismParser.Expression(false, false);
                PrismParser.jj_consume_token(60);
                Expression expression2 = PrismParser.Expression(false, false);
                PrismParser.jj_consume_token(65);
                expressionTemporal.setLowerBound(expression, false);
                expressionTemporal.setUpperBound(expression2, false);
                break;
            }
            case 70: {
                PrismParser.jj_consume_token(70);
                Expression expression = PrismParser.Expression(false, false);
                expressionTemporal.setEqualBounds(expression);
                break;
            }
            default: {
                PrismParser.jj_la1[48] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final Expression ExpressionITE(boolean bl, boolean bl2) throws ParseException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionImplies(bl, bl2);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 84: {
                PrismParser.jj_consume_token(84);
                Expression expression2 = PrismParser.ExpressionImplies(bl, bl2);
                PrismParser.jj_consume_token(58);
                Expression expression3 = PrismParser.ExpressionITE(bl, bl2);
                expression = new ExpressionITE(expression, expression2, expression3);
                expression.setPosition(token, PrismParser.getToken(0));
                break;
            }
            default: {
                PrismParser.jj_la1[49] = jj_gen;
            }
        }
        return expression;
    }

    public static final Expression ExpressionImplies(boolean bl, boolean bl2) throws ParseException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionIff(bl, bl2);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 55: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[50] = jj_gen;
                    break block3;
                }
            }
            PrismParser.jj_consume_token(55);
            Expression expression2 = PrismParser.ExpressionIff(bl, bl2);
            expression = new ExpressionBinaryOp(1, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionIff(boolean bl, boolean bl2) throws ParseException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionOr(bl, bl2);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 56: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[51] = jj_gen;
                    break block3;
                }
            }
            PrismParser.jj_consume_token(56);
            Expression expression2 = PrismParser.ExpressionOr(bl, bl2);
            expression = new ExpressionBinaryOp(2, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionOr(boolean bl, boolean bl2) throws ParseException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionAnd(bl, bl2);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 54: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[52] = jj_gen;
                    break block3;
                }
            }
            PrismParser.jj_consume_token(54);
            Expression expression2 = PrismParser.ExpressionAnd(bl, bl2);
            expression = new ExpressionBinaryOp(3, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionAnd(boolean bl, boolean bl2) throws ParseException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionNot(bl, bl2);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 53: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[53] = jj_gen;
                    break block3;
                }
            }
            PrismParser.jj_consume_token(53);
            Expression expression2 = PrismParser.ExpressionNot(bl, bl2);
            expression = new ExpressionBinaryOp(4, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionNot(boolean bl, boolean bl2) throws ParseException {
        Expression expression;
        Token token = null;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 52: {
                token = PrismParser.jj_consume_token(52);
                Expression expression2 = PrismParser.ExpressionNot(bl, bl2);
                expression = new ExpressionUnaryOp(1, expression2);
                expression.setPosition(token, PrismParser.getToken(0));
                break;
            }
            case 3: 
            case 11: 
            case 17: 
            case 19: 
            case 20: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 62: 
            case 66: 
            case 74: 
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 89: {
                expression = PrismParser.ExpressionEquality(bl, bl2);
                break;
            }
            default: {
                PrismParser.jj_la1[54] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public static final Expression ExpressionEquality(boolean bl, boolean bl2) throws ParseException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionRelop(bl, bl2);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 70: 
                case 71: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[55] = jj_gen;
                    break block3;
                }
            }
            int n = PrismParser.EqNeq();
            Expression expression2 = PrismParser.ExpressionRelop(bl, bl2);
            expression = new ExpressionBinaryOp(n, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionRelop(boolean bl, boolean bl2) throws ParseException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionPlusMinus(bl, bl2);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 72: 
                case 73: 
                case 76: 
                case 77: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[56] = jj_gen;
                    break block3;
                }
            }
            int n = PrismParser.LtGt();
            Expression expression2 = PrismParser.ExpressionPlusMinus(bl, bl2);
            expression = new ExpressionBinaryOp(n, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionPlusMinus(boolean bl, boolean bl2) throws ParseException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionTimesDivide(bl, bl2);
        block7: while (true) {
            int n;
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 78: 
                case 79: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[57] = jj_gen;
                    break block7;
                }
            }
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 78: {
                    PrismParser.jj_consume_token(78);
                    n = 11;
                    break;
                }
                case 79: {
                    PrismParser.jj_consume_token(79);
                    n = 12;
                    break;
                }
                default: {
                    PrismParser.jj_la1[58] = jj_gen;
                    PrismParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression expression2 = PrismParser.ExpressionTimesDivide(bl, bl2);
            expression = new ExpressionBinaryOp(n, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionTimesDivide(boolean bl, boolean bl2) throws ParseException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionUnaryMinus(bl, bl2);
        block7: while (true) {
            int n;
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 80: 
                case 81: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[59] = jj_gen;
                    break block7;
                }
            }
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 80: {
                    PrismParser.jj_consume_token(80);
                    n = 13;
                    break;
                }
                case 81: {
                    PrismParser.jj_consume_token(81);
                    n = 14;
                    break;
                }
                default: {
                    PrismParser.jj_la1[60] = jj_gen;
                    PrismParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression expression2 = PrismParser.ExpressionUnaryMinus(bl, bl2);
            expression = new ExpressionBinaryOp(n, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionUnaryMinus(boolean bl, boolean bl2) throws ParseException {
        Expression expression;
        Token token = null;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 79: {
                token = PrismParser.jj_consume_token(79);
                Expression expression2 = PrismParser.ExpressionUnaryMinus(bl, bl2);
                expression = new ExpressionUnaryOp(2, expression2);
                expression.setPosition(token, PrismParser.getToken(0));
                break;
            }
            case 3: 
            case 11: 
            case 17: 
            case 19: 
            case 20: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 62: 
            case 66: 
            case 74: 
            case 85: 
            case 86: 
            case 87: 
            case 89: {
                expression = PrismParser.ExpressionBasic(bl, bl2);
                break;
            }
            default: {
                PrismParser.jj_la1[61] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public static final Expression ExpressionBasic(boolean bl, boolean bl2) throws ParseException {
        Expression expression;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 17: 
            case 49: 
            case 86: 
            case 87: {
                expression = PrismParser.ExpressionLiteral(bl, bl2);
                break;
            }
            case 89: {
                expression = PrismParser.ExpressionFuncOrIdent(bl, bl2);
                break;
            }
            case 29: 
            case 31: {
                expression = PrismParser.ExpressionFuncMinMax(bl, bl2);
                break;
            }
            case 20: {
                expression = PrismParser.ExpressionFuncOldStyle(bl, bl2);
                break;
            }
            case 62: {
                expression = PrismParser.ExpressionParenth(bl, bl2);
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                expression = PrismParser.ExpressionProb(bl, bl2);
                break;
            }
            case 46: {
                expression = PrismParser.ExpressionSS(bl, bl2);
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                expression = PrismParser.ExpressionReward(bl, bl2);
                break;
            }
            case 11: {
                expression = PrismParser.ExpressionExists(bl, bl2);
                break;
            }
            case 3: {
                expression = PrismParser.ExpressionForAll(bl, bl2);
                break;
            }
            case 66: 
            case 74: {
                expression = PrismParser.ExpressionStrategy(bl, bl2);
                break;
            }
            case 85: {
                expression = PrismParser.ExpressionLabel(bl, bl2);
                break;
            }
            case 19: {
                expression = PrismParser.ExpressionFilter(bl, bl2);
                break;
            }
            default: {
                PrismParser.jj_la1[62] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public static final Expression ExpressionFuncOrIdent(boolean bl, boolean bl2) throws ParseException {
        String string = null;
        Expression expression = null;
        Token token = null;
        string = PrismParser.Identifier();
        expression = new ExpressionIdent(string);
        token = PrismParser.getToken(0);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 62: {
                PrismParser.jj_consume_token(62);
                expression = new ExpressionFunc(string);
                PrismParser.ExpressionFuncArgs(bl, bl2, (ExpressionFunc)expression);
                PrismParser.jj_consume_token(63);
                break;
            }
            default: {
                PrismParser.jj_la1[63] = jj_gen;
            }
        }
        expression.setPosition(token, PrismParser.getToken(0));
        return expression;
    }

    public static final Expression ExpressionFuncMinMax(boolean bl, boolean bl2) throws ParseException {
        String string = null;
        ExpressionFunc expressionFunc = null;
        Token token = null;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 31: {
                token = PrismParser.jj_consume_token(31);
                string = "min";
                break;
            }
            case 29: {
                token = PrismParser.jj_consume_token(29);
                string = "max";
                break;
            }
            default: {
                PrismParser.jj_la1[64] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        expressionFunc = new ExpressionFunc(string);
        PrismParser.jj_consume_token(62);
        PrismParser.ExpressionFuncArgs(bl, bl2, expressionFunc);
        PrismParser.jj_consume_token(63);
        expressionFunc.setPosition(token, PrismParser.getToken(0));
        return expressionFunc;
    }

    public static final Expression ExpressionFuncOldStyle(boolean bl, boolean bl2) throws ParseException {
        String string = null;
        ExpressionFunc expressionFunc = null;
        Token token = null;
        token = PrismParser.jj_consume_token(20);
        PrismParser.jj_consume_token(62);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 31: {
                PrismParser.jj_consume_token(31);
                string = "min";
                break;
            }
            case 29: {
                PrismParser.jj_consume_token(29);
                string = "max";
                break;
            }
            case 89: {
                string = PrismParser.Identifier();
                break;
            }
            default: {
                PrismParser.jj_la1[65] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PrismParser.jj_consume_token(60);
        expressionFunc = new ExpressionFunc(string);
        expressionFunc.setOldStyle(true);
        PrismParser.ExpressionFuncArgs(bl, bl2, expressionFunc);
        PrismParser.jj_consume_token(63);
        expressionFunc.setPosition(token, PrismParser.getToken(0));
        return expressionFunc;
    }

    public static final void ExpressionFuncArgs(boolean bl, boolean bl2, ExpressionFunc expressionFunc) throws ParseException {
        Expression expression = PrismParser.Expression(bl, bl2);
        expressionFunc.addOperand(expression);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 60: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[66] = jj_gen;
                    break block3;
                }
            }
            PrismParser.jj_consume_token(60);
            expression = PrismParser.Expression(bl, bl2);
            expressionFunc.addOperand(expression);
        }
    }

    public static final Expression ExpressionLiteral(boolean bl, boolean bl2) throws ParseException {
        ExpressionLiteral expressionLiteral = null;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 86: {
                PrismParser.jj_consume_token(86);
                try {
                    int n = Integer.parseInt(PrismParser.getToken((int)0).image);
                    expressionLiteral = new ExpressionLiteral(TypeInt.getInstance(), new Integer(n));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    ParseException parseException = new ParseException("Invalid integer literal");
                    parseException.currentToken = PrismParser.getToken(0);
                    throw parseException;
                }
            }
            case 87: {
                PrismParser.jj_consume_token(87);
                try {
                    double d = Double.parseDouble(PrismParser.getToken((int)0).image);
                    expressionLiteral = new ExpressionLiteral(TypeDouble.getInstance(), new Double(d), PrismParser.getToken((int)0).image);
                }
                catch (NumberFormatException numberFormatException) {
                    ParseException parseException = new ParseException("Invalid double literal");
                }
                break;
            }
            case 49: {
                PrismParser.jj_consume_token(49);
                expressionLiteral = new ExpressionLiteral(TypeBool.getInstance(), new Boolean(true));
                break;
            }
            case 17: {
                PrismParser.jj_consume_token(17);
                expressionLiteral = new ExpressionLiteral(TypeBool.getInstance(), new Boolean(false));
                break;
            }
            default: {
                PrismParser.jj_la1[67] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        expressionLiteral.setPosition(PrismParser.getToken(0));
        return expressionLiteral;
    }

    public static final Expression ExpressionParenth(boolean bl, boolean bl2) throws ParseException {
        Token token = null;
        token = PrismParser.jj_consume_token(62);
        Expression expression = PrismParser.Expression(bl, bl2);
        PrismParser.jj_consume_token(63);
        ExpressionUnaryOp expressionUnaryOp = new ExpressionUnaryOp(3, expression);
        expressionUnaryOp.setPosition(token, PrismParser.getToken(0));
        return expressionUnaryOp;
    }

    public static final Expression ExpressionProb(boolean bl, boolean bl2) throws ParseException {
        boolean bl3;
        ExpressionIdent expressionIdent = null;
        String string = null;
        Expression expression = null;
        Filter filter = null;
        ExpressionProb expressionProb = new ExpressionProb();
        Token token = null;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 37: {
                token = PrismParser.jj_consume_token(37);
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 62: {
                        PrismParser.jj_consume_token(62);
                        expressionIdent = PrismParser.IdentifierExpression();
                        PrismParser.jj_consume_token(63);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[68] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 72: 
                    case 73: 
                    case 76: 
                    case 77: {
                        int n = PrismParser.LtGt();
                        expression = PrismParser.Expression(false, false);
                        string = ExpressionBinaryOp.opSymbols[n];
                        bl3 = true;
                        break block0;
                    }
                    case 70: {
                        PrismParser.jj_consume_token(70);
                        PrismParser.jj_consume_token(84);
                        string = "=";
                        bl3 = false;
                        break block0;
                    }
                    case 31: {
                        PrismParser.jj_consume_token(31);
                        PrismParser.jj_consume_token(70);
                        PrismParser.jj_consume_token(84);
                        string = "min=";
                        bl3 = false;
                        break block0;
                    }
                    case 29: {
                        PrismParser.jj_consume_token(29);
                        PrismParser.jj_consume_token(70);
                        PrismParser.jj_consume_token(84);
                        string = "max=";
                        bl3 = false;
                        break block0;
                    }
                }
                PrismParser.jj_la1[69] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
            case 36: {
                token = PrismParser.jj_consume_token(36);
                PrismParser.jj_consume_token(70);
                PrismParser.jj_consume_token(84);
                string = "min=";
                bl3 = false;
                break;
            }
            case 35: {
                token = PrismParser.jj_consume_token(35);
                PrismParser.jj_consume_token(70);
                PrismParser.jj_consume_token(84);
                string = "max=";
                bl3 = false;
                break;
            }
            default: {
                PrismParser.jj_la1[70] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PrismParser.jj_consume_token(64);
        Expression expression2 = PrismParser.Expression(bl, true);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 68: {
                filter = PrismParser.Filter();
                break;
            }
            default: {
                PrismParser.jj_la1[71] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(65);
        expressionProb.setModifier(expressionIdent == null ? null : expressionIdent.getName());
        expressionProb.setRelOp(string);
        expressionProb.setProb(expression);
        expressionProb.setExpression(expression2);
        expressionProb.setFilter(filter);
        expressionProb.setPosition(token, PrismParser.getToken(0));
        if (filter != null) {
            String string2 = bl3 ? "&" : filter.getFilterOpString();
            ExpressionFilter expressionFilter = new ExpressionFilter(string2, expressionProb, filter.getExpression());
            expressionFilter.setInvisible(true);
            return expressionFilter;
        }
        return expressionProb;
    }

    public static final Filter Filter() throws ParseException {
        Token token = null;
        token = PrismParser.jj_consume_token(68);
        Expression expression = PrismParser.Expression(true, false);
        Filter filter = new Filter(expression);
        PrismParser.jj_consume_token(69);
        block7: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 68: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[72] = jj_gen;
                    break block7;
                }
            }
            PrismParser.jj_consume_token(68);
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 31: {
                    PrismParser.jj_consume_token(31);
                    filter.setMinRequested(true);
                    break;
                }
                case 29: {
                    PrismParser.jj_consume_token(29);
                    filter.setMaxRequested(true);
                    break;
                }
                default: {
                    PrismParser.jj_la1[73] = jj_gen;
                    PrismParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            PrismParser.jj_consume_token(69);
        }
        filter.setPosition(token, PrismParser.getToken(0));
        return filter;
    }

    public static final Expression ExpressionSS(boolean bl, boolean bl2) throws ParseException {
        boolean bl3;
        ExpressionIdent expressionIdent = null;
        String string = null;
        Expression expression = null;
        Filter filter = null;
        ExpressionSS expressionSS = new ExpressionSS();
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        Token token = PrismParser.jj_consume_token(46);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 62: 
            case 72: 
            case 73: 
            case 76: 
            case 77: {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 62: {
                        PrismParser.jj_consume_token(62);
                        expressionIdent = PrismParser.IdentifierExpression();
                        PrismParser.jj_consume_token(63);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[74] = jj_gen;
                    }
                }
                int n = PrismParser.LtGt();
                expression = PrismParser.Expression(false, false);
                string = ExpressionBinaryOp.opSymbols[n];
                bl3 = true;
                break;
            }
            case 70: {
                PrismParser.jj_consume_token(70);
                PrismParser.jj_consume_token(84);
                string = "=";
                bl3 = false;
                break;
            }
            default: {
                PrismParser.jj_la1[75] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PrismParser.jj_consume_token(64);
        Expression expression2 = PrismParser.Expression(bl, bl2);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 68: {
                filter = PrismParser.Filter();
                break;
            }
            default: {
                PrismParser.jj_la1[76] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(65);
        expressionSS.setModifier(expressionIdent == null ? null : expressionIdent.getName());
        expressionSS.setRelOp(string);
        expressionSS.setProb(expression);
        expressionSS.setExpression(expression2);
        expressionSS.setFilter(filter);
        expressionSS.setPosition(token, PrismParser.getToken(0));
        if (filter != null) {
            String string2 = bl3 ? "&" : filter.getFilterOpString();
            ExpressionFilter expressionFilter = new ExpressionFilter(string2, expressionSS, filter.getExpression());
            expressionFilter.setInvisible(true);
            return expressionFilter;
        }
        return expressionSS;
    }

    public static final Expression ExpressionReward(boolean bl, boolean bl2) throws ParseException {
        boolean bl3;
        Token token;
        ExpressionIdent expressionIdent = null;
        String string = null;
        Expression expression = null;
        Filter filter = null;
        ExpressionReward expressionReward = new ExpressionReward();
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 45: {
                token = PrismParser.jj_consume_token(45);
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 62: {
                        PrismParser.jj_consume_token(62);
                        expressionIdent = PrismParser.IdentifierExpression();
                        PrismParser.jj_consume_token(63);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[77] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 68: {
                        PrismParser.RewardIndex(expressionReward);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[78] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 72: 
                    case 73: 
                    case 76: 
                    case 77: {
                        int n = PrismParser.LtGt();
                        expression = PrismParser.Expression(false, false);
                        string = ExpressionBinaryOp.opSymbols[n];
                        bl3 = true;
                        break block0;
                    }
                    case 70: {
                        PrismParser.jj_consume_token(70);
                        PrismParser.jj_consume_token(84);
                        string = "=";
                        bl3 = false;
                        break block0;
                    }
                    case 31: {
                        PrismParser.jj_consume_token(31);
                        PrismParser.jj_consume_token(70);
                        PrismParser.jj_consume_token(84);
                        string = "min=";
                        bl3 = false;
                        break block0;
                    }
                    case 29: {
                        PrismParser.jj_consume_token(29);
                        PrismParser.jj_consume_token(70);
                        PrismParser.jj_consume_token(84);
                        string = "max=";
                        bl3 = false;
                        break block0;
                    }
                }
                PrismParser.jj_la1[79] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
            case 44: {
                token = PrismParser.jj_consume_token(44);
                PrismParser.jj_consume_token(70);
                PrismParser.jj_consume_token(84);
                string = "min=";
                bl3 = false;
                break;
            }
            case 43: {
                token = PrismParser.jj_consume_token(43);
                PrismParser.jj_consume_token(70);
                PrismParser.jj_consume_token(84);
                string = "max=";
                bl3 = false;
                break;
            }
            default: {
                PrismParser.jj_la1[80] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PrismParser.jj_consume_token(64);
        Expression expression2 = PrismParser.ExpressionRewardContents(bl, bl2);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 68: {
                filter = PrismParser.Filter();
                break;
            }
            default: {
                PrismParser.jj_la1[81] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(65);
        expressionReward.setModifier(expressionIdent == null ? null : expressionIdent.getName());
        expressionReward.setRelOp(string);
        expressionReward.setReward(expression);
        expressionReward.setExpression(expression2);
        expressionReward.setFilter(filter);
        expressionReward.setPosition(token, PrismParser.getToken(0));
        if (filter != null) {
            String string2 = bl3 ? "&" : filter.getFilterOpString();
            ExpressionFilter expressionFilter = new ExpressionFilter(string2, expressionReward, filter.getExpression());
            expressionFilter.setInvisible(true);
            return expressionFilter;
        }
        return expressionReward;
    }

    public static final void RewardIndex(ExpressionReward expressionReward) throws ParseException {
        Object object = null;
        Object object2 = null;
        PrismParser.jj_consume_token(68);
        if (PrismParser.jj_2_15(Integer.MAX_VALUE)) {
            PrismParser.jj_consume_token(85);
            object = PrismParser.Identifier();
            PrismParser.jj_consume_token(85);
        } else {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 3: 
                case 11: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 23: 
                case 29: 
                case 31: 
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 49: 
                case 52: 
                case 62: 
                case 66: 
                case 74: 
                case 79: 
                case 85: 
                case 86: 
                case 87: 
                case 89: {
                    object = PrismParser.Expression(false, false);
                    break;
                }
                default: {
                    PrismParser.jj_la1[82] = jj_gen;
                    PrismParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        PrismParser.jj_consume_token(69);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 81: {
                PrismParser.jj_consume_token(81);
                PrismParser.jj_consume_token(68);
                if (PrismParser.jj_2_16(Integer.MAX_VALUE)) {
                    PrismParser.jj_consume_token(85);
                    object2 = PrismParser.Identifier();
                    PrismParser.jj_consume_token(85);
                } else {
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 3: 
                        case 11: 
                        case 17: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 23: 
                        case 29: 
                        case 31: 
                        case 33: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 49: 
                        case 52: 
                        case 62: 
                        case 66: 
                        case 74: 
                        case 79: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 89: {
                            object2 = PrismParser.Expression(false, false);
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[83] = jj_gen;
                            PrismParser.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                PrismParser.jj_consume_token(69);
                break;
            }
            default: {
                PrismParser.jj_la1[84] = jj_gen;
            }
        }
        expressionReward.setRewardStructIndex(object);
        if (object2 != null) {
            expressionReward.setRewardStructIndexDiv(object2);
        }
    }

    public static final Expression ExpressionRewardContents(boolean bl, boolean bl2) throws ParseException {
        Expression expression = null;
        ExpressionTemporal expressionTemporal = null;
        Expression expression2 = null;
        Token token = PrismParser.getToken(1);
        if (PrismParser.jj_2_17(Integer.MAX_VALUE)) {
            expression2 = expression = PrismParser.ExpressionSS(bl, true);
        } else {
            block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 46: {
                    PrismParser.jj_consume_token(46);
                    expression2 = new ExpressionTemporal(14, null, null);
                    break;
                }
                default: {
                    PrismParser.jj_la1[85] = jj_gen;
                    if (PrismParser.jj_2_18(Integer.MAX_VALUE)) {
                        token = PrismParser.jj_consume_token(8);
                        PrismParser.jj_consume_token(76);
                        expression = PrismParser.Expression(false, false);
                        expressionTemporal = new ExpressionTemporal(11, null, null);
                        expressionTemporal.setUpperBound(expression);
                        expression2 = expressionTemporal;
                        break;
                    }
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 8: {
                            PrismParser.jj_consume_token(8);
                            expression2 = new ExpressionTemporal(11, null, null);
                            break block0;
                        }
                        case 26: {
                            PrismParser.jj_consume_token(26);
                            PrismParser.jj_consume_token(70);
                            expression = PrismParser.Expression(false, false);
                            expressionTemporal = new ExpressionTemporal(12, null, null);
                            expressionTemporal.setUpperBound(expression);
                            expression2 = expressionTemporal;
                            break block0;
                        }
                        case 3: 
                        case 11: 
                        case 17: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 23: 
                        case 29: 
                        case 31: 
                        case 33: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 49: 
                        case 52: 
                        case 62: 
                        case 66: 
                        case 74: 
                        case 79: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 89: {
                            expression2 = expression = PrismParser.Expression(bl, true);
                            break block0;
                        }
                    }
                    PrismParser.jj_la1[86] = jj_gen;
                    PrismParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        expression2.setPosition(token, PrismParser.getToken(0));
        return expression2;
    }

    public static final Expression ExpressionExists(boolean bl, boolean bl2) throws ParseException {
        ExpressionExists expressionExists = new ExpressionExists();
        Token token = null;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        token = PrismParser.jj_consume_token(11);
        PrismParser.jj_consume_token(64);
        Expression expression = PrismParser.Expression(bl, true);
        PrismParser.jj_consume_token(65);
        expressionExists.setExpression(expression);
        expressionExists.setPosition(token, PrismParser.getToken(0));
        return expressionExists;
    }

    public static final Expression ExpressionForAll(boolean bl, boolean bl2) throws ParseException {
        ExpressionForAll expressionForAll = new ExpressionForAll();
        Token token = null;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        token = PrismParser.jj_consume_token(3);
        PrismParser.jj_consume_token(64);
        Expression expression = PrismParser.Expression(bl, true);
        PrismParser.jj_consume_token(65);
        expressionForAll.setExpression(expression);
        expressionForAll.setPosition(token, PrismParser.getToken(0));
        return expressionForAll;
    }

    public static final Expression ExpressionStrategy(boolean bl, boolean bl2) throws ParseException {
        ExpressionStrategy expressionStrategy;
        Token token = null;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 74: {
                token = PrismParser.jj_consume_token(74);
                expressionStrategy = new ExpressionStrategy(true);
                PrismParser.ExpressionStrategyCoalition(expressionStrategy);
                PrismParser.jj_consume_token(75);
                break;
            }
            case 66: {
                token = PrismParser.jj_consume_token(66);
                expressionStrategy = new ExpressionStrategy(false);
                PrismParser.ExpressionStrategyCoalition(expressionStrategy);
                PrismParser.jj_consume_token(67);
                break;
            }
            default: {
                PrismParser.jj_la1[87] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: {
                Expression expression;
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 35: 
                    case 36: 
                    case 37: {
                        expression = PrismParser.ExpressionProb(bl, bl2);
                        break;
                    }
                    case 43: 
                    case 44: 
                    case 45: {
                        expression = PrismParser.ExpressionReward(bl, bl2);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[88] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                expressionStrategy.setSingleOperand(expression);
                break;
            }
            case 62: {
                Expression expression = PrismParser.ExpressionParenth(bl, bl2);
                expressionStrategy.addOperand(expression);
                break;
            }
            default: {
                PrismParser.jj_la1[89] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        expressionStrategy.setPosition(token, PrismParser.getToken(0));
        return expressionStrategy;
    }

    public static final void ExpressionStrategyCoalition(ExpressionStrategy expressionStrategy) throws ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 80: {
                PrismParser.jj_consume_token(80);
                expressionStrategy.setCoalitionAllPlayers();
                break;
            }
            default: {
                PrismParser.jj_la1[92] = jj_gen;
                block3 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 86: 
                    case 89: {
                        String string = PrismParser.ExpressionStrategyCoalitionPlayer();
                        arrayList.add(string);
                        while (true) {
                            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                                case 60: {
                                    break;
                                }
                                default: {
                                    PrismParser.jj_la1[90] = jj_gen;
                                    break block3;
                                }
                            }
                            PrismParser.jj_consume_token(60);
                            string = PrismParser.ExpressionStrategyCoalitionPlayer();
                            arrayList.add(string);
                        }
                    }
                    default: {
                        PrismParser.jj_la1[91] = jj_gen;
                    }
                }
                expressionStrategy.setCoalition(arrayList);
            }
        }
    }

    public static final String ExpressionStrategyCoalitionPlayer() throws ParseException {
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 86: {
                PrismParser.jj_consume_token(86);
                break;
            }
            case 89: {
                PrismParser.jj_consume_token(89);
                break;
            }
            default: {
                PrismParser.jj_la1[93] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String string = PrismParser.getToken((int)0).image;
        return string;
    }

    public static final Expression ExpressionLabel(boolean bl, boolean bl2) throws ParseException {
        String string;
        ExpressionLabel expressionLabel = null;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        Token token = PrismParser.jj_consume_token(85);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 89: {
                string = PrismParser.Identifier();
                break;
            }
            case 24: {
                PrismParser.jj_consume_token(24);
                string = "init";
                break;
            }
            default: {
                PrismParser.jj_la1[94] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PrismParser.jj_consume_token(85);
        expressionLabel = new ExpressionLabel(string);
        expressionLabel.setPosition(token, PrismParser.getToken(0));
        return expressionLabel;
    }

    public static final Expression ExpressionFilter(boolean bl, boolean bl2) throws ParseException {
        ExpressionFilter expressionFilter = null;
        String string = null;
        Expression expression = null;
        Expression expression2 = null;
        Token token = null;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        token = PrismParser.jj_consume_token(19);
        PrismParser.jj_consume_token(62);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 31: {
                PrismParser.jj_consume_token(31);
                string = "min";
                break;
            }
            case 29: {
                PrismParser.jj_consume_token(29);
                string = "max";
                break;
            }
            case 78: {
                PrismParser.jj_consume_token(78);
                string = "+";
                break;
            }
            case 53: {
                PrismParser.jj_consume_token(53);
                string = "&";
                break;
            }
            case 54: {
                PrismParser.jj_consume_token(54);
                string = "|";
                break;
            }
            case 89: {
                string = PrismParser.Identifier();
                break;
            }
            default: {
                PrismParser.jj_la1[95] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PrismParser.jj_consume_token(60);
        expression2 = PrismParser.Expression(bl, bl2);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 60: {
                PrismParser.jj_consume_token(60);
                expression = PrismParser.Expression(bl, bl2);
                break;
            }
            default: {
                PrismParser.jj_la1[96] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(63);
        expressionFilter = new ExpressionFilter(string, expression2, expression);
        expressionFilter.setPosition(token, PrismParser.getToken(0));
        return expressionFilter;
    }

    public static final String Identifier() throws ParseException {
        PrismParser.jj_consume_token(89);
        return PrismParser.getToken((int)0).image;
    }

    public static final ExpressionIdent IdentifierExpression() throws ParseException {
        String string = PrismParser.Identifier();
        ExpressionIdent expressionIdent = new ExpressionIdent(string);
        expressionIdent.setPosition(PrismParser.getToken(0));
        return expressionIdent;
    }

    public static final ExpressionIdent IdentifierExpressionMinMax() throws ParseException {
        String string;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 89: {
                string = PrismParser.Identifier();
                break;
            }
            case 31: {
                PrismParser.jj_consume_token(31);
                string = "min";
                break;
            }
            case 29: {
                PrismParser.jj_consume_token(29);
                string = "max";
                break;
            }
            default: {
                PrismParser.jj_la1[97] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ExpressionIdent expressionIdent = new ExpressionIdent(string);
        expressionIdent.setPosition(PrismParser.getToken(0));
        return expressionIdent;
    }

    public static final ExpressionIdent IdentifierPrime() throws ParseException {
        PrismParser.jj_consume_token(88);
        String string = PrismParser.getToken((int)0).image;
        string = string.substring(0, string.length() - 1);
        ExpressionIdent expressionIdent = new ExpressionIdent(string);
        expressionIdent.setPosition(token);
        expressionIdent.setEndColumn(expressionIdent.getEndColumn() - 1);
        return expressionIdent;
    }

    public static final int EqNeq() throws ParseException {
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 70: {
                PrismParser.jj_consume_token(70);
                return 5;
            }
            case 71: {
                PrismParser.jj_consume_token(71);
                return 6;
            }
        }
        PrismParser.jj_la1[98] = jj_gen;
        PrismParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final int LtGt() throws ParseException {
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 73: {
                PrismParser.jj_consume_token(73);
                return 7;
            }
            case 72: {
                PrismParser.jj_consume_token(72);
                return 9;
            }
            case 77: {
                PrismParser.jj_consume_token(77);
                return 8;
            }
            case 76: {
                PrismParser.jj_consume_token(76);
                return 10;
            }
        }
        PrismParser.jj_la1[99] = jj_gen;
        PrismParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final ForLoop ForLoop() throws ParseException {
        Expression expression = null;
        Expression expression2 = null;
        Expression expression3 = null;
        ForLoop forLoop = new ForLoop();
        Token token = PrismParser.getToken(1);
        String string = PrismParser.Identifier();
        PrismParser.jj_consume_token(70);
        expression = PrismParser.Expression(false, false);
        PrismParser.jj_consume_token(58);
        expression2 = PrismParser.Expression(false, false);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 58: {
                PrismParser.jj_consume_token(58);
                expression3 = PrismParser.Expression(false, false);
                break;
            }
            default: {
                PrismParser.jj_la1[100] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(0);
        forLoop.setLHS(string);
        forLoop.setFrom(expression);
        forLoop.setTo(expression2);
        if (expression3 != null) {
            forLoop.setStep(expression3);
        }
        forLoop.setPosition(token, PrismParser.getToken(0));
        return forLoop;
    }

    private static boolean jj_2_1(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(0, n);
        }
    }

    private static boolean jj_2_2(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(1, n);
        }
    }

    private static boolean jj_2_3(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(2, n);
        }
    }

    private static boolean jj_2_4(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(3, n);
        }
    }

    private static boolean jj_2_5(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(4, n);
        }
    }

    private static boolean jj_2_6(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(5, n);
        }
    }

    private static boolean jj_2_7(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(6, n);
        }
    }

    private static boolean jj_2_8(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(7, n);
        }
    }

    private static boolean jj_2_9(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(8, n);
        }
    }

    private static boolean jj_2_10(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(9, n);
        }
    }

    private static boolean jj_2_11(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(10, n);
        }
    }

    private static boolean jj_2_12(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(11, n);
        }
    }

    private static boolean jj_2_13(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(12, n);
        }
    }

    private static boolean jj_2_14(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(13, n);
        }
    }

    private static boolean jj_2_15(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(14, n);
        }
    }

    private static boolean jj_2_16(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(15, n);
        }
    }

    private static boolean jj_2_17(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(16, n);
        }
    }

    private static boolean jj_2_18(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(17, n);
        }
    }

    private static boolean jj_3R_164() {
        return PrismParser.jj_3R_29();
    }

    private static boolean jj_3R_46() {
        if (PrismParser.jj_3R_55()) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_56()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3R_184() {
        return PrismParser.jj_scan_token(54);
    }

    private static boolean jj_3R_90() {
        if (PrismParser.jj_scan_token(60)) {
            return true;
        }
        return PrismParser.jj_3R_29();
    }

    private static boolean jj_3R_146() {
        if (PrismParser.jj_scan_token(62)) {
            return true;
        }
        if (PrismParser.jj_3R_38()) {
            return true;
        }
        return PrismParser.jj_scan_token(63);
    }

    private static boolean jj_3R_32() {
        return PrismParser.jj_3R_29();
    }

    private static boolean jj_3R_163() {
        return PrismParser.jj_scan_token(29);
    }

    private static boolean jj_3R_157() {
        return PrismParser.jj_scan_token(17);
    }

    private static boolean jj_3R_156() {
        return PrismParser.jj_scan_token(49);
    }

    private static boolean jj_3R_183() {
        return PrismParser.jj_scan_token(53);
    }

    private static boolean jj_3R_181() {
        return PrismParser.jj_scan_token(29);
    }

    private static boolean jj_3R_38() {
        return PrismParser.jj_3R_46();
    }

    private static boolean jj_3R_29() {
        return PrismParser.jj_scan_token(89);
    }

    private static boolean jj_3_4() {
        return PrismParser.jj_scan_token(28);
    }

    private static boolean jj_3R_179() {
        return PrismParser.jj_scan_token(24);
    }

    private static boolean jj_3R_155() {
        return PrismParser.jj_scan_token(87);
    }

    private static boolean jj_3_3() {
        if (PrismParser.jj_scan_token(28)) {
            return true;
        }
        return PrismParser.jj_scan_token(85);
    }

    private static boolean jj_3R_186() {
        if (PrismParser.jj_scan_token(60)) {
            return true;
        }
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3R_162() {
        return PrismParser.jj_scan_token(31);
    }

    private static boolean jj_3R_79() {
        if (PrismParser.jj_scan_token(62)) {
            return true;
        }
        if (PrismParser.jj_3R_31()) {
            return true;
        }
        return PrismParser.jj_scan_token(63);
    }

    private static boolean jj_3R_185() {
        return PrismParser.jj_3R_29();
    }

    private static boolean jj_3R_182() {
        return PrismParser.jj_scan_token(78);
    }

    private static boolean jj_3R_154() {
        return PrismParser.jj_scan_token(86);
    }

    private static boolean jj_3R_78() {
        if (PrismParser.jj_scan_token(85)) {
            return true;
        }
        if (PrismParser.jj_3R_29()) {
            return true;
        }
        return PrismParser.jj_scan_token(85);
    }

    private static boolean jj_3R_180() {
        return PrismParser.jj_scan_token(31);
    }

    private static boolean jj_3R_142() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_154()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_155()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_156()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_157()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_178() {
        return PrismParser.jj_3R_29();
    }

    private static boolean jj_3R_77() {
        return PrismParser.jj_3R_29();
    }

    private static boolean jj_3R_70() {
        if (PrismParser.jj_scan_token(60)) {
            return true;
        }
        return PrismParser.jj_3R_29();
    }

    private static boolean jj_3R_160() {
        return PrismParser.jj_scan_token(29);
    }

    private static boolean jj_3R_68() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_77()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_78()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_79()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_153() {
        if (PrismParser.jj_scan_token(19)) {
            return true;
        }
        if (PrismParser.jj_scan_token(62)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_180()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_181()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_182()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_183()) {
                        jj_scanpos = token;
                        if (PrismParser.jj_3R_184()) {
                            jj_scanpos = token;
                            if (PrismParser.jj_3R_185()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        if (PrismParser.jj_scan_token(60)) {
            return true;
        }
        if (PrismParser.jj_3R_38()) {
            return true;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_186()) {
            jj_scanpos = token;
        }
        return PrismParser.jj_scan_token(63);
    }

    private static boolean jj_3R_161() {
        Token token;
        if (PrismParser.jj_3R_38()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_187());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_91() {
        if (PrismParser.jj_scan_token(60)) {
            return true;
        }
        if (PrismParser.jj_3R_29()) {
            return true;
        }
        if (PrismParser.jj_scan_token(83)) {
            return true;
        }
        return PrismParser.jj_3R_29();
    }

    private static boolean jj_3_9() {
        if (PrismParser.jj_scan_token(54)) {
            return true;
        }
        if (PrismParser.jj_scan_token(54)) {
            return true;
        }
        return PrismParser.jj_scan_token(54);
    }

    private static boolean jj_3R_81() {
        Token token;
        if (PrismParser.jj_scan_token(68)) {
            return true;
        }
        if (PrismParser.jj_3R_29()) {
            return true;
        }
        if (PrismParser.jj_scan_token(83)) {
            return true;
        }
        if (PrismParser.jj_3R_29()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_91());
        jj_scanpos = token;
        return PrismParser.jj_scan_token(69);
    }

    private static boolean jj_3R_50() {
        if (PrismParser.jj_scan_token(54)) {
            return true;
        }
        if (PrismParser.jj_scan_token(54)) {
            return true;
        }
        if (PrismParser.jj_scan_token(54)) {
            return true;
        }
        return PrismParser.jj_3R_35();
    }

    private static boolean jj_3R_145() {
        if (PrismParser.jj_scan_token(20)) {
            return true;
        }
        if (PrismParser.jj_scan_token(62)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_162()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_163()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_164()) {
                    return true;
                }
            }
        }
        if (PrismParser.jj_scan_token(60)) {
            return true;
        }
        if (PrismParser.jj_3R_161()) {
            return true;
        }
        return PrismParser.jj_scan_token(63);
    }

    private static boolean jj_3R_152() {
        if (PrismParser.jj_scan_token(85)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_178()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_179()) {
                return true;
            }
        }
        return PrismParser.jj_scan_token(85);
    }

    private static boolean jj_3R_207() {
        return PrismParser.jj_3R_148();
    }

    private static boolean jj_3R_80() {
        Token token;
        if (PrismParser.jj_scan_token(81)) {
            return true;
        }
        if (PrismParser.jj_scan_token(68)) {
            return true;
        }
        if (PrismParser.jj_3R_29()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_90());
        jj_scanpos = token;
        return PrismParser.jj_scan_token(69);
    }

    private static boolean jj_3R_69() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_80()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_81()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_58() {
        Token token;
        if (PrismParser.jj_3R_68()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_69());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_159() {
        return PrismParser.jj_scan_token(31);
    }

    private static boolean jj_3_8() {
        if (PrismParser.jj_scan_token(54)) {
            return true;
        }
        return PrismParser.jj_scan_token(54);
    }

    private static boolean jj_3R_144() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_159()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_160()) {
                return true;
            }
        }
        if (PrismParser.jj_scan_token(62)) {
            return true;
        }
        if (PrismParser.jj_3R_161()) {
            return true;
        }
        return PrismParser.jj_scan_token(63);
    }

    private static boolean jj_3R_217() {
        Token token = jj_scanpos;
        if (PrismParser.jj_scan_token(86)) {
            jj_scanpos = token;
            if (PrismParser.jj_scan_token(89)) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_43() {
        if (PrismParser.jj_scan_token(54)) {
            return true;
        }
        if (PrismParser.jj_scan_token(54)) {
            return true;
        }
        return PrismParser.jj_3R_49();
    }

    private static boolean jj_3R_158() {
        if (PrismParser.jj_scan_token(62)) {
            return true;
        }
        if (PrismParser.jj_3R_161()) {
            return true;
        }
        return PrismParser.jj_scan_token(63);
    }

    private static boolean jj_3_10() {
        if (PrismParser.jj_scan_token(54)) {
            return true;
        }
        return PrismParser.jj_scan_token(64);
    }

    private static boolean jj_3R_218() {
        if (PrismParser.jj_scan_token(60)) {
            return true;
        }
        return PrismParser.jj_3R_217();
    }

    private static boolean jj_3R_214() {
        Token token;
        if (PrismParser.jj_3R_217()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_218());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_210() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_214()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3_2() {
        if (PrismParser.jj_scan_token(85)) {
            return true;
        }
        if (PrismParser.jj_3R_29()) {
            return true;
        }
        if (PrismParser.jj_scan_token(85)) {
            return true;
        }
        return PrismParser.jj_scan_token(58);
    }

    private static boolean jj_3R_143() {
        if (PrismParser.jj_3R_29()) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_158()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3R_209() {
        return PrismParser.jj_scan_token(80);
    }

    private static boolean jj_3R_205() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_209()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_210()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_59() {
        Token token;
        if (PrismParser.jj_scan_token(54)) {
            return true;
        }
        if (PrismParser.jj_scan_token(64)) {
            return true;
        }
        if (PrismParser.jj_3R_29()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_70());
        jj_scanpos = token;
        if (PrismParser.jj_scan_token(65)) {
            return true;
        }
        if (PrismParser.jj_scan_token(54)) {
            return true;
        }
        return PrismParser.jj_3R_58();
    }

    private static boolean jj_3R_49() {
        if (PrismParser.jj_3R_58()) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_59()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3R_141() {
        return PrismParser.jj_3R_153();
    }

    private static boolean jj_3R_140() {
        return PrismParser.jj_3R_152();
    }

    private static boolean jj_3R_177() {
        return PrismParser.jj_3R_146();
    }

    private static boolean jj_3R_139() {
        return PrismParser.jj_3R_151();
    }

    private static boolean jj_3R_206() {
        return PrismParser.jj_3R_147();
    }

    private static boolean jj_3R_138() {
        return PrismParser.jj_3R_150();
    }

    private static boolean jj_3R_176() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_206()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_207()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_175() {
        if (PrismParser.jj_scan_token(66)) {
            return true;
        }
        if (PrismParser.jj_3R_205()) {
            return true;
        }
        return PrismParser.jj_scan_token(67);
    }

    private static boolean jj_3R_137() {
        return PrismParser.jj_3R_149();
    }

    private static boolean jj_3R_127() {
        return PrismParser.jj_scan_token(81);
    }

    private static boolean jj_3R_216() {
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3R_174() {
        if (PrismParser.jj_scan_token(74)) {
            return true;
        }
        if (PrismParser.jj_3R_205()) {
            return true;
        }
        return PrismParser.jj_scan_token(75);
    }

    private static boolean jj_3R_136() {
        return PrismParser.jj_3R_148();
    }

    private static boolean jj_3R_135() {
        return PrismParser.jj_3R_33();
    }

    private static boolean jj_3R_134() {
        return PrismParser.jj_3R_147();
    }

    private static boolean jj_3R_151() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_174()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_175()) {
                return true;
            }
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_176()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_177()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_133() {
        return PrismParser.jj_3R_146();
    }

    private static boolean jj_3R_132() {
        return PrismParser.jj_3R_145();
    }

    private static boolean jj_3R_42() {
        Token token;
        if (PrismParser.jj_3R_49()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_50());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_131() {
        return PrismParser.jj_3R_144();
    }

    private static boolean jj_3R_130() {
        return PrismParser.jj_3R_143();
    }

    private static boolean jj_3R_129() {
        return PrismParser.jj_3R_142();
    }

    private static boolean jj_3R_212() {
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3R_123() {
        return PrismParser.jj_scan_token(79);
    }

    private static boolean jj_3R_150() {
        if (PrismParser.jj_scan_token(3)) {
            return true;
        }
        if (PrismParser.jj_scan_token(64)) {
            return true;
        }
        if (PrismParser.jj_3R_38()) {
            return true;
        }
        return PrismParser.jj_scan_token(65);
    }

    private static boolean jj_3R_128() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_129()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_130()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_131()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_132()) {
                        jj_scanpos = token;
                        if (PrismParser.jj_3R_133()) {
                            jj_scanpos = token;
                            if (PrismParser.jj_3R_134()) {
                                jj_scanpos = token;
                                if (PrismParser.jj_3R_135()) {
                                    jj_scanpos = token;
                                    if (PrismParser.jj_3R_136()) {
                                        jj_scanpos = token;
                                        if (PrismParser.jj_3R_137()) {
                                            jj_scanpos = token;
                                            if (PrismParser.jj_3R_138()) {
                                                jj_scanpos = token;
                                                if (PrismParser.jj_3R_139()) {
                                                    jj_scanpos = token;
                                                    if (PrismParser.jj_3R_140()) {
                                                        jj_scanpos = token;
                                                        if (PrismParser.jj_3R_141()) {
                                                            return true;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_125() {
        return PrismParser.jj_3R_128();
    }

    private static boolean jj_3R_124() {
        if (PrismParser.jj_scan_token(79)) {
            return true;
        }
        return PrismParser.jj_3R_120();
    }

    private static boolean jj_3R_35() {
        Token token;
        if (PrismParser.jj_3R_42()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_43());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_120() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_124()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_125()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_149() {
        if (PrismParser.jj_scan_token(11)) {
            return true;
        }
        if (PrismParser.jj_scan_token(64)) {
            return true;
        }
        if (PrismParser.jj_3R_38()) {
            return true;
        }
        return PrismParser.jj_scan_token(65);
    }

    private static boolean jj_3R_126() {
        return PrismParser.jj_scan_token(80);
    }

    private static boolean jj_3R_31() {
        return PrismParser.jj_3R_35();
    }

    private static boolean jj_3R_121() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_126()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_127()) {
                return true;
            }
        }
        return PrismParser.jj_3R_120();
    }

    private static boolean jj_3_7() {
        if (PrismParser.jj_scan_token(85)) {
            return true;
        }
        if (PrismParser.jj_3R_29()) {
            return true;
        }
        if (PrismParser.jj_scan_token(85)) {
            return true;
        }
        return PrismParser.jj_3R_31();
    }

    private static boolean jj_3_18() {
        if (PrismParser.jj_scan_token(8)) {
            return true;
        }
        return PrismParser.jj_scan_token(76);
    }

    private static boolean jj_3R_204() {
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3R_116() {
        Token token;
        if (PrismParser.jj_3R_120()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_121());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3_17() {
        return PrismParser.jj_3R_33();
    }

    private static boolean jj_3R_203() {
        if (PrismParser.jj_scan_token(26)) {
            return true;
        }
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3_16() {
        return PrismParser.jj_scan_token(85);
    }

    private static boolean jj_3R_202() {
        return PrismParser.jj_scan_token(8);
    }

    private static boolean jj_3R_201() {
        if (PrismParser.jj_scan_token(8)) {
            return true;
        }
        if (PrismParser.jj_scan_token(76)) {
            return true;
        }
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3R_122() {
        return PrismParser.jj_scan_token(78);
    }

    private static boolean jj_3R_200() {
        return PrismParser.jj_scan_token(46);
    }

    private static boolean jj_3R_173() {
        return PrismParser.jj_3R_47();
    }

    private static boolean jj_3_1() {
        if (PrismParser.jj_scan_token(32)) {
            return true;
        }
        if (PrismParser.jj_3R_29()) {
            return true;
        }
        return PrismParser.jj_scan_token(70);
    }

    private static boolean jj_3R_117() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_122()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_123()) {
                return true;
            }
        }
        return PrismParser.jj_3R_116();
    }

    private static boolean jj_3R_199() {
        return PrismParser.jj_3R_33();
    }

    private static boolean jj_3R_215() {
        if (PrismParser.jj_scan_token(85)) {
            return true;
        }
        if (PrismParser.jj_3R_29()) {
            return true;
        }
        return PrismParser.jj_scan_token(85);
    }

    private static boolean jj_3R_172() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_199()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_200()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_201()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_202()) {
                        jj_scanpos = token;
                        if (PrismParser.jj_3R_203()) {
                            jj_scanpos = token;
                            if (PrismParser.jj_3R_204()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3_15() {
        return PrismParser.jj_scan_token(85);
    }

    private static boolean jj_3R_113() {
        Token token;
        if (PrismParser.jj_3R_116()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_117());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3_6() {
        return PrismParser.jj_scan_token(85);
    }

    private static boolean jj_3R_211() {
        if (PrismParser.jj_scan_token(85)) {
            return true;
        }
        if (PrismParser.jj_3R_29()) {
            return true;
        }
        return PrismParser.jj_scan_token(85);
    }

    private static boolean jj_3R_213() {
        if (PrismParser.jj_scan_token(81)) {
            return true;
        }
        if (PrismParser.jj_scan_token(68)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_215()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_216()) {
                return true;
            }
        }
        return PrismParser.jj_scan_token(69);
    }

    private static boolean jj_3R_114() {
        if (PrismParser.jj_3R_45()) {
            return true;
        }
        return PrismParser.jj_3R_113();
    }

    private static boolean jj_3R_208() {
        if (PrismParser.jj_scan_token(68)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_211()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_212()) {
                return true;
            }
        }
        if (PrismParser.jj_scan_token(69)) {
            return true;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_213()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3R_111() {
        Token token;
        if (PrismParser.jj_3R_113()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_114());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_112() {
        if (PrismParser.jj_3R_115()) {
            return true;
        }
        return PrismParser.jj_3R_111();
    }

    private static boolean jj_3R_110() {
        Token token;
        if (PrismParser.jj_3R_111()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_112());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_109() {
        return PrismParser.jj_3R_110();
    }

    private static boolean jj_3R_108() {
        if (PrismParser.jj_scan_token(52)) {
            return true;
        }
        return PrismParser.jj_3R_106();
    }

    private static boolean jj_3R_101() {
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3R_99() {
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3R_97() {
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3R_95() {
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3R_195() {
        if (PrismParser.jj_3R_45()) {
            return true;
        }
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3R_194() {
        return PrismParser.jj_3R_208();
    }

    private static boolean jj_3R_193() {
        if (PrismParser.jj_scan_token(62)) {
            return true;
        }
        if (PrismParser.jj_3R_32()) {
            return true;
        }
        return PrismParser.jj_scan_token(63);
    }

    private static boolean jj_3R_41() {
        if (PrismParser.jj_scan_token(53)) {
            return true;
        }
        return PrismParser.jj_3R_40();
    }

    private static boolean jj_3R_198() {
        if (PrismParser.jj_scan_token(29)) {
            return true;
        }
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        return PrismParser.jj_scan_token(84);
    }

    private static boolean jj_3R_171() {
        if (PrismParser.jj_scan_token(43)) {
            return true;
        }
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        return PrismParser.jj_scan_token(84);
    }

    private static boolean jj_3R_197() {
        if (PrismParser.jj_scan_token(31)) {
            return true;
        }
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        return PrismParser.jj_scan_token(84);
    }

    private static boolean jj_3R_170() {
        if (PrismParser.jj_scan_token(44)) {
            return true;
        }
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        return PrismParser.jj_scan_token(84);
    }

    private static boolean jj_3R_106() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_108()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_109()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_196() {
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        return PrismParser.jj_scan_token(84);
    }

    private static boolean jj_3R_39() {
        return PrismParser.jj_3R_47();
    }

    private static boolean jj_3R_169() {
        if (PrismParser.jj_scan_token(45)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_193()) {
            jj_scanpos = token;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_194()) {
            jj_scanpos = token;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_195()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_196()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_197()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_198()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_107() {
        if (PrismParser.jj_scan_token(53)) {
            return true;
        }
        return PrismParser.jj_3R_106();
    }

    private static boolean jj_3R_148() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_169()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_170()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_171()) {
                    return true;
                }
            }
        }
        if (PrismParser.jj_scan_token(64)) {
            return true;
        }
        if (PrismParser.jj_3R_172()) {
            return true;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_173()) {
            jj_scanpos = token;
        }
        return PrismParser.jj_scan_token(65);
    }

    private static boolean jj_3R_40() {
        if (PrismParser.jj_scan_token(62)) {
            return true;
        }
        if (PrismParser.jj_3R_48()) {
            return true;
        }
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        if (PrismParser.jj_3R_38()) {
            return true;
        }
        return PrismParser.jj_scan_token(63);
    }

    private static boolean jj_3R_104() {
        Token token;
        if (PrismParser.jj_3R_106()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_107());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_105() {
        if (PrismParser.jj_scan_token(54)) {
            return true;
        }
        return PrismParser.jj_3R_104();
    }

    private static boolean jj_3R_34() {
        Token token;
        if (PrismParser.jj_3R_40()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_41());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3_5() {
        return PrismParser.jj_3R_30();
    }

    private static boolean jj_3R_102() {
        Token token;
        if (PrismParser.jj_3R_104()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_105());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_30() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_34()) {
            jj_scanpos = token;
            if (PrismParser.jj_scan_token(49)) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_103() {
        if (PrismParser.jj_scan_token(56)) {
            return true;
        }
        return PrismParser.jj_3R_102();
    }

    private static boolean jj_3R_92() {
        Token token;
        if (PrismParser.jj_3R_102()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_103());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_37() {
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        return PrismParser.jj_scan_token(84);
    }

    private static boolean jj_3R_44() {
        if (PrismParser.jj_scan_token(62)) {
            return true;
        }
        if (PrismParser.jj_3R_32()) {
            return true;
        }
        return PrismParser.jj_scan_token(63);
    }

    private static boolean jj_3R_36() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_44()) {
            jj_scanpos = token;
        }
        if (PrismParser.jj_3R_45()) {
            return true;
        }
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3R_93() {
        if (PrismParser.jj_scan_token(55)) {
            return true;
        }
        return PrismParser.jj_3R_92();
    }

    private static boolean jj_3R_82() {
        Token token;
        if (PrismParser.jj_3R_92()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_93());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_33() {
        if (PrismParser.jj_scan_token(46)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_36()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_37()) {
                return true;
            }
        }
        if (PrismParser.jj_scan_token(64)) {
            return true;
        }
        if (PrismParser.jj_3R_38()) {
            return true;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_39()) {
            jj_scanpos = token;
        }
        return PrismParser.jj_scan_token(65);
    }

    private static boolean jj_3R_83() {
        if (PrismParser.jj_scan_token(84)) {
            return true;
        }
        if (PrismParser.jj_3R_82()) {
            return true;
        }
        if (PrismParser.jj_scan_token(58)) {
            return true;
        }
        return PrismParser.jj_3R_75();
    }

    private static boolean jj_3_14() {
        if (PrismParser.jj_3R_32()) {
            return true;
        }
        return PrismParser.jj_scan_token(62);
    }

    private static boolean jj_3_13() {
        if (PrismParser.jj_3R_32()) {
            return true;
        }
        return PrismParser.jj_scan_token(62);
    }

    private static boolean jj_3_12() {
        if (PrismParser.jj_3R_32()) {
            return true;
        }
        return PrismParser.jj_scan_token(62);
    }

    private static boolean jj_3_11() {
        if (PrismParser.jj_3R_32()) {
            return true;
        }
        return PrismParser.jj_scan_token(62);
    }

    private static boolean jj_3R_168() {
        return PrismParser.jj_3R_47();
    }

    private static boolean jj_3R_67() {
        return PrismParser.jj_scan_token(29);
    }

    private static boolean jj_3R_66() {
        return PrismParser.jj_scan_token(31);
    }

    private static boolean jj_3R_75() {
        if (PrismParser.jj_3R_82()) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_83()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3R_100() {
        return PrismParser.jj_3R_32();
    }

    private static boolean jj_3R_98() {
        return PrismParser.jj_3R_32();
    }

    private static boolean jj_3R_96() {
        return PrismParser.jj_3R_32();
    }

    private static boolean jj_3R_94() {
        return PrismParser.jj_3R_32();
    }

    private static boolean jj_3R_57() {
        if (PrismParser.jj_scan_token(68)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_66()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_67()) {
                return true;
            }
        }
        return PrismParser.jj_scan_token(69);
    }

    private static boolean jj_3R_89() {
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3R_88() {
        if (PrismParser.jj_scan_token(64)) {
            return true;
        }
        if (PrismParser.jj_3R_38()) {
            return true;
        }
        if (PrismParser.jj_scan_token(60)) {
            return true;
        }
        if (PrismParser.jj_3R_38()) {
            return true;
        }
        return PrismParser.jj_scan_token(65);
    }

    private static boolean jj_3R_47() {
        Token token;
        if (PrismParser.jj_scan_token(68)) {
            return true;
        }
        if (PrismParser.jj_3R_38()) {
            return true;
        }
        if (PrismParser.jj_scan_token(69)) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_57());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_87() {
        if (PrismParser.jj_scan_token(73)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_100()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_101()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_86() {
        if (PrismParser.jj_scan_token(77)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_98()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_99()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_85() {
        if (PrismParser.jj_scan_token(72)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_96()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_97()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_84() {
        if (PrismParser.jj_scan_token(76)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_94()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_95()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_76() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_84()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_85()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_86()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_87()) {
                        jj_scanpos = token;
                        if (PrismParser.jj_3R_88()) {
                            jj_scanpos = token;
                            if (PrismParser.jj_3R_89()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_61() {
        return PrismParser.jj_3R_75();
    }

    private static boolean jj_3R_74() {
        return PrismParser.jj_3R_76();
    }

    private static boolean jj_3R_73() {
        return PrismParser.jj_scan_token(23);
    }

    private static boolean jj_3R_72() {
        return PrismParser.jj_scan_token(21);
    }

    private static boolean jj_3R_71() {
        return PrismParser.jj_scan_token(33);
    }

    private static boolean jj_3R_60() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_71()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_72()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_73()) {
                    return true;
                }
            }
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_74()) {
            jj_scanpos = token;
        }
        return PrismParser.jj_3R_55();
    }

    private static boolean jj_3R_54() {
        return PrismParser.jj_scan_token(76);
    }

    private static boolean jj_3R_189() {
        if (PrismParser.jj_3R_45()) {
            return true;
        }
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3R_188() {
        if (PrismParser.jj_scan_token(62)) {
            return true;
        }
        if (PrismParser.jj_3R_32()) {
            return true;
        }
        return PrismParser.jj_scan_token(63);
    }

    private static boolean jj_3R_53() {
        return PrismParser.jj_scan_token(77);
    }

    private static boolean jj_3R_52() {
        return PrismParser.jj_scan_token(72);
    }

    private static boolean jj_3R_51() {
        return PrismParser.jj_scan_token(73);
    }

    private static boolean jj_3R_45() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_51()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_52()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_53()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_54()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_192() {
        if (PrismParser.jj_scan_token(29)) {
            return true;
        }
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        return PrismParser.jj_scan_token(84);
    }

    private static boolean jj_3R_191() {
        if (PrismParser.jj_scan_token(31)) {
            return true;
        }
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        return PrismParser.jj_scan_token(84);
    }

    private static boolean jj_3R_190() {
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        return PrismParser.jj_scan_token(84);
    }

    private static boolean jj_3R_167() {
        if (PrismParser.jj_scan_token(35)) {
            return true;
        }
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        return PrismParser.jj_scan_token(84);
    }

    private static boolean jj_3R_55() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_60()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_61()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_166() {
        if (PrismParser.jj_scan_token(36)) {
            return true;
        }
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        return PrismParser.jj_scan_token(84);
    }

    private static boolean jj_3R_119() {
        return PrismParser.jj_scan_token(71);
    }

    private static boolean jj_3R_115() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_118()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_119()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_118() {
        return PrismParser.jj_scan_token(70);
    }

    private static boolean jj_3R_65() {
        return PrismParser.jj_3R_76();
    }

    private static boolean jj_3R_64() {
        return PrismParser.jj_scan_token(45);
    }

    private static boolean jj_3R_63() {
        return PrismParser.jj_scan_token(51);
    }

    private static boolean jj_3R_165() {
        if (PrismParser.jj_scan_token(37)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_188()) {
            jj_scanpos = token;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_189()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_190()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_191()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_192()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_62() {
        return PrismParser.jj_scan_token(50);
    }

    private static boolean jj_3R_147() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_165()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_166()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_167()) {
                    return true;
                }
            }
        }
        if (PrismParser.jj_scan_token(64)) {
            return true;
        }
        if (PrismParser.jj_3R_38()) {
            return true;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_168()) {
            jj_scanpos = token;
        }
        return PrismParser.jj_scan_token(65);
    }

    private static boolean jj_3R_56() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_62()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_63()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_64()) {
                    return true;
                }
            }
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_65()) {
            jj_scanpos = token;
        }
        return PrismParser.jj_3R_55();
    }

    private static boolean jj_3R_187() {
        if (PrismParser.jj_scan_token(60)) {
            return true;
        }
        return PrismParser.jj_3R_38();
    }

    private static boolean jj_3R_48() {
        return PrismParser.jj_scan_token(88);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{1363412160, 1346634944, 0x1000000, -1340471224, 0, -1340471224, -1340471224, 0, -1340471224, 1024, 0x40000000, 128, 0x40000480, 134218256, 134218256, 0, 64, 0, 0x1000000, 0x8000030, 0, 0x2000000, 0, 0, 0, -1598420984, 0, 0, 0, -1598420984, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0xA00000, 0, -1598420984, -1598420984, -1598420984, -1598420984, -1598420984, 0, 0, 0, 0, 0, 0, -1608906744, 0, 0, 0, 0, 0, 0, -1608906744, -1608906744, 0, -1610612736, -1610612736, 0, 131072, 0, -1610612736, 0, 0, 0, -1610612736, 0, 0, 0, 0, 0, -1610612736, 0, 0, -1598420984, -1598420984, 0, 0, -1531311864, 0, 0, 0, 0, 0, 0, 0, 0x1000000, -1610612736, 0, -1610612736, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{100293, 33732, 66561, 1074952888, 0x8000000, 1074952888, 1074952888, 0x8000000, 1074952888, 64, 4, 32768, 33092, 0, 0, 640, 640, 0, 0, 0, 0, 0, 0, 0, 0, 1074952250, 0x200000, 0x40020000, 0x10000000, 1074952250, 0, 0, 0x10000000, 0, 0x10000000, 0x10000000, 0, 0x40000000, 794624, 0, 794624, 2, 0, 1074952250, 1074952250, 1074952250, 1074952250, 1074952250, 0, 0, 0x800000, 0x1000000, 0x400000, 0x200000, 1074952248, 0, 0, 0, 0, 0, 0, 1073903672, 1073903672, 0x40000000, 0, 0, 0x10000000, 131072, 0x40000000, 0, 56, 0, 0, 0, 0x40000000, 0x40000000, 0, 0x40000000, 0, 0, 14336, 0, 1074952250, 1074952250, 0, 16384, 1074952250, 0, 14392, 1073756216, 0x10000000, 0, 0, 0, 0, 0x600000, 0x10000000, 0, 0, 0, 0x4000000};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 48268292, 0, 48268292, 48268292, 0, 48268292, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 1, 0x2000000, 0, 1, 0x2000000, 16384, 48268292, 0, 0, 0, 48268293, 0x2000000, 1, 0, 131088, 0, 0, 131088, 0x2200000, 0, 13121, 0, 0, 13121, 48268292, 48268292, 48268292, 48268292, 48268292, 13121, 0x100000, 0, 0, 0, 0, 48268292, 192, 13056, 49152, 49152, 196608, 196608, 48268292, 48235524, 0, 0, 0x2000000, 0, 0xC00000, 0, 13120, 0, 16, 16, 0, 0, 13120, 16, 0, 16, 13120, 0, 16, 48268292, 48268292, 131072, 0, 48268292, 1028, 0, 0, 0, 0x2400000, 65536, 0x2400000, 0x2000000, 0x2004000, 0, 0x2000000, 192, 13056, 0};
    }

    public PrismParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public PrismParser(InputStream inputStream, String string) {
        int n;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        try {
            jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        token_source = new PrismParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 101; ++n) {
            PrismParser.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            PrismParser.jj_2_rtns[n] = new JJCalls();
        }
    }

    public static void ReInit(InputStream inputStream) {
        PrismParser.ReInit(inputStream, null);
    }

    public static void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        PrismParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 101; ++n) {
            PrismParser.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            PrismParser.jj_2_rtns[n] = new JJCalls();
        }
    }

    public PrismParser(Reader reader) {
        int n;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new SimpleCharStream(reader, 1, 1);
        token_source = new PrismParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 101; ++n) {
            PrismParser.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            PrismParser.jj_2_rtns[n] = new JJCalls();
        }
    }

    public static void ReInit(Reader reader) {
        int n;
        jj_input_stream.ReInit(reader, 1, 1);
        PrismParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 101; ++n) {
            PrismParser.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            PrismParser.jj_2_rtns[n] = new JJCalls();
        }
    }

    public PrismParser(PrismParserTokenManager prismParserTokenManager) {
        int n;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = prismParserTokenManager;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 101; ++n) {
            PrismParser.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            PrismParser.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(PrismParserTokenManager prismParserTokenManager) {
        int n;
        token_source = prismParserTokenManager;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 101; ++n) {
            PrismParser.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            PrismParser.jj_2_rtns[n] = new JJCalls();
        }
    }

    private static Token jj_consume_token(int n) throws ParseException {
        Token token = PrismParser.token;
        PrismParser.token = token.next != null ? PrismParser.token.next : (PrismParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        if (PrismParser.token.kind == n) {
            ++jj_gen;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return PrismParser.token;
        }
        PrismParser.token = token;
        jj_kind = n;
        throw PrismParser.generateParseException();
    }

    private static boolean jj_scan_token(int n) {
        if (jj_scanpos == jj_lastpos) {
            --jj_la;
            if (PrismParser.jj_scanpos.next == null) {
                jj_scanpos = PrismParser.jj_scanpos.next = token_source.getNextToken();
                jj_lastpos = PrismParser.jj_scanpos.next;
            } else {
                jj_lastpos = jj_scanpos = PrismParser.jj_scanpos.next;
            }
        } else {
            jj_scanpos = PrismParser.jj_scanpos.next;
        }
        if (jj_rescan) {
            int n2 = 0;
            Token token = PrismParser.token;
            while (token != null && token != jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                PrismParser.jj_add_error_token(n, n2);
            }
        }
        if (PrismParser.jj_scanpos.kind != n) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public static final Token getNextToken() {
        token = PrismParser.token.next != null ? PrismParser.token.next : (PrismParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int n) {
        Token token = PrismParser.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = token_source.getNextToken());
        }
        return token;
    }

    private static int jj_ntk_f() {
        jj_nt = PrismParser.token.next;
        if (jj_nt == null) {
            PrismParser.token.next = token_source.getNextToken();
            jj_ntk = PrismParser.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = PrismParser.jj_nt.kind;
        return jj_ntk;
    }

    private static void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == jj_endpos + 1) {
            PrismParser.jj_lasttokens[PrismParser.jj_endpos++] = n;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; ++i) {
                PrismParser.jj_expentry[i] = jj_lasttokens[i];
            }
            block1: for (int[] nArray : jj_expentries) {
                if (nArray.length != jj_expentry.length) continue;
                for (int i = 0; i < jj_expentry.length; ++i) {
                    if (nArray[i] != jj_expentry[i]) continue block1;
                }
                jj_expentries.add(jj_expentry);
                break;
            }
            if (n2 != 0) {
                jj_endpos = n2;
                PrismParser.jj_lasttokens[PrismParser.jj_endpos - 1] = n;
            }
        }
    }

    public static ParseException generateParseException() {
        int n;
        int n2;
        jj_expentries.clear();
        boolean[] blArray = new boolean[92];
        if (jj_kind >= 0) {
            blArray[PrismParser.jj_kind] = true;
            jj_kind = -1;
        }
        for (n2 = 0; n2 < 101; ++n2) {
            if (jj_la1[n2] != jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) == 0) continue;
                blArray[64 + n] = true;
            }
        }
        for (n2 = 0; n2 < 92; ++n2) {
            if (!blArray[n2]) continue;
            jj_expentry = new int[1];
            PrismParser.jj_expentry[0] = n2;
            jj_expentries.add(jj_expentry);
        }
        jj_endpos = 0;
        PrismParser.jj_rescan_token();
        PrismParser.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[jj_expentries.size()][];
        for (n = 0; n < jj_expentries.size(); ++n) {
            nArrayArray[n] = jj_expentries.get(n);
        }
        return new ParseException(token, nArrayArray, tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    private static void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 18; ++i) {
            try {
                JJCalls jJCalls = jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= jj_gen) continue;
                    jj_la = jJCalls.arg;
                    jj_lastpos = jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            PrismParser.jj_3_1();
                            break;
                        }
                        case 1: {
                            PrismParser.jj_3_2();
                            break;
                        }
                        case 2: {
                            PrismParser.jj_3_3();
                            break;
                        }
                        case 3: {
                            PrismParser.jj_3_4();
                            break;
                        }
                        case 4: {
                            PrismParser.jj_3_5();
                            break;
                        }
                        case 5: {
                            PrismParser.jj_3_6();
                            break;
                        }
                        case 6: {
                            PrismParser.jj_3_7();
                            break;
                        }
                        case 7: {
                            PrismParser.jj_3_8();
                            break;
                        }
                        case 8: {
                            PrismParser.jj_3_9();
                            break;
                        }
                        case 9: {
                            PrismParser.jj_3_10();
                            break;
                        }
                        case 10: {
                            PrismParser.jj_3_11();
                            break;
                        }
                        case 11: {
                            PrismParser.jj_3_12();
                            break;
                        }
                        case 12: {
                            PrismParser.jj_3_13();
                            break;
                        }
                        case 13: {
                            PrismParser.jj_3_14();
                            break;
                        }
                        case 14: {
                            PrismParser.jj_3_15();
                            break;
                        }
                        case 15: {
                            PrismParser.jj_3_16();
                            break;
                        }
                        case 16: {
                            PrismParser.jj_3_17();
                            break;
                        }
                        case 17: {
                            PrismParser.jj_3_18();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        jj_rescan = false;
    }

    private static void jj_save(int n, int n2) {
        JJCalls jJCalls = jj_2_rtns[n];
        while (jJCalls.gen > jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = jj_gen + n2 - jj_la;
        jJCalls.first = token;
        jJCalls.arg = n2;
    }

    static {
        keywordList = new ArrayList();
        keywordList.clear();
        for (int i = 3; i < 52; ++i) {
            keywordList.add(PrismParserConstants.tokenImage[i].replaceAll("\"", ""));
        }
        jj_initialized_once = false;
        jj_la1 = new int[101];
        PrismParser.jj_la1_init_0();
        PrismParser.jj_la1_init_1();
        PrismParser.jj_la1_init_2();
        jj_2_rtns = new JJCalls[18];
        jj_rescan = false;
        jj_gc = 0;
        jj_ls = new LookaheadSuccess();
        jj_expentries = new ArrayList<int[]>();
        jj_kind = -1;
        jj_lasttokens = new int[100];
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static class ExpressionPair {
        public Expression expr1 = null;
        public Expression expr2 = null;

        ExpressionPair() {
        }
    }
}

